/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharFilterFactory;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;
import org.apache.lucene.util.Version;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.HasImplicitIndexAnalyzer;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.TextField;
import org.jesterj.ingest.utils.ClassSubPathResourceLoader;
import org.objenesis.ObjenesisStd;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SolrSchemaUtil {
    private static final Logger log = LogManager.getLogger();
    private static final Class[] NO_CLASSES = new Class[0];
    private static final Object[] NO_OBJECTS = new Object[0];
    private static final String XPATH_OR = " | ";
    private static final String[] NO_SUB_PACKAGES = new String[0];
    public static final String SCHEMA_XML_ANALYZER_FILTER = "[schema.xml] analyzer/filter";
    public static final String SCHEMA_XML_ANALYZER_TOKENIZER = "[schema.xml] analyzer/tokenizer";
    public static final String SCHEMA_XML_ANALYZER_CHAR_FILTER = "[schema.xml] analyzer/charFilter";
    static final String project = "solr";
    static final String base = "org.apache.solr";
    static final String[] packages = new String[]{"", "analysis.", "schema.", "handler.", "handler.tagger.", "search.", "update.", "core.", "response.", "request.", "update.processor.", "util.", "spelling.", "handler.component.", "handler.dataimport.", "spelling.suggest.", "spelling.suggest.fst.", "rest.schema.analysis.", "security.", "handler.admin.", "cloud.autoscaling."};
    private static final Pattern legacyAnalysisPattern = Pattern.compile("((\\Qorg.apache.solr.analysis.\\E)|(\\Qsolr.\\E))([\\p{L}_$][\\p{L}\\p{N}_$]+?)(TokenFilter|Filter|Tokenizer|CharFilter)Factory");
    private static final Map<String, String> classNameCache = new ConcurrentHashMap<String, String>();
    private final XPath xpath = XPathFactory.newInstance().newXPath();

    public Document getSchemaDocument(String schemaFile, ClassSubPathResourceLoader classLoader) throws ParserConfigurationException, SAXException, IOException {
        InputStream resourceAsStream = classLoader.openResource(schemaFile);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(resourceAsStream);
    }

    private <T> T create(Class<T> classToMock) {
        ObjenesisStd objenesis = new ObjenesisStd();
        return (T)objenesis.getInstantiatorOf(classToMock).newInstance();
    }

    public FieldType getFieldType(Document doc, String fieldTypeName, String luceneMatch, float schemaVersion, ClassSubPathResourceLoader loader) throws XPathExpressionException, InstantiationException, IllegalAccessException {
        FieldType ft = null;
        Node node = null;
        String expression = this.getFieldTypeXPathExpressions();
        NodeList nodeList = (NodeList)this.xpath.evaluate(expression, doc, XPathConstants.NODESET);
        for (int k = 0; k < nodeList.getLength(); ++k) {
            Node n = nodeList.item(k);
            String aName = n.getAttributes().getNamedItem("name").getNodeValue();
            if (!fieldTypeName.equals(aName)) continue;
            node = n;
            String aClass = n.getAttributes().getNamedItem("class").getNodeValue();
            Class<Object> clazz = this.findClass(aClass, Object.class, new String[0]);
            ft = (FieldType)clazz.newInstance();
            break;
        }
        if (ft == null) {
            throw new RuntimeException("Could not find field type " + fieldTypeName);
        }
        this.commitHorribleCrimesAgainstTypeSafety(fieldTypeName, schemaVersion, ft, node);
        expression = "./analyzer[@type='query']";
        Node anode = (Node)this.xpath.evaluate(expression, node, XPathConstants.NODE);
        Analyzer queryAnalyzer = this.readAnalyzer(anode, luceneMatch, loader);
        expression = "./analyzer[@type='multiterm']";
        anode = (Node)this.xpath.evaluate(expression, node, XPathConstants.NODE);
        Analyzer multiAnalyzer = this.readAnalyzer(anode, luceneMatch, loader);
        expression = "./analyzer[not(@type)] | ./analyzer[@type='index']";
        anode = (Node)this.xpath.evaluate(expression, node, XPathConstants.NODE);
        Analyzer analyzer = this.readAnalyzer(anode, luceneMatch, loader);
        if (ft instanceof HasImplicitIndexAnalyzer) {
            ft.setIsExplicitAnalyzer(false);
            if (null != queryAnalyzer && null != analyzer) {
                if (log.isWarnEnabled()) {
                    log.warn("Ignoring index-time analyzer for type: " + fieldTypeName);
                }
            } else if (null == queryAnalyzer) {
                queryAnalyzer = analyzer;
            }
            if (null != queryAnalyzer) {
                ft.setIsExplicitQueryAnalyzer(true);
                ft.setQueryAnalyzer(queryAnalyzer);
            }
        } else {
            if (null == queryAnalyzer) {
                queryAnalyzer = analyzer;
                ft.setIsExplicitQueryAnalyzer(false);
            } else {
                ft.setIsExplicitQueryAnalyzer(true);
            }
            if (null == analyzer) {
                analyzer = queryAnalyzer;
                ft.setIsExplicitAnalyzer(false);
            } else {
                ft.setIsExplicitAnalyzer(true);
            }
            if (null != analyzer) {
                ft.setIndexAnalyzer(analyzer);
                ft.setQueryAnalyzer(queryAnalyzer);
                if (ft instanceof TextField) {
                    if (null == multiAnalyzer) {
                        multiAnalyzer = this.constructMultiTermAnalyzer(queryAnalyzer);
                        ((TextField)ft).setIsExplicitMultiTermAnalyzer(false);
                    } else {
                        ((TextField)ft).setIsExplicitMultiTermAnalyzer(true);
                    }
                    ((TextField)ft).setMultiTermAnalyzer(multiAnalyzer);
                }
            }
        }
        return ft;
    }

    private void commitHorribleCrimesAgainstTypeSafety(String fieldTypeName, float schemaVersion, FieldType ft, Node node) throws IllegalAccessException {
        boolean found = false;
        Class<?> clazz = ft.getClass();
        do {
            try {
                Field typeName = clazz.getDeclaredField("typeName");
                found = true;
                typeName.setAccessible(true);
                typeName.set(ft, fieldTypeName);
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        } while (!found && clazz != Object.class);
        if (!found) {
            throw new RuntimeException("Couldn't find fieldType field to set it to" + fieldTypeName);
        }
        Map map = DOMUtil.toMapExcept((NamedNodeMap)node.getAttributes(), (String[])new String[]{"name"});
        IndexSchema indexSchema = this.create(IndexSchema.class);
        try {
            Field versionField = IndexSchema.class.getDeclaredField("version");
            versionField.setAccessible(true);
            versionField.set(indexSchema, Float.valueOf(schemaVersion));
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        try {
            Method setArgs = FieldType.class.getDeclaredMethod("setArgs", IndexSchema.class, Map.class);
            setArgs.setAccessible(true);
            setArgs.invoke((Object)ft, indexSchema, map);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Analyzer readAnalyzer(Node node, String luceneMatch, ResourceLoader loader) throws XPathExpressionException {
        if (node == null) {
            return null;
        }
        NamedNodeMap attrs = node.getAttributes();
        String analyzerClassName = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"class");
        NodeList charFilterNodes = (NodeList)this.xpath.evaluate("./charFilter", node, XPathConstants.NODESET);
        NodeList tokenizerNodes = (NodeList)this.xpath.evaluate("./tokenizer", node, XPathConstants.NODESET);
        NodeList tokenFilterNodes = (NodeList)this.xpath.evaluate("./filter", node, XPathConstants.NODESET);
        if (analyzerClassName != null) {
            if (0 != charFilterNodes.getLength() || 0 != tokenizerNodes.getLength() || 0 != tokenFilterNodes.getLength()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Configuration Error: Analyzer class='" + analyzerClassName + "' can not be combined with nested analysis factories");
            }
            try {
                Version luceneMatchVersion;
                Class<Analyzer> clazz = this.findClass(analyzerClassName, Analyzer.class, new String[0]);
                Analyzer analyzer = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                String matchVersionStr = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"luceneMatchVersion");
                Version version = luceneMatchVersion = matchVersionStr == null ? Version.parse((String)luceneMatch) : SolrConfig.parseLuceneVersionString((String)matchVersionStr);
                if (luceneMatchVersion == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Configuration Error: Analyzer '" + clazz.getName() + "' needs a 'luceneMatchVersion' parameter");
                }
                if (analyzer instanceof ResourceLoaderAware) {
                    ((ResourceLoaderAware)analyzer).inform(loader);
                }
                return analyzer;
            }
            catch (Exception e) {
                log.error("Cannot load analyzer: " + analyzerClassName, (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot load analyzer: " + analyzerClassName, (Throwable)e);
            }
        }
        ArrayList charFilters = new ArrayList();
        this.load(charFilterNodes, SCHEMA_XML_ANALYZER_CHAR_FILTER, charFilters, CharFilterFactory.class, luceneMatch, loader);
        ArrayList tokenizers = new ArrayList(1);
        this.load(tokenizerNodes, SCHEMA_XML_ANALYZER_TOKENIZER, tokenizers, TokenizerFactory.class, luceneMatch, loader);
        if (tokenizers.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "analyzer without class or tokenizer");
        }
        ArrayList filters = new ArrayList();
        this.load(tokenFilterNodes, SCHEMA_XML_ANALYZER_FILTER, filters, TokenFilterFactory.class, luceneMatch, loader);
        return new TokenizerChain(charFilters.toArray(new CharFilterFactory[0]), (TokenizerFactory)tokenizers.get(0), filters.toArray(new TokenFilterFactory[0]));
    }

    public <T> void load(NodeList nodes, String errRef, List<T> list, Class<T> clazz, String luceneMatch, ResourceLoader loader) {
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = null;
                try {
                    Object plugin;
                    TokenFilterFactory factory;
                    name = DOMUtil.getAttr((Node)node, (String)"name", null);
                    String className = DOMUtil.getAttr((Node)node, (String)"class", (String)errRef);
                    Map params = DOMUtil.toMap((NamedNodeMap)node.getAttributes());
                    String configuredVersion = (String)params.remove("luceneMatchVersion");
                    params.put("luceneMatchVersion", luceneMatch);
                    if (TokenFilterFactory.class.isAssignableFrom(clazz)) {
                        factory = this.newInstance(className, TokenFilterFactory.class, this.getDefaultPackages(), new Class[]{Map.class}, new Object[]{params});
                        factory.setExplicitLuceneMatchVersion(null != configuredVersion);
                        plugin = factory;
                    } else if (CharFilterFactory.class.isAssignableFrom(clazz)) {
                        factory = this.newInstance(className, CharFilterFactory.class, this.getDefaultPackages(), new Class[]{Map.class}, new Object[]{params});
                        factory.setExplicitLuceneMatchVersion(null != configuredVersion);
                        plugin = factory;
                    } else if (TokenizerFactory.class.isAssignableFrom(clazz)) {
                        factory = this.newInstance(className, TokenizerFactory.class, this.getDefaultPackages(), new Class[]{Map.class}, new Object[]{params});
                        factory.setExplicitLuceneMatchVersion(null != configuredVersion);
                        plugin = factory;
                    } else {
                        plugin = this.newInstance(className, clazz, NO_SUB_PACKAGES, NO_CLASSES, NO_OBJECTS);
                    }
                    if (plugin instanceof ResourceLoaderAware) {
                        ((ResourceLoaderAware)plugin).inform(loader);
                    }
                    log.debug("created " + (name != null ? name : "") + ": " + plugin.getClass().getName());
                    list.add(plugin);
                    continue;
                }
                catch (Exception ex) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Plugin init failure for " + errRef + (String)(null != name ? " \"" + name + "\"" : "") + ": " + ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    public <T> T newInstance(String cName, Class<T> expectedType, String[] subPackages, Class[] params, Object[] args) {
        T obj;
        Class<T> clazz = this.findClass(cName, expectedType, subPackages);
        if (clazz == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Can not find class: " + cName);
        }
        try {
            try {
                Constructor<T> constructor = clazz.getConstructor(params);
                obj = constructor.newInstance(args);
            }
            catch (NoSuchMethodException e) {
                try {
                    Constructor<T> constructor = clazz.getConstructor(new Class[0]);
                    obj = constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e1) {
                    throw e;
                }
            }
        }
        catch (Error err) {
            log.error("Loading Class " + cName + " (" + clazz.getName() + ") triggered serious java error: " + err.getClass().getName(), (Throwable)err);
            throw err;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error instantiating class: '" + clazz.getName() + "'", (Throwable)e);
        }
        return obj;
    }

    /*
     * Exception decompiling
     */
    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType, String ... subpackages) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 17[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String stepsToPath(String ... steps) {
        StringBuilder builder = new StringBuilder();
        for (String step : steps) {
            builder.append("/").append(step);
        }
        return builder.toString();
    }

    protected String getFieldTypeXPathExpressions() {
        return this.stepsToPath("schema", "fieldType".toLowerCase(Locale.ROOT)) + XPATH_OR + this.stepsToPath("schema", "fieldType") + XPATH_OR + this.stepsToPath("schema", "types", "fieldType".toLowerCase(Locale.ROOT)) + XPATH_OR + this.stepsToPath("schema", "types", "fieldType");
    }

    private Analyzer constructMultiTermAnalyzer(Analyzer queryAnalyzer) {
        if (queryAnalyzer == null) {
            return null;
        }
        if (!(queryAnalyzer instanceof TokenizerChain)) {
            return new KeywordAnalyzer();
        }
        return ((TokenizerChain)queryAnalyzer).getMultiTermAnalyzer();
    }

    protected String[] getDefaultPackages() {
        return new String[0];
    }
}

