/*
 * Decompiled with CFR 0.152.
 */
package org.jesterj.ingest.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jesterj.ingest.model.exception.ConfigurationException;
import org.jesterj.ingest.model.exception.PersistenceException;

public class SqlUtils {
    private static Logger log = LogManager.getLogger();

    public Connection createJdbcConnection(String jdbcDriver, String jdbcUrl, String jdbcUser, String jdbcPassword, boolean autoCommit) throws ConfigurationException, PersistenceException {
        Connection connection;
        try {
            Class.forName(jdbcDriver);
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigurationException(String.format("JDBC Driver could not be found: '%s'.", jdbcDriver), ex);
        }
        try {
            log.debug("Establishing JDBC connection to '{}' on thread {}", (Object)jdbcUrl, (Object)Thread.currentThread().getName());
            connection = DriverManager.getConnection(jdbcUrl, jdbcUser, jdbcPassword);
            connection.setAutoCommit(autoCommit);
            log.debug("Successfully established JDBC connection to '{}'", (Object)jdbcUrl);
        }
        catch (SQLException ex) {
            throw new PersistenceException(String.format("Error connecting to JDBC data source: '%s' with driver: '%s'.", jdbcUrl, jdbcDriver), ex);
        }
        return connection;
    }
}

