/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.MainThread;
import androidx.annotation.RestrictTo;
import androidx.core.bundle.Bundle;
import androidx.core.bundle.Bundle_jbKt;
import androidx.savedstate.SavedStateRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\b\u0016\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0004H\u0087\u0002J\u001e\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0010\u001a\u00020\u0004H\u0087\u0002\u00a2\u0006\u0002\u0010\u0015J)\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0017\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u0002H\u0014H\u0007\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bH\u0007J\u001d\u0010\u001c\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0010\u001a\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u000b\u001a\u00020\fH\u0007J&\u0010\u001d\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u0001H\u0014H\u0087\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\fH\u0007R\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Landroidx/lifecycle/SavedStateHandle;", "", "initialState", "", "", "(Ljava/util/Map;)V", "()V", "flows", "", "Lkotlinx/coroutines/flow/MutableStateFlow;", "regular", "savedStateProvider", "Landroidx/savedstate/SavedStateRegistry$SavedStateProvider;", "savedStateProviders", "clearSavedStateProvider", "", "key", "contains", "", "get", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "getStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "initialValue", "(Ljava/lang/String;Ljava/lang/Object;)Lkotlinx/coroutines/flow/StateFlow;", "keys", "", "remove", "set", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "setSavedStateProvider", "provider", "Companion", "lifecycle-viewmodel-savedstate"})
@SourceDebugExtension(value={"SMAP\nSavedStateHandle.jb.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SavedStateHandle.jb.kt\nandroidx/lifecycle/SavedStateHandle\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,327:1\n372#2,3:328\n375#2,4:332\n1#3:331\n37#4,2:336\n*S KotlinDebug\n*F\n+ 1 SavedStateHandle.jb.kt\nandroidx/lifecycle/SavedStateHandle\n*L\n122#1:328,3\n122#1:332,4\n53#1:336,2\n*E\n"})
public final class SavedStateHandle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Object> regular;
    @NotNull
    private final Map<String, SavedStateRegistry.SavedStateProvider> savedStateProviders;
    @NotNull
    private final Map<String, MutableStateFlow<Object>> flows;
    @NotNull
    private final SavedStateRegistry.SavedStateProvider savedStateProvider;

    public SavedStateHandle(@NotNull Map<String, ? extends Object> initialState) {
        Intrinsics.checkNotNullParameter(initialState, (String)"initialState");
        this.regular = new LinkedHashMap();
        this.savedStateProviders = new LinkedHashMap();
        this.flows = new LinkedHashMap();
        this.savedStateProvider = () -> SavedStateHandle.savedStateProvider$lambda$0(this);
        this.regular.putAll(initialState);
    }

    public SavedStateHandle() {
        this.regular = new LinkedHashMap();
        this.savedStateProviders = new LinkedHashMap();
        this.flows = new LinkedHashMap();
        this.savedStateProvider = () -> SavedStateHandle.savedStateProvider$lambda$0(this);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public final SavedStateRegistry.SavedStateProvider savedStateProvider() {
        return this.savedStateProvider;
    }

    @MainThread
    public final boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.regular.containsKey(key);
    }

    @MainThread
    @NotNull
    public final <T> StateFlow<T> getStateFlow(@NotNull String key, T initialValue) {
        MutableStateFlow mutableStateFlow;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Map<String, MutableStateFlow<Object>> $this$getOrPut$iv = this.flows;
        boolean $i$f$getOrPut = false;
        MutableStateFlow value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            MutableStateFlow mutableStateFlow2;
            boolean bl = false;
            if (!this.regular.containsKey(key)) {
                this.regular.put(key, initialValue);
            }
            MutableStateFlow $this$getStateFlow_u24lambda_u242_u24lambda_u241 = mutableStateFlow2 = StateFlowKt.MutableStateFlow((Object)this.regular.get(key));
            boolean bl2 = false;
            this.flows.put(key, (MutableStateFlow<Object>)$this$getStateFlow_u24lambda_u242_u24lambda_u241);
            MutableStateFlow answer$iv = mutableStateFlow2;
            $this$getOrPut$iv.put(key, (MutableStateFlow<Object>)answer$iv);
            mutableStateFlow = answer$iv;
        } else {
            mutableStateFlow = value$iv;
        }
        StateFlow stateFlow = FlowKt.asStateFlow(mutableStateFlow);
        Intrinsics.checkNotNull((Object)stateFlow, (String)"null cannot be cast to non-null type kotlinx.coroutines.flow.StateFlow<T of androidx.lifecycle.SavedStateHandle.getStateFlow>");
        return stateFlow;
    }

    @MainThread
    @NotNull
    public final Set<String> keys() {
        return SetsKt.plus(this.regular.keySet(), (Iterable)this.savedStateProviders.keySet());
    }

    @MainThread
    @Nullable
    public final <T> T get(@NotNull String key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            object = this.regular.get(key);
        }
        catch (ClassCastException e) {
            this.remove(key);
            object = null;
        }
        return (T)object;
    }

    @MainThread
    public final <T> void set(@NotNull String key, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!Companion.validateValue(value)) {
            StringBuilder stringBuilder = new StringBuilder().append("Can't put value with type ");
            T t = value;
            Intrinsics.checkNotNull(t);
            throw new IllegalArgumentException(stringBuilder.append(Reflection.getOrCreateKotlinClass(t.getClass())).append(" into saved state").toString());
        }
        this.regular.put(key, value);
        MutableStateFlow<Object> mutableStateFlow = this.flows.get(key);
        if (mutableStateFlow != null) {
            mutableStateFlow.setValue(value);
        }
    }

    @MainThread
    @Nullable
    public final <T> T remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object latestValue = this.regular.remove(key);
        this.flows.remove(key);
        return (T)latestValue;
    }

    @MainThread
    public final void setSavedStateProvider(@NotNull String key, @NotNull SavedStateRegistry.SavedStateProvider provider) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.savedStateProviders.put(key, provider);
    }

    @MainThread
    public final void clearSavedStateProvider(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.savedStateProviders.remove(key);
    }

    private static final Bundle savedStateProvider$lambda$0(SavedStateHandle this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = MapsKt.toMap(this$0.savedStateProviders);
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            SavedStateRegistry.SavedStateProvider value = (SavedStateRegistry.SavedStateProvider)entry.getValue();
            Bundle savedState = value.saveState();
            this$0.set(key, savedState);
        }
        Collection $this$toTypedArray$iv = MapsKt.toList(this$0.regular);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        return Bundle_jbKt.bundleOf((Pair[])Arrays.copyOf(pairArray, pairArray.length));
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final SavedStateHandle createHandle(@Nullable Bundle restoredState, @Nullable Bundle defaultState) {
        return Companion.createHandle(restoredState, defaultState);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0007\u00a8\u0006\u000b"}, d2={"Landroidx/lifecycle/SavedStateHandle$Companion;", "", "()V", "createHandle", "Landroidx/lifecycle/SavedStateHandle;", "restoredState", "Landroidx/core/bundle/Bundle;", "defaultState", "validateValue", "", "value", "lifecycle-viewmodel-savedstate"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final SavedStateHandle createHandle(@Nullable Bundle restoredState, @Nullable Bundle defaultState) {
            if (restoredState == null) {
                SavedStateHandle savedStateHandle;
                if (defaultState == null) {
                    savedStateHandle = new SavedStateHandle();
                } else {
                    Map state = new HashMap();
                    for (String key : defaultState.keySet()) {
                        Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type kotlin.String");
                        state.put(key, defaultState.get(key));
                    }
                    savedStateHandle = new SavedStateHandle(state);
                }
                return savedStateHandle;
            }
            Map state = new LinkedHashMap();
            for (String key : restoredState.keySet()) {
                Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type kotlin.String");
                state.put(key, restoredState.get(key));
            }
            return new SavedStateHandle(state);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public final boolean validateValue(@Nullable Object value) {
            Object object;
            Object object2 = value;
            boolean bl = object2 == null ? true : ((((((((object2 instanceof Boolean ? true : object2 instanceof Byte) ? true : object2 instanceof Character) ? true : object2 instanceof Double) ? true : object2 instanceof Float) ? true : object2 instanceof Integer) ? true : object2 instanceof Long) ? true : object2 instanceof Short) ? true : (((object2 instanceof Bundle ? true : object2 instanceof String) ? true : object2 instanceof CharSequence) ? true : ((((((((object2 instanceof boolean[] ? true : object2 instanceof byte[]) ? true : object2 instanceof char[]) ? true : object2 instanceof double[]) ? true : object2 instanceof float[]) ? true : object2 instanceof int[]) ? true : object2 instanceof long[]) ? true : object2 instanceof short[]) ? true : (object2 instanceof List ? (((object = CollectionsKt.firstOrNull((List)((List)value))) instanceof Integer ? true : object instanceof String) ? true : ((List)value).isEmpty()) : false))));
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

