/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio;

import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bio.RomBuffer;
import org.jetbrains.bio.SupportKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010&\u001a\u00020\u001dH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010)\u001a\u00020\u0006H\u0016J\b\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000b\u00a8\u0006,"}, d2={"Lorg/jetbrains/bio/BBRomBuffer;", "Lorg/jetbrains/bio/RomBuffer;", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "value", "", "limit", "getLimit", "()J", "setLimit", "(J)V", "maxLength", "getMaxLength", "order", "Ljava/nio/ByteOrder;", "getOrder", "()Ljava/nio/ByteOrder;", "position", "getPosition", "setPosition", "close", "", "duplicate", "readByte", "", "readBytes", "", "size", "", "readCString", "", "readDouble", "", "readFloat", "", "readFloats", "", "readInt", "readInts", "", "readLong", "readShort", "", "big"})
public final class BBRomBuffer
extends RomBuffer {
    private final long maxLength;
    private final ByteBuffer buffer;

    @Override
    public long getPosition() {
        return this.buffer.position();
    }

    @Override
    public void setPosition(long value) {
        SupportKt.ignore(this.buffer.position(Ints.checkedCast((long)value)));
    }

    @Override
    public long getMaxLength() {
        return this.maxLength;
    }

    @Override
    public long getLimit() {
        return this.buffer.limit();
    }

    @Override
    public void setLimit(long value) {
        this.buffer.limit(Ints.checkedCast((long)value));
    }

    @Override
    @NotNull
    public ByteOrder getOrder() {
        ByteOrder byteOrder = this.buffer.order();
        Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"buffer.order()");
        return byteOrder;
    }

    @Override
    @NotNull
    public BBRomBuffer duplicate(long position, long limit) {
        Object object = this.buffer.duplicate();
        boolean bl = false;
        boolean bl2 = false;
        Object $this$apply = object;
        boolean bl3 = false;
        ((ByteBuffer)$this$apply).order(this.buffer.order());
        ((ByteBuffer)$this$apply).position(Ints.checkedCast((long)position));
        Unit unit = Unit.INSTANCE;
        ByteBuffer byteBuffer = object;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buffer.duplicate().apply\u2026ckedCast(position))\n    }");
        ByteBuffer byteBuffer2 = byteBuffer;
        object = new BBRomBuffer(byteBuffer2);
        bl = false;
        bl2 = false;
        $this$apply = object;
        boolean bl4 = false;
        ((BBRomBuffer)$this$apply).setPosition(position);
        ((BBRomBuffer)$this$apply).setLimit(limit);
        return object;
    }

    @Override
    public void close() {
    }

    @Override
    @NotNull
    public int[] readInts(int size) {
        int[] nArray = new int[size];
        boolean bl = false;
        boolean bl2 = false;
        int[] $this$apply = nArray;
        boolean bl3 = false;
        this.buffer.asIntBuffer().get($this$apply);
        this.buffer.position(this.buffer.position() + size * 4);
        return nArray;
    }

    @Override
    @NotNull
    public float[] readFloats(int size) {
        float[] fArray = new float[size];
        boolean bl = false;
        boolean bl2 = false;
        float[] $this$apply = fArray;
        boolean bl3 = false;
        this.buffer.asFloatBuffer().get($this$apply);
        this.buffer.position(this.buffer.position() + size * 4);
        return fArray;
    }

    @Override
    @NotNull
    public byte[] readBytes(int size) {
        byte[] byArray = new byte[size];
        boolean bl = false;
        boolean bl2 = false;
        byte[] $this$apply = byArray;
        boolean bl3 = false;
        this.buffer.get($this$apply);
        return byArray;
    }

    @Override
    public byte readByte() {
        return this.buffer.get();
    }

    @Override
    public short readShort() {
        return this.buffer.getShort();
    }

    @Override
    public int readInt() {
        return this.buffer.getInt();
    }

    @Override
    public long readLong() {
        return this.buffer.getLong();
    }

    @Override
    public float readFloat() {
        return this.buffer.getFloat();
    }

    @Override
    public double readDouble() {
        return this.buffer.getDouble();
    }

    @Override
    @NotNull
    public String readCString() {
        return this.doReadCString();
    }

    public BBRomBuffer(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.maxLength = this.buffer.capacity();
    }
}

