/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio;

import com.google.common.primitives.Ints;
import htsjdk.samtools.seekablestream.SeekableStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u001d\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\b\b\u0016\u0018\u0000 F2\u00020\u0001:\u0001FB!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u00103\u001a\u000204H\u0016J\r\u00105\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b6J\b\u00107\u001a\u00020\u0006H\u0016J%\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b<J\b\u0010=\u001a\u00020\u0004H\u0014J\n\u0010>\u001a\u0004\u0018\u00010?H\u0016J\b\u0010@\u001a\u00020\u000fH\u0016J\b\u0010/\u001a\u00020\u000fH\u0016J\b\u0010A\u001a\u00020\u0004H\u0016J \u0010A\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t2\u0006\u0010B\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\u0004H\u0016J\u0010\u0010C\u001a\u0002042\u0006\u0010/\u001a\u00020\u000fH\u0016J\r\u0010D\u001a\u000204H\u0000\u00a2\u0006\u0002\bER(\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f8F@DX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR$\u0010 \u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f8F@DX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u0012\"\u0004\b\"\u0010\u0014R\"\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b$\u0010\u0018\"\u0004\b%\u0010\u001aR$\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0016X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010+\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R$\u0010/\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0012\"\u0004\b1\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/bio/BetterSeekableBufferedStream;", "Lhtsjdk/samtools/seekablestream/SeekableStream;", "stream", "bufferSize", "", "doubleBuffer", "", "(Lhtsjdk/samtools/seekablestream/SeekableStream;IZ)V", "value", "", "buffer", "getBuffer$big", "()[B", "setBuffer$big", "([B)V", "", "bufferEndOffset", "getBufferEndOffset", "()J", "setBufferEndOffset", "(J)V", "bufferEndOffsets", "", "getBufferEndOffsets$big", "()[Ljava/lang/Long;", "setBufferEndOffsets$big", "([Ljava/lang/Long;)V", "[Ljava/lang/Long;", "getBufferSize", "()I", "setBufferSize", "(I)V", "bufferStartOffset", "getBufferStartOffset", "setBufferStartOffset", "bufferStartOffsets", "getBufferStartOffsets$big", "setBufferStartOffsets$big", "buffers", "getBuffers$big", "()[[B", "setBuffers$big", "([[B)V", "[[B", "getDoubleBuffer", "()Z", "<set-?>", "position", "getPosition", "setPosition", "useSndBuffer", "close", "", "curBufIdx", "curBufIdx$big", "eof", "fetchNewBuffer", "pos", "buffOffset", "size", "fetchNewBuffer$big", "fillBuffer", "getSource", "", "length", "read", "offset", "seek", "switchBuffersIfNeeded", "switchBuffersIfNeeded$big", "Companion", "big"})
public class BetterSeekableBufferedStream
extends SeekableStream {
    private long position;
    private boolean useSndBuffer;
    @NotNull
    private Long[] bufferStartOffsets;
    @NotNull
    private Long[] bufferEndOffsets;
    @NotNull
    private byte[][] buffers;
    private final SeekableStream stream;
    private final boolean doubleBuffer;
    public static final int DEFAULT_BUFFER_SIZE = 128000;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final long getPosition() {
        return this.position;
    }

    protected final void setPosition(long l) {
        this.position = l;
    }

    public final int curBufIdx$big() {
        return this.useSndBuffer ? 1 : 0;
    }

    @NotNull
    public final Long[] getBufferStartOffsets$big() {
        return this.bufferStartOffsets;
    }

    public final void setBufferStartOffsets$big(@NotNull Long[] longArray) {
        Intrinsics.checkNotNullParameter((Object)longArray, (String)"<set-?>");
        this.bufferStartOffsets = longArray;
    }

    public final long getBufferStartOffset() {
        return this.bufferStartOffsets[this.curBufIdx$big()];
    }

    protected final void setBufferStartOffset(long value) {
        this.bufferStartOffsets[this.curBufIdx$big()] = value;
    }

    @NotNull
    public final Long[] getBufferEndOffsets$big() {
        return this.bufferEndOffsets;
    }

    public final void setBufferEndOffsets$big(@NotNull Long[] longArray) {
        Intrinsics.checkNotNullParameter((Object)longArray, (String)"<set-?>");
        this.bufferEndOffsets = longArray;
    }

    public final long getBufferEndOffset() {
        return this.bufferEndOffsets[this.curBufIdx$big()];
    }

    protected final void setBufferEndOffset(long value) {
        this.bufferEndOffsets[this.curBufIdx$big()] = value;
    }

    @NotNull
    public final byte[][] getBuffers$big() {
        return this.buffers;
    }

    public final void setBuffers$big(@NotNull byte[][] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.buffers = byArray;
    }

    @Nullable
    public final byte[] getBuffer$big() {
        byte[] buf = this.buffers[this.curBufIdx$big()];
        boolean bl = false;
        boolean bl2 = false;
        if (buf == null) {
            boolean bl3 = false;
            String string = "Stream is closed: " + this.getSource();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return buf;
    }

    public final void setBuffer$big(@Nullable byte[] value) {
        this.buffers[this.curBufIdx$big()] = value;
    }

    public final int getBufferSize() {
        byte[] byArray = this.getBuffer$big();
        Intrinsics.checkNotNull((Object)byArray);
        return byArray.length;
    }

    public final void setBufferSize(int bufferSize) {
        this.useSndBuffer = false;
        this.buffers = new byte[][]{new byte[bufferSize], new byte[bufferSize]};
        this.bufferStartOffsets = new Long[]{0L, 0L};
        this.bufferEndOffsets = new Long[]{0L, 0L};
    }

    public long length() {
        return this.stream.length();
    }

    @Nullable
    public String getSource() {
        return this.stream.getSource();
    }

    public boolean eof() {
        return this.position >= this.length();
    }

    public void seek(long position) {
        boolean bl = position >= 0L;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Position should be non-negative value, but was " + position + " in " + this.getSource();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.position = position;
    }

    public long position() {
        return this.position;
    }

    public void close() {
        this.setBuffer$big(null);
        this.stream.close();
    }

    public int read(@NotNull byte[] buffer, int offset, int length) {
        int count;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        long initialPos = this.position;
        long requestEndOffset = initialPos + (long)length;
        long cachedStart = this.getBufferStartOffset();
        long cachedEnd = this.getBufferEndOffset();
        int readBytes = 0;
        int dstOffset = offset;
        if (requestEndOffset >= cachedEnd) {
            long l = this.position;
            if (cachedStart <= l && cachedEnd > l) {
                int inCBuffPos = (int)(this.position - cachedStart);
                count = (int)(cachedEnd - cachedStart) - inCBuffPos;
                byte[] byArray = this.getBuffer$big();
                Intrinsics.checkNotNull((Object)byArray);
                System.arraycopy(byArray, inCBuffPos, buffer, dstOffset, count);
                readBytes = count;
                dstOffset += count;
                this.seek(this.position + (long)count);
            }
        } else if (requestEndOffset >= cachedStart) {
            count = 0;
            int n = (int)(this.position - cachedStart);
            boolean bl = false;
            int inCBuffPos = Math.max(count, n);
            count = (int)(requestEndOffset - cachedStart) - inCBuffPos;
            byte[] byArray = this.getBuffer$big();
            Intrinsics.checkNotNull((Object)byArray);
            System.arraycopy(byArray, inCBuffPos, buffer, dstOffset + length - count, count);
            readBytes = count;
        }
        while (readBytes < length) {
            this.fillBuffer();
            long newCachedEnd = this.getBufferEndOffset();
            if (newCachedEnd == -1L) break;
            int available = (int)(newCachedEnd - this.position);
            int remaining = length - readBytes;
            boolean bl = false;
            int count2 = Math.min(remaining, available);
            int inBuffPos = Ints.checkedCast((long)(this.position - this.getBufferStartOffset()));
            byte[] byArray = this.getBuffer$big();
            Intrinsics.checkNotNull((Object)byArray);
            System.arraycopy(byArray, inBuffPos, buffer, dstOffset, count2);
            readBytes += count2;
            dstOffset += count2;
            this.seek(this.position + (long)count2);
        }
        this.seek(initialPos + (long)readBytes);
        return readBytes > 0 ? readBytes : -1;
    }

    public int read() {
        long cachedStart = this.getBufferStartOffset();
        long cachedEnd = this.getBufferEndOffset();
        if (cachedEnd == -1L) {
            return -1;
        }
        long l = this.position;
        if (cachedStart > l || cachedEnd <= l) {
            this.fillBuffer();
            if (this.getBufferEndOffset() == -1L) {
                return -1;
            }
        }
        int inBuffPos = (int)(this.position - this.getBufferStartOffset());
        long l2 = this.position;
        this.position = l2 + 1L;
        byte[] byArray = this.getBuffer$big();
        Intrinsics.checkNotNull((Object)byArray);
        return byArray[inBuffPos] & 0xFF;
    }

    public final void switchBuffersIfNeeded$big() {
        if (!this.doubleBuffer) {
            return;
        }
        long cachedStart = this.getBufferStartOffset();
        long cachedEnd = this.getBufferEndOffset();
        byte[] byArray = this.getBuffer$big();
        Intrinsics.checkNotNull((Object)byArray);
        int maxBuffSize = byArray.length;
        long newEnd = this.position + (long)maxBuffSize;
        if (this.position < cachedStart && newEnd <= cachedStart || this.position >= cachedEnd) {
            this.useSndBuffer = !this.useSndBuffer;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int fillBuffer() {
        this.switchBuffersIfNeeded$big();
        byte[] byArray = this.getBuffer$big();
        Intrinsics.checkNotNull((Object)byArray);
        byte[] buff = byArray;
        int maxBuffSize = buff.length;
        long cachedStart = this.getBufferStartOffset();
        long cachedEnd = this.getBufferEndOffset();
        int actuallyReadBytes = 0;
        long desiredNextEndOffset = this.position + (long)maxBuffSize;
        if (this.position >= cachedEnd) {
            return this.fetchNewBuffer$big(this.position, 0, maxBuffSize);
        }
        if (this.position >= cachedStart) return actuallyReadBytes;
        if (desiredNextEndOffset <= cachedStart) return this.fetchNewBuffer$big(this.position, 0, maxBuffSize);
        boolean bl = false;
        int count = (int)(Math.min(desiredNextEndOffset, cachedEnd) - cachedStart);
        int remainingPrefixLength = (int)(cachedStart - this.position);
        System.arraycopy(buff, 0, buff, remainingPrefixLength, count);
        try {
            actuallyReadBytes = this.fetchNewBuffer$big(this.position, 0, remainingPrefixLength);
            boolean bl2 = this.getBufferEndOffset() != -1L;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!bl2) {
                boolean bl5 = false;
                String string = "Read backward, cannot be eof. Position " + this.position + ", " + count;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (actuallyReadBytes != remainingPrefixLength) return actuallyReadBytes;
            BetterSeekableBufferedStream betterSeekableBufferedStream = this;
            betterSeekableBufferedStream.setBufferEndOffset(betterSeekableBufferedStream.getBufferEndOffset() + (long)count);
            return actuallyReadBytes;
        }
        catch (Exception e) {
            this.setBufferStartOffset(0L);
            this.setBufferEndOffset(0L);
            throw (Throwable)e;
        }
    }

    public int fetchNewBuffer$big(long pos, int buffOffset, int size) {
        this.stream.seek(pos);
        if (size == 0) {
            this.setBufferStartOffset(pos);
            this.setBufferEndOffset(pos);
            return 0;
        }
        byte[] byArray = this.getBuffer$big();
        Intrinsics.checkNotNull((Object)byArray);
        byte[] buff = byArray;
        int n = this.stream.read(buff, buffOffset, size);
        if (n <= 0) {
            this.setBufferStartOffset(0L);
            this.setBufferEndOffset(-1L);
        } else {
            this.setBufferStartOffset(pos);
            this.setBufferEndOffset(pos + (long)n);
        }
        return n;
    }

    public final boolean getDoubleBuffer() {
        return this.doubleBuffer;
    }

    public BetterSeekableBufferedStream(@NotNull SeekableStream stream, int bufferSize, boolean doubleBuffer) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream;
        this.doubleBuffer = doubleBuffer;
        this.bufferStartOffsets = new Long[]{0L, 0L};
        this.bufferEndOffsets = new Long[]{0L, 0L};
        this.buffers = new byte[][]{(byte[])null, (byte[])null};
        this.setBufferSize(bufferSize < 0 ? 128000 : bufferSize);
    }

    public /* synthetic */ BetterSeekableBufferedStream(SeekableStream seekableStream, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 128000;
        }
        if ((n2 & 4) != 0) {
            bl = true;
        }
        this(seekableStream, n, bl);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/bio/BetterSeekableBufferedStream$Companion;", "", "()V", "DEFAULT_BUFFER_SIZE", "", "big"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

