/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio;

import com.google.common.io.LittleEndianDataInputStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.EndianSeekableDataInput;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0017H\u0016J \u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0015H\u0016J\b\u0010'\u001a\u00020\u0015H\u0016J\n\u0010(\u001a\u0004\u0018\u00010)H\u0017J\b\u0010*\u001a\u00020\u0012H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\n .*\u0004\u0018\u00010)0)H\u0016J\b\u0010/\u001a\u00020\u0015H\u0016J\b\u00100\u001a\u00020\u0015H\u0016J\u0010\u00101\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/bio/EndianAwareDataSeekableStream;", "Lorg/jetbrains/bio/EndianSeekableDataInput;", "stream", "Lhtsjdk/samtools/seekablestream/SeekableStream;", "(Lhtsjdk/samtools/seekablestream/SeekableStream;)V", "beInput", "Ljava/io/DataInputStream;", "leInput", "Lcom/google/common/io/LittleEndianDataInputStream;", "order", "Ljava/nio/ByteOrder;", "getOrder", "()Ljava/nio/ByteOrder;", "setOrder", "(Ljava/nio/ByteOrder;)V", "close", "", "length", "", "position", "read", "", "buffer", "", "offset", "readBoolean", "", "readByte", "", "readChar", "", "readDouble", "", "readFloat", "", "readFully", "b", "off", "len", "readInt", "readLine", "", "readLong", "readShort", "", "readUTF", "kotlin.jvm.PlatformType", "readUnsignedByte", "readUnsignedShort", "seek", "skipBytes", "n", "big"})
public final class EndianAwareDataSeekableStream
implements EndianSeekableDataInput {
    @NotNull
    private ByteOrder order;
    private final DataInputStream beInput;
    private final LittleEndianDataInputStream leInput;
    private final SeekableStream stream;

    @Override
    @NotNull
    public ByteOrder getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(@NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"<set-?>");
        this.order = byteOrder;
    }

    @Override
    public long position() {
        return this.stream.position();
    }

    @Override
    public long length() {
        return this.stream.length();
    }

    @Override
    public void seek(long position) {
        this.stream.seek(position);
    }

    @Override
    public void close() {
        this.stream.close();
    }

    @Override
    public int read(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return this.stream.read(buffer, offset, length);
    }

    @Override
    public int readInt() {
        ByteOrder byteOrder = this.getOrder();
        return Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.BIG_ENDIAN) ? this.beInput.readInt() : this.leInput.readInt();
    }

    @Override
    public long readLong() {
        ByteOrder byteOrder = this.getOrder();
        return Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.BIG_ENDIAN) ? this.beInput.readLong() : this.leInput.readLong();
    }

    @Override
    public float readFloat() {
        ByteOrder byteOrder = this.getOrder();
        return Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.BIG_ENDIAN) ? this.beInput.readFloat() : this.leInput.readFloat();
    }

    @Override
    public double readDouble() {
        ByteOrder byteOrder = this.getOrder();
        return Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.BIG_ENDIAN) ? this.beInput.readDouble() : this.leInput.readDouble();
    }

    @Override
    public void readFully(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        ByteOrder byteOrder = this.getOrder();
        if (Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.BIG_ENDIAN)) {
            this.beInput.readFully(b);
        } else {
            this.leInput.readFully(b);
        }
    }

    @Override
    public void readFully(@NotNull byte[] b, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        ByteOrder byteOrder = this.getOrder();
        if (Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.BIG_ENDIAN)) {
            this.beInput.readFully(b, off, len);
        } else {
            this.leInput.readFully(b, off, len);
        }
    }

    @Override
    public int readUnsignedShort() {
        ByteOrder byteOrder = this.getOrder();
        return Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.BIG_ENDIAN) ? this.beInput.readUnsignedShort() : this.leInput.readUnsignedShort();
    }

    @Override
    public int readUnsignedByte() {
        ByteOrder byteOrder = this.getOrder();
        return Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.BIG_ENDIAN) ? this.beInput.readUnsignedByte() : this.leInput.readUnsignedByte();
    }

    @Override
    public String readUTF() {
        ByteOrder byteOrder = this.getOrder();
        return Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.BIG_ENDIAN) ? this.beInput.readUTF() : this.leInput.readUTF();
    }

    @Override
    public char readChar() {
        ByteOrder byteOrder = this.getOrder();
        return Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.BIG_ENDIAN) ? this.beInput.readChar() : this.leInput.readChar();
    }

    @Override
    @Deprecated(message="Unsupported for LE and doesn't work properly for BE stream. So let's always throw `UnsupportedOperationException`")
    @Nullable
    public String readLine() throws UnsupportedOperationException {
        throw (Throwable)new UnsupportedOperationException("readLine is not supported");
    }

    @Override
    public byte readByte() {
        ByteOrder byteOrder = this.getOrder();
        return Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.BIG_ENDIAN) ? this.beInput.readByte() : this.leInput.readByte();
    }

    @Override
    public int skipBytes(int n) {
        ByteOrder byteOrder = this.getOrder();
        return Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.BIG_ENDIAN) ? this.beInput.skipBytes(n) : this.leInput.skipBytes(n);
    }

    @Override
    public boolean readBoolean() {
        ByteOrder byteOrder = this.getOrder();
        return Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.BIG_ENDIAN) ? this.beInput.readBoolean() : this.leInput.readBoolean();
    }

    @Override
    public short readShort() {
        ByteOrder byteOrder = this.getOrder();
        return Intrinsics.areEqual((Object)byteOrder, (Object)ByteOrder.BIG_ENDIAN) ? this.beInput.readShort() : this.leInput.readShort();
    }

    public EndianAwareDataSeekableStream(@NotNull SeekableStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream;
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"ByteOrder.BIG_ENDIAN");
        this.order = byteOrder;
        this.beInput = new DataInputStream((InputStream)this.stream);
        this.leInput = new LittleEndianDataInputStream((InputStream)this.stream);
    }

    @Override
    public void readInt(@NotNull int[] pa, int start, int n) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pa, (String)"pa");
        EndianSeekableDataInput.DefaultImpls.readInt(this, pa, start, n);
    }

    @Override
    public void readLong(@NotNull long[] pa, int start, int n) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pa, (String)"pa");
        EndianSeekableDataInput.DefaultImpls.readLong(this, pa, start, n);
    }

    @Override
    public void readFloat(@NotNull float[] pa, int start, int n) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pa, (String)"pa");
        EndianSeekableDataInput.DefaultImpls.readFloat(this, pa, start, n);
    }

    @Override
    public void readDouble(@NotNull double[] pa, int start, int n) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pa, (String)"pa");
        EndianSeekableDataInput.DefaultImpls.readDouble(this, pa, start, n);
    }
}

