/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.seekablestream.SeekableStreamFactory;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bio.BetterSeekableBufferedStream;
import org.jetbrains.bio.EndianAwareDataSeekableStream;
import org.jetbrains.bio.EndianSeekableDataInput;
import org.jetbrains.bio.LightweightRomBuffer;
import org.jetbrains.bio.RomBuffer;
import org.jetbrains.bio.RomBufferFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/bio/EndianBufferFactory;", "Lorg/jetbrains/bio/RomBufferFactory;", "stream", "Lorg/jetbrains/bio/EndianSeekableDataInput;", "(Lorg/jetbrains/bio/EndianSeekableDataInput;)V", "maxLength", "", "order", "Ljava/nio/ByteOrder;", "getOrder", "()Ljava/nio/ByteOrder;", "setOrder", "(Ljava/nio/ByteOrder;)V", "close", "", "create", "Lorg/jetbrains/bio/RomBuffer;", "Companion", "big"})
public class EndianBufferFactory
implements RomBufferFactory {
    @NotNull
    private ByteOrder order;
    private final long maxLength;
    private final EndianSeekableDataInput stream;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ByteOrder getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(@NotNull ByteOrder byteOrder) {
        Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"<set-?>");
        this.order = byteOrder;
    }

    @Override
    @NotNull
    public RomBuffer create() {
        return new LightweightRomBuffer(this.stream, this.getOrder(), this.maxLength, 0L, 0L, 24, null);
    }

    @Override
    public void close() {
        this.stream.close();
    }

    public EndianBufferFactory(@NotNull EndianSeekableDataInput stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.stream = stream;
        this.order = this.stream.getOrder();
        this.maxLength = this.stream.length();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/bio/EndianBufferFactory$Companion;", "", "()V", "create", "Lorg/jetbrains/bio/EndianBufferFactory;", "path", "", "byteOrder", "Ljava/nio/ByteOrder;", "bufferSize", "", "big"})
    public static final class Companion {
        @NotNull
        public final EndianBufferFactory create(@NotNull String path, @NotNull ByteOrder byteOrder, int bufferSize) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)byteOrder, (String)"byteOrder");
            SeekableStream seekableStream = SeekableStreamFactory.getInstance().getStreamFor(path);
            Intrinsics.checkNotNullExpressionValue((Object)seekableStream, (String)"SeekableStreamFactory.ge\u2026ance().getStreamFor(path)");
            EndianAwareDataSeekableStream endianAwareDataSeekableStream = new EndianAwareDataSeekableStream(new BetterSeekableBufferedStream(seekableStream, bufferSize, false, 4, null));
            boolean bl = false;
            boolean bl2 = false;
            EndianAwareDataSeekableStream $this$apply = endianAwareDataSeekableStream;
            boolean bl3 = false;
            $this$apply.setOrder(byteOrder);
            Unit unit = Unit.INSTANCE;
            EndianSeekableDataInput endianSeekableDataInput = endianAwareDataSeekableStream;
            return new EndianBufferFactory(endianSeekableDataInput);
        }

        public static /* synthetic */ EndianBufferFactory create$default(Companion companion, String string, ByteOrder byteOrder, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 128000;
            }
            return companion.create(string, byteOrder, n);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

