/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.big;

import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.OrderedDataOutput;
import org.jetbrains.bio.RomBuffer;
import org.jetbrains.bio.SupportKt;
import org.jetbrains.bio.big.BPlusLeaf;
import org.jetbrains.bio.big.BPlusNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ#\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0082\u0010J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/bio/big/BPlusTree;", "", "header", "Lorg/jetbrains/bio/big/BPlusTree$Header;", "(Lorg/jetbrains/bio/big/BPlusTree$Header;)V", "getHeader", "()Lorg/jetbrains/bio/big/BPlusTree$Header;", "find", "Lorg/jetbrains/bio/big/BPlusLeaf;", "input", "Lorg/jetbrains/bio/RomBuffer;", "query", "", "findRecursively", "blockStart", "", "traverse", "Lkotlin/sequences/Sequence;", "traverseRecursively", "offset", "Companion", "Header", "big"})
public final class BPlusTree {
    @NotNull
    private final Header header;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Sequence<BPlusLeaf> traverse(@NotNull RomBuffer input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.header.getItemCount() == 0 ? SequencesKt.emptySequence() : this.traverseRecursively(input, this.header.getRootOffset());
    }

    private final Sequence<BPlusLeaf> traverseRecursively(RomBuffer input, long offset) {
        Sequence sequence;
        boolean bl = Intrinsics.areEqual((Object)input.getOrder(), (Object)this.header.getOrder());
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        input.setPosition(offset);
        boolean isLeaf = input.readByte() > 0;
        input.readByte();
        int childCount = input.readUnsignedShort();
        if (isLeaf) {
            IntProgression $this$mapUnboxed$iv = (IntProgression)RangesKt.until((int)0, (int)childCount);
            boolean $i$f$mapUnboxed = false;
            IntIterator it$iv = $this$mapUnboxed$iv.iterator();
            sequence = CollectionsKt.asSequence((Iterable)SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)new Iterator<BPlusLeaf>(it$iv, this, input){
                final /* synthetic */ IntIterator $it;
                final /* synthetic */ BPlusTree this$0;
                final /* synthetic */ RomBuffer $input$inlined;
                {
                    this.$it = $captured_local_variable$1;
                    this.this$0 = bPlusTree;
                    this.$input$inlined = romBuffer;
                }

                public BPlusLeaf next() {
                    int it = this.$it.nextInt();
                    boolean bl = false;
                    return BPlusLeaf.Companion.read$big(this.$input$inlined, this.this$0.getHeader().getKeySize());
                }

                public boolean hasNext() {
                    return this.$it.hasNext();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            })));
        } else {
            IntProgression $this$mapUnboxed$iv = (IntProgression)RangesKt.until((int)0, (int)childCount);
            boolean $i$f$mapUnboxed = false;
            IntIterator it$iv = $this$mapUnboxed$iv.iterator();
            sequence = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)new Iterator<BPlusNode>(it$iv, this, input){
                final /* synthetic */ IntIterator $it;
                final /* synthetic */ BPlusTree this$0;
                final /* synthetic */ RomBuffer $input$inlined;
                {
                    this.$it = $captured_local_variable$1;
                    this.this$0 = bPlusTree;
                    this.$input$inlined = romBuffer;
                }

                public BPlusNode next() {
                    int it = this.$it.nextInt();
                    boolean bl = false;
                    return BPlusNode.Companion.read$big(this.$input$inlined, this.this$0.getHeader().getKeySize());
                }

                public boolean hasNext() {
                    return this.$it.hasNext();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            }))), (Function1)((Function1)new Function1<BPlusNode, Sequence<? extends BPlusLeaf>>(this, input){
                final /* synthetic */ BPlusTree this$0;
                final /* synthetic */ RomBuffer $input;

                @NotNull
                public final Sequence<BPlusLeaf> invoke(@NotNull BPlusNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return BPlusTree.access$traverseRecursively(this.this$0, this.$input, it.getChildOffset());
                }
                {
                    this.this$0 = bPlusTree;
                    this.$input = romBuffer;
                    super(1);
                }
            }));
        }
        return sequence;
    }

    @Nullable
    public final BPlusLeaf find(@NotNull RomBuffer input, @NotNull String query2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        if (this.header.getItemCount() == 0 || query2.length() > this.header.getKeySize()) {
            return null;
        }
        return this.findRecursively(input, this.header.getRootOffset(), query2);
    }

    /*
     * WARNING - void declaration
     */
    private final BPlusLeaf findRecursively(RomBuffer input, long blockStart, String query2) {
        while (true) {
            BPlusNode next;
            int n;
            boolean bl = Intrinsics.areEqual((Object)input.getOrder(), (Object)this.header.getOrder());
            boolean bl2 = false;
            int n2 = 0;
            if (_Assertions.ENABLED && !bl) {
                n = 0;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            input.setPosition(blockStart);
            boolean isLeaf = input.readByte() > 0;
            input.readByte();
            int childCount = input.readUnsignedShort();
            if (isLeaf) {
                n2 = 0;
                n = childCount;
                while (n2 < n) {
                    void i;
                    BPlusLeaf leaf = BPlusLeaf.Companion.read$big(input, this.header.getKeySize());
                    if (Intrinsics.areEqual((Object)leaf.getKey(), (Object)query2)) {
                        return leaf;
                    }
                    ++i;
                }
                return null;
            }
            BPlusNode node = BPlusNode.Companion.read$big(input, this.header.getKeySize());
            n = 1;
            int n3 = childCount;
            while (n < n3 && query2.compareTo((next = BPlusNode.Companion.read$big(input, this.header.getKeySize())).getKey()) >= 0) {
                void i;
                node = next;
                ++i;
            }
            blockStart = node.getChildOffset();
        }
    }

    @NotNull
    public final Header getHeader() {
        return this.header;
    }

    public BPlusTree(@NotNull Header header2) {
        Intrinsics.checkNotNullParameter((Object)header2, (String)"header");
        this.header = header2;
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(BPlusTree.class);
    }

    public static final /* synthetic */ Sequence access$traverseRecursively(BPlusTree $this, RomBuffer input, long offset) {
        return $this.traverseRecursively(input, offset);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\b\u0018\u0000 #2\u00020\u0001:\u0001#B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lorg/jetbrains/bio/big/BPlusTree$Header;", "", "order", "Ljava/nio/ByteOrder;", "blockSize", "", "keySize", "itemCount", "rootOffset", "", "(Ljava/nio/ByteOrder;IIIJ)V", "getBlockSize", "()I", "getItemCount", "getKeySize", "getOrder", "()Ljava/nio/ByteOrder;", "getRootOffset", "()J", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "", "write", "", "output", "Lorg/jetbrains/bio/OrderedDataOutput;", "Companion", "big"})
    public static final class Header {
        @NotNull
        private final ByteOrder order;
        private final int blockSize;
        private final int keySize;
        private final int itemCount;
        private final long rootOffset;
        private static final int BYTES;
        private static final int MAGIC;
        @NotNull
        public static final Companion Companion;

        public final void write(@NotNull OrderedDataOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            boolean bl = false;
            boolean bl2 = false;
            OrderedDataOutput $this$with = output;
            boolean bl3 = false;
            $this$with.writeInt(MAGIC);
            $this$with.writeInt(this.blockSize);
            $this$with.writeInt(this.keySize);
            $this$with.writeInt(8);
            $this$with.writeLong(this.itemCount);
            $this$with.writeLong(0L);
        }

        @NotNull
        public final ByteOrder getOrder() {
            return this.order;
        }

        public final int getBlockSize() {
            return this.blockSize;
        }

        public final int getKeySize() {
            return this.keySize;
        }

        public final int getItemCount() {
            return this.itemCount;
        }

        public final long getRootOffset() {
            return this.rootOffset;
        }

        public Header(@NotNull ByteOrder order, int blockSize, int keySize, int itemCount, long rootOffset) {
            Intrinsics.checkNotNullParameter((Object)order, (String)"order");
            this.order = order;
            this.blockSize = blockSize;
            this.keySize = keySize;
            this.itemCount = itemCount;
            this.rootOffset = rootOffset;
        }

        static {
            Companion = new Companion(null);
            BYTES = 32;
            MAGIC = 2026540177;
        }

        @NotNull
        public final ByteOrder component1() {
            return this.order;
        }

        public final int component2() {
            return this.blockSize;
        }

        public final int component3() {
            return this.keySize;
        }

        public final int component4() {
            return this.itemCount;
        }

        public final long component5() {
            return this.rootOffset;
        }

        @NotNull
        public final Header copy(@NotNull ByteOrder order, int blockSize, int keySize, int itemCount, long rootOffset) {
            Intrinsics.checkNotNullParameter((Object)order, (String)"order");
            return new Header(order, blockSize, keySize, itemCount, rootOffset);
        }

        public static /* synthetic */ Header copy$default(Header header2, ByteOrder byteOrder, int n, int n2, int n3, long l, int n4, Object object) {
            if ((n4 & 1) != 0) {
                byteOrder = header2.order;
            }
            if ((n4 & 2) != 0) {
                n = header2.blockSize;
            }
            if ((n4 & 4) != 0) {
                n2 = header2.keySize;
            }
            if ((n4 & 8) != 0) {
                n3 = header2.itemCount;
            }
            if ((n4 & 0x10) != 0) {
                l = header2.rootOffset;
            }
            return header2.copy(byteOrder, n, n2, n3, l);
        }

        @NotNull
        public String toString() {
            return "Header(order=" + this.order + ", blockSize=" + this.blockSize + ", keySize=" + this.keySize + ", itemCount=" + this.itemCount + ", rootOffset=" + this.rootOffset + ")";
        }

        public int hashCode() {
            ByteOrder byteOrder = this.order;
            return ((((byteOrder != null ? byteOrder.hashCode() : 0) * 31 + Integer.hashCode(this.blockSize)) * 31 + Integer.hashCode(this.keySize)) * 31 + Integer.hashCode(this.itemCount)) * 31 + Long.hashCode(this.rootOffset);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Header)) break block3;
                    Header header2 = (Header)object;
                    if (!Intrinsics.areEqual((Object)this.order, (Object)header2.order) || this.blockSize != header2.blockSize || this.keySize != header2.keySize || this.itemCount != header2.itemCount || this.rootOffset != header2.rootOffset) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/bio/big/BPlusTree$Header$Companion;", "", "()V", "BYTES", "", "getBYTES$big", "()I", "MAGIC", "read", "Lorg/jetbrains/bio/big/BPlusTree$Header;", "input", "Lorg/jetbrains/bio/RomBuffer;", "offset", "", "big"})
        public static final class Companion {
            public final int getBYTES$big() {
                return BYTES;
            }

            @NotNull
            public final Header read(@NotNull RomBuffer input, long offset) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                boolean bl = false;
                boolean bl2 = false;
                RomBuffer $this$with = input;
                boolean bl3 = false;
                ByteOrder expectedOrder = $this$with.getOrder();
                $this$with.setPosition(offset);
                $this$with.checkHeader(MAGIC);
                boolean bl4 = Intrinsics.areEqual((Object)$this$with.getOrder(), (Object)expectedOrder);
                boolean bl5 = false;
                boolean bl6 = false;
                bl6 = false;
                boolean bl7 = false;
                if (!bl4) {
                    boolean bl8 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                int blockSize = $this$with.readInt();
                int keySize = $this$with.readInt();
                int valSize = $this$with.readInt();
                bl7 = valSize == 8;
                boolean bl9 = false;
                boolean bl10 = false;
                if (!bl7) {
                    boolean bl11 = false;
                    String string = "inconsistent value size: " + valSize;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                long itemCount = $this$with.readLong();
                $this$with.readLong();
                long rootOffset = $this$with.getPosition();
                return new Header($this$with.getOrder(), blockSize, keySize, Ints.checkedCast((long)itemCount), rootOffset);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\nJ\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J-\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\b\b\u0002\u0010\b\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0019J.\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J.\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/bio/big/BPlusTree$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "countLevels", "", "blockSize", "itemCount", "countLevels$big", "read", "Lorg/jetbrains/bio/big/BPlusTree;", "input", "Lorg/jetbrains/bio/RomBuffer;", "offset", "", "read$big", "write", "", "output", "Lorg/jetbrains/bio/OrderedDataOutput;", "unsortedItems", "", "Lorg/jetbrains/bio/big/BPlusLeaf;", "write$big", "writeLeaves", "items", "keySize", "writeLevels", "big"})
    public static final class Companion {
        @NotNull
        public final BPlusTree read$big(@NotNull RomBuffer input, long offset) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return new BPlusTree(Header.Companion.read(input, offset));
        }

        /*
         * WARNING - void declaration
         */
        public final void write$big(@NotNull OrderedDataOutput output, @NotNull List<BPlusLeaf> unsortedItems, int blockSize) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter(unsortedItems, (String)"unsortedItems");
            boolean bl = blockSize > 1;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "blockSize must be >1";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Iterable $this$sortedBy$iv = unsortedItems;
            boolean $i$f$sortedBy = false;
            boolean bl4 = false;
            List items = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    BPlusLeaf it = (BPlusLeaf)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getKey());
                    it = (BPlusLeaf)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.getKey();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
            Iterable $this$map$iv = items;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BPlusLeaf bPlusLeaf = (BPlusLeaf)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                Integer n = it.getKey().length();
                collection.add(n);
            }
            Integer n = (Integer)CollectionsKt.max((Iterable)((List)destination$iv$iv));
            int keySize = n != null ? n : 0;
            Header header2 = new Header(output.getOrder(), blockSize, keySize, items.size(), output.tell() + (long)Header.Companion.getBYTES$big());
            header2.write(output);
            if (items.isEmpty()) {
                return;
            }
            LOG.debug("Creating a B+ tree for " + items.size() + " items (" + blockSize + " slots/node)");
            this.writeLevels(output, items, blockSize, keySize);
            this.writeLeaves(output, items, blockSize, keySize);
            LOG.debug("Saved B+ tree using " + (output.tell() - header2.getRootOffset()) + " bytes");
        }

        public static /* synthetic */ void write$big$default(Companion companion, OrderedDataOutput orderedDataOutput, List list, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = Math.max(Math.min(list.size(), 256), 2);
            }
            companion.write$big(orderedDataOutput, list, n);
        }

        /*
         * WARNING - void declaration
         */
        private final void writeLeaves(OrderedDataOutput output, List<BPlusLeaf> items, int blockSize, int keySize) {
            int bytesInLeafSlot = keySize + 8;
            int itemCount = items.size();
            long levelOffset = output.tell();
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)itemCount)), (int)blockSize);
            int n = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            int n4 = n;
            int n5 = n2;
            if (n3 >= 0 ? n4 <= n5 : n4 >= n5) {
                while (true) {
                    void i;
                    int leafCount = Math.min(itemCount - i, blockSize);
                    boolean bl = false;
                    boolean bl2 = false;
                    OrderedDataOutput $this$with = output;
                    boolean bl3 = false;
                    $this$with.writeBoolean(true);
                    $this$with.writeByte(0);
                    $this$with.writeShort(leafCount);
                    int n6 = 0;
                    int n7 = leafCount;
                    while (n6 < n7) {
                        void j;
                        items.get((int)(i + j)).write$big(output, keySize);
                        ++j;
                    }
                    $this$with.skipBytes(bytesInLeafSlot * (blockSize - leafCount));
                    if (i == n2) break;
                    i += n3;
                }
            }
            LOG.trace("Wrote " + items.size() + " leaves at leaf level " + "(offset: " + levelOffset + ')');
        }

        /*
         * WARNING - void declaration
         */
        private final void writeLevels(OrderedDataOutput output, List<BPlusLeaf> items, int blockSize, int keySize) {
            int bytesInNodeHeader = 4;
            int bytesInIndexSlot = keySize + 8;
            long bytesInIndexBlock = bytesInNodeHeader + blockSize * bytesInIndexSlot;
            int bytesInLeafSlot = keySize + 8;
            long bytesInLeafBlock = bytesInNodeHeader + blockSize * bytesInLeafSlot;
            int itemCount = items.size();
            int n = this.countLevels$big(blockSize, itemCount) - 1;
            int n2 = 1;
            while (n >= n2) {
                void d;
                long levelOffset = output.tell();
                int itemsPerSlot = IntMath.pow((int)blockSize, (int)d);
                int itemsPerNode = itemsPerSlot * blockSize;
                int nodeCount = SupportKt.divCeiling(itemCount, itemsPerNode);
                long bytesInCurrentLevel = (long)nodeCount * bytesInIndexBlock;
                long bytesInNextLevelBlock = d == true ? bytesInLeafBlock : bytesInIndexBlock;
                long childOffset = levelOffset + bytesInCurrentLevel;
                IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)itemCount)), (int)itemsPerNode);
                int n3 = intProgression.getFirst();
                int n4 = intProgression.getLast();
                int n5 = intProgression.getStep();
                int n6 = n3;
                int n7 = n4;
                if (n5 >= 0 ? n6 <= n7 : n6 >= n7) {
                    while (true) {
                        void i;
                        int childCount = Math.min(SupportKt.divCeiling(itemCount - i, itemsPerSlot), blockSize);
                        boolean bl = false;
                        boolean bl2 = false;
                        OrderedDataOutput $this$with = output;
                        boolean bl3 = false;
                        $this$with.writeBoolean(false);
                        $this$with.writeByte(0);
                        $this$with.writeShort(childCount);
                        IntProgression intProgression2 = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)Math.min(itemsPerNode, itemCount - i))), (int)itemsPerSlot);
                        int n8 = intProgression2.getFirst();
                        int n9 = intProgression2.getLast();
                        int n10 = intProgression2.getStep();
                        int n11 = n8;
                        int n12 = n9;
                        if (n10 >= 0 ? n11 <= n12 : n11 >= n12) {
                            while (true) {
                                void j;
                                new BPlusNode(items.get((int)(i + j)).getKey(), childOffset).write$big(output, keySize);
                                childOffset += bytesInNextLevelBlock;
                                if (j == n9) break;
                                j += n10;
                            }
                        }
                        $this$with.skipBytes(bytesInIndexSlot * (blockSize - childCount));
                        if (i == n4) break;
                        i += n5;
                    }
                }
                LOG.trace("Wrote " + nodeCount + " nodes at level " + (int)d + " (offset: " + levelOffset + ')');
                --d;
            }
        }

        public final int countLevels$big(int blockSize, int itemCount) {
            return SupportKt.logCeiling(itemCount, blockSize);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

