/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.big;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;
import gnu.trove.list.TFloatList;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TFloatArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.ScoredInterval;
import org.jetbrains.bio.SupportKt;
import org.jetbrains.bio.big.WigSection;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u001c\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u001dJ\u000e\u0010\u001e\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u001fJ\u000e\u0010 \u001a\u00020\bH\u00c0\u0003\u00a2\u0006\u0002\b!J1\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\u0019\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\rH\u0086\u0002J\t\u0010+\u001a\u00020\rH\u00d6\u0001J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u00020\rH\u0016J!\u00101\u001a\u0002022\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\r2\u0006\u00103\u001a\u00020(H\u0086\u0002J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u00010-2\u0006\u00105\u001a\u00020\rH\u0016J\b\u00106\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00067"}, d2={"Lorg/jetbrains/bio/big/BedGraphSection;", "Lorg/jetbrains/bio/big/WigSection;", "chrom", "", "startOffsets", "Lgnu/trove/list/TIntList;", "endOffsets", "values", "Lgnu/trove/list/TFloatList;", "(Ljava/lang/String;Lgnu/trove/list/TIntList;Lgnu/trove/list/TIntList;Lgnu/trove/list/TFloatList;)V", "getChrom", "()Ljava/lang/String;", "end", "", "getEnd", "()I", "getEndOffsets$big", "()Lgnu/trove/list/TIntList;", "size", "getSize", "span", "getSpan", "start", "getStart", "getStartOffsets$big", "getValues$big", "()Lgnu/trove/list/TFloatList;", "component1", "component2", "component2$big", "component3", "component3$big", "component4", "component4$big", "copy", "equals", "", "other", "", "get", "", "startOffset", "endOffset", "hashCode", "query", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/bio/ScoredInterval;", "from", "to", "set", "", "value", "splice", "max", "toString", "big"})
public final class BedGraphSection
implements WigSection {
    @NotNull
    private final String chrom;
    @NotNull
    private final TIntList startOffsets;
    @NotNull
    private final TIntList endOffsets;
    @NotNull
    private final TFloatList values;

    /*
     * WARNING - void declaration
     */
    @Override
    public int getSpan() {
        Mean mean = new Mean();
        int n = 0;
        int n2 = this.getSize();
        while (n < n2) {
            void i;
            mean.increment((double)(this.endOffsets.get((int)i) - this.startOffsets.get((int)i)));
            ++i;
        }
        return Ints.saturatedCast((long)MathKt.roundToLong((double)mean.getResult()));
    }

    @Override
    public int getStart() {
        boolean bl = this.getSize() > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "no data";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.startOffsets.get(0);
    }

    @Override
    public int getEnd() {
        boolean bl = this.getSize() > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "no data";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.endOffsets.max();
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    public final void set(int startOffset, int endOffset, float value) {
        int i = this.startOffsets.binarySearch(startOffset);
        if (i < 0) {
            this.startOffsets.insert(~i, startOffset);
            this.endOffsets.insert(~i, endOffset);
            this.values.insert(~i, value);
        } else if (this.endOffsets.get(i) != endOffset) {
            this.startOffsets.insert(i + 1, startOffset);
            this.endOffsets.insert(i + 1, endOffset);
            this.values.insert(i + 1, value);
        } else {
            TFloatList tFloatList = this.values;
            int n = i;
            tFloatList.set(n, tFloatList.get(n) + value);
        }
    }

    public final float get(int startOffset, int endOffset) {
        int i = this.startOffsets.binarySearch(startOffset);
        if (i < 0 || this.endOffsets.get(i) != endOffset) {
            throw (Throwable)new NoSuchElementException();
        }
        return this.values.get(i);
    }

    @Override
    @NotNull
    public Sequence<ScoredInterval> query(int from, int to) {
        int j;
        int i = this.startOffsets.binarySearch(from);
        if (i < 0) {
            i ^= 0xFFFFFFFF;
        }
        if ((j = this.startOffsets.binarySearch(to + 1)) < 0) {
            j = ~j - 1;
        }
        int n = i;
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)new IntRange(n, j))), (Function1)((Function1)new Function1<Integer, Boolean>(this, to){
            final /* synthetic */ BedGraphSection this$0;
            final /* synthetic */ int $to;

            public final boolean invoke(int it) {
                return this.this$0.getEndOffsets$big().get(it) <= this.$to;
            }
            {
                this.this$0 = bedGraphSection;
                this.$to = n;
                super(1);
            }
        })), (Function1)((Function1)new Function1<Integer, ScoredInterval>(this){
            final /* synthetic */ BedGraphSection this$0;

            @NotNull
            public final ScoredInterval invoke(int it) {
                return new ScoredInterval(this.this$0.getStartOffsets$big().get(it), this.this$0.getEndOffsets$big().get(it), this.this$0.getValues$big().get(it));
            }
            {
                this.this$0 = bedGraphSection;
                super(1);
            }
        }));
    }

    @Override
    @NotNull
    public Sequence<WigSection> splice(int max) {
        Sequence sequence;
        int chunks = SupportKt.divCeiling(this.getSize(), max);
        if (chunks == 1) {
            sequence = SequencesKt.sequenceOf((Object[])new BedGraphSection[]{this});
        } else {
            IntProgression $this$mapUnboxed$iv = (IntProgression)RangesKt.until((int)0, (int)chunks);
            boolean $i$f$mapUnboxed = false;
            IntIterator it$iv = $this$mapUnboxed$iv.iterator();
            sequence = SequencesKt.asSequence((Iterator)new Iterator<BedGraphSection>(it$iv, this, max){
                final /* synthetic */ IntIterator $it;
                final /* synthetic */ BedGraphSection this$0;
                final /* synthetic */ int $max$inlined;
                {
                    this.$it = $captured_local_variable$1;
                    this.this$0 = bedGraphSection;
                    this.$max$inlined = n;
                }

                public BedGraphSection next() {
                    int i = this.$it.nextInt();
                    boolean bl = false;
                    int from = i * this.$max$inlined;
                    int n = (i + 1) * this.$max$inlined;
                    int n2 = this.this$0.getSize();
                    boolean bl2 = false;
                    int to = Math.min(n, n2);
                    TIntList tIntList = this.this$0.getStartOffsets$big().subList(from, to);
                    Intrinsics.checkNotNullExpressionValue((Object)tIntList, (String)"startOffsets.subList(from, to)");
                    TIntList tIntList2 = this.this$0.getEndOffsets$big().subList(from, to);
                    Intrinsics.checkNotNullExpressionValue((Object)tIntList2, (String)"endOffsets.subList(from, to)");
                    TFloatList tFloatList = this.this$0.getValues$big().subList(from, to);
                    Intrinsics.checkNotNullExpressionValue((Object)tFloatList, (String)"values.subList(from, to)");
                    return BedGraphSection.copy$default(this.this$0, null, tIntList, tIntList2, tFloatList, 1, null);
                }

                public boolean hasNext() {
                    return this.$it.hasNext();
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            });
        }
        return sequence;
    }

    @NotNull
    public String toString() {
        String string = MoreObjects.toStringHelper((Object)this).addValue((Object)this.getChrom()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MoreObjects.toStringHelp\u2026)\n            .toString()");
        return string;
    }

    @Override
    @NotNull
    public String getChrom() {
        return this.chrom;
    }

    @NotNull
    public final TIntList getStartOffsets$big() {
        return this.startOffsets;
    }

    @NotNull
    public final TIntList getEndOffsets$big() {
        return this.endOffsets;
    }

    @NotNull
    public final TFloatList getValues$big() {
        return this.values;
    }

    public BedGraphSection(@NotNull String chrom, @NotNull TIntList startOffsets, @NotNull TIntList endOffsets, @NotNull TFloatList values) {
        Intrinsics.checkNotNullParameter((Object)chrom, (String)"chrom");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.chrom = chrom;
        this.startOffsets = startOffsets;
        this.endOffsets = endOffsets;
        this.values = values;
    }

    public /* synthetic */ BedGraphSection(String string, TIntList tIntList, TIntList tIntList2, TFloatList tFloatList, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            tIntList = (TIntList)new TIntArrayList();
        }
        if ((n & 4) != 0) {
            tIntList2 = (TIntList)new TIntArrayList();
        }
        if ((n & 8) != 0) {
            tFloatList = (TFloatList)new TFloatArrayList();
        }
        this(string, tIntList, tIntList2, tFloatList);
    }

    @Override
    @NotNull
    public Sequence<ScoredInterval> query() {
        return WigSection.DefaultImpls.query(this);
    }

    @Override
    public boolean isEmpty() {
        return WigSection.DefaultImpls.isEmpty(this);
    }

    @Override
    public int compareTo(@NotNull WigSection other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return WigSection.DefaultImpls.compareTo(this, other);
    }

    @NotNull
    public final String component1() {
        return this.getChrom();
    }

    @NotNull
    public final TIntList component2$big() {
        return this.startOffsets;
    }

    @NotNull
    public final TIntList component3$big() {
        return this.endOffsets;
    }

    @NotNull
    public final TFloatList component4$big() {
        return this.values;
    }

    @NotNull
    public final BedGraphSection copy(@NotNull String chrom, @NotNull TIntList startOffsets, @NotNull TIntList endOffsets, @NotNull TFloatList values) {
        Intrinsics.checkNotNullParameter((Object)chrom, (String)"chrom");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return new BedGraphSection(chrom, startOffsets, endOffsets, values);
    }

    public static /* synthetic */ BedGraphSection copy$default(BedGraphSection bedGraphSection, String string, TIntList tIntList, TIntList tIntList2, TFloatList tFloatList, int n, Object object) {
        if ((n & 1) != 0) {
            string = bedGraphSection.getChrom();
        }
        if ((n & 2) != 0) {
            tIntList = bedGraphSection.startOffsets;
        }
        if ((n & 4) != 0) {
            tIntList2 = bedGraphSection.endOffsets;
        }
        if ((n & 8) != 0) {
            tFloatList = bedGraphSection.values;
        }
        return bedGraphSection.copy(string, tIntList, tIntList2, tFloatList);
    }

    public int hashCode() {
        String string = this.getChrom();
        TIntList tIntList = this.startOffsets;
        TIntList tIntList2 = this.endOffsets;
        TFloatList tFloatList = this.values;
        return (((string != null ? string.hashCode() : 0) * 31 + (tIntList != null ? tIntList.hashCode() : 0)) * 31 + (tIntList2 != null ? tIntList2.hashCode() : 0)) * 31 + (tFloatList != null ? tFloatList.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof BedGraphSection)) break block3;
                BedGraphSection bedGraphSection = (BedGraphSection)object;
                if (!Intrinsics.areEqual((Object)this.getChrom(), (Object)bedGraphSection.getChrom()) || !Intrinsics.areEqual((Object)this.startOffsets, (Object)bedGraphSection.startOffsets) || !Intrinsics.areEqual((Object)this.endOffsets, (Object)bedGraphSection.endOffsets) || !Intrinsics.areEqual((Object)this.values, (Object)bedGraphSection.values)) break block3;
            }
            return true;
        }
        return false;
    }
}

