/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.big;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.CompressionType;
import org.jetbrains.bio.OrderedDataOutput;
import org.jetbrains.bio.RomBuffer;
import org.jetbrains.bio.RomBufferFactory;
import org.jetbrains.bio.SupportKt;
import org.jetbrains.bio.big.BPlusLeaf;
import org.jetbrains.bio.big.BPlusTree;
import org.jetbrains.bio.big.BedEntry;
import org.jetbrains.bio.big.BigBedFile;
import org.jetbrains.bio.big.BigBedKt;
import org.jetbrains.bio.big.BigFile;
import org.jetbrains.bio.big.BigSummary;
import org.jetbrains.bio.big.ChromosomeInterval;
import org.jetbrains.bio.big.Interval;
import org.jetbrains.bio.big.RTreeIndex;
import org.jetbrains.bio.big.RTreeIndexLeaf;
import org.jetbrains.bio.big.ZoomLevel;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B7\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ+\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b\u0016JA\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u000f2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0010\u00a2\u0006\u0002\b\u001cJ$\u0010\u001d\u001a\u00020\u0015*\u00020\u00132\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/bio/big/BigBedFile;", "Lorg/jetbrains/bio/big/BigFile;", "Lorg/jetbrains/bio/big/BedEntry;", "path", "", "buffFactory", "Lorg/jetbrains/bio/RomBufferFactory;", "magic", "", "prefetch", "cancelledChecker", "Lkotlin/Function0;", "", "(Ljava/lang/String;Lorg/jetbrains/bio/RomBufferFactory;IILkotlin/jvm/functions/Function0;)V", "queryInternal", "Lkotlin/sequences/Sequence;", "decompressedBlock", "Lorg/jetbrains/bio/RomBuffer;", "query", "Lorg/jetbrains/bio/big/ChromosomeInterval;", "overlaps", "", "queryInternal$big", "summarizeInternal", "Lkotlin/collections/IndexedValue;", "Lorg/jetbrains/bio/big/BigSummary;", "input", "numBins", "summarizeInternal$big", "contains", "startOffset", "endOffset", "Companion", "big"})
public final class BigBedFile
extends BigFile<BedEntry> {
    public static final int MAGIC = -2021002517;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Sequence<IndexedValue<BigSummary>> summarizeInternal$big(@NotNull RomBuffer input, @NotNull ChromosomeInterval query2, int numBins, @Nullable Function0<Unit> cancelledChecker) {
        void edge;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        List<Pair<BedEntry, Integer>> coverage = BigBedKt.aggregate(this.query$big(input, query2, true, cancelledChecker));
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        return SequencesKt.filterNotNull((Sequence)SequencesKt.mapIndexed(query2.slice$big(numBins), (Function2)((Function2)new Function2<Integer, ChromosomeInterval, IndexedValue<? extends BigSummary>>((Ref.IntRef)edge, coverage, query2){
            final /* synthetic */ Ref.IntRef $edge;
            final /* synthetic */ List $coverage;
            final /* synthetic */ ChromosomeInterval $query;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final IndexedValue<BigSummary> invoke(int i, @NotNull ChromosomeInterval bin) {
                Intrinsics.checkNotNullParameter((Object)bin, (String)"bin");
                BigSummary summary = new BigSummary(0L, 0.0, 0.0, 0.0, 0.0, 31, null);
                int n = this.$edge.element;
                int n2 = this.$coverage.size();
                while (n < n2) {
                    void bedEntry;
                    void j;
                    Pair pair = (Pair)this.$coverage.get((int)j);
                    BedEntry bedEntry2 = (BedEntry)pair.component1();
                    int score = ((Number)pair.component2()).intValue();
                    if (bedEntry.getEnd() <= bin.getStartOffset()) {
                        this.$edge.element = j + true;
                    } else {
                        if (bedEntry.getStart() > bin.getEndOffset()) break;
                        ChromosomeInterval interval = Interval.Companion.invoke$big(this.$query.getChromIx(), bedEntry.getStart(), bedEntry.getEnd());
                        if (interval.intersects(bin)) {
                            summary.update$big(score, interval.intersectionLength(bin));
                        }
                    }
                    ++j;
                }
                return summary.isEmpty$big() ? null : new IndexedValue(i, (Object)summary);
            }
            {
                this.$edge = intRef;
                this.$coverage = list;
                this.$query = chromosomeInterval;
                super(2);
            }
        })));
    }

    private final boolean contains(ChromosomeInterval $this$contains, int startOffset, int endOffset, boolean overlaps) {
        ChromosomeInterval interval = Interval.Companion.invoke$big($this$contains.getChromIx(), startOffset, endOffset);
        return overlaps && interval.intersects($this$contains) || $this$contains.contains(interval);
    }

    @Override
    @NotNull
    public Sequence<BedEntry> queryInternal$big(@NotNull RomBuffer decompressedBlock, @NotNull ChromosomeInterval query2, boolean overlaps) {
        Intrinsics.checkNotNullParameter((Object)decompressedBlock, (String)"decompressedBlock");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        String chrom = (String)this.getChromosomes().get(query2.getChromIx());
        boolean bl = false;
        boolean bl2 = false;
        RomBuffer $this$with = decompressedBlock;
        boolean bl3 = false;
        ArrayList<BedEntry> chunk = new ArrayList<BedEntry>();
        do {
            int chromIx;
            boolean bl4 = (chromIx = $this$with.readInt()) == query2.getChromIx();
            boolean bl5 = false;
            if (_Assertions.ENABLED && !bl4) {
                boolean $i$a$-assert-BigBedFile$queryInternal$1$22 = false;
                String $i$a$-assert-BigBedFile$queryInternal$1$22 = "interval contains wrong chromosome " + chromIx + ", expected " + query2.getChromIx() + ", source: " + this.getSource();
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-BigBedFile$queryInternal$1$22));
            }
            int startOffset = $this$with.readInt();
            int endOffset = $this$with.readInt();
            String rest = $this$with.readCString();
            if (!this.contains(query2, startOffset, endOffset, overlaps)) continue;
            String string = chrom;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"chrom");
            chunk.add(new BedEntry(string, startOffset, endOffset, rest));
        } while ($this$with.hasRemaining());
        return CollectionsKt.asSequence((Iterable)chunk);
    }

    private BigBedFile(String path, RomBufferFactory buffFactory, int magic, int prefetch, Function0<Unit> cancelledChecker) {
        super(path, buffFactory, magic, prefetch, cancelledChecker);
    }

    public /* synthetic */ BigBedFile(String path, RomBufferFactory buffFactory, int magic, int prefetch, Function0 cancelledChecker, DefaultConstructorMarker $constructor_marker) {
        this(path, buffFactory, magic, prefetch, (Function0<Unit>)cancelledChecker);
    }

    @JvmStatic
    @NotNull
    public static final BigBedFile read(@NotNull Path path, @Nullable Function0<Unit> cancelledChecker) throws IOException {
        return Companion.read(path, cancelledChecker);
    }

    @JvmStatic
    @NotNull
    public static final BigBedFile read(@NotNull String src, int prefetch, @Nullable Function0<Unit> cancelledChecker, @NotNull Function2<? super String, ? super ByteOrder, ? extends RomBufferFactory> factoryProvider) throws IOException {
        return Companion.read(src, prefetch, cancelledChecker, factoryProvider);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Iterable<BedEntry> bedEntries, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int itemsPerSlot, int zoomLevelCount, @NotNull CompressionType compression, @NotNull ByteOrder order, @Nullable Function0<Unit> cancelledChecker) throws IOException {
        Companion.write(bedEntries, chromSizes, outputPath, itemsPerSlot, zoomLevelCount, compression, order, cancelledChecker);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Iterable<BedEntry> bedEntries, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int itemsPerSlot, int zoomLevelCount, @NotNull CompressionType compression, @NotNull ByteOrder order) throws IOException {
        org.jetbrains.bio.big.BigBedFile$Companion.write$default(Companion, bedEntries, chromSizes, outputPath, itemsPerSlot, zoomLevelCount, compression, order, null, 128, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Iterable<BedEntry> bedEntries, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int itemsPerSlot, int zoomLevelCount, @NotNull CompressionType compression) throws IOException {
        org.jetbrains.bio.big.BigBedFile$Companion.write$default(Companion, bedEntries, chromSizes, outputPath, itemsPerSlot, zoomLevelCount, compression, null, null, 192, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Iterable<BedEntry> bedEntries, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int itemsPerSlot, int zoomLevelCount) throws IOException {
        org.jetbrains.bio.big.BigBedFile$Companion.write$default(Companion, bedEntries, chromSizes, outputPath, itemsPerSlot, zoomLevelCount, null, null, null, 224, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Iterable<BedEntry> bedEntries, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int itemsPerSlot) throws IOException {
        org.jetbrains.bio.big.BigBedFile$Companion.write$default(Companion, bedEntries, chromSizes, outputPath, itemsPerSlot, 0, null, null, null, 240, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void write(@NotNull Iterable<BedEntry> bedEntries, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath) throws IOException {
        org.jetbrains.bio.big.BigBedFile$Companion.write$default(Companion, bedEntries, chromSizes, outputPath, 0, 0, null, null, null, 248, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001 B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0007JL\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00042\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u001e\b\u0002\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u0002`\u0013H\u0007Jr\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0018\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\u00190\u00162\u0006\u0010\u001a\u001a\u00020\b2\b\b\u0002\u0010\u001b\u001a\u00020\u00042\b\b\u0002\u0010\u001c\u001a\u00020\u00042\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u00112\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/bio/big/BigBedFile$Companion;", "", "()V", "MAGIC", "", "read", "Lorg/jetbrains/bio/big/BigBedFile;", "path", "Ljava/nio/file/Path;", "cancelledChecker", "Lkotlin/Function0;", "", "src", "", "prefetch", "factoryProvider", "Lkotlin/Function2;", "Ljava/nio/ByteOrder;", "Lorg/jetbrains/bio/RomBufferFactory;", "Lorg/jetbrains/bio/big/RomBufferFactoryProvider;", "write", "bedEntries", "", "Lorg/jetbrains/bio/big/BedEntry;", "chromSizes", "Lkotlin/Pair;", "outputPath", "itemsPerSlot", "zoomLevelCount", "compression", "Lorg/jetbrains/bio/CompressionType;", "order", "BedEntrySummary", "big"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final BigBedFile read(@NotNull Path path, @Nullable Function0<Unit> cancelledChecker) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return org.jetbrains.bio.big.BigBedFile$Companion.read$default(this, ((Object)path).toString(), 0, cancelledChecker, null, 10, null);
        }

        public static /* synthetic */ BigBedFile read$default(Companion companion, Path path, Function0 function0, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                function0 = null;
            }
            return companion.read(path, (Function0<Unit>)function0);
        }

        @JvmStatic
        @NotNull
        public final BigBedFile read(@NotNull String src, int prefetch, @Nullable Function0<Unit> cancelledChecker, @NotNull Function2<? super String, ? super ByteOrder, ? extends RomBufferFactory> factoryProvider) throws IOException {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Intrinsics.checkNotNullParameter(factoryProvider, (String)"factoryProvider");
            ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
            Intrinsics.checkNotNullExpressionValue((Object)byteOrder, (String)"ByteOrder.LITTLE_ENDIAN");
            RomBufferFactory factory = (RomBufferFactory)factoryProvider.invoke((Object)src, (Object)byteOrder);
            try {
                ByteOrder byteOrder2 = BigFile.Companion.getByteOrder$big(src, -2021002517, factory);
                factory.setOrder(byteOrder2);
                return new BigBedFile(src, factory, -2021002517, prefetch, cancelledChecker, null);
            }
            catch (Exception e) {
                Closeables.close((Closeable)factory, (boolean)true);
                throw (Throwable)e;
            }
        }

        public static /* synthetic */ BigBedFile read$default(Companion companion, String string, int n, Function0 function0, Function2 function2, int n2, Object object) throws IOException {
            if ((n2 & 2) != 0) {
                n = 2;
            }
            if ((n2 & 4) != 0) {
                function0 = null;
            }
            if ((n2 & 8) != 0) {
                function2 = BigFile.Companion.defaultFactory();
            }
            return companion.read(string, n, (Function0<Unit>)function0, function2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmOverloads
        public final void write(@NotNull Iterable<BedEntry> bedEntries, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int itemsPerSlot, int zoomLevelCount, @NotNull CompressionType compression, @NotNull ByteOrder order, @Nullable Function0<Unit> cancelledChecker) throws IOException {
            Intrinsics.checkNotNullParameter(bedEntries, (String)"bedEntries");
            Intrinsics.checkNotNullParameter(chromSizes, (String)"chromSizes");
            Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
            Intrinsics.checkNotNullParameter((Object)((Object)compression), (String)"compression");
            Intrinsics.checkNotNullParameter((Object)order, (String)"order");
            BedEntrySummary bedEntrySummary = new BedEntrySummary();
            boolean bl = false;
            boolean bl2 = false;
            BedEntrySummary $this$apply52222 = bedEntrySummary;
            boolean bl3 = false;
            Iterable<BedEntry> $this$forEach$iv = bedEntries;
            boolean $i$f$forEach = false;
            Iterator<BedEntry> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                BedEntry element$iv;
                BedEntry it = element$iv = iterator2.next();
                boolean bl4 = false;
                $this$apply52222.invoke(it);
            }
            BedEntrySummary summary = bedEntrySummary;
            Closeable closeable = OrderedDataOutput.Companion.invoke$default(OrderedDataOutput.Companion, outputPath, order, 0L, false, 12, null);
            bl2 = false;
            boolean $this$apply52222 = false;
            Throwable $this$apply52222 = null;
            try {
                void $this$mapTo$iv$iv;
                BPlusLeaf bPlusLeaf;
                Collection collection;
                Object item$iv$iv2;
                void $this$mapIndexedTo$iv$iv;
                int n;
                Iterable $this$filterTo$iv$iv;
                Object output = (OrderedDataOutput)closeable;
                boolean bl5 = false;
                ((OrderedDataOutput)output).skipBytes(64);
                ((OrderedDataOutput)output).skipBytes(ZoomLevel.Companion.getBYTES$big() * zoomLevelCount);
                long totalSummaryOffset = ((OrderedDataOutput)output).tell();
                ((OrderedDataOutput)output).skipBytes(BigSummary.Companion.getBYTES$big());
                Iterable<Pair<String, Integer>> $this$filter$iv = chromSizes;
                boolean $i$f$filter = false;
                Iterable<Pair<String, Integer>> bl4 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Pair it = (Pair)element$iv$iv;
                    n = 0;
                    if (!summary.getChromosomes().contains(it.getFirst())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$mapIndexed$iv = (List)destination$iv$iv;
                boolean $i$f$mapIndexed = false;
                $this$filterTo$iv$iv = $this$mapIndexed$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                    void i;
                    void key;
                    Iterator $dstr$key$size;
                    n = index$iv$iv++;
                    boolean bl6 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Pair pair = (Pair)item$iv$iv2;
                    int n2 = n;
                    collection = destination$iv$iv;
                    boolean bl7 = false;
                    String string = (String)$dstr$key$size.component1();
                    int size = ((Number)$dstr$key$size.component2()).intValue();
                    bPlusLeaf = new BPlusLeaf((String)key, (int)i, size);
                    collection.add(bPlusLeaf);
                }
                List unsortedChromosomes = (List)destination$iv$iv;
                long chromTreeOffset = ((OrderedDataOutput)output).tell();
                BPlusTree.Companion.write$big$default(BPlusTree.Companion, (OrderedDataOutput)output, unsortedChromosomes, 0, 4, null);
                long unzoomedDataOffset = ((OrderedDataOutput)output).tell();
                Iterable $this$map$iv = unsortedChromosomes;
                boolean $i$f$map = false;
                item$iv$iv2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                    void it;
                    BPlusLeaf bl7 = (BPlusLeaf)item$iv$iv3;
                    collection = destination$iv$iv2;
                    boolean bl8 = false;
                    bPlusLeaf = TuplesKt.to((Object)it.getKey(), (Object)it.getId());
                    collection.add(bPlusLeaf);
                }
                Map resolver = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
                ArrayList<RTreeIndexLeaf> leaves2 = new ArrayList<RTreeIndexLeaf>();
                int uncompressBufSize = 0;
                Function0<Unit> function0 = cancelledChecker;
                Object object = function0 != null ? (Unit)function0.invoke() : null;
                for (Pair pair : SupportKt.groupingBy(CollectionsKt.asSequence(bedEntries), write.header.1.1.INSTANCE)) {
                    BedEntry it;
                    void chrName;
                    String $i$f$mapTo2 = (String)pair.component1();
                    Sequence items = (Sequence)pair.component2();
                    Function0<Unit> function02 = cancelledChecker;
                    Object object2 = function02 != null ? (Unit)function02.invoke() : null;
                    Integer chromIx = (Integer)resolver.get(chrName);
                    if (chromIx == null) {
                        Sequence $this$forEach$iv2 = items;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv : $this$forEach$iv2) {
                            it = (BedEntry)element$iv;
                            boolean bl9 = false;
                        }
                        continue;
                    }
                    Iterator it2 = items.iterator();
                    while (it2.hasNext()) {
                        void leafEnd;
                        void leafStart;
                        Object element$iv;
                        long dataOffset = ((OrderedDataOutput)output).tell();
                        element$iv = new Ref.IntRef();
                        ((Ref.IntRef)element$iv).element = 0;
                        it = new Ref.IntRef();
                        ((Ref.IntRef)it).element = 0;
                        int current2 = ((OrderedDataOutput)output).with(compression, (Function1<? super OrderedDataOutput, Unit>)((Function1)new Function1<OrderedDataOutput, Unit>(it2, chromIx, (Ref.IntRef)leafStart, (Ref.IntRef)leafEnd, zoomLevelCount, chromSizes, summary, cancelledChecker, bedEntries, compression, itemsPerSlot){
                            final /* synthetic */ Iterator $it;
                            final /* synthetic */ Integer $chromIx;
                            final /* synthetic */ Ref.IntRef $leafStart;
                            final /* synthetic */ Ref.IntRef $leafEnd;
                            final /* synthetic */ int $zoomLevelCount$inlined;
                            final /* synthetic */ Iterable $chromSizes$inlined;
                            final /* synthetic */ BedEntrySummary $summary$inlined;
                            final /* synthetic */ Function0 $cancelledChecker$inlined;
                            final /* synthetic */ Iterable $bedEntries$inlined;
                            final /* synthetic */ CompressionType $compression$inlined;
                            final /* synthetic */ int $itemsPerSlot$inlined;
                            {
                                this.$it = iterator2;
                                this.$chromIx = n;
                                this.$leafStart = intRef;
                                this.$leafEnd = intRef2;
                                this.$zoomLevelCount$inlined = n2;
                                this.$chromSizes$inlined = iterable;
                                this.$summary$inlined = bedEntrySummary;
                                this.$cancelledChecker$inlined = function0;
                                this.$bedEntries$inlined = iterable2;
                                this.$compression$inlined = compressionType;
                                this.$itemsPerSlot$inlined = n3;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(@NotNull OrderedDataOutput $this$with) {
                                Intrinsics.checkNotNullParameter((Object)$this$with, (String)"$receiver");
                                for (BedEntry bedEntry : SequencesKt.take((Sequence)SequencesKt.asSequence((Iterator)this.$it), (int)this.$itemsPerSlot$inlined)) {
                                    void end;
                                    void start;
                                    int n = bedEntry.component2();
                                    int n2 = bedEntry.component3();
                                    String rest = bedEntry.component4();
                                    $this$with.writeInt(this.$chromIx);
                                    $this$with.writeInt((int)start);
                                    $this$with.writeInt((int)end);
                                    OrderedDataOutput.writeString$default($this$with, rest, 0, 2, null);
                                    $this$with.writeByte(0);
                                    this.$leafStart.element = Math.min(this.$leafStart.element, (int)start);
                                    this.$leafEnd.element = Math.max(this.$leafEnd.element, (int)end);
                                }
                            }
                        }));
                        leaves2.add(new RTreeIndexLeaf(Interval.Companion.invoke$big(chromIx, leafStart.element, leafEnd.element), dataOffset, ((OrderedDataOutput)output).tell() - dataOffset));
                        uncompressBufSize = Math.max(uncompressBufSize, current2);
                    }
                }
                Function0<Unit> function03 = cancelledChecker;
                Object object3 = function03 != null ? (Unit)function03.invoke() : null;
                long unzoomedIndexOffset = ((OrderedDataOutput)output).tell();
                RTreeIndex.Companion.write$big$default(RTreeIndex.Companion, (OrderedDataOutput)output, leaves2, 0, itemsPerSlot, 4, null);
                output = new BigFile.Header(((OrderedDataOutput)output).getOrder(), -2021002517, compression == CompressionType.SNAPPY ? 5 : 4, zoomLevelCount, chromTreeOffset, unzoomedDataOffset, unzoomedIndexOffset, 3, 3, 0L, totalSummaryOffset, compression.getAbsent() ? 0 : uncompressBufSize, 0L, 4608, null);
            }
            catch (Throwable output) {
                $this$apply52222 = output;
                throw output;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)$this$apply52222);
            }
            Object header2 = output;
            closeable = OrderedDataOutput.Companion.invoke$default(OrderedDataOutput.Companion, outputPath, order, 0L, false, 4, null);
            bl2 = false;
            boolean $this$apply52222 = false;
            Throwable $this$apply52222 = null;
            try {
                OrderedDataOutput it = (OrderedDataOutput)closeable;
                boolean bl10 = false;
                ((BigFile.Header)header2).write$big(it);
                it = Unit.INSTANCE;
            }
            catch (Throwable it) {
                $this$apply52222 = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)$this$apply52222);
            }
            boolean bl11 = false;
            bl2 = false;
            BedEntrySummary $this$with = summary;
            boolean bl12 = false;
            if ($this$with.getCount() > 0) {
                int initial = (int)Math.max(SupportKt.divCeiling($this$with.getSum(), (long)$this$with.getCount()), 1L) * 10;
                BigFile.Post.zoom$big$default(BigFile.Post.INSTANCE, outputPath, itemsPerSlot, initial, 0, cancelledChecker, 8, null);
            }
            BigFile.Post.INSTANCE.totalSummary$big(outputPath);
        }

        public static /* synthetic */ void write$default(Companion companion, Iterable iterable, Iterable iterable2, Path path, int n, int n2, CompressionType compressionType, ByteOrder byteOrder, Function0 function0, int n3, Object object) throws IOException {
            if ((n3 & 8) != 0) {
                n = 1024;
            }
            if ((n3 & 0x10) != 0) {
                n2 = 8;
            }
            if ((n3 & 0x20) != 0) {
                compressionType = CompressionType.SNAPPY;
            }
            if ((n3 & 0x40) != 0) {
                ByteOrder byteOrder2 = ByteOrder.nativeOrder();
                Intrinsics.checkNotNullExpressionValue((Object)byteOrder2, (String)"ByteOrder.nativeOrder()");
                byteOrder = byteOrder2;
            }
            if ((n3 & 0x80) != 0) {
                function0 = null;
            }
            companion.write(iterable, iterable2, path, n, n2, compressionType, byteOrder, (Function0<Unit>)function0);
        }

        @JvmStatic
        @JvmOverloads
        public final void write(@NotNull Iterable<BedEntry> bedEntries, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int itemsPerSlot, int zoomLevelCount, @NotNull CompressionType compression, @NotNull ByteOrder order) throws IOException {
            org.jetbrains.bio.big.BigBedFile$Companion.write$default(this, bedEntries, chromSizes, outputPath, itemsPerSlot, zoomLevelCount, compression, order, null, 128, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void write(@NotNull Iterable<BedEntry> bedEntries, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int itemsPerSlot, int zoomLevelCount, @NotNull CompressionType compression) throws IOException {
            org.jetbrains.bio.big.BigBedFile$Companion.write$default(this, bedEntries, chromSizes, outputPath, itemsPerSlot, zoomLevelCount, compression, null, null, 192, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void write(@NotNull Iterable<BedEntry> bedEntries, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int itemsPerSlot, int zoomLevelCount) throws IOException {
            org.jetbrains.bio.big.BigBedFile$Companion.write$default(this, bedEntries, chromSizes, outputPath, itemsPerSlot, zoomLevelCount, null, null, null, 224, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void write(@NotNull Iterable<BedEntry> bedEntries, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath, int itemsPerSlot) throws IOException {
            org.jetbrains.bio.big.BigBedFile$Companion.write$default(this, bedEntries, chromSizes, outputPath, itemsPerSlot, 0, null, null, null, 240, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void write(@NotNull Iterable<BedEntry> bedEntries, @NotNull Iterable<Pair<String, Integer>> chromSizes, @NotNull Path outputPath) throws IOException {
            org.jetbrains.bio.big.BigBedFile$Companion.write$default(this, bedEntries, chromSizes, outputPath, 0, 0, null, null, null, 248, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/bio/big/BigBedFile$Companion$BedEntrySummary;", "", "()V", "chromosomes", "Ljava/util/HashSet;", "", "getChromosomes", "()Ljava/util/HashSet;", "count", "", "getCount", "()I", "setCount", "(I)V", "edge", "previous", "sum", "", "getSum", "()J", "setSum", "(J)V", "invoke", "", "entry", "Lorg/jetbrains/bio/big/BedEntry;", "big"})
        private static final class BedEntrySummary {
            @NotNull
            private final HashSet<String> chromosomes = new HashSet();
            private int count;
            private long sum;
            private int edge;
            private String previous = "";

            @NotNull
            public final HashSet<String> getChromosomes() {
                return this.chromosomes;
            }

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }

            public final long getSum() {
                return this.sum;
            }

            public final void setSum(long l) {
                this.sum = l;
            }

            public final void invoke(@NotNull BedEntry entry) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                boolean bl = !this.chromosomes.contains(entry.getChrom());
                int n = Intrinsics.areEqual((Object)entry.getChrom(), (Object)this.previous) || bl ? 1 : 0;
                boolean bl2 = false;
                boolean bl3 = false;
                if (n == 0) {
                    boolean bl4 = false;
                    String string = "must be sorted by chromosome";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                n = entry.getStart() >= this.edge || bl ? 1 : 0;
                bl2 = false;
                bl3 = false;
                if (n == 0) {
                    boolean bl5 = false;
                    String string = "must be sorted by offset";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                this.chromosomes.add(entry.getChrom());
                this.sum += (long)(entry.getEnd() - entry.getStart());
                n = this.count;
                this.count = n + 1;
                this.previous = entry.getChrom();
                this.edge = entry.getStart();
            }
        }
    }
}

