/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.big;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.bio.OrderedDataOutput;
import org.jetbrains.bio.RomBuffer;
import org.jetbrains.bio.SupportKt;
import org.jetbrains.bio.big.Interval;
import org.jetbrains.bio.big.Offset;
import org.jetbrains.bio.big.RTReeNodeIntermediate;
import org.jetbrains.bio.big.RTReeNodeLeaf;
import org.jetbrains.bio.big.RTreeIndexLeaf;
import org.jetbrains.bio.big.RTreeIndexNode;
import org.jetbrains.bio.big.RTreeNode;
import org.jetbrains.bio.big.RTreeNodeProxy;
import org.jetbrains.bio.big.RTreeNodeRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JE\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0000\u00a2\u0006\u0002\b\u001aJ4\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018J>\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0002J6\u0010!\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lorg/jetbrains/bio/big/RTreeIndex;", "", "header", "Lorg/jetbrains/bio/big/RTreeIndex$Header;", "(Lorg/jetbrains/bio/big/RTreeIndex$Header;)V", "getHeader", "()Lorg/jetbrains/bio/big/RTreeIndex$Header;", "rootNode", "Lorg/jetbrains/bio/big/RTreeNode;", "getRootNode", "()Lorg/jetbrains/bio/big/RTreeNode;", "setRootNode", "(Lorg/jetbrains/bio/big/RTreeNode;)V", "fetchRTreeNodeRecursively", "input", "Lorg/jetbrains/bio/RomBuffer;", "expandAll", "", "expandUpToChrs", "offset", "", "uncompressBufSize", "", "cancelledChecker", "Lkotlin/Function0;", "", "fetchRTreeNodeRecursively$big", "findOverlappingBlocks", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/bio/big/RTreeIndexLeaf;", "query", "Lorg/jetbrains/bio/big/Interval;", "findOverlappingBlocksRecursively", "prefetchBlocksIndex", "Companion", "Header", "big"})
public final class RTreeIndex {
    @Nullable
    private RTreeNode rootNode;
    @NotNull
    private final Header header;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final RTreeNode getRootNode() {
        return this.rootNode;
    }

    public final void setRootNode(@Nullable RTreeNode rTreeNode) {
        this.rootNode = rTreeNode;
    }

    @NotNull
    public final Sequence<RTreeIndexLeaf> findOverlappingBlocks(@NotNull RomBuffer input, @NotNull Interval query2, int uncompressBufSize, @Nullable Function0<Unit> cancelledChecker) throws IOException {
        Sequence<RTreeIndexLeaf> sequence;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
        if (this.header.getItemCount() == 0L) {
            sequence = SequencesKt.emptySequence();
        } else if (this.rootNode == null) {
            sequence = this.findOverlappingBlocksRecursively(input, query2, this.fetchRTreeNodeRecursively$big(input, false, false, this.header.getRootOffset(), uncompressBufSize, cancelledChecker), uncompressBufSize, cancelledChecker);
        } else {
            RTreeNode rTreeNode = this.rootNode;
            Intrinsics.checkNotNull((Object)rTreeNode);
            sequence = this.findOverlappingBlocksRecursively(input, query2, rTreeNode, uncompressBufSize, cancelledChecker);
        }
        return sequence;
    }

    public final void prefetchBlocksIndex(@NotNull RomBuffer input, boolean expandAll, boolean expandUpToChrs, int uncompressBufSize, @Nullable Function0<Unit> cancelledChecker) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.rootNode = this.header.getItemCount() == 0L ? null : this.fetchRTreeNodeRecursively$big(input, expandAll, expandUpToChrs, this.header.getRootOffset(), uncompressBufSize, cancelledChecker);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RTreeNode fetchRTreeNodeRecursively$big(@NotNull RomBuffer input, boolean expandAll, boolean expandUpToChrs, long offset, int uncompressBufSize, @Nullable Function0<Unit> cancelledChecker) {
        RTreeNode rTreeNode;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Function0<Unit> function0 = cancelledChecker;
        if (function0 != null) {
            Unit cfr_ignored_0 = (Unit)function0.invoke();
        }
        boolean bl = Intrinsics.areEqual((Object)input.getOrder(), (Object)this.header.getOrder());
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        input.setPosition(offset);
        boolean isLeaf = input.readByte() > 0;
        input.readByte();
        int childCount = input.readUnsignedShort();
        if (isLeaf) {
            List leaves2 = (List)RomBuffer.with$big$default(input, input.getPosition(), childCount * 32, null, uncompressBufSize, (Function1)new Function1<RomBuffer, List<? extends RTreeIndexLeaf>>(childCount){
                final /* synthetic */ int $childCount;

                @NotNull
                public final List<RTreeIndexLeaf> invoke(@NotNull RomBuffer $this$with) {
                    Intrinsics.checkNotNullParameter((Object)$this$with, (String)"$receiver");
                    int n = this.$childCount;
                    boolean bl = false;
                    boolean bl2 = false;
                    ArrayList<RTreeIndexLeaf> arrayList = new ArrayList<RTreeIndexLeaf>(n);
                    boolean bl3 = false;
                    int n2 = 0;
                    n2 = 0;
                    int n3 = n;
                    while (n2 < n3) {
                        int n4 = n2++;
                        boolean bl4 = false;
                        int n5 = n4;
                        ArrayList<RTreeIndexLeaf> arrayList2 = arrayList;
                        boolean bl5 = false;
                        RTreeIndexLeaf rTreeIndexLeaf = RTreeIndexLeaf.Companion.read$big($this$with);
                        arrayList2.add(rTreeIndexLeaf);
                    }
                    return arrayList;
                }
                {
                    this.$childCount = n;
                    super(1);
                }
            }, 4, null);
            rTreeNode = new RTReeNodeLeaf(leaves2);
        } else {
            void $this$mapTo$iv$iv;
            List nodes2 = (List)RomBuffer.with$big$default(input, input.getPosition(), childCount * 24, null, uncompressBufSize, (Function1)new Function1<RomBuffer, List<? extends RTreeIndexNode>>(childCount){
                final /* synthetic */ int $childCount;

                @NotNull
                public final List<RTreeIndexNode> invoke(@NotNull RomBuffer $this$with) {
                    Intrinsics.checkNotNullParameter((Object)$this$with, (String)"$receiver");
                    int n = this.$childCount;
                    boolean bl = false;
                    boolean bl2 = false;
                    ArrayList<RTreeIndexNode> arrayList = new ArrayList<RTreeIndexNode>(n);
                    boolean bl3 = false;
                    int n2 = 0;
                    n2 = 0;
                    int n3 = n;
                    while (n2 < n3) {
                        int n4 = n2++;
                        boolean bl4 = false;
                        int n5 = n4;
                        ArrayList<RTreeIndexNode> arrayList2 = arrayList;
                        boolean bl5 = false;
                        RTreeIndexNode rTreeIndexNode = RTreeIndexNode.Companion.read$big($this$with);
                        arrayList2.add(rTreeIndexNode);
                    }
                    return arrayList;
                }
                {
                    this.$childCount = n;
                    super(1);
                }
            }, 4, null);
            Iterable $this$map$iv = nodes2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void rTIndexNode;
                RTreeIndexNode rTreeIndexNode = (RTreeIndexNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                Interval interval = rTIndexNode.getInterval();
                RTreeNodeProxy rTreeNodeProxy = expandAll || expandUpToChrs && interval.getLeft().getChromIx() != interval.getRight().getChromIx() ? new RTreeNodeProxy(this.fetchRTreeNodeRecursively$big(input, expandAll, expandUpToChrs, rTIndexNode.getDataOffset(), uncompressBufSize, cancelledChecker), interval) : new RTreeNodeProxy(new RTreeNodeRef(rTIndexNode.getDataOffset()), interval);
                collection.add(rTreeNodeProxy);
            }
            List children = (List)destination$iv$iv;
            rTreeNode = new RTReeNodeIntermediate(children);
        }
        return rTreeNode;
    }

    private final Sequence<RTreeIndexLeaf> findOverlappingBlocksRecursively(RomBuffer input, Interval query2, RTreeNode rootNode, int uncompressBufSize, Function0<Unit> cancelledChecker) {
        Sequence sequence;
        Function0<Unit> function0 = cancelledChecker;
        if (function0 != null) {
            Unit cfr_ignored_0 = (Unit)function0.invoke();
        }
        RTreeNode rTreeNode = rootNode;
        if (rTreeNode instanceof RTReeNodeLeaf) {
            sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((RTReeNodeLeaf)rootNode).getLeaves()), (Function1)((Function1)new Function1<RTreeIndexLeaf, Boolean>(query2){
                final /* synthetic */ Interval $query;

                public final boolean invoke(@NotNull RTreeIndexLeaf it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getInterval().intersects(this.$query);
                }
                {
                    this.$query = interval;
                    super(1);
                }
            }));
        } else {
            RTreeNode rTreeNode2 = rootNode;
            if (rTreeNode2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.bio.big.RTReeNodeIntermediate");
            }
            sequence = SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((RTReeNodeIntermediate)rTreeNode2).getChildren()), (Function1)((Function1)new Function1<RTreeNodeProxy, Boolean>(query2){
                final /* synthetic */ Interval $query;

                public final boolean invoke(@NotNull RTreeNodeProxy it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.getInterval().intersects(this.$query);
                }
                {
                    this.$query = interval;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<RTreeNodeProxy, Sequence<? extends RTreeIndexLeaf>>(this, input, uncompressBufSize, cancelledChecker, query2){
                final /* synthetic */ RTreeIndex this$0;
                final /* synthetic */ RomBuffer $input;
                final /* synthetic */ int $uncompressBufSize;
                final /* synthetic */ Function0 $cancelledChecker;
                final /* synthetic */ Interval $query;

                @NotNull
                public final Sequence<RTreeIndexLeaf> invoke(@NotNull RTreeNodeProxy proxy) {
                    Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
                    RTreeNode node = proxy.resolve(this.$input, this.this$0, this.$uncompressBufSize, (Function0<Unit>)this.$cancelledChecker);
                    return RTreeIndex.access$findOverlappingBlocksRecursively(this.this$0, this.$input, this.$query, node, this.$uncompressBufSize, this.$cancelledChecker);
                }
                {
                    this.this$0 = rTreeIndex;
                    this.$input = romBuffer;
                    this.$uncompressBufSize = n;
                    this.$cancelledChecker = function0;
                    this.$query = interval;
                    super(1);
                }
            }));
        }
        return sequence;
    }

    @NotNull
    public final Header getHeader() {
        return this.header;
    }

    public RTreeIndex(@NotNull Header header2) {
        Intrinsics.checkNotNullParameter((Object)header2, (String)"header");
        this.header = header2;
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(RTreeIndex.class);
    }

    public static final /* synthetic */ Sequence access$findOverlappingBlocksRecursively(RTreeIndex $this, RomBuffer input, Interval query2, RTreeNode rootNode, int uncompressBufSize, Function0 cancelledChecker) {
        return $this.findOverlappingBlocksRecursively(input, query2, rootNode, uncompressBufSize, (Function0<Unit>)cancelledChecker);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b!\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\b\u0018\u0000 32\u00020\u0001:\u00013BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003Jm\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020\u0005H\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001J\u0015\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\b2R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0011\u00a8\u00064"}, d2={"Lorg/jetbrains/bio/big/RTreeIndex$Header;", "", "order", "Ljava/nio/ByteOrder;", "blockSize", "", "itemCount", "", "startChromIx", "startBase", "endChromIx", "endBase", "endDataOffset", "itemsPerSlot", "rootOffset", "(Ljava/nio/ByteOrder;IJIIIIJIJ)V", "getBlockSize", "()I", "getEndBase", "getEndChromIx", "getEndDataOffset", "()J", "getItemCount", "getItemsPerSlot", "getOrder", "()Ljava/nio/ByteOrder;", "getRootOffset", "getStartBase", "getStartChromIx", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "", "write", "", "output", "Lorg/jetbrains/bio/OrderedDataOutput;", "write$big", "Companion", "big"})
    public static final class Header {
        @NotNull
        private final ByteOrder order;
        private final int blockSize;
        private final long itemCount;
        private final int startChromIx;
        private final int startBase;
        private final int endChromIx;
        private final int endBase;
        private final long endDataOffset;
        private final int itemsPerSlot;
        private final long rootOffset;
        public static final int BYTES = 48;
        private static final int MAGIC = 610839776;
        @NotNull
        public static final Companion Companion = new Companion(null);

        public final void write$big(@NotNull OrderedDataOutput output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            boolean bl = false;
            boolean bl2 = false;
            OrderedDataOutput $this$with = output;
            boolean bl3 = false;
            $this$with.writeInt(610839776);
            $this$with.writeInt(this.blockSize);
            $this$with.writeLong(this.itemCount);
            $this$with.writeInt(this.startChromIx);
            $this$with.writeInt(this.startBase);
            $this$with.writeInt(this.endChromIx);
            $this$with.writeInt(this.endBase);
            $this$with.writeLong(this.endDataOffset);
            $this$with.writeInt(this.itemsPerSlot);
            $this$with.writeInt(0);
        }

        @NotNull
        public final ByteOrder getOrder() {
            return this.order;
        }

        public final int getBlockSize() {
            return this.blockSize;
        }

        public final long getItemCount() {
            return this.itemCount;
        }

        public final int getStartChromIx() {
            return this.startChromIx;
        }

        public final int getStartBase() {
            return this.startBase;
        }

        public final int getEndChromIx() {
            return this.endChromIx;
        }

        public final int getEndBase() {
            return this.endBase;
        }

        public final long getEndDataOffset() {
            return this.endDataOffset;
        }

        public final int getItemsPerSlot() {
            return this.itemsPerSlot;
        }

        public final long getRootOffset() {
            return this.rootOffset;
        }

        public Header(@NotNull ByteOrder order, int blockSize, long itemCount, int startChromIx, int startBase, int endChromIx, int endBase, long endDataOffset, int itemsPerSlot, long rootOffset) {
            Intrinsics.checkNotNullParameter((Object)order, (String)"order");
            this.order = order;
            this.blockSize = blockSize;
            this.itemCount = itemCount;
            this.startChromIx = startChromIx;
            this.startBase = startBase;
            this.endChromIx = endChromIx;
            this.endBase = endBase;
            this.endDataOffset = endDataOffset;
            this.itemsPerSlot = itemsPerSlot;
            this.rootOffset = rootOffset;
        }

        @NotNull
        public final ByteOrder component1() {
            return this.order;
        }

        public final int component2() {
            return this.blockSize;
        }

        public final long component3() {
            return this.itemCount;
        }

        public final int component4() {
            return this.startChromIx;
        }

        public final int component5() {
            return this.startBase;
        }

        public final int component6() {
            return this.endChromIx;
        }

        public final int component7() {
            return this.endBase;
        }

        public final long component8() {
            return this.endDataOffset;
        }

        public final int component9() {
            return this.itemsPerSlot;
        }

        public final long component10() {
            return this.rootOffset;
        }

        @NotNull
        public final Header copy(@NotNull ByteOrder order, int blockSize, long itemCount, int startChromIx, int startBase, int endChromIx, int endBase, long endDataOffset, int itemsPerSlot, long rootOffset) {
            Intrinsics.checkNotNullParameter((Object)order, (String)"order");
            return new Header(order, blockSize, itemCount, startChromIx, startBase, endChromIx, endBase, endDataOffset, itemsPerSlot, rootOffset);
        }

        public static /* synthetic */ Header copy$default(Header header2, ByteOrder byteOrder, int n, long l, int n2, int n3, int n4, int n5, long l2, int n6, long l3, int n7, Object object) {
            if ((n7 & 1) != 0) {
                byteOrder = header2.order;
            }
            if ((n7 & 2) != 0) {
                n = header2.blockSize;
            }
            if ((n7 & 4) != 0) {
                l = header2.itemCount;
            }
            if ((n7 & 8) != 0) {
                n2 = header2.startChromIx;
            }
            if ((n7 & 0x10) != 0) {
                n3 = header2.startBase;
            }
            if ((n7 & 0x20) != 0) {
                n4 = header2.endChromIx;
            }
            if ((n7 & 0x40) != 0) {
                n5 = header2.endBase;
            }
            if ((n7 & 0x80) != 0) {
                l2 = header2.endDataOffset;
            }
            if ((n7 & 0x100) != 0) {
                n6 = header2.itemsPerSlot;
            }
            if ((n7 & 0x200) != 0) {
                l3 = header2.rootOffset;
            }
            return header2.copy(byteOrder, n, l, n2, n3, n4, n5, l2, n6, l3);
        }

        @NotNull
        public String toString() {
            return "Header(order=" + this.order + ", blockSize=" + this.blockSize + ", itemCount=" + this.itemCount + ", startChromIx=" + this.startChromIx + ", startBase=" + this.startBase + ", endChromIx=" + this.endChromIx + ", endBase=" + this.endBase + ", endDataOffset=" + this.endDataOffset + ", itemsPerSlot=" + this.itemsPerSlot + ", rootOffset=" + this.rootOffset + ")";
        }

        public int hashCode() {
            ByteOrder byteOrder = this.order;
            return (((((((((byteOrder != null ? byteOrder.hashCode() : 0) * 31 + Integer.hashCode(this.blockSize)) * 31 + Long.hashCode(this.itemCount)) * 31 + Integer.hashCode(this.startChromIx)) * 31 + Integer.hashCode(this.startBase)) * 31 + Integer.hashCode(this.endChromIx)) * 31 + Integer.hashCode(this.endBase)) * 31 + Long.hashCode(this.endDataOffset)) * 31 + Integer.hashCode(this.itemsPerSlot)) * 31 + Long.hashCode(this.rootOffset);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Header)) break block3;
                    Header header2 = (Header)object;
                    if (!Intrinsics.areEqual((Object)this.order, (Object)header2.order) || this.blockSize != header2.blockSize || this.itemCount != header2.itemCount || this.startChromIx != header2.startChromIx || this.startBase != header2.startBase || this.endChromIx != header2.endChromIx || this.endBase != header2.endBase || this.endDataOffset != header2.endDataOffset || this.itemsPerSlot != header2.itemsPerSlot || this.rootOffset != header2.rootOffset) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/bio/big/RTreeIndex$Header$Companion;", "", "()V", "BYTES", "", "MAGIC", "read", "Lorg/jetbrains/bio/big/RTreeIndex$Header;", "input", "Lorg/jetbrains/bio/RomBuffer;", "offset", "", "read$big", "big"})
        public static final class Companion {
            @NotNull
            public final Header read$big(@NotNull RomBuffer input, long offset) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                boolean bl = false;
                boolean bl2 = false;
                RomBuffer $this$with = input;
                boolean bl3 = false;
                ByteOrder expectedOrder = $this$with.getOrder();
                $this$with.setPosition(offset);
                $this$with.checkHeader(610839776);
                boolean bl4 = Intrinsics.areEqual((Object)$this$with.getOrder(), (Object)expectedOrder);
                boolean bl5 = false;
                boolean bl6 = false;
                bl6 = false;
                boolean bl7 = false;
                if (!bl4) {
                    boolean bl8 = false;
                    String string = "Check failed.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                int blockSize = $this$with.readInt();
                long itemCount = $this$with.readLong();
                int startChromIx = $this$with.readInt();
                int startBase = $this$with.readInt();
                int endChromIx = $this$with.readInt();
                int endBase = $this$with.readInt();
                long endDataOffset = $this$with.readLong();
                int itemsPerSlot = $this$with.readInt();
                $this$with.readInt();
                long rootOffset = $this$with.getPosition();
                return new Header($this$with.getOrder(), blockSize, itemCount, startChromIx, startBase, endChromIx, endBase, endDataOffset, itemsPerSlot, rootOffset);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J7\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0018\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0019J&\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J,\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/bio/big/RTreeIndex$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "computeLevels", "", "Lorg/jetbrains/bio/big/Interval;", "leaves", "Lorg/jetbrains/bio/big/RTreeIndexLeaf;", "blockSize", "", "read", "Lorg/jetbrains/bio/big/RTreeIndex;", "input", "Lorg/jetbrains/bio/RomBuffer;", "offset", "", "read$big", "write", "", "output", "Lorg/jetbrains/bio/OrderedDataOutput;", "itemsPerSlot", "write$big", "writeLeaves", "writeLevels", "levels", "big"})
    public static final class Companion {
        @NotNull
        public final RTreeIndex read$big(@NotNull RomBuffer input, long offset) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return new RTreeIndex(Header.Companion.read$big(input, offset));
        }

        public final void write$big(@NotNull OrderedDataOutput output, @NotNull List<RTreeIndexLeaf> leaves2, int blockSize, int itemsPerSlot) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter(leaves2, (String)"leaves");
            boolean bl = blockSize > 1;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "blockSize must be >1";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (leaves2.isEmpty()) {
                new Header(output.getOrder(), blockSize, leaves2.size(), 0, 0, 0, 0, output.tell(), itemsPerSlot, output.tell() + (long)48).write$big(output);
                return;
            }
            Offset leftmost = ((RTreeIndexLeaf)CollectionsKt.first(leaves2)).getInterval().getLeft();
            Offset rightmost = ((RTreeIndexLeaf)CollectionsKt.last(leaves2)).getInterval().getRight();
            Header header2 = new Header(output.getOrder(), blockSize, leaves2.size(), leftmost.getChromIx(), leftmost.getOffset(), rightmost.getChromIx(), rightmost.getOffset(), output.tell(), itemsPerSlot, output.tell() + (long)48);
            header2.write$big(output);
            LOG.debug("Creating R+ tree for " + leaves2.size() + " items " + '(' + blockSize + " slots/node, " + itemsPerSlot + " items/slot)");
            this.writeLevels(output, this.computeLevels(leaves2, blockSize), blockSize);
            this.writeLeaves(output, leaves2, blockSize);
            LOG.debug("Saved R+ tree using " + (output.tell() - header2.getRootOffset()) + " bytes");
        }

        public static /* synthetic */ void write$big$default(Companion companion, OrderedDataOutput orderedDataOutput, List list, int n, int n2, int n3, Object object) {
            if ((n3 & 4) != 0) {
                n = 256;
            }
            if ((n3 & 8) != 0) {
                n2 = 512;
            }
            companion.write$big(orderedDataOutput, list, n, n2);
        }

        /*
         * WARNING - void declaration
         */
        private final void writeLeaves(OrderedDataOutput output, List<RTreeIndexLeaf> leaves2, int blockSize) {
            long levelOffset = output.tell();
            for (int i = 0; i < leaves2.size(); i += blockSize) {
                int n = leaves2.size() - i;
                boolean bl = false;
                int leafCount = Math.min(blockSize, n);
                n = 0;
                bl = false;
                OrderedDataOutput $this$with = output;
                boolean bl2 = false;
                $this$with.writeBoolean(true);
                $this$with.writeByte(0);
                $this$with.writeShort(leafCount);
                int n2 = 0;
                int n3 = leafCount;
                while (n2 < n3) {
                    void j;
                    leaves2.get(i + j).write$big($this$with);
                    ++j;
                }
                $this$with.skipBytes(32 * (blockSize - leafCount));
            }
            LOG.trace("Wrote " + leaves2.size() + " slots at leaf level " + "(offset: " + levelOffset + ')');
        }

        /*
         * WARNING - void declaration
         */
        private final void writeLevels(OrderedDataOutput output, List<? extends List<? extends Interval>> levels, int blockSize) {
            int bytesInNodeHeader = 4;
            int bytesInIndexBlock = bytesInNodeHeader + blockSize * 24;
            int bytesInLeafBlock = bytesInNodeHeader + blockSize * 32;
            boolean bl = false;
            for (List level : (Iterable)levels) {
                void d;
                int bytesInCurrentBlock = bytesInIndexBlock;
                int bytesInNextLevelBlock = d == levels.size() - 1 ? bytesInLeafBlock : bytesInCurrentBlock;
                long levelOffset = output.tell();
                int nodeCount = SupportKt.divCeiling(level.size(), blockSize);
                long childOffset = levelOffset + (long)(bytesInCurrentBlock * nodeCount);
                for (int i = 0; i < level.size(); i += blockSize) {
                    int n = level.size() - i;
                    boolean bl2 = false;
                    int childCount = Math.min(blockSize, n);
                    n = 0;
                    bl2 = false;
                    OrderedDataOutput $this$with = output;
                    boolean bl3 = false;
                    $this$with.writeBoolean(false);
                    $this$with.writeByte(0);
                    $this$with.writeShort(childCount);
                    int n2 = 0;
                    int n3 = childCount;
                    while (n2 < n3) {
                        void j;
                        new RTreeIndexNode((Interval)level.get(i + j), childOffset).write$big($this$with);
                        childOffset += (long)bytesInNextLevelBlock;
                        ++j;
                    }
                    $this$with.skipBytes(24 * (blockSize - childCount));
                }
                LOG.trace("Wrote " + level.size() + " slots at level " + (int)d + " (offset: " + levelOffset + ')');
                ++d;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<List<Interval>> computeLevels(List<RTreeIndexLeaf> leaves2, int blockSize) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List links;
            Object object;
            ArrayList<Interval> arrayList;
            void $this$mapTo$iv$iv22;
            Iterable $this$map$iv2 = leaves2;
            int $i$f$map = 0;
            Iterable iterable = $this$map$iv2;
            ArrayList<Interval> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            int $i$f$mapTo2 = 0;
            for (Object item$iv$iv : $this$mapTo$iv$iv22) {
                void it;
                RTreeIndexLeaf rTreeIndexLeaf = (RTreeIndexLeaf)item$iv$iv;
                arrayList = destination$iv$iv;
                boolean bl = false;
                object = it.getInterval();
                arrayList.add((Interval)object);
            }
            List intervals = destination$iv$iv;
            Logger logger = LOG;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
            if (logger.isWarnEnabled()) {
                boolean containsIntersectedIntervalse = false;
                $i$f$map = 1;
                int $this$mapTo$iv$iv22 = intervals.size();
                while ($i$f$map < $this$mapTo$iv$iv22) {
                    void i;
                    if (((Interval)intervals.get((int)i)).intersects((Interval)intervals.get((int)(i - true)))) {
                        containsIntersectedIntervalse = true;
                        LOG.debug("R+ tree leaves are overlapping: " + (Interval)intervals.get((int)i) + " ^ " + (Interval)intervals.get((int)(i - true)));
                    }
                    ++i;
                }
                if (containsIntersectedIntervalse) {
                    LOG.warn("Some R+ tree leaves are overlapping. Queries might be not efficient.");
                }
            }
            ArrayList levels = CollectionsKt.arrayListOf((Object[])new List[]{intervals});
            while (intervals.size() > 1) {
                ArrayList<Interval> level = new ArrayList<Interval>(SupportKt.divCeiling(intervals.size(), blockSize));
                for (int i = 0; i < intervals.size(); i += blockSize) {
                    void $this$reduce$iv;
                    $i$f$mapTo2 = intervals.size();
                    int n = i + blockSize;
                    boolean item$iv$iv = false;
                    links = intervals.subList(i, Math.min($i$f$mapTo2, n));
                    Iterable $i$f$mapTo2 = links;
                    arrayList = level;
                    boolean $i$f$reduce = false;
                    Iterator iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    Object accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        void p2;
                        Interval bl = (Interval)iterator$iv.next();
                        Interval p1 = (Interval)accumulator$iv;
                        boolean bl2 = false;
                        accumulator$iv = p1.union((Interval)p2);
                    }
                    object = accumulator$iv;
                    arrayList.add((Interval)object);
                }
                levels.add(level);
                intervals = level;
            }
            CollectionsKt.reverse((List)levels);
            Iterable level = levels;
            object = new StringBuilder().append("Computed ").append(levels.size()).append(" levels: ");
            arrayList = LOG;
            boolean $i$f$map2 = false;
            links = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                List p2 = (List)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                Integer n = it.size();
                collection.add(n);
            }
            collection = (List)destination$iv$iv2;
            arrayList.debug(((StringBuilder)object).append(collection).toString());
            int n = 1;
            int n2 = levels.size() - 1;
            boolean bl = false;
            List<List<Interval>> list = levels.subList(1, Math.max(n, n2));
            Intrinsics.checkNotNullExpressionValue(list, (String)"levels.subList(1, max(1, levels.size - 1))");
            return list;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

