/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.big;

import java.io.Closeable;
import java.io.Writer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bio.ScoredInterval;
import org.jetbrains.bio.big.FixedStepSection;
import org.jetbrains.bio.big.VariableStepSection;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B!\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/bio/big/WigPrinter;", "Ljava/io/Closeable;", "Ljava/lang/AutoCloseable;", "writer", "Ljava/io/Writer;", "name", "", "description", "(Ljava/io/Writer;Ljava/lang/String;Ljava/lang/String;)V", "close", "", "print", "track", "Lorg/jetbrains/bio/big/FixedStepSection;", "Lorg/jetbrains/bio/big/VariableStepSection;", "big"})
public final class WigPrinter
implements Closeable,
AutoCloseable {
    private final Writer writer;
    private final String name;

    /*
     * WARNING - void declaration
     */
    public final void print(@NotNull VariableStepSection track) {
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        this.writer.write("variableStep chrom=" + track.getChrom() + " span=" + track.getSpan() + '\n');
        for (ScoredInterval scoredInterval : track.query()) {
            void start;
            int n = scoredInterval.component1();
            float score = scoredInterval.component3();
            this.writer.write("" + (int)(start + true) + ' ' + score + '\n');
        }
    }

    public final void print(@NotNull FixedStepSection track) {
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        this.writer.write("fixedStep chrom=" + track.getChrom() + ' ' + "start=" + (track.getStart() + 1) + ' ' + "step=" + track.getStep() + " span=" + track.getSpan() + '\n');
        for (ScoredInterval interval : track.query()) {
            this.writer.write("" + interval.getScore() + '\n');
        }
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @JvmOverloads
    public WigPrinter(@NotNull Writer writer, @NotNull String name, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.writer = writer;
        this.name = name;
        this.writer.write("track type=wiggle_0 name=\"" + this.name + "\" description=\"" + description + "\"\n");
    }

    public /* synthetic */ WigPrinter(Writer writer, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = string;
        }
        this(writer, string, string2);
    }

    @JvmOverloads
    public WigPrinter(@NotNull Writer writer, @NotNull String name) {
        this(writer, name, null, 4, null);
    }
}

