/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.bio.viktor;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.random.RandomGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.bio.viktor.F64FlatArray;
import org.jetbrains.bio.viktor.SortingKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0086\u0010\u00a8\u0006\r"}, d2={"Lorg/jetbrains/bio/viktor/QuickSelect;", "", "()V", "select", "", "values", "Lorg/jetbrains/bio/viktor/F64FlatArray;", "left", "", "right", "n", "randomGenerator", "Lorg/apache/commons/math3/random/RandomGenerator;", "viktor"})
public final class QuickSelect {
    @NotNull
    public static final QuickSelect INSTANCE;

    public final double select(@NotNull F64FlatArray values, int left, int right, int n, @NotNull RandomGenerator randomGenerator) {
        while (true) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            Intrinsics.checkNotNullParameter((Object)randomGenerator, (String)"randomGenerator");
            if (left == right) {
                return values.get(left);
            }
            int split = left + randomGenerator.nextInt(right - left + 1);
            split = SortingKt.partition(values, split, left, right);
            if (split == n) break;
            if (split > n) {
                right = split - 1;
                continue;
            }
            left = split + 1;
        }
        return values.get(n);
    }

    private QuickSelect() {
    }

    static {
        QuickSelect quickSelect;
        INSTANCE = quickSelect = new QuickSelect();
    }
}

