/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.resources;

import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.resources.MissingResourceException;
import org.jetbrains.compose.resources.ResourceReader;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u00a8\u0006\u0002"}, d2={"getPlatformResourceReader", "Lorg/jetbrains/compose/resources/ResourceReader;", "library"})
public final class ResourceReader_desktopKt {
    @NotNull
    public static final ResourceReader getPlatformResourceReader() {
        return new ResourceReader(){

            @Nullable
            public Object read(@NotNull String path, @NotNull Continuation<? super byte[]> $completion) {
                InputStream resource = this.getResourceAsStream(path);
                return ByteStreamsKt.readBytes((InputStream)resource);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public Object readPart(@NotNull String path, long offset, long size, @NotNull Continuation<? super byte[]> $completion) {
                InputStream resource = this.getResourceAsStream(path);
                byte[] result = new byte[(int)size];
                Closeable closeable = resource;
                Throwable throwable = null;
                try {
                    InputStream input = (InputStream)closeable;
                    boolean bl = false;
                    input.skip(offset);
                    int n = input.read(result, 0, (int)size);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return result;
            }

            @NotNull
            public String getUri(@NotNull String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                ClassLoader classLoader = this.getClassLoader();
                URL uRL = classLoader.getResource(path);
                if (uRL == null) {
                    throw new MissingResourceException(path);
                }
                URL resource = uRL;
                String string = resource.toURI().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }

            private final InputStream getResourceAsStream(String path) {
                ClassLoader classLoader = this.getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream(path);
                if (inputStream == null) {
                    throw new MissingResourceException(path);
                }
                return inputStream;
            }

            private final ClassLoader getClassLoader() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    ClassLoader classLoader2 = this.getClass().getClassLoader();
                    classLoader = classLoader2;
                    Intrinsics.checkNotNull((Object)classLoader2);
                }
                return classLoader;
            }
        };
    }
}

