/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.dsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.dsl.ConfigurationSource;
import org.jetbrains.compose.desktop.application.dsl.NativeDistributions;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.targets.jvm.KotlinJvmTarget;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0019\u001a\u0002002\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000301\"\u00020\u0003\u00a2\u0006\u0002\u00102J\u001f\u00103\u001a\u0002002\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000301\"\u00020\u0003\u00a2\u0006\u0002\u00102J\u001f\u00103\u001a\u0002002\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020501\"\u000205\u00a2\u0006\u0002\u00106J\u0006\u00107\u001a\u000200J\u000e\u00108\u001a\u0002002\u0006\u00108\u001a\u000209J\u000e\u00108\u001a\u0002002\u0006\u00108\u001a\u00020:J\u001f\u0010;\u001a\u0002002\u0012\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000101\"\u00020\u0001\u00a2\u0006\u0002\u0010=J\u001f\u0010\"\u001a\u0002002\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000301\"\u00020\u0003\u00a2\u0006\u0002\u00102J\u0014\u0010,\u001a\u0002002\f\u0010>\u001a\b\u0012\u0004\u0012\u00020-0?R\"\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u0015@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001cR\u001c\u0010$\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001f\"\u0004\b&\u0010!R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u001fR\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006@"}, d2={"Lorg/jetbrains/compose/desktop/application/dsl/Application;", "", "name", "", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Ljava/lang/String;Lorg/gradle/api/model/ObjectFactory;)V", "<set-?>", "Lorg/jetbrains/compose/desktop/application/dsl/ConfigurationSource;", "_configurationSource", "get_configurationSource$compose", "()Lorg/jetbrains/compose/desktop/application/dsl/ConfigurationSource;", "_dependenciesTaskNames", "Ljava/util/ArrayList;", "get_dependenciesTaskNames$compose", "()Ljava/util/ArrayList;", "_fromFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "kotlin.jvm.PlatformType", "get_fromFiles$compose", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "", "_isDefaultConfigurationEnabled", "get_isDefaultConfigurationEnabled$compose", "()Z", "args", "", "getArgs", "()Ljava/util/List;", "javaHome", "getJavaHome", "()Ljava/lang/String;", "setJavaHome", "(Ljava/lang/String;)V", "jvmArgs", "getJvmArgs", "mainClass", "getMainClass", "setMainClass", "mainJar", "Lorg/gradle/api/file/RegularFileProperty;", "getMainJar", "()Lorg/gradle/api/file/RegularFileProperty;", "getName", "nativeDistributions", "Lorg/jetbrains/compose/desktop/application/dsl/NativeDistributions;", "getNativeDistributions", "()Lorg/jetbrains/compose/desktop/application/dsl/NativeDistributions;", "", "", "([Ljava/lang/String;)V", "dependsOn", "tasks", "Lorg/gradle/api/Task;", "([Lorg/gradle/api/Task;)V", "disableDefaultConfiguration", "from", "Lorg/gradle/api/tasks/SourceSet;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "fromFiles", "files", "([Ljava/lang/Object;)V", "fn", "Lorg/gradle/api/Action;", "compose"})
public class Application {
    @NotNull
    private final String name;
    @Nullable
    private ConfigurationSource _configurationSource;
    private boolean _isDefaultConfigurationEnabled;
    private final ConfigurableFileCollection _fromFiles;
    @NotNull
    private final ArrayList<String> _dependenciesTaskNames;
    @Nullable
    private String mainClass;
    @NotNull
    private final RegularFileProperty mainJar;
    @Nullable
    private String javaHome;
    @NotNull
    private final List<String> args;
    @NotNull
    private final List<String> jvmArgs;
    @NotNull
    private final NativeDistributions nativeDistributions;

    @Inject
    public Application(@NotNull String name, @NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.name = name;
        this._isDefaultConfigurationEnabled = true;
        this._fromFiles = objects.fileCollection();
        this._dependenciesTaskNames = new ArrayList();
        Object object = objects.fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objects.fileProperty()");
        this.mainJar = object;
        this.args = new ArrayList();
        this.jvmArgs = new ArrayList();
        object = objects.newInstance(NativeDistributions.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"objects.newInstance(NativeDistributions::class.java)");
        this.nativeDistributions = (NativeDistributions)object;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final ConfigurationSource get_configurationSource$compose() {
        return this._configurationSource;
    }

    public final boolean get_isDefaultConfigurationEnabled$compose() {
        return this._isDefaultConfigurationEnabled;
    }

    public final ConfigurableFileCollection get_fromFiles$compose() {
        return this._fromFiles;
    }

    @NotNull
    public final ArrayList<String> get_dependenciesTaskNames$compose() {
        return this._dependenciesTaskNames;
    }

    public final void from(@NotNull SourceSet from) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        this._configurationSource = new ConfigurationSource.GradleSourceSet(from);
    }

    public final void from(@NotNull KotlinTarget from) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        boolean bl = from instanceof KotlinJvmTarget;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Non JVM Kotlin MPP targets are not supported: " + from.getClass().getCanonicalName() + " is not subtype of " + KotlinJvmTarget.class.getCanonicalName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this._configurationSource = new ConfigurationSource.KotlinMppTarget((KotlinJvmTarget)from);
    }

    public final void disableDefaultConfiguration() {
        this._isDefaultConfigurationEnabled = false;
    }

    public final void fromFiles(Object ... files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        this._fromFiles.from(Arrays.copyOf(files, files.length));
    }

    public final void dependsOn(String ... tasks) {
        Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
        CollectionsKt.addAll((Collection)this._dependenciesTaskNames, (Object[])tasks);
    }

    /*
     * WARNING - void declaration
     */
    public final void dependsOn(Task ... tasks) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
        Task[] taskArray = tasks;
        Collection destination$iv = this._dependenciesTaskNames;
        boolean $i$f$mapTo = false;
        void var5_5 = $this$mapTo$iv;
        int n = ((void)var5_5).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv;
            void var9_9 = item$iv = var5_5[j];
            Collection collection = destination$iv;
            boolean bl = false;
            String string = it.getPath();
            collection.add(string);
        }
    }

    @Nullable
    public final String getMainClass() {
        return this.mainClass;
    }

    public final void setMainClass(@Nullable String string) {
        this.mainClass = string;
    }

    @NotNull
    public final RegularFileProperty getMainJar() {
        return this.mainJar;
    }

    @Nullable
    public final String getJavaHome() {
        return this.javaHome;
    }

    public final void setJavaHome(@Nullable String string) {
        this.javaHome = string;
    }

    @NotNull
    public final List<String> getArgs() {
        return this.args;
    }

    public final void args(String ... args2) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        CollectionsKt.addAll((Collection)this.args, (Object[])args2);
    }

    @NotNull
    public final List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public final void jvmArgs(String ... jvmArgs) {
        Intrinsics.checkNotNullParameter((Object)jvmArgs, (String)"jvmArgs");
        CollectionsKt.addAll((Collection)this.jvmArgs, (Object[])jvmArgs);
    }

    @NotNull
    public final NativeDistributions getNativeDistributions() {
        return this.nativeDistributions;
    }

    public final void nativeDistributions(@NotNull Action<NativeDistributions> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        fn.execute((Object)this.nativeDistributions);
    }
}

