/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.dsl;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.tasks.Jar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinJvmCompilation;
import org.jetbrains.kotlin.gradle.targets.jvm.KotlinJvmTarget;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/compose/desktop/application/dsl/ConfigurationSource;", "", "()V", "jarTaskName", "", "getJarTaskName", "()Ljava/lang/String;", "jarTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/jvm/tasks/Jar;", "project", "Lorg/gradle/api/Project;", "runtimeClasspath", "Lorg/gradle/api/file/FileCollection;", "GradleSourceSet", "KotlinMppTarget", "Lorg/jetbrains/compose/desktop/application/dsl/ConfigurationSource$GradleSourceSet;", "Lorg/jetbrains/compose/desktop/application/dsl/ConfigurationSource$KotlinMppTarget;", "compose"})
public abstract class ConfigurationSource {
    private ConfigurationSource() {
    }

    @NotNull
    public abstract String getJarTaskName();

    @NotNull
    public abstract FileCollection runtimeClasspath(@NotNull Project var1);

    @NotNull
    public final TaskProvider<Jar> jarTask(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        TaskProvider taskProvider = project.getTasks().named(this.getJarTaskName(), Jar.class);
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"project.tasks.named(jarTaskName, Jar::class.java)");
        return taskProvider;
    }

    public /* synthetic */ ConfigurationSource(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/compose/desktop/application/dsl/ConfigurationSource$GradleSourceSet;", "Lorg/jetbrains/compose/desktop/application/dsl/ConfigurationSource;", "sourceSet", "Lorg/gradle/api/tasks/SourceSet;", "(Lorg/gradle/api/tasks/SourceSet;)V", "jarTaskName", "", "getJarTaskName", "()Ljava/lang/String;", "getSourceSet", "()Lorg/gradle/api/tasks/SourceSet;", "runtimeClasspath", "Lorg/gradle/api/file/FileCollection;", "project", "Lorg/gradle/api/Project;", "compose"})
    public static final class GradleSourceSet
    extends ConfigurationSource {
        @NotNull
        private final SourceSet sourceSet;

        public GradleSourceSet(@NotNull SourceSet sourceSet) {
            Intrinsics.checkNotNullParameter((Object)sourceSet, (String)"sourceSet");
            super(null);
            this.sourceSet = sourceSet;
        }

        @NotNull
        public final SourceSet getSourceSet() {
            return this.sourceSet;
        }

        @Override
        @NotNull
        public String getJarTaskName() {
            String string = this.sourceSet.getJarTaskName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceSet.jarTaskName");
            return string;
        }

        @Override
        @NotNull
        public FileCollection runtimeClasspath(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ConfigurableFileCollection configurableFileCollection = project.getObjects().fileCollection();
            boolean bl = false;
            boolean bl2 = false;
            ConfigurableFileCollection $this$runtimeClasspath_u24lambda_u2d2 = configurableFileCollection;
            boolean bl3 = false;
            Object[] objectArray = new Object[]{this.jarTask(project).flatMap(GradleSourceSet::runtimeClasspath$lambda-2$lambda-0)};
            $this$runtimeClasspath_u24lambda_u2d2.from(objectArray);
            objectArray = new Object[]{this.getSourceSet().getRuntimeClasspath().filter(GradleSourceSet::runtimeClasspath$lambda-2$lambda-1)};
            $this$runtimeClasspath_u24lambda_u2d2.from(objectArray);
            ConfigurableFileCollection configurableFileCollection2 = configurableFileCollection;
            Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection2, (String)"project.objects.fileCollection().apply {\n                from(jarTask(project).flatMap { it.archiveFile })\n                from(sourceSet.runtimeClasspath.filter { it.path.endsWith(\".jar\") })\n            }");
            return (FileCollection)configurableFileCollection2;
        }

        private static final Provider runtimeClasspath$lambda-2$lambda-0(Jar it) {
            return it.getArchiveFile();
        }

        private static final boolean runtimeClasspath$lambda-2$lambda-1(File it) {
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
            return StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/compose/desktop/application/dsl/ConfigurationSource$KotlinMppTarget;", "Lorg/jetbrains/compose/desktop/application/dsl/ConfigurationSource;", "target", "Lorg/jetbrains/kotlin/gradle/targets/jvm/KotlinJvmTarget;", "(Lorg/jetbrains/kotlin/gradle/targets/jvm/KotlinJvmTarget;)V", "jarTaskName", "", "getJarTaskName", "()Ljava/lang/String;", "getTarget", "()Lorg/jetbrains/kotlin/gradle/targets/jvm/KotlinJvmTarget;", "runtimeClasspath", "Lorg/gradle/api/file/FileCollection;", "project", "Lorg/gradle/api/Project;", "compose"})
    public static final class KotlinMppTarget
    extends ConfigurationSource {
        @NotNull
        private final KotlinJvmTarget target;

        public KotlinMppTarget(@NotNull KotlinJvmTarget target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            super(null);
            this.target = target;
        }

        @NotNull
        public final KotlinJvmTarget getTarget() {
            return this.target;
        }

        @Override
        @NotNull
        public String getJarTaskName() {
            return this.target.getArtifactsTaskName();
        }

        @Override
        @NotNull
        public FileCollection runtimeClasspath(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ConfigurableFileCollection configurableFileCollection = project.getObjects().fileCollection();
            boolean bl = false;
            boolean bl2 = false;
            ConfigurableFileCollection $this$runtimeClasspath_u24lambda_u2d2 = configurableFileCollection;
            boolean bl3 = false;
            Object[] objectArray = new Object[]{this.jarTask(project).flatMap(KotlinMppTarget::runtimeClasspath$lambda-2$lambda-0)};
            $this$runtimeClasspath_u24lambda_u2d2.from(objectArray);
            objectArray = new Object[]{((KotlinJvmCompilation)this.getTarget().getCompilations().getByName("main")).getRuntimeDependencyFiles().filter(KotlinMppTarget::runtimeClasspath$lambda-2$lambda-1)};
            $this$runtimeClasspath_u24lambda_u2d2.from(objectArray);
            ConfigurableFileCollection configurableFileCollection2 = configurableFileCollection;
            Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection2, (String)"project.objects.fileCollection().apply {\n                from(jarTask(project).flatMap { it.archiveFile })\n                from(target.compilations.getByName(\"main\").runtimeDependencyFiles.filter { it.path.endsWith(\".jar\") })\n            }");
            return (FileCollection)configurableFileCollection2;
        }

        private static final Provider runtimeClasspath$lambda-2$lambda-0(Jar it) {
            return it.getArchiveFile();
        }

        private static final boolean runtimeClasspath$lambda-2$lambda-1(File it) {
            String string = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
            return StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null);
        }
    }
}

