/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal.validation;

import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.dsl.MacOSSigningSettings;
import org.jetbrains.compose.desktop.application.internal.OS;
import org.jetbrains.compose.desktop.application.internal.OsUtilsKt;
import org.jetbrains.compose.desktop.application.internal.validation.ValidateBundleIDKt;
import org.jetbrains.compose.desktop.application.internal.validation.ValidatedMacOSSigningSettings;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"ERR_PREFIX", "", "ERR_UNKNOWN_PREFIX", "ERR_UNKNOWN_SIGN_ID", "ERR_WRONG_OS", "validate", "Lorg/jetbrains/compose/desktop/application/internal/validation/ValidatedMacOSSigningSettings;", "Lorg/jetbrains/compose/desktop/application/dsl/MacOSSigningSettings;", "bundleIDProvider", "Lorg/gradle/api/provider/Provider;", "project", "Lorg/gradle/api/Project;", "compose"})
public final class ValidatedMacOSSigningSettingsKt {
    @NotNull
    private static final String ERR_PREFIX = "Signing settings error:";
    @NotNull
    private static final String ERR_WRONG_OS = Intrinsics.stringPlus((String)"Signing settings error: macOS was expected, actual OS is ", (Object)((Object)OsUtilsKt.getCurrentOS()));
    @NotNull
    private static final String ERR_UNKNOWN_PREFIX = "Signing settings error: Could not infer signing prefix. To specify:\n  * Set bundleID to reverse DNS notation (e.g. \"com.mycompany.myapp\");\n  * Use 'compose.desktop.mac.signing.prefix' Gradle property;\n  * Use 'nativeExecutables.macOS.signing.prefix' DSL property;";
    @NotNull
    private static final String ERR_UNKNOWN_SIGN_ID = "Signing settings error: signing identity is null or empty. To specify:\n  * Use 'compose.desktop.mac.signing.identity' Gradle property;\n  * Use 'nativeExecutables.macOS.signing.identity' DSL property;";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ValidatedMacOSSigningSettings validate(@NotNull MacOSSigningSettings $this$validate, @NotNull Provider<String> bundleIDProvider, @NotNull Project project) {
        File file;
        String string;
        String string2;
        String string3;
        boolean bl;
        boolean bl2;
        String string4;
        Intrinsics.checkNotNullParameter((Object)$this$validate, (String)"<this>");
        Intrinsics.checkNotNullParameter(bundleIDProvider, (String)"bundleIDProvider");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean bl3 = OsUtilsKt.getCurrentOS() == OS.MacOS;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!bl3) {
            boolean bl6 = false;
            String string5 = ERR_WRONG_OS;
            throw (Throwable)new IllegalStateException(string5.toString());
        }
        String bundleID = ValidateBundleIDKt.validateBundleID(bundleIDProvider);
        String bl6 = (String)$this$validate.getPrefix().getOrNull();
        if (bl6 == null) {
            string4 = Intrinsics.stringPlus((String)StringsKt.substringBeforeLast$default((String)bundleID, (String)".", null, (int)2, null), (Object)".");
            bl2 = false;
            bl = false;
            String it = string4;
            boolean bl7 = false;
            String string6 = string3 = StringsKt.contains$default((CharSequence)bundleID, (char)'.', (boolean)false, (int)2, null) ? string4 : null;
            if (string3 == null) {
                string4 = ERR_UNKNOWN_PREFIX;
                bl2 = false;
                throw (Throwable)new IllegalStateException(string4.toString());
            }
            string2 = string3;
        } else {
            string2 = bl6;
        }
        String signPrefix = string = string2;
        string3 = (String)$this$validate.getIdentity().getOrNull();
        if (string3 == null) {
            string4 = ERR_UNKNOWN_SIGN_ID;
            bl2 = false;
            throw (Throwable)new IllegalStateException(string4.toString());
        }
        String signIdentity = bl6 = string3;
        String keychainPath = (String)$this$validate.getKeychain().getOrNull();
        if (keychainPath != null) {
            Object v2;
            block9: {
                void $this$firstOrNull$iv;
                Object object = new File[]{project.file((Object)keychainPath), project.getRootProject().file((Object)keychainPath)};
                object = CollectionsKt.listOf((Object[])object);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    File it = (File)element$iv;
                    boolean bl8 = false;
                    if (!it.exists()) continue;
                    v2 = element$iv;
                    break block9;
                }
                v2 = null;
            }
            File keychainFile = v2;
            bl2 = keychainFile != null;
            bl = false;
            boolean bl9 = false;
            if (!bl2) {
                boolean bl10 = false;
                String string7 = Intrinsics.stringPlus((String)"Signing settings error: could not find the specified keychain: ", (Object)keychainPath);
                throw (Throwable)new IllegalStateException(string7.toString());
            }
            file = keychainFile;
        } else {
            file = null;
        }
        File keychainFile = file;
        return new ValidatedMacOSSigningSettings(bundleID, signIdentity, keychainFile, signPrefix);
    }
}

