/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.de.undercouch.gradle.tasks.download.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.gradle.api.logging.Logger;

public class ProgressLoggerWrapper {
    private final Logger logger;
    private final Object progressLogger;

    public ProgressLoggerWrapper(Logger logger, Object servicesOwner, String src) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> progressLoggerFactoryClass;
        this.logger = logger;
        try {
            progressLoggerFactoryClass = Class.forName("org.gradle.internal.logging.progress.ProgressLoggerFactory");
        }
        catch (ClassNotFoundException e) {
            progressLoggerFactoryClass = Class.forName("org.gradle.logging.ProgressLoggerFactory");
        }
        Object serviceFactory = ProgressLoggerWrapper.invoke(servicesOwner, "getServices", new Object[0]);
        Object progressLoggerFactory = ProgressLoggerWrapper.invoke(serviceFactory, "get", progressLoggerFactoryClass);
        this.progressLogger = ProgressLoggerWrapper.invoke(progressLoggerFactory, "newOperation", this.getClass());
        String desc = "Download " + src;
        ProgressLoggerWrapper.invoke(this.progressLogger, "setDescription", desc);
        try {
            ProgressLoggerWrapper.invoke(this.progressLogger, "setLoggingHeader", desc);
        }
        catch (ReflectiveOperationException e) {
            logger.lifecycle(desc);
        }
    }

    private static Object invoke(Object obj, String method, Object ... args2) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class[] argumentTypes = new Class[args2.length];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            argumentTypes[i2] = args2[i2].getClass();
        }
        Method m = ProgressLoggerWrapper.findMethod(obj, method, argumentTypes);
        m.setAccessible(true);
        return m.invoke(obj, args2);
    }

    private static Method findMethod(Object obj, String methodName, Class<?>[] argumentTypes) throws NoSuchMethodException {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || !Arrays.equals(method.getParameterTypes(), argumentTypes)) continue;
                return method;
            }
        }
        throw new NoSuchMethodException("Method " + methodName + "(" + Arrays.toString(argumentTypes) + ") on " + obj.getClass());
    }

    private void invokeIgnoreExceptions(Object obj, String method, Object ... args2) {
        try {
            ProgressLoggerWrapper.invoke(obj, method, args2);
        }
        catch (ReflectiveOperationException e) {
            this.logger.trace("Unable to log progress", (Throwable)e);
        }
    }

    public void started() {
        this.invokeIgnoreExceptions(this.progressLogger, "started", new Object[0]);
    }

    public void completed() {
        this.invokeIgnoreExceptions(this.progressLogger, "completed", new Object[0]);
    }

    public void progress(String msg) {
        this.invokeIgnoreExceptions(this.progressLogger, "progress", msg);
    }
}

