/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.client.protocol;

import java.io.IOException;
import java.util.List;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.HttpException;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.HttpRequest;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.HttpRequestInterceptor;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.annotation.Contract;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.annotation.ThreadingBehavior;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.client.config.RequestConfig;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.client.protocol.HttpClientContext;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestAcceptEncoding
implements HttpRequestInterceptor {
    private final String acceptEncoding;

    public RequestAcceptEncoding(List<String> encodings) {
        if (encodings != null && !encodings.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (int i2 = 0; i2 < encodings.size(); ++i2) {
                if (i2 > 0) {
                    buf.append(",");
                }
                buf.append(encodings.get(i2));
            }
            this.acceptEncoding = buf.toString();
        } else {
            this.acceptEncoding = "gzip,deflate";
        }
    }

    public RequestAcceptEncoding() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        if (!request.containsHeader("Accept-Encoding") && requestConfig.isContentCompressionEnabled()) {
            request.addHeader("Accept-Encoding", this.acceptEncoding);
        }
    }
}

