/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.internal.GradleUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/compose/desktop/application/internal/DefaultIcons;", "", "()V", "forLinux", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "project", "Lorg/gradle/api/Project;", "forMac", "forWindows", "unpackIconIfNeeded", "platformName", "", "iconExt", "compose"})
public final class DefaultIcons {
    @NotNull
    public static final DefaultIcons INSTANCE = new DefaultIcons();

    private DefaultIcons() {
    }

    @NotNull
    public final Provider<RegularFile> forLinux(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.unpackIconIfNeeded(project, "linux", "png");
    }

    @NotNull
    public final Provider<RegularFile> forWindows(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.unpackIconIfNeeded(project, "windows", "ico");
    }

    @NotNull
    public final Provider<RegularFile> forMac(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.unpackIconIfNeeded(project, "mac", "icns");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Provider<RegularFile> unpackIconIfNeeded(Project project, String platformName, String iconExt) {
        Provider iconsDir = project.getLayout().getBuildDirectory().dir("compose/default-icons/1.1.0-rc01");
        Provider targetFile = iconsDir.map(arg_0 -> DefaultIcons.unpackIconIfNeeded$lambda-0(platformName, iconExt, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)targetFile, (String)"targetFile");
        File targetIoFile = GradleUtilsKt.getIoFile(targetFile);
        String sourceIconName = "default-compose-desktop-icon-" + platformName + '.' + iconExt;
        if (targetIoFile.exists()) {
            return targetFile;
        }
        Closeable closeable = INSTANCE.getClass().getClassLoader().getResourceAsStream(sourceIconName);
        if (closeable == null) {
            String string = Intrinsics.stringPlus((String)"Could not find default icon resource: ", (Object)sourceIconName);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        InputStream iconResourceStream = closeable;
        closeable = iconResourceStream;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            long l;
            Closeable input = closeable;
            boolean bl3 = false;
            targetIoFile.getParentFile().mkdirs();
            targetIoFile.createNewFile();
            Object object = targetIoFile;
            int n = 0;
            object = new FileOutputStream((File)object);
            n = 8192;
            boolean bl4 = false;
            object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
            n = 0;
            bl4 = false;
            Throwable throwable2 = null;
            try {
                BufferedOutputStream output = (BufferedOutputStream)object;
                boolean bl5 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return targetFile;
    }

    private static final RegularFile unpackIconIfNeeded$lambda-0(String $platformName, String $iconExt, Directory it) {
        Intrinsics.checkNotNullParameter((Object)$platformName, (String)"$platformName");
        Intrinsics.checkNotNullParameter((Object)$iconExt, (String)"$iconExt");
        return it.file("icon-" + $platformName + '.' + $iconExt);
    }
}

