/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal.validation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.dsl.MacOSNotarizationSettings;
import org.jetbrains.compose.desktop.application.internal.validation.ValidateBundleIDKt;
import org.jetbrains.compose.desktop.application.internal.validation.ValidatedMacOSNotarizationSettings;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"ERR_APPLE_ID_IS_EMPTY", "", "ERR_NOTARIZATION_SETTINGS_ARE_NOT_PROVIDED", "ERR_PASSWORD_IS_EMPTY", "ERR_PREFIX", "validate", "Lorg/jetbrains/compose/desktop/application/internal/validation/ValidatedMacOSNotarizationSettings;", "Lorg/jetbrains/compose/desktop/application/dsl/MacOSNotarizationSettings;", "bundleIDProvider", "Lorg/gradle/api/provider/Provider;", "compose"})
public final class ValidatedMacOSNotarizationSettingsKt {
    @NotNull
    private static final String ERR_PREFIX = "Notarization settings error:";
    @NotNull
    private static final String ERR_NOTARIZATION_SETTINGS_ARE_NOT_PROVIDED = "Notarization settings error: notarization settings are not provided";
    @NotNull
    private static final String ERR_APPLE_ID_IS_EMPTY = "Notarization settings error: appleID is null or empty. To specify:\n  * Use 'compose.desktop.mac.notarization.appleID' Gradle property;\n  * Or use 'nativeDistributions.macOS.notarization.appleID' DSL property;";
    @NotNull
    private static final String ERR_PASSWORD_IS_EMPTY = "Notarization settings error: password is null or empty. To specify:\n  * Use 'compose.desktop.mac.notarization.password' Gradle property;\n  * Or use 'nativeDistributions.macOS.notarization.password' DSL property;";

    @NotNull
    public static final ValidatedMacOSNotarizationSettings validate(@Nullable MacOSNotarizationSettings $this$validate, @NotNull Provider<String> bundleIDProvider) {
        String string;
        Intrinsics.checkNotNullParameter(bundleIDProvider, (String)"bundleIDProvider");
        boolean bl = false;
        boolean bl2 = false;
        if ($this$validate == null) {
            boolean bl3 = false;
            String string2 = ERR_NOTARIZATION_SETTINGS_ARE_NOT_PROVIDED;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String bundleID = ValidateBundleIDKt.validateBundleID(bundleIDProvider);
        CharSequence charSequence = (CharSequence)$this$validate.getAppleID().getOrNull();
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = !(charSequence == null || charSequence.length() == 0);
        bl4 = false;
        bl5 = false;
        if (!bl6) {
            boolean bl7 = false;
            String string3 = ERR_APPLE_ID_IS_EMPTY;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        CharSequence charSequence2 = (CharSequence)$this$validate.getPassword().getOrNull();
        bl4 = false;
        bl5 = false;
        boolean bl8 = !(charSequence2 == null || charSequence2.length() == 0);
        bl4 = false;
        bl5 = false;
        if (!bl8) {
            boolean bl9 = false;
            String string4 = ERR_PASSWORD_IS_EMPTY;
            throw (Throwable)new IllegalStateException(string4.toString());
        }
        String string5 = (String)$this$validate.getAppleID().getOrNull();
        Intrinsics.checkNotNull((Object)string5);
        String string6 = string = string5;
        string5 = (String)$this$validate.getPassword().getOrNull();
        Intrinsics.checkNotNull((Object)string5);
        string = string5;
        return new ValidatedMacOSNotarizationSettings(bundleID, string6, string, (String)$this$validate.getAscProvider().getOrNull());
    }
}

