/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.ui.tooling.preview.rpc;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.Command;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.CommandsKt;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.ConfigFromGradle;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.FrameConfig;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.FrameRequest;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewHostConfig;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewListener;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RemoteConnection;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RenderedFrame;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.UtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a&\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u0000\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\u0002\u001a4\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\u000bH\u0000\u001a4\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00010\u000b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00010\u000bH\u0000\u001a\f\u0010\u0013\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\"\u0010\u0014\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e\u001a\u0018\u0010\u0019\u001a\u00020\u0001*\u00020\u00022\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cH\u0000\u001a\u0014\u0010\u001d\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\fH\u0000\u001a\u001c\u0010\u001f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0012H\u0000\u00a8\u0006!"}, d2={"receiveAttach", "", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/RemoteConnection;", "listener", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewListener;", "fn", "Lkotlin/Function0;", "receiveConfigFromGradle", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/ConfigFromGradle;", "receiveFrame", "onFrame", "Lkotlin/Function1;", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/RenderedFrame;", "onError", "", "receivePreviewRequest", "onPreviewClasspath", "onFrameRequest", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/FrameRequest;", "sendAttach", "sendConfigFromGradle", "config", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewHostConfig;", "previewClasspath", "previewFqName", "sendError", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "sendFrame", "frame", "sendPreviewRequest", "request", "preview-rpc"})
public final class CommandsKt {
    public static final void sendAttach(@NotNull RemoteConnection $this$sendAttach) {
        Intrinsics.checkNotNullParameter((Object)$this$sendAttach, (String)"<this>");
        String[] stringArray = new String[]{"2"};
        $this$sendAttach.sendCommand(Command.Type.ATTACH, stringArray);
    }

    public static final void receiveAttach(@NotNull RemoteConnection $this$receiveAttach, @Nullable PreviewListener listener, @NotNull Function0<Unit> fn) {
        Intrinsics.checkNotNullParameter((Object)$this$receiveAttach, (String)"<this>");
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        $this$receiveAttach.receiveCommand((Function1<? super Command, Unit>)((Function1)new Function1<Command, Unit>(listener, fn){
            final /* synthetic */ PreviewListener $listener;
            final /* synthetic */ Function0<Unit> $fn;
            {
                this.$listener = $listener;
                this.$fn = $fn;
                super(1);
            }

            public final void invoke(@NotNull Command $dstr$type$args) {
                Intrinsics.checkNotNullParameter((Object)$dstr$type$args, (String)"$dstr$type$args");
                Command.Type type = $dstr$type$args.component1();
                List<String> args2 = $dstr$type$args.component2();
                if (type == Command.Type.ATTACH) {
                    Integer n;
                    int version;
                    Object object = (String)CollectionsKt.firstOrNull(args2);
                    int n2 = object == null ? 0 : (version = (n = StringsKt.toIntOrNull((String)object)) == null ? 0 : n);
                    if (2 != version && (object = this.$listener) != null) {
                        object.onError("Compose Multiplatform Gradle plugin version is not compatible with Intellij plugin version");
                    }
                    this.$fn.invoke();
                }
            }
        }));
    }

    public static /* synthetic */ void receiveAttach$default(RemoteConnection remoteConnection, PreviewListener previewListener, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            previewListener = null;
        }
        CommandsKt.receiveAttach(remoteConnection, previewListener, (Function0<Unit>)function0);
    }

    public static final void sendFrame(@NotNull RemoteConnection $this$sendFrame, @NotNull RenderedFrame frame) {
        Intrinsics.checkNotNullParameter((Object)$this$sendFrame, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        String[] stringArray = new String[]{String.valueOf(frame.getWidth()), String.valueOf(frame.getHeight())};
        $this$sendFrame.sendCommand(Command.Type.FRAME, stringArray);
        $this$sendFrame.sendData(frame.getBytes());
    }

    public static final void sendError(@NotNull RemoteConnection $this$sendError, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)$this$sendError, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        $this$sendError.sendCommand(Command.Type.ERROR, new String[0]);
        $this$sendError.sendUtf8StringData(UtilsKt.getStackTraceString(e));
    }

    public static final void receiveFrame(@NotNull RemoteConnection $this$receiveFrame, @NotNull Function1<? super RenderedFrame, Unit> onFrame, @NotNull Function1<? super String, Unit> onError2) {
        Intrinsics.checkNotNullParameter((Object)$this$receiveFrame, (String)"<this>");
        Intrinsics.checkNotNullParameter(onFrame, (String)"onFrame");
        Intrinsics.checkNotNullParameter(onError2, (String)"onError");
        $this$receiveFrame.receiveCommand((Function1<? super Command, Unit>)((Function1)new Function1<Command, Unit>($this$receiveFrame, onFrame, onError2){
            final /* synthetic */ RemoteConnection $this_receiveFrame;
            final /* synthetic */ Function1<RenderedFrame, Unit> $onFrame;
            final /* synthetic */ Function1<String, Unit> $onError;
            {
                this.$this_receiveFrame = $receiver;
                this.$onFrame = $onFrame;
                this.$onError = $onError;
                super(1);
            }

            public final void invoke(@NotNull Command $dstr$type$args) {
                Intrinsics.checkNotNullParameter((Object)$dstr$type$args, (String)"$dstr$type$args");
                Command.Type type = $dstr$type$args.component1();
                List<String> args2 = $dstr$type$args.component2();
                Command.Type type2 = type;
                int n = receiveFrame.WhenMappings.$EnumSwitchMapping$0[type2.ordinal()];
                switch (n) {
                    case 1: {
                        this.$this_receiveFrame.receiveData((Function1<? super byte[], Unit>)((Function1)new Function1<byte[], Unit>(args2, this.$onFrame){
                            final /* synthetic */ List<String> $args;
                            final /* synthetic */ Function1<RenderedFrame, Unit> $onFrame;
                            {
                                this.$args = $args;
                                this.$onFrame = $onFrame;
                                super(1);
                            }

                            public final void invoke(@NotNull byte[] bytes) {
                                List<String> list;
                                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                                List<String> list2 = list = this.$args;
                                boolean bl = false;
                                String w = list2.get(0);
                                List<String> list3 = list;
                                boolean bl2 = false;
                                String h = list3.get(1);
                                String string = w;
                                boolean bl3 = false;
                                int n = Integer.parseInt(string);
                                string = h;
                                bl3 = false;
                                RenderedFrame frame = new RenderedFrame(bytes, n, Integer.parseInt(string));
                                this.$onFrame.invoke((Object)frame);
                            }
                        }));
                        break;
                    }
                    case 2: {
                        this.$this_receiveFrame.receiveUtf8StringData((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.$onError){
                            final /* synthetic */ Function1<String, Unit> $onError;
                            {
                                this.$onError = $onError;
                                super(1);
                            }

                            public final void invoke(@NotNull String stacktrace) {
                                Intrinsics.checkNotNullParameter((Object)stacktrace, (String)"stacktrace");
                                this.$onError.invoke((Object)stacktrace);
                            }
                        }));
                        break;
                    }
                    default: {
                        String string = Intrinsics.stringPlus((String)"Received unexpected command type: ", (Object)((Object)type));
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                }
            }
        }));
    }

    public static final void sendConfigFromGradle(@NotNull RemoteConnection $this$sendConfigFromGradle, @NotNull PreviewHostConfig config, @NotNull String previewClasspath, @NotNull String previewFqName) {
        Intrinsics.checkNotNullParameter((Object)$this$sendConfigFromGradle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)previewClasspath, (String)"previewClasspath");
        Intrinsics.checkNotNullParameter((Object)previewFqName, (String)"previewFqName");
        String[] stringArray = new String[1];
        String string = URLEncoder.encode(config.getJavaExecutable(), Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(config.javaExecutable, Charsets.UTF_8)");
        stringArray[0] = string;
        $this$sendConfigFromGradle.sendCommand(Command.Type.PREVIEW_CONFIG, stringArray);
        $this$sendConfigFromGradle.sendUtf8StringData(config.getHostClasspath());
        $this$sendConfigFromGradle.sendCommand(Command.Type.PREVIEW_CLASSPATH, new String[0]);
        $this$sendConfigFromGradle.sendUtf8StringData(previewClasspath);
        $this$sendConfigFromGradle.sendCommand(Command.Type.PREVIEW_FQ_NAME, new String[0]);
        $this$sendConfigFromGradle.sendUtf8StringData(previewFqName);
    }

    @Nullable
    public static final ConfigFromGradle receiveConfigFromGradle(@NotNull RemoteConnection $this$receiveConfigFromGradle) {
        ConfigFromGradle configFromGradle;
        Intrinsics.checkNotNullParameter((Object)$this$receiveConfigFromGradle, (String)"<this>");
        Ref.ObjectRef previewClasspath = new Ref.ObjectRef();
        Ref.ObjectRef previewFqName = new Ref.ObjectRef();
        Ref.ObjectRef previewHostConfig = new Ref.ObjectRef();
        $this$receiveConfigFromGradle.receiveCommand((Function1<? super Command, Unit>)((Function1)new Function1<Command, Unit>($this$receiveConfigFromGradle, (Ref.ObjectRef<PreviewHostConfig>)previewHostConfig){
            final /* synthetic */ RemoteConnection $this_receiveConfigFromGradle;
            final /* synthetic */ Ref.ObjectRef<PreviewHostConfig> $previewHostConfig;
            {
                this.$this_receiveConfigFromGradle = $receiver;
                this.$previewHostConfig = $previewHostConfig;
                super(1);
            }

            public final void invoke(@NotNull Command $dstr$type$args) {
                Intrinsics.checkNotNullParameter((Object)$dstr$type$args, (String)"$dstr$type$args");
                Command.Type type = $dstr$type$args.component1();
                List<String> args2 = $dstr$type$args.component2();
                boolean bl = type == Command.Type.PREVIEW_CONFIG;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Expected " + (Object)((Object)Command.Type.PREVIEW_CONFIG) + ", got " + (Object)((Object)type);
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                String javaExecutable = URLDecoder.decode(args2.get(0), Charsets.UTF_8);
                this.$this_receiveConfigFromGradle.receiveUtf8StringData((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.$previewHostConfig, javaExecutable){
                    final /* synthetic */ Ref.ObjectRef<PreviewHostConfig> $previewHostConfig;
                    final /* synthetic */ String $javaExecutable;
                    {
                        this.$previewHostConfig = $previewHostConfig;
                        this.$javaExecutable = $javaExecutable;
                        super(1);
                    }

                    public final void invoke(@NotNull String hostClasspath) {
                        Intrinsics.checkNotNullParameter((Object)hostClasspath, (String)"hostClasspath");
                        String string = this.$javaExecutable;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaExecutable");
                        this.$previewHostConfig.element = new PreviewHostConfig(string, hostClasspath);
                    }
                }));
            }
        }));
        $this$receiveConfigFromGradle.receiveCommand((Function1<? super Command, Unit>)((Function1)new Function1<Command, Unit>($this$receiveConfigFromGradle, (Ref.ObjectRef<String>)previewClasspath){
            final /* synthetic */ RemoteConnection $this_receiveConfigFromGradle;
            final /* synthetic */ Ref.ObjectRef<String> $previewClasspath;
            {
                this.$this_receiveConfigFromGradle = $receiver;
                this.$previewClasspath = $previewClasspath;
                super(1);
            }

            public final void invoke(@NotNull Command $dstr$type$_u24__u24) {
                Intrinsics.checkNotNullParameter((Object)$dstr$type$_u24__u24, (String)"$dstr$type$_u24__u24");
                Command.Type type = $dstr$type$_u24__u24.component1();
                boolean bl = type == Command.Type.PREVIEW_CLASSPATH;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Expected " + (Object)((Object)Command.Type.PREVIEW_CLASSPATH) + ", got " + (Object)((Object)type);
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                this.$this_receiveConfigFromGradle.receiveUtf8StringData((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.$previewClasspath){
                    final /* synthetic */ Ref.ObjectRef<String> $previewClasspath;
                    {
                        this.$previewClasspath = $previewClasspath;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$previewClasspath.element = it;
                    }
                }));
            }
        }));
        $this$receiveConfigFromGradle.receiveCommand((Function1<? super Command, Unit>)((Function1)new Function1<Command, Unit>($this$receiveConfigFromGradle, (Ref.ObjectRef<String>)previewFqName){
            final /* synthetic */ RemoteConnection $this_receiveConfigFromGradle;
            final /* synthetic */ Ref.ObjectRef<String> $previewFqName;
            {
                this.$this_receiveConfigFromGradle = $receiver;
                this.$previewFqName = $previewFqName;
                super(1);
            }

            public final void invoke(@NotNull Command $dstr$type$_u24__u24) {
                Intrinsics.checkNotNullParameter((Object)$dstr$type$_u24__u24, (String)"$dstr$type$_u24__u24");
                Command.Type type = $dstr$type$_u24__u24.component1();
                boolean bl = type == Command.Type.PREVIEW_FQ_NAME;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Expected " + (Object)((Object)Command.Type.PREVIEW_FQ_NAME) + ", got " + (Object)((Object)type);
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                this.$this_receiveConfigFromGradle.receiveUtf8StringData((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.$previewFqName){
                    final /* synthetic */ Ref.ObjectRef<String> $previewFqName;
                    {
                        this.$previewFqName = $previewFqName;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$previewFqName.element = it;
                    }
                }));
            }
        }));
        if (previewClasspath.element != null && previewFqName.element != null && previewHostConfig.element != null) {
            Intrinsics.checkNotNull((Object)previewClasspath.element);
            String string = (String)previewClasspath.element;
            Intrinsics.checkNotNull((Object)previewFqName.element);
            String string2 = (String)previewFqName.element;
            Intrinsics.checkNotNull((Object)previewHostConfig.element);
            configFromGradle = new ConfigFromGradle(string, string2, (PreviewHostConfig)previewHostConfig.element);
        } else {
            configFromGradle = null;
        }
        return configFromGradle;
    }

    public static final void sendPreviewRequest(@NotNull RemoteConnection $this$sendPreviewRequest, @NotNull String previewClasspath, @NotNull FrameRequest request) {
        FrameConfig frameConfig;
        Intrinsics.checkNotNullParameter((Object)$this$sendPreviewRequest, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)previewClasspath, (String)"previewClasspath");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        $this$sendPreviewRequest.sendCommand(Command.Type.PREVIEW_CLASSPATH, new String[0]);
        Object object = previewClasspath;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        $this$sendPreviewRequest.sendData(byArray);
        object = request;
        long id = ((FrameRequest)object).component1();
        String fqName = ((FrameRequest)object).component2();
        FrameConfig frameConfig2 = frameConfig = ((FrameRequest)object).component3();
        int w = frameConfig2.component1();
        int h = frameConfig2.component2();
        Double scale = frameConfig2.component3();
        Object[] objectArray = new String[]{fqName, String.valueOf(id), String.valueOf(w), String.valueOf(h)};
        ArrayList args2 = CollectionsKt.arrayListOf((Object[])objectArray);
        if (scale != null) {
            long scaleLong = Double.doubleToRawLongBits(scale);
            args2.add(String.valueOf(scaleLong));
        }
        Collection $this$toTypedArray$iv = args2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray = stringArray;
        $this$sendPreviewRequest.sendCommand(Command.Type.FRAME_REQUEST, (String[])Arrays.copyOf(objectArray, objectArray.length));
    }

    public static final void receivePreviewRequest(@NotNull RemoteConnection $this$receivePreviewRequest, @NotNull Function1<? super String, Unit> onPreviewClasspath, @NotNull Function1<? super FrameRequest, Unit> onFrameRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$receivePreviewRequest, (String)"<this>");
        Intrinsics.checkNotNullParameter(onPreviewClasspath, (String)"onPreviewClasspath");
        Intrinsics.checkNotNullParameter(onFrameRequest, (String)"onFrameRequest");
        $this$receivePreviewRequest.receiveCommand((Function1<? super Command, Unit>)((Function1)new Function1<Command, Unit>($this$receivePreviewRequest, onFrameRequest, onPreviewClasspath){
            final /* synthetic */ RemoteConnection $this_receivePreviewRequest;
            final /* synthetic */ Function1<FrameRequest, Unit> $onFrameRequest;
            final /* synthetic */ Function1<String, Unit> $onPreviewClasspath;
            {
                this.$this_receivePreviewRequest = $receiver;
                this.$onFrameRequest = $onFrameRequest;
                this.$onPreviewClasspath = $onPreviewClasspath;
                super(1);
            }

            public final void invoke(@NotNull Command $dstr$type$args) {
                Intrinsics.checkNotNullParameter((Object)$dstr$type$args, (String)"$dstr$type$args");
                Command.Type type = $dstr$type$args.component1();
                List<String> args2 = $dstr$type$args.component2();
                Command.Type type2 = type;
                int n = receivePreviewRequest.WhenMappings.$EnumSwitchMapping$0[type2.ordinal()];
                switch (n) {
                    case 1: {
                        this.$this_receivePreviewRequest.receiveUtf8StringData((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.$onPreviewClasspath){
                            final /* synthetic */ Function1<String, Unit> $onPreviewClasspath;
                            {
                                this.$onPreviewClasspath = $onPreviewClasspath;
                                super(1);
                            }

                            public final void invoke(@NotNull String it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                this.$onPreviewClasspath.invoke((Object)it);
                            }
                        }));
                        break;
                    }
                    case 2: {
                        Double d;
                        String fqName = (String)CollectionsKt.getOrNull(args2, (int)0);
                        String string = (String)CollectionsKt.getOrNull(args2, (int)1);
                        Long id = string == null ? null : StringsKt.toLongOrNull((String)string);
                        String string2 = (String)CollectionsKt.getOrNull(args2, (int)2);
                        Integer w = string2 == null ? null : StringsKt.toIntOrNull((String)string2);
                        String string3 = (String)CollectionsKt.getOrNull(args2, (int)3);
                        Integer h = string3 == null ? null : StringsKt.toIntOrNull((String)string3);
                        CharSequence charSequence = (String)CollectionsKt.getOrNull(args2, (int)4);
                        if (charSequence == null) {
                            d = null;
                        } else {
                            Long l = StringsKt.toLongOrNull((String)charSequence);
                            if (l == null) {
                                d = null;
                            } else {
                                Long l2 = l;
                                boolean bl = false;
                                boolean bl2 = false;
                                long it = ((Number)l2).longValue();
                                boolean bl3 = false;
                                d = Double.longBitsToDouble(it);
                            }
                        }
                        Double scale = d;
                        if (fqName == null) break;
                        charSequence = fqName;
                        boolean bl = false;
                        if (!(charSequence.length() > 0) || id == null || w == null || w <= 0 || h == null || h <= 0) break;
                        this.$onFrameRequest.invoke((Object)new FrameRequest(id, fqName, new FrameConfig(w, h, scale)));
                    }
                }
            }
        }));
    }
}

