/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.protocol;

import java.io.IOException;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.HttpException;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.HttpResponse;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.HttpResponseInterceptor;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.annotation.Contract;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.annotation.ThreadingBehavior;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.protocol.HttpContext;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.protocol.HttpDateGenerator;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

