/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import kotlin.reflect.KProperty0;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.dsl.JvmApplication;
import org.jetbrains.compose.desktop.application.dsl.JvmApplicationBuildTypes;
import org.jetbrains.compose.desktop.application.dsl.JvmApplicationDistributions;
import org.jetbrains.compose.desktop.application.internal.JvmApplicationData;
import org.jetbrains.compose.desktop.application.internal.JvmApplicationRuntimeFilesProvider;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.targets.jvm.KotlinJvmTarget;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\u0007\u001a\u0002002\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000301\"\u00020\u0003\u00a2\u0006\u0002\u00102J\u0014\u0010\r\u001a\u0002002\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000e04J\u001f\u00105\u001a\u0002002\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000301\"\u00020\u0003\u00a2\u0006\u0002\u00102J\u001f\u00105\u001a\u0002002\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020701\"\u000207\u00a2\u0006\u0002\u00108J\u0006\u00109\u001a\u000200J\u000e\u0010:\u001a\u0002002\u0006\u0010:\u001a\u00020;J\u000e\u0010:\u001a\u0002002\u0006\u0010:\u001a\u00020<J\u001f\u0010=\u001a\u0002002\u0012\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020?01\"\u00020?\u00a2\u0006\u0002\u0010@J\u001f\u0010\u001e\u001a\u0002002\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000301\"\u00020\u0003\u00a2\u0006\u0002\u00102J\u0014\u0010+\u001a\u0002002\f\u00103\u001a\b\u0012\u0004\u0012\u00020,04R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R+\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR!\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\f\u001a\u0004\b\u001f\u0010\nR/\u0010!\u001a\u0004\u0018\u00010\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010\u001d\u001a\u0004\b\"\u0010\u0019\"\u0004\b#\u0010\u001bR\u001b\u0010%\u001a\u00020&8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\f\u001a\u0004\b'\u0010(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0019R\u001b\u0010+\u001a\u00020,8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\f\u001a\u0004\b-\u0010.\u00a8\u0006A"}, d2={"Lorg/jetbrains/compose/desktop/application/internal/JvmApplicationInternal;", "Lorg/jetbrains/compose/desktop/application/dsl/JvmApplication;", "name", "", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Ljava/lang/String;Lorg/gradle/api/model/ObjectFactory;)V", "args", "", "getArgs", "()Ljava/util/List;", "args$delegate", "Lkotlin/reflect/KProperty0;", "buildTypes", "Lorg/jetbrains/compose/desktop/application/dsl/JvmApplicationBuildTypes;", "getBuildTypes", "()Lorg/jetbrains/compose/desktop/application/dsl/JvmApplicationBuildTypes;", "buildTypes$delegate", "data", "Lorg/jetbrains/compose/desktop/application/internal/JvmApplicationData;", "getData$compose", "()Lorg/jetbrains/compose/desktop/application/internal/JvmApplicationData;", "<set-?>", "javaHome", "getJavaHome", "()Ljava/lang/String;", "setJavaHome", "(Ljava/lang/String;)V", "javaHome$delegate", "Lkotlin/reflect/KMutableProperty0;", "jvmArgs", "getJvmArgs", "jvmArgs$delegate", "mainClass", "getMainClass", "setMainClass", "mainClass$delegate", "mainJar", "Lorg/gradle/api/file/RegularFileProperty;", "getMainJar", "()Lorg/gradle/api/file/RegularFileProperty;", "mainJar$delegate", "getName", "nativeDistributions", "Lorg/jetbrains/compose/desktop/application/dsl/JvmApplicationDistributions;", "getNativeDistributions", "()Lorg/jetbrains/compose/desktop/application/dsl/JvmApplicationDistributions;", "nativeDistributions$delegate", "", "", "([Ljava/lang/String;)V", "fn", "Lorg/gradle/api/Action;", "dependsOn", "tasks", "Lorg/gradle/api/Task;", "([Lorg/gradle/api/Task;)V", "disableDefaultConfiguration", "from", "Lorg/gradle/api/tasks/SourceSet;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "fromFiles", "files", "", "([Ljava/lang/Object;)V", "compose"})
public class JvmApplicationInternal
extends JvmApplication {
    @NotNull
    private final String name;
    @NotNull
    private final JvmApplicationData data;
    @NotNull
    private final KMutableProperty0 mainClass$delegate;
    @NotNull
    private final KProperty0 mainJar$delegate;
    @NotNull
    private final KMutableProperty0 javaHome$delegate;
    @NotNull
    private final KProperty0 args$delegate;
    @NotNull
    private final KProperty0 jvmArgs$delegate;
    @NotNull
    private final KProperty0 nativeDistributions$delegate;
    @NotNull
    private final KProperty0 buildTypes$delegate;

    /*
     * WARNING - void declaration
     */
    @Inject
    public JvmApplicationInternal(@NotNull String name, @NotNull ObjectFactory objects) {
        void $this$new$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        this.name = name;
        ObjectFactory objectFactory = objects;
        Object[] params$iv = new Object[]{};
        boolean $i$f$new = false;
        this.data = (JvmApplicationData)$this$new$iv.newInstance(JvmApplicationData.class, Arrays.copyOf(params$iv, params$iv.length));
        this.mainClass$delegate = (KMutableProperty0)new MutablePropertyReference0Impl(this.data){

            @Nullable
            public Object get() {
                return ((JvmApplicationData)this.receiver).getMainClass();
            }

            public void set(@Nullable Object value) {
                ((JvmApplicationData)this.receiver).setMainClass((String)value);
            }
        };
        this.mainJar$delegate = (KProperty0)new PropertyReference0Impl(this.data){

            @Nullable
            public Object get() {
                return ((JvmApplicationData)this.receiver).getMainJar();
            }
        };
        this.javaHome$delegate = (KMutableProperty0)new MutablePropertyReference0Impl(this.data){

            @Nullable
            public Object get() {
                return ((JvmApplicationData)this.receiver).getJavaHome();
            }

            public void set(@Nullable Object value) {
                ((JvmApplicationData)this.receiver).setJavaHome((String)value);
            }
        };
        this.args$delegate = (KProperty0)new PropertyReference0Impl(this.data){

            @Nullable
            public Object get() {
                return ((JvmApplicationData)this.receiver).getArgs();
            }
        };
        this.jvmArgs$delegate = (KProperty0)new PropertyReference0Impl(this.data){

            @Nullable
            public Object get() {
                return ((JvmApplicationData)this.receiver).getJvmArgs();
            }
        };
        this.nativeDistributions$delegate = (KProperty0)new PropertyReference0Impl(this.data){

            @Nullable
            public Object get() {
                return ((JvmApplicationData)this.receiver).getNativeDistributions();
            }
        };
        this.buildTypes$delegate = (KProperty0)new PropertyReference0Impl(this.data){

            @Nullable
            public Object get() {
                return ((JvmApplicationData)this.receiver).getBuildTypes();
            }
        };
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final JvmApplicationData getData$compose() {
        return this.data;
    }

    @Override
    public final void from(@NotNull SourceSet from) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        this.data.setJvmApplicationRuntimeFilesProvider(new JvmApplicationRuntimeFilesProvider.FromGradleSourceSet(from));
    }

    @Override
    public final void from(@NotNull KotlinTarget from) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        boolean bl = from instanceof KotlinJvmTarget;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Non JVM Kotlin MPP targets are not supported: " + from.getClass().getCanonicalName() + " is not subtype of " + KotlinJvmTarget.class.getCanonicalName();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.data.setJvmApplicationRuntimeFilesProvider(new JvmApplicationRuntimeFilesProvider.FromKotlinMppTarget((KotlinJvmTarget)from));
    }

    @Override
    public final void disableDefaultConfiguration() {
        this.data.setDefaultConfigurationEnabled(false);
    }

    @Override
    public final void fromFiles(Object ... files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        this.data.getFromFiles().from(Arrays.copyOf(files, files.length));
    }

    @Override
    public final void dependsOn(String ... tasks) {
        Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
        CollectionsKt.addAll((Collection)this.data.getDependenciesTaskNames(), (Object[])tasks);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void dependsOn(Task ... tasks) {
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)tasks, (String)"tasks");
        Task[] taskArray = tasks;
        Collection destination$iv = this.data.getDependenciesTaskNames();
        boolean $i$f$mapTo = false;
        void var5_5 = $this$mapTo$iv;
        int n = ((void)var5_5).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv;
            void var9_9 = item$iv = var5_5[j];
            Collection collection = destination$iv;
            boolean bl = false;
            String string = it.getPath();
            collection.add(string);
        }
    }

    @Override
    @Nullable
    public final String getMainClass() {
        KProperty0 kProperty0 = (KProperty0)this.mainClass$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)kProperty0.get();
    }

    @Override
    public final void setMainClass(@Nullable String string) {
        KMutableProperty0 kMutableProperty0 = this.mainClass$delegate;
        Object var3_3 = null;
        boolean bl = false;
        kMutableProperty0.set((Object)string);
    }

    @Override
    @NotNull
    public final RegularFileProperty getMainJar() {
        KProperty0 kProperty0 = this.mainJar$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (RegularFileProperty)kProperty0.get();
    }

    @Override
    @NotNull
    public final String getJavaHome() {
        KProperty0 kProperty0 = (KProperty0)this.javaHome$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (String)kProperty0.get();
    }

    @Override
    public final void setJavaHome(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        KMutableProperty0 kMutableProperty0 = this.javaHome$delegate;
        Object var3_3 = null;
        boolean bl = false;
        kMutableProperty0.set((Object)string);
    }

    @Override
    @NotNull
    public final List<String> getArgs() {
        KProperty0 kProperty0 = this.args$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)kProperty0.get();
    }

    @Override
    public final void args(String ... args2) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        CollectionsKt.addAll((Collection)this.data.getArgs(), (Object[])args2);
    }

    @Override
    @NotNull
    public final List<String> getJvmArgs() {
        KProperty0 kProperty0 = this.jvmArgs$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)kProperty0.get();
    }

    @Override
    public final void jvmArgs(String ... jvmArgs2) {
        Intrinsics.checkNotNullParameter((Object)jvmArgs2, (String)"jvmArgs");
        CollectionsKt.addAll((Collection)this.data.getJvmArgs(), (Object[])jvmArgs2);
    }

    @Override
    @NotNull
    public final JvmApplicationDistributions getNativeDistributions() {
        KProperty0 kProperty0 = this.nativeDistributions$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (JvmApplicationDistributions)kProperty0.get();
    }

    @Override
    public final void nativeDistributions(@NotNull Action<JvmApplicationDistributions> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        fn.execute((Object)this.data.getNativeDistributions());
    }

    @Override
    @NotNull
    public final JvmApplicationBuildTypes getBuildTypes() {
        KProperty0 kProperty0 = this.buildTypes$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (JvmApplicationBuildTypes)kProperty0.get();
    }

    @Override
    public final void buildTypes(@NotNull Action<JvmApplicationBuildTypes> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        fn.execute((Object)this.data.getBuildTypes());
    }
}

