/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.internal.ExternalToolRunner;
import org.jetbrains.compose.desktop.application.internal.GradleUtilsKt;
import org.jetbrains.compose.desktop.application.internal.JvmRuntimeProperties;
import org.jetbrains.compose.desktop.application.internal.OsUtilsKt;
import org.jetbrains.compose.desktop.tasks.AbstractComposeDesktopTask;

@CacheableTask
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\tH\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00020\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0006R\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/compose/desktop/application/tasks/AbstractCheckNativeDistributionRuntime;", "Lorg/jetbrains/compose/desktop/tasks/AbstractComposeDesktopTask;", "()V", "javaExec", "Ljava/io/File;", "getJavaExec", "()Ljava/io/File;", "javaHome", "Lorg/gradle/api/provider/Property;", "", "getJavaHome", "()Lorg/gradle/api/provider/Property;", "javaRuntimePropertiesFile", "Lorg/gradle/api/file/RegularFileProperty;", "getJavaRuntimePropertiesFile", "()Lorg/gradle/api/file/RegularFileProperty;", "javacExec", "getJavacExec", "workingDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getWorkingDir", "()Lorg/gradle/api/provider/Provider;", "getJavaRuntimeVersionUnsafe", "getTool", "toolName", "run", "", "compose"})
public abstract class AbstractCheckNativeDistributionRuntime
extends AbstractComposeDesktopTask {
    @NotNull
    private final Property<String> javaHome;
    @NotNull
    private final RegularFileProperty javaRuntimePropertiesFile;
    @NotNull
    private final Provider<Directory> workingDir;

    public AbstractCheckNativeDistributionRuntime() {
        ObjectFactory $this$notNullProperty$iv = this.getObjects();
        boolean $i$f$notNullProperty = false;
        Property property = $this$notNullProperty$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.javaHome = property;
        RegularFileProperty regularFileProperty = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objects.fileProperty()");
        this.javaRuntimePropertiesFile = regularFileProperty;
        regularFileProperty = this.getProject().getLayout().getBuildDirectory().dir(Intrinsics.stringPlus((String)"compose/tmp/", (Object)this.getName()));
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"project.layout.buildDire\u2026.dir(\"compose/tmp/$name\")");
        this.workingDir = regularFileProperty;
    }

    @Input
    @NotNull
    public final Property<String> getJavaHome() {
        return this.javaHome;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getJavaRuntimePropertiesFile() {
        return this.javaRuntimePropertiesFile;
    }

    @LocalState
    @NotNull
    public final Provider<Directory> getWorkingDir() {
        return this.workingDir;
    }

    private final File getJavaExec() {
        return this.getTool("java");
    }

    private final File getJavacExec() {
        return this.getTool("javac");
    }

    private final File getTool(String toolName) {
        File javaHomeBin = FilesKt.resolve((File)new File((String)this.javaHome.get()), (String)"bin");
        File tool = FilesKt.resolve((File)javaHomeBin, (String)OsUtilsKt.executableName(toolName));
        boolean bl = tool.exists();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Could not find " + tool + " at: " + tool.getAbsolutePath() + '}';
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return tool;
    }

    @TaskAction
    public final void run() {
        int n;
        try {
            Integer n2;
            String string = this.getJavaRuntimeVersionUnsafe();
            n = string == null ? -1 : ((n2 = StringsKt.toIntOrNull((String)string)) == null ? -1 : n2);
        }
        catch (Exception e22) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Could not infer Java runtime version for Java home directory: ", (Object)this.javaHome.get()), e22);
        }
        int javaRuntimeVersion = n;
        n = javaRuntimeVersion >= 15 ? 1 : 0;
        boolean e22 = false;
        boolean bl = false;
        if (n == 0) {
            boolean bl2 = false;
            int n3 = javaRuntimeVersion;
            String string = StringsKt.trimMargin$default((String)("|Packaging native distributions requires JDK runtime version >= 15\n               |Actual version: '" + Integer.valueOf(n3) + "'\n               |Java home: " + this.getJavaHome().get() + "\n            "), null, (int)1, null);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        e22 = false;
        ArrayList<String> modules = new ArrayList<String>();
        ExternalToolRunner e22 = this.getRunExternalTool$compose();
        File file = this.getJavaExec();
        List list = CollectionsKt.listOf((Object)"--list-modules");
        ExternalToolRunner.LogToConsole logToConsole = ExternalToolRunner.LogToConsole.Never;
        ExternalToolRunner.invoke$default(e22, file, list, null, null, false, (Function1)new Function1<String, Unit>(modules){
            final /* synthetic */ ArrayList<String> $modules;
            {
                this.$modules = $modules;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull String stdout) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
                Sequence sequence = StringsKt.lineSequence((CharSequence)stdout);
                ArrayList<String> arrayList = this.$modules;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    String line = (String)element$iv;
                    boolean bl = false;
                    CharSequence charSequence = line;
                    boolean bl2 = false;
                    String string = charSequence;
                    if (string == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String moduleName = StringsKt.substringBefore$default((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)"@", null, (int)2, null);
                    charSequence = moduleName;
                    bl2 = false;
                    if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                    arrayList.add(moduleName);
                }
            }
        }, logToConsole, 28, null);
        JvmRuntimeProperties properties = new JvmRuntimeProperties(javaRuntimeVersion, (List<String>)modules);
        JvmRuntimeProperties.Companion.writeToFile(properties, GradleUtilsKt.getIoFile((Provider)this.javaRuntimePropertiesFile));
    }

    private final String getJavaRuntimeVersionUnsafe() {
        Provider[] providerArray = new Provider[]{this.workingDir};
        this.cleanDirs(providerArray);
        File workingDir = GradleUtilsKt.getIoFile(this.workingDir);
        String printJavaRuntimeClassName = "PrintJavaRuntimeVersion";
        String javaVersionPrefix = "Java runtime version = '";
        String javaVersionSuffix = "'";
        File file = FilesKt.resolve((File)workingDir, (String)("java/" + printJavaRuntimeClassName + ".java"));
        boolean bl = false;
        boolean bl2 = false;
        File $this$getJavaRuntimeVersionUnsafe_u24lambda_u2d2 = file;
        boolean bl3 = false;
        $this$getJavaRuntimeVersionUnsafe_u24lambda_u2d2.getParentFile().mkdirs();
        FilesKt.writeText$default((File)$this$getJavaRuntimeVersionUnsafe_u24lambda_u2d2, (String)StringsKt.trimIndent((String)("\n                import java.lang.reflect.Method;\n\n                public class " + printJavaRuntimeClassName + " {\n                    public static void main(String[] args) {\n                        Class<Runtime> runtimeClass = Runtime.class;\n                        try {\n                            Method version = runtimeClass.getMethod(\"version\");\n                            Object runtimeVer = version.invoke(runtimeClass);\n                            Class<? extends Object> runtimeVerClass = runtimeVer.getClass();\n                            try {\n                                int feature = (int) runtimeVerClass.getMethod(\"feature\").invoke(runtimeVer);\n                                printVersionAndHalt((Integer.valueOf(feature)).toString());\n                            } catch (NoSuchMethodException e) {\n                                int major = (int) runtimeVerClass.getMethod(\"major\").invoke(runtimeVer);\n                                printVersionAndHalt((Integer.valueOf(major)).toString());\n                            }\n                        } catch (Exception e) {\n                            printVersionAndHalt(System.getProperty(\"java.version\"));\n                        }\n                    }\n\n                    private static void printVersionAndHalt(String version) {\n                        System.out.println(\"" + javaVersionPrefix + "\" + version + \"" + javaVersionSuffix + "\");\n                        Runtime.getRuntime().exit(0);\n                    }\n                }\n            ")), null, (int)2, null);
        File printJavaRuntimeJava = file;
        File classFilesDir = FilesKt.resolve((File)workingDir, (String)"out-classes");
        Object[] objectArray = new String[]{"-source", "1.8", "-target", "1.8", "-d", classFilesDir.getAbsolutePath(), printJavaRuntimeJava.getAbsolutePath()};
        ExternalToolRunner.invoke$default(this.getRunExternalTool$compose(), this.getJavacExec(), CollectionsKt.listOf((Object[])objectArray), null, null, false, null, null, 124, null);
        Ref.ObjectRef javaRuntimeVersion = new Ref.ObjectRef();
        Object[] objectArray2 = new String[]{"-cp", classFilesDir.getAbsolutePath(), printJavaRuntimeClassName};
        ExternalToolRunner.invoke$default(this.getRunExternalTool$compose(), this.getJavaExec(), CollectionsKt.listOf((Object[])objectArray2), null, null, false, (Function1)new Function1<String, Unit>(javaVersionPrefix, javaVersionSuffix, (Ref.ObjectRef<String>)javaRuntimeVersion){
            final /* synthetic */ String $javaVersionPrefix;
            final /* synthetic */ String $javaVersionSuffix;
            final /* synthetic */ Ref.ObjectRef<String> $javaRuntimeVersion;
            {
                this.$javaVersionPrefix = $javaVersionPrefix;
                this.$javaVersionSuffix = $javaVersionSuffix;
                this.$javaRuntimeVersion = $javaRuntimeVersion;
                super(1);
            }

            public final void invoke(@NotNull String stdout) {
                List list;
                Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
                String string = this.$javaVersionPrefix + "(.+)" + this.$javaVersionSuffix;
                boolean bl = false;
                MatchResult m = Regex.find$default((Regex)new Regex(string), (CharSequence)stdout, (int)0, (int)2, null);
                string = m;
                this.$javaRuntimeVersion.element = string == null ? null : ((list = string.getGroupValues()) == null ? null : (String)list.get(1));
            }
        }, null, 92, null);
        return (String)javaRuntimeVersion.element;
    }
}

