/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.tasks;

import java.io.File;
import java.util.Comparator;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.internal.ExternalToolRunner;
import org.jetbrains.compose.desktop.application.internal.GradleUtilsKt;
import org.jetbrains.compose.desktop.application.internal.MacUtils;
import org.jetbrains.compose.desktop.application.internal.NotarizationRequestInfo;
import org.jetbrains.compose.desktop.application.internal.validation.ValidatedMacOSNotarizationSettings;
import org.jetbrains.compose.desktop.application.tasks.AbstractNotarizationTask;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0007R\u0013\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/compose/desktop/application/tasks/AbstractCheckNotarizationStatusTask;", "Lorg/jetbrains/compose/desktop/application/tasks/AbstractNotarizationTask;", "()V", "requestDir", "Lorg/gradle/api/file/DirectoryProperty;", "getRequestDir", "()Lorg/gradle/api/file/DirectoryProperty;", "run", "", "compose"})
public abstract class AbstractCheckNotarizationStatusTask
extends AbstractNotarizationTask {
    @NotNull
    private final DirectoryProperty requestDir;

    public AbstractCheckNotarizationStatusTask() {
        DirectoryProperty directoryProperty = this.getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objects.directoryProperty()");
        this.requestDir = directoryProperty;
    }

    @Internal
    @NotNull
    public final DirectoryProperty getRequestDir() {
        return this.requestDir;
    }

    @TaskAction
    public final void run() {
        ValidatedMacOSNotarizationSettings notarization = this.validateNotarization$compose();
        HashSet<NotarizationRequestInfo> requests = new HashSet<NotarizationRequestInfo>();
        for (File file : FilesKt.walk$default((File)GradleUtilsKt.getIoFile((Provider)this.requestDir), null, (int)1, null)) {
            if (!file.isFile() || !Intrinsics.areEqual((Object)file.getName(), (Object)"notarization-request.properties")) continue;
            try {
                NotarizationRequestInfo status = new NotarizationRequestInfo(null, null, 3, null);
                status.loadFrom(file);
                requests.add(status);
            }
            catch (Exception e) {
                this.getLogger().error(Intrinsics.stringPlus((String)"Invalid notarization request status file: ", (Object)file), (Throwable)e);
            }
        }
        if (requests.isEmpty()) {
            this.getLogger().quiet("No existing notarization requests");
            return;
        }
        Iterable $this$sortedBy$iv = requests;
        boolean $i$f$sortedBy2 = false;
        boolean bl = false;
        for (NotarizationRequestInfo request : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                NotarizationRequestInfo it = (NotarizationRequestInfo)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getUploadTime());
                it = (NotarizationRequestInfo)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getUploadTime();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        })) {
            try {
                this.getLogger().quiet("Checking status of notarization request '" + request.getUuid() + '\'');
                Object[] $i$f$sortedBy2 = new String[]{"altool", "--notarization-info", request.getUuid(), "--username", notarization.getAppleID(), "--password", notarization.getPassword()};
                ExternalToolRunner.invoke$default(this.getRunExternalTool$compose(), MacUtils.INSTANCE.getXcrun(), CollectionsKt.listOf((Object[])$i$f$sortedBy2), null, null, false, null, ExternalToolRunner.LogToConsole.Always, 60, null);
            }
            catch (Exception e) {
                this.getLogger().error("Could not check notarization request '" + request.getUuid() + '\'', (Throwable)e);
            }
        }
    }
}

