/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.internal.file.FileOperations;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.internal.OS;
import org.jetbrains.compose.desktop.application.internal.OsUtilsKt;
import org.jetbrains.compose.desktop.application.internal.files.FileUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"isSkikoForCurrentOS", "", "lib", "Ljava/io/File;", "unpackSkikoForCurrentOS", "", "sourceJar", "skikoDir", "fileOperations", "Lorg/gradle/api/internal/file/FileOperations;", "compose"})
public final class AbstractJPackageTaskKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSkikoForCurrentOS(File lib) {
        String string = lib.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lib.name");
        if (!StringsKt.startsWith$default((String)string, (String)("skiko-awt-runtime-" + OsUtilsKt.getCurrentOS().getId() + '-' + OsUtilsKt.getCurrentArch().getId()), (boolean)false, (int)2, null)) return false;
        string = lib.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lib.name");
        if (!StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final List<File> unpackSkikoForCurrentOS(File sourceJar, File skikoDir, FileOperations fileOperations) {
        Object[] objectArray;
        Set set;
        OS oS = OsUtilsKt.getCurrentOS();
        int n = WhenMappings.$EnumSwitchMapping$0[oS.ordinal()];
        switch (n) {
            case 1: {
                set = SetsKt.setOf((Object)("libskiko-macos-" + OsUtilsKt.getCurrentArch().getId() + ".dylib"));
                break;
            }
            case 2: {
                objectArray = new String[]{"skiko-windows-" + OsUtilsKt.getCurrentArch().getId() + ".dll", "icudtl.dat"};
                set = SetsKt.setOf((Object[])objectArray);
                break;
            }
            case 3: {
                set = SetsKt.setOf((Object)("libskiko-linux-" + OsUtilsKt.getCurrentArch().getId() + ".so"));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Set entriesToUnpack = set;
        ArrayList<File> outputFiles = new ArrayList<File>(entriesToUnpack.size() * 2 + 1);
        objectArray = sourceJar.getName();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"sourceJar.name");
        File targetJar = FilesKt.resolve((File)skikoDir, (String)objectArray);
        outputFiles.add(targetJar);
        objectArray = new Object[]{skikoDir};
        fileOperations.delete(objectArray);
        fileOperations.mkdir((Object)skikoDir);
        boolean $i$f$transformJar = false;
        Closeable closeable = new FileInputStream(sourceJar);
        int n2 = 8192;
        boolean bl = false;
        closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n2));
        n2 = 0;
        bl = false;
        Throwable throwable = null;
        try {
            ZipInputStream zin$iv = (ZipInputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new FileOutputStream(targetJar);
            int n3 = 8192;
            boolean bl3 = false;
            closeable2 = new ZipOutputStream(closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n3));
            n3 = 0;
            bl3 = false;
            Throwable throwable2 = null;
            try {
                ZipOutputStream zout$iv = (ZipOutputStream)closeable2;
                boolean bl4 = false;
                for (ZipEntry sourceEntry$iv : SequencesKt.generateSequence((Function0)((Function0)new Function0<ZipEntry>(zin$iv){
                    final /* synthetic */ ZipInputStream $zin;
                    {
                        this.$zin = $zin;
                        super(0);
                    }

                    @Nullable
                    public final ZipEntry invoke() {
                        return this.$zin.getNextEntry();
                    }
                }))) {
                    void zout;
                    void zin;
                    ZipOutputStream zipOutputStream = zout$iv;
                    ZipInputStream zipInputStream = zin$iv;
                    ZipEntry entry = sourceEntry$iv;
                    boolean bl5 = false;
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
                    if (entriesToUnpack.contains(StringsKt.removeSuffix((String)string, (CharSequence)".sha256"))) {
                        String string2 = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"entry.name");
                        File unpackedFile = FilesKt.resolve((File)skikoDir, (String)StringsKt.substringAfterLast$default((String)string2, (String)"/", null, (int)2, null));
                        FileUtilsKt.copyTo((InputStream)zin, unpackedFile);
                        outputFiles.add(unpackedFile);
                        continue;
                    }
                    FileUtilsKt.copyZipEntry(entry, (InputStream)zin, (ZipOutputStream)zout);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return outputFiles;
    }

    public static final /* synthetic */ boolean access$isSkikoForCurrentOS(File lib) {
        return AbstractJPackageTaskKt.isSkikoForCurrentOS(lib);
    }

    public static final /* synthetic */ List access$unpackSkikoForCurrentOS(File sourceJar, File skikoDir, FileOperations fileOperations) {
        return AbstractJPackageTaskKt.unpackSkikoForCurrentOS(sourceJar, skikoDir, fileOperations);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            nArray[OS.MacOS.ordinal()] = 1;
            nArray[OS.Windows.ordinal()] = 2;
            nArray[OS.Linux.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

