/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.tasks;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.internal.GradleUtilsKt;
import org.jetbrains.compose.desktop.application.internal.InfoPlistBuilder;
import org.jetbrains.compose.desktop.application.internal.PlistKeys;
import org.jetbrains.compose.desktop.application.tasks.AbstractNativeMacApplicationPackageTask;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0014J\u0014\u0010\u0017\u001a\u00020\u0013*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u001b\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001b\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0013\u0010\f\u001a\u00020\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u00020\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/compose/desktop/application/tasks/AbstractNativeMacApplicationPackageAppDirTask;", "Lorg/jetbrains/compose/desktop/application/tasks/AbstractNativeMacApplicationPackageTask;", "()V", "appCategory", "Lorg/gradle/api/provider/Property;", "", "getAppCategory", "()Lorg/gradle/api/provider/Property;", "bundleID", "getBundleID", "copyright", "getCopyright", "executable", "Lorg/gradle/api/file/RegularFileProperty;", "getExecutable", "()Lorg/gradle/api/file/RegularFileProperty;", "iconFile", "getIconFile", "createPackage", "", "destinationDir", "Ljava/io/File;", "workingDir", "setupInfoPlist", "Lorg/jetbrains/compose/desktop/application/internal/InfoPlistBuilder;", "executableName", "compose"})
public abstract class AbstractNativeMacApplicationPackageAppDirTask
extends AbstractNativeMacApplicationPackageTask {
    @NotNull
    private final RegularFileProperty executable;
    @NotNull
    private final RegularFileProperty iconFile;
    @NotNull
    private final Property<String> bundleID;
    @NotNull
    private final Property<String> appCategory;
    @NotNull
    private final Property<String> copyright;

    public AbstractNativeMacApplicationPackageAppDirTask() {
        RegularFileProperty regularFileProperty = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objects.fileProperty()");
        this.executable = regularFileProperty;
        regularFileProperty = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objects.fileProperty()");
        this.iconFile = regularFileProperty;
        ObjectFactory $this$notNullProperty$iv = this.getObjects();
        boolean $i$f$notNullProperty = false;
        Property property = $this$notNullProperty$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        regularFileProperty = property.value((Provider)this.getPackageName());
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objects.notNullProperty<\u2026ing>().value(packageName)");
        this.bundleID = regularFileProperty;
        ObjectFactory $this$nullableProperty$iv = this.getObjects();
        boolean $i$f$nullableProperty = false;
        Property property2 = $this$nullableProperty$iv.property(String.class);
        if (property2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.provider.Property<T of org.jetbrains.compose.desktop.application.internal.GradleUtilsKt.nullableProperty?>");
        }
        this.appCategory = property2;
        $this$nullableProperty$iv = this.getObjects();
        $i$f$nullableProperty = false;
        property2 = $this$nullableProperty$iv.property(String.class);
        if (property2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.provider.Property<T of org.jetbrains.compose.desktop.application.internal.GradleUtilsKt.nullableProperty?>");
        }
        this.copyright = property2;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public final RegularFileProperty getExecutable() {
        return this.executable;
    }

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public final RegularFileProperty getIconFile() {
        return this.iconFile;
    }

    @Input
    @NotNull
    public final Property<String> getBundleID() {
        return this.bundleID;
    }

    @Input
    @Optional
    @NotNull
    public final Property<String> getAppCategory() {
        return this.appCategory;
    }

    @Input
    @Optional
    @NotNull
    public final Property<String> getCopyright() {
        return this.copyright;
    }

    @Override
    protected void createPackage(@NotNull File destinationDir, @NotNull File workingDir) {
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        String packageName = (String)this.getPackageName().get();
        File file = FilesKt.resolve((File)destinationDir, (String)Intrinsics.stringPlus((String)packageName, (Object)".app"));
        boolean bl = false;
        boolean bl2 = false;
        File $this$createPackage_u24lambda_u2d722 = file;
        boolean bl3 = false;
        $this$createPackage_u24lambda_u2d722.mkdirs();
        File appDir2 = file;
        File file2 = FilesKt.resolve((File)appDir2, (String)"Contents");
        bl2 = false;
        boolean $this$createPackage_u24lambda_u2d722 = false;
        File $this$createPackage_u24lambda_u2d62 = file2;
        boolean bl4 = false;
        $this$createPackage_u24lambda_u2d62.mkdirs();
        File contentsDir = file2;
        File file3 = FilesKt.resolve((File)contentsDir, (String)"MacOS");
        $this$createPackage_u24lambda_u2d722 = false;
        boolean $this$createPackage_u24lambda_u2d62 = false;
        File $this$createPackage_u24lambda_u2d2 = file3;
        boolean bl5 = false;
        $this$createPackage_u24lambda_u2d2.mkdirs();
        File macOSDir = file3;
        File $this$createPackage_u24lambda_u2d722 = FilesKt.resolve((File)contentsDir, (String)"Resources");
        $this$createPackage_u24lambda_u2d62 = false;
        boolean bl6 = false;
        File $this$createPackage_u24lambda_u2d3 = $this$createPackage_u24lambda_u2d722;
        boolean bl7 = false;
        $this$createPackage_u24lambda_u2d3.mkdirs();
        File appResourcesDir = $this$createPackage_u24lambda_u2d722;
        Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
        File appExecutableFile = FilesKt.resolve((File)macOSDir, (String)packageName);
        FilesKt.copyTo$default((File)GradleUtilsKt.getIoFile((Provider)this.executable), (File)appExecutableFile, (boolean)false, (int)0, (int)6, null);
        appExecutableFile.setExecutable(true);
        File appIconFile = FilesKt.resolve((File)appResourcesDir, (String)Intrinsics.stringPlus((String)packageName, (Object)".icns"));
        FilesKt.copyTo$default((File)GradleUtilsKt.getIoFile((Provider)this.iconFile), (File)appIconFile, (boolean)false, (int)0, (int)6, null);
        InfoPlistBuilder infoPlistBuilder = new InfoPlistBuilder(null, 1, null);
        boolean bl8 = false;
        boolean bl9 = false;
        InfoPlistBuilder $this$createPackage_u24lambda_u2d4 = infoPlistBuilder;
        boolean bl10 = false;
        String string = appExecutableFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"appExecutableFile.name");
        this.setupInfoPlist($this$createPackage_u24lambda_u2d4, string);
        $this$createPackage_u24lambda_u2d4.writeToFile(FilesKt.resolve((File)contentsDir, (String)"Info.plist"));
    }

    private final void setupInfoPlist(InfoPlistBuilder $this$setupInfoPlist, String executableName) {
        $this$setupInfoPlist.set(PlistKeys.INSTANCE.getLSMinimumSystemVersion(), "10.13");
        $this$setupInfoPlist.set(PlistKeys.INSTANCE.getCFBundleDevelopmentRegion(), "English");
        $this$setupInfoPlist.set(PlistKeys.INSTANCE.getCFBundleAllowMixedLocalizations(), "true");
        $this$setupInfoPlist.set(PlistKeys.INSTANCE.getCFBundleExecutable(), executableName);
        $this$setupInfoPlist.set(PlistKeys.INSTANCE.getCFBundleIconFile(), GradleUtilsKt.getIoFile((Provider)this.iconFile).getName());
        $this$setupInfoPlist.set(PlistKeys.INSTANCE.getCFBundleIdentifier(), (String)this.bundleID.get());
        String packageVersion = (String)this.getPackageVersion().get();
        $this$setupInfoPlist.set(PlistKeys.INSTANCE.getCFBundleShortVersionString(), packageVersion);
        $this$setupInfoPlist.set(PlistKeys.INSTANCE.getCFBundleVersion(), packageVersion);
        $this$setupInfoPlist.set(PlistKeys.INSTANCE.getLSApplicationCategoryType(), (String)this.appCategory.getOrNull());
        $this$setupInfoPlist.set(PlistKeys.INSTANCE.getNSHumanReadableCopyright(), (String)this.copyright.getOrNull());
        $this$setupInfoPlist.set(PlistKeys.INSTANCE.getNSSupportsAutomaticGraphicsSwitching(), "true");
        $this$setupInfoPlist.set(PlistKeys.INSTANCE.getNSHighResolutionCapable(), "true");
    }
}

