/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.ui.tooling.preview.rpc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.CommandsKt;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.ConfigFromGradle;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.FrameConfig;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.FrameRequest;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewHostConfig;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewListener;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewLogger;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewManager;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewManagerImpl;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PrintStreamLogger;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RemoteConnection;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RemoteConnectionImpl;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RemotePreviewHostKt;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RenderedFrame;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RunningPreview;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.UtilsKt;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.utils.RingBuffer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010(\u001a\u00020)H\u0016J\u001f\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00020)0-H\u0082\bJ\u0010\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020\u0017H\u0002J\u0010\u0010.\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0002J+\u00102\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u00172\b\b\u0002\u00103\u001a\u0002042\u000e\b\u0004\u00105\u001a\b\u0012\u0004\u0012\u00020)0-H\u0082\bJ\u001a\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020\u0017H\u0002J\u0010\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020\u001aH\u0016J\"\u0010<\u001a\u00020)2\u0017\u00105\u001a\u0013\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020)0=\u00a2\u0006\u0002\b>H\u0082\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u000e0%j\b\u0012\u0004\u0012\u00020\u000e`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewManagerImpl;", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewManager;", "previewListener", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewListener;", "(Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewListener;)V", "connectionNumber", "Ljava/util/concurrent/atomic/AtomicLong;", "gradleCallbackPort", "", "getGradleCallbackPort", "()I", "gradleCallbackSocket", "Ljava/net/ServerSocket;", "gradleCallbackThread", "Ljava/lang/Thread;", "inProcessRequest", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/FrameRequest;", "isAlive", "Ljava/util/concurrent/atomic/AtomicBoolean;", "log", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PrintStreamLogger;", "previewClasspath", "", "previewFqName", "previewFrameConfig", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/FrameConfig;", "previewHostConfig", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewHostConfig;", "previewSocket", "processedRequest", "receivePreviewResponseThread", "runPreviewThread", "runningPreview", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/RunningPreview;", "sendPreviewRequestThread", "threads", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "userRequestCount", "close", "", "closeService", "name", "doClose", "Lkotlin/Function0;", "onError", "error", "e", "", "repeatWhileAliveThread", "sleepDelayMs", "", "fn", "tryAcceptConnection", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/RemoteConnection;", "serverSocket", "socketType", "updateFrameConfig", "frameConfig", "withLivePreviewConnection", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "preview-rpc"})
public final class PreviewManagerImpl
implements PreviewManager {
    @NotNull
    private final PreviewListener previewListener;
    @NotNull
    private final PrintStreamLogger log;
    @NotNull
    private final ServerSocket previewSocket;
    @NotNull
    private final ServerSocket gradleCallbackSocket;
    @NotNull
    private final AtomicLong connectionNumber;
    @NotNull
    private final AtomicBoolean isAlive;
    @NotNull
    private final AtomicReference<PreviewHostConfig> previewHostConfig;
    @NotNull
    private final AtomicReference<String> previewClasspath;
    @NotNull
    private final AtomicReference<String> previewFqName;
    @NotNull
    private final AtomicReference<FrameConfig> previewFrameConfig;
    @NotNull
    private final AtomicReference<FrameRequest> inProcessRequest;
    @NotNull
    private final AtomicReference<FrameRequest> processedRequest;
    @NotNull
    private final AtomicLong userRequestCount;
    @NotNull
    private final AtomicReference<RunningPreview> runningPreview;
    @NotNull
    private final ArrayList<Thread> threads;
    @NotNull
    private final Thread runPreviewThread;
    @NotNull
    private final Thread sendPreviewRequestThread;
    @NotNull
    private final Thread receivePreviewResponseThread;
    @NotNull
    private final Thread gradleCallbackThread;

    public PreviewManagerImpl(@NotNull PreviewListener previewListener) {
        Intrinsics.checkNotNullParameter((Object)previewListener, (String)"previewListener");
        this.previewListener = previewListener;
        this.log = new PrintStreamLogger("SERVER", null, 2, null);
        this.previewSocket = UtilsKt.newServerSocket();
        this.gradleCallbackSocket = UtilsKt.newServerSocket();
        this.connectionNumber = new AtomicLong(0L);
        this.isAlive = new AtomicBoolean(true);
        this.previewHostConfig = new AtomicReference<Object>(null);
        this.previewClasspath = new AtomicReference<Object>(null);
        this.previewFqName = new AtomicReference<Object>(null);
        this.previewFrameConfig = new AtomicReference<Object>(null);
        this.inProcessRequest = new AtomicReference<Object>(null);
        this.processedRequest = new AtomicReference<Object>(null);
        this.userRequestCount = new AtomicLong(0L);
        this.runningPreview = new AtomicReference<Object>(null);
        boolean bl = false;
        this.threads = new ArrayList();
        String name$iv = "runPreview";
        long sleepDelayMs$iv = 1000L;
        boolean $i$f$repeatWhileAliveThread = false;
        Thread thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)name$iv, (int)0, (Function0)((Function0)new Function0<Unit>(this, sleepDelayMs$iv, this){
            final /* synthetic */ PreviewManagerImpl this$0$inline_fun;
            final /* synthetic */ long $sleepDelayMs;
            final /* synthetic */ PreviewManagerImpl this$0;
            {
                this.this$0$inline_fun = $receiver;
                this.$sleepDelayMs = $sleepDelayMs;
                this.this$0 = previewManagerImpl;
                super(0);
            }

            public final void invoke() {
                while (PreviewManagerImpl.access$isAlive$p(this.this$0$inline_fun).get()) {
                    try {
                        RunningPreview runningPreview;
                        boolean bl = false;
                        RunningPreview runningPreview2 = (RunningPreview)PreviewManagerImpl.access$getRunningPreview$p(this.this$0).get();
                        PreviewHostConfig previewConfig = (PreviewHostConfig)PreviewManagerImpl.access$getPreviewHostConfig$p(this.this$0).get();
                        if (previewConfig != null && !((runningPreview = runningPreview2) == null ? false : runningPreview.isAlive())) {
                            Process process = PreviewManagerImpl.access$runPreviewThread$lambda-2$startPreviewProcess(this.this$0, previewConfig);
                            RemoteConnection connection2 = PreviewManagerImpl.access$tryAcceptConnection(this.this$0, PreviewManagerImpl.access$getPreviewSocket$p(this.this$0), "PREVIEW");
                            RemoteConnection remoteConnection = connection2;
                            if (remoteConnection != null) {
                                CommandsKt.receiveAttach(remoteConnection, PreviewManagerImpl.access$getPreviewListener$p(this.this$0), (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, connection2, process){
                                    final /* synthetic */ PreviewManagerImpl this$0;
                                    final /* synthetic */ RemoteConnection $connection;
                                    final /* synthetic */ Process $process;
                                    {
                                        this.this$0 = $receiver;
                                        this.$connection = $connection;
                                        this.$process = $process;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        PreviewManagerImpl.access$getRunningPreview$p(this.this$0).set(new RunningPreview(this.$connection, this.$process));
                                    }
                                }));
                            }
                            RingBuffer<String> processLogLines = new RingBuffer<String>(512);
                            StringBuilder exception = new StringBuilder();
                            Ref.BooleanRef exceptionMarker = new Ref.BooleanRef();
                            Object object = process.getInputStream();
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"process.inputStream");
                            Charset charset = Charsets.UTF_8;
                            boolean bl2 = false;
                            Object object2 = object;
                            int n = 0;
                            object2 = new InputStreamReader((InputStream)object2, charset);
                            n = 8192;
                            boolean bl3 = false;
                            TextStreamsKt.forEachLine((Reader)(object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n)), (Function1)((Function1)new Function1<String, Unit>(exceptionMarker, exception, processLogLines){
                                final /* synthetic */ Ref.BooleanRef $exceptionMarker;
                                final /* synthetic */ StringBuilder $exception;
                                final /* synthetic */ RingBuffer<String> $processLogLines;
                                {
                                    this.$exceptionMarker = $exceptionMarker;
                                    this.$exception = $exception;
                                    this.$processLogLines = $processLogLines;
                                    super(1);
                                }

                                public final void invoke(@NotNull String line) {
                                    Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                                    if (this.$exceptionMarker.element) {
                                        StringBuilder stringBuilder = this.$exception;
                                        boolean bl = false;
                                        StringBuilder stringBuilder2 = stringBuilder.append(line);
                                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                                        StringBuilder stringBuilder3 = stringBuilder2;
                                        boolean bl2 = false;
                                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
                                    } else if (StringsKt.startsWith$default((String)line, (String)"<!--START OF COMPOSE PREVIEW PROCESS FATAL EXCEPTION--!>", (boolean)false, (int)2, null)) {
                                        this.$exceptionMarker.element = true;
                                    } else {
                                        this.$processLogLines.add(line);
                                    }
                                }
                            }));
                            while (process.isAlive()) {
                                process.waitFor(5L, TimeUnit.SECONDS);
                                if (!process.isAlive()) continue;
                                process.destroyForcibly();
                                process.waitFor(5L, TimeUnit.SECONDS);
                            }
                            if (process.isAlive()) {
                                object = "Preview process does not finish!";
                                boolean bl4 = false;
                                throw (Throwable)new IllegalStateException(object.toString());
                            }
                            int exitCode = process.exitValue();
                            if (exitCode != 0) {
                                String errorMessage;
                                StringBuilder stringBuilder;
                                bl2 = false;
                                boolean bl5 = false;
                                object2 = new StringBuilder();
                                n = 0;
                                bl3 = false;
                                Object $this$runPreviewThread_u24lambda_u2d2_u24lambda_u2d1 = object2;
                                boolean bl6 = false;
                                Object object3 = $this$runPreviewThread_u24lambda_u2d2_u24lambda_u2d1;
                                String string = Intrinsics.stringPlus((String)"Preview process exited unexpectedly: exitCode=", (Object)exitCode);
                                boolean bl7 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object3).append(string), (String)"append(value)");
                                boolean bl8 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
                                if (exceptionMarker.element) {
                                    StringBuilder stringBuilder2;
                                    object3 = $this$runPreviewThread_u24lambda_u2d2_u24lambda_u2d1;
                                    boolean bl9 = false;
                                    Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object3).append((CharSequence)exception), (String)"append(value)");
                                    boolean bl10 = false;
                                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)object2).toString(), (String)"StringBuilder().apply(builderAction).toString()");
                                PreviewManagerImpl.access$onError(this.this$0, errorMessage);
                            }
                        }
                        Thread.sleep(this.$sleepDelayMs);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }), (int)22, null);
        boolean bl2 = false;
        boolean bl3 = false;
        Thread it$iv = thread;
        boolean bl4 = false;
        it$iv.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){
            final /* synthetic */ PreviewManagerImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void uncaughtException(Thread thread, Throwable e) {
                Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
                PreviewManagerImpl.access$onError(this.this$0, e);
            }
        });
        this.threads.add(it$iv);
        it$iv.start();
        this.runPreviewThread = thread;
        name$iv = "sendPreviewRequest";
        sleepDelayMs$iv = 1000L;
        $i$f$repeatWhileAliveThread = false;
        thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)name$iv, (int)0, (Function0)((Function0)new Function0<Unit>(this, sleepDelayMs$iv, this){
            final /* synthetic */ PreviewManagerImpl this$0$inline_fun;
            final /* synthetic */ long $sleepDelayMs;
            final /* synthetic */ PreviewManagerImpl this$0;
            {
                this.this$0$inline_fun = $receiver;
                this.$sleepDelayMs = $sleepDelayMs;
                this.this$0 = previewManagerImpl;
                super(0);
            }

            public final void invoke() {
                while (PreviewManagerImpl.access$isAlive$p(this.this$0$inline_fun).get()) {
                    try {
                        RunningPreview runningPreview$iv;
                        boolean bl = false;
                        PreviewManagerImpl this_$iv = this.this$0;
                        boolean $i$f$withLivePreviewConnection = false;
                        RunningPreview runningPreview = (RunningPreview)PreviewManagerImpl.access$getRunningPreview$p(this_$iv).get();
                        if (runningPreview != null && (runningPreview$iv = runningPreview).isAlive()) {
                            RemoteConnection $this$sendPreviewRequestThread_u24lambda_u2d4_u24lambda_u2d3 = runningPreview$iv.getConnection();
                            boolean bl2 = false;
                            String classpath = (String)PreviewManagerImpl.access$getPreviewClasspath$p(this.this$0).get();
                            String fqName = (String)PreviewManagerImpl.access$getPreviewFqName$p(this.this$0).get();
                            FrameConfig frameConfig = (FrameConfig)PreviewManagerImpl.access$getPreviewFrameConfig$p(this.this$0).get();
                            if (classpath != null && frameConfig != null && fqName != null) {
                                FrameRequest request = new FrameRequest(PreviewManagerImpl.access$getUserRequestCount$p(this.this$0).get(), fqName, frameConfig);
                                FrameRequest prevRequest = (FrameRequest)PreviewManagerImpl.access$getProcessedRequest$p(this.this$0).get();
                                if (PreviewManagerImpl.access$getInProcessRequest$p(this.this$0).get() == null && !Intrinsics.areEqual((Object)request, (Object)prevRequest) && PreviewManagerImpl.access$getInProcessRequest$p(this.this$0).compareAndSet(null, request)) {
                                    PreviewManagerImpl.access$getPreviewListener$p(this.this$0).onNewRenderRequest(request);
                                    CommandsKt.sendPreviewRequest($this$sendPreviewRequestThread_u24lambda_u2d4_u24lambda_u2d3, classpath, request);
                                }
                            }
                        }
                        Thread.sleep(this.$sleepDelayMs);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }), (int)22, null);
        bl2 = false;
        bl3 = false;
        it$iv = thread;
        bl4 = false;
        it$iv.setUncaughtExceptionHandler(new /* invalid duplicate definition of identical inner class */);
        this.threads.add(it$iv);
        it$iv.start();
        this.sendPreviewRequestThread = thread;
        name$iv = "receivePreviewResponse";
        sleepDelayMs$iv = 1000L;
        $i$f$repeatWhileAliveThread = false;
        thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)name$iv, (int)0, (Function0)((Function0)new Function0<Unit>(this, sleepDelayMs$iv, this){
            final /* synthetic */ PreviewManagerImpl this$0$inline_fun;
            final /* synthetic */ long $sleepDelayMs;
            final /* synthetic */ PreviewManagerImpl this$0;
            {
                this.this$0$inline_fun = $receiver;
                this.$sleepDelayMs = $sleepDelayMs;
                this.this$0 = previewManagerImpl;
                super(0);
            }

            public final void invoke() {
                while (PreviewManagerImpl.access$isAlive$p(this.this$0$inline_fun).get()) {
                    try {
                        RunningPreview runningPreview$iv;
                        boolean bl = false;
                        PreviewManagerImpl this_$iv = this.this$0;
                        boolean $i$f$withLivePreviewConnection = false;
                        RunningPreview runningPreview = (RunningPreview)PreviewManagerImpl.access$getRunningPreview$p(this_$iv).get();
                        if (runningPreview != null && (runningPreview$iv = runningPreview).isAlive()) {
                            RemoteConnection $this$receivePreviewResponseThread_u24lambda_u2d6_u24lambda_u2d5 = runningPreview$iv.getConnection();
                            boolean bl2 = false;
                            CommandsKt.receiveFrame($this$receivePreviewResponseThread_u24lambda_u2d6_u24lambda_u2d5, (Function1<? super RenderedFrame, Unit>)((Function1)new Function1<RenderedFrame, Unit>(this.this$0){
                                final /* synthetic */ PreviewManagerImpl this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull RenderedFrame renderedFrame) {
                                    Intrinsics.checkNotNullParameter((Object)renderedFrame, (String)"renderedFrame");
                                    FrameRequest frameRequest = (FrameRequest)PreviewManagerImpl.access$getInProcessRequest$p(this.this$0).get();
                                    if (frameRequest != null) {
                                        FrameRequest frameRequest2 = frameRequest;
                                        PreviewManagerImpl previewManagerImpl = this.this$0;
                                        boolean bl = false;
                                        boolean bl2 = false;
                                        FrameRequest request = frameRequest2;
                                        boolean bl3 = false;
                                        PreviewManagerImpl.access$getProcessedRequest$p(previewManagerImpl).set(request);
                                        PreviewManagerImpl.access$getInProcessRequest$p(previewManagerImpl).compareAndSet(request, null);
                                    }
                                    PreviewManagerImpl.access$getPreviewListener$p(this.this$0).onRenderedFrame(renderedFrame);
                                }
                            }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.this$0){
                                final /* synthetic */ PreviewManagerImpl this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull String error) {
                                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                                    PreviewManagerImpl.access$getPreviewHostConfig$p(this.this$0).set(null);
                                    PreviewManagerImpl.access$getPreviewClasspath$p(this.this$0).set(null);
                                    PreviewManagerImpl.access$getInProcessRequest$p(this.this$0).set(null);
                                    PreviewManagerImpl.access$onError(this.this$0, error);
                                }
                            }));
                        }
                        Thread.sleep(this.$sleepDelayMs);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }), (int)22, null);
        bl2 = false;
        bl3 = false;
        it$iv = thread;
        bl4 = false;
        it$iv.setUncaughtExceptionHandler(new /* invalid duplicate definition of identical inner class */);
        this.threads.add(it$iv);
        it$iv.start();
        this.receivePreviewResponseThread = thread;
        name$iv = "gradleCallback";
        sleepDelayMs$iv = 1000L;
        $i$f$repeatWhileAliveThread = false;
        thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)name$iv, (int)0, (Function0)((Function0)new Function0<Unit>(this, sleepDelayMs$iv, this){
            final /* synthetic */ PreviewManagerImpl this$0$inline_fun;
            final /* synthetic */ long $sleepDelayMs;
            final /* synthetic */ PreviewManagerImpl this$0;
            {
                this.this$0$inline_fun = $receiver;
                this.$sleepDelayMs = $sleepDelayMs;
                this.this$0 = previewManagerImpl;
                super(0);
            }

            public final void invoke() {
                while (PreviewManagerImpl.access$isAlive$p(this.this$0$inline_fun).get()) {
                    try {
                        boolean bl = false;
                        RemoteConnection remoteConnection = PreviewManagerImpl.access$tryAcceptConnection(this.this$0, PreviewManagerImpl.access$getGradleCallbackSocket$p(this.this$0), "GRADLE_CALLBACK");
                        if (remoteConnection != null) {
                            RemoteConnection remoteConnection2 = remoteConnection;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            RemoteConnection connection2 = remoteConnection2;
                            boolean bl4 = false;
                            while (PreviewManagerImpl.access$isAlive$p(this.this$0).get() && connection2.isAlive()) {
                                ConfigFromGradle config = CommandsKt.receiveConfigFromGradle(connection2);
                                if (config == null) continue;
                                PreviewManagerImpl.access$getPreviewClasspath$p(this.this$0).set(config.getPreviewClasspath());
                                PreviewManagerImpl.access$getPreviewFqName$p(this.this$0).set(config.getPreviewFqName());
                                PreviewManagerImpl.access$getPreviewHostConfig$p(this.this$0).set(config.getPreviewHostConfig());
                                PreviewManagerImpl.access$getUserRequestCount$p(this.this$0).incrementAndGet();
                                PreviewManagerImpl.access$getSendPreviewRequestThread$p(this.this$0).interrupt();
                            }
                        }
                        Thread.sleep(this.$sleepDelayMs);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }), (int)22, null);
        bl2 = false;
        bl3 = false;
        it$iv = thread;
        bl4 = false;
        it$iv.setUncaughtExceptionHandler(new /* invalid duplicate definition of identical inner class */);
        this.threads.add(it$iv);
        it$iv.start();
        this.gradleCallbackThread = thread;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        block41: {
            void this_$iv;
            if (!this.isAlive.compareAndSet(true, false)) {
                return;
            }
            PreviewManagerImpl previewManagerImpl = this;
            String name$iv = "PREVIEW MANAGER";
            boolean $i$f$closeService = false;
            try {
                long start$iv$iv;
                String string;
                PreviewLogger previewLogger;
                block40: {
                    boolean bl;
                    Object object;
                    boolean bl2;
                    boolean bl3;
                    Object object2;
                    long start$iv$iv2;
                    String string2;
                    PreviewLogger this_$iv$iv;
                    PreviewManagerImpl this_$iv2;
                    boolean $i$f$closeService2;
                    String name$iv2;
                    Process previewProcess;
                    block39: {
                        block38: {
                            boolean $i$f$invoke;
                            boolean bl4;
                            long ms$iv;
                            block37: {
                                block36: {
                                    RunningPreview runningPreview;
                                    PreviewLogger this_$iv$iv2 = ((PreviewManagerImpl)this_$iv).log;
                                    boolean $i$f$invoke2 = false;
                                    if (this_$iv$iv2.isEnabled()) {
                                        previewLogger = this_$iv$iv2;
                                        boolean bl5 = false;
                                        string = Intrinsics.stringPlus((String)"CLOSING ", (Object)name$iv);
                                        previewLogger.log(string);
                                    }
                                    boolean $i$f$measureTimeMillis = false;
                                    boolean bl6 = false;
                                    start$iv$iv = System.currentTimeMillis();
                                    boolean bl7 = false;
                                    boolean bl8 = false;
                                    RunningPreview runningPreview2 = runningPreview = (RunningPreview)this.runningPreview.getAndSet(null);
                                    RemoteConnection previewConnection = runningPreview2 == null ? null : runningPreview2.getConnection();
                                    RunningPreview runningPreview3 = runningPreview;
                                    previewProcess = runningPreview3 == null ? null : runningPreview3.getProcess();
                                    Object $this$forEach$iv = this.threads;
                                    boolean $i$f$forEach = false;
                                    Iterator iterator2 = $this$forEach$iv.iterator();
                                    while (iterator2.hasNext()) {
                                        Object element$iv = iterator2.next();
                                        Thread it = (Thread)element$iv;
                                        boolean bl9 = false;
                                        it.interrupt();
                                    }
                                    $this$forEach$iv = this;
                                    name$iv2 = "PREVIEW HOST CONNECTION";
                                    $i$f$closeService2 = false;
                                    try {
                                        Unit unit;
                                        this_$iv$iv = this_$iv2.log;
                                        boolean $i$f$invoke3 = false;
                                        if (this_$iv$iv.isEnabled()) {
                                            PreviewLogger previewLogger2 = this_$iv$iv;
                                            boolean bl10 = false;
                                            string2 = Intrinsics.stringPlus((String)"CLOSING ", (Object)name$iv2);
                                            previewLogger2.log(string2);
                                        }
                                        boolean $i$f$measureTimeMillis2 = false;
                                        boolean bl11 = false;
                                        start$iv$iv2 = System.currentTimeMillis();
                                        bl2 = false;
                                        boolean bl12 = false;
                                        object2 = previewConnection;
                                        if (object2 == null) {
                                            unit = null;
                                        } else {
                                            object2.close();
                                            unit = Unit.INSTANCE;
                                        }
                                        long ms$iv2 = System.currentTimeMillis() - start$iv$iv2;
                                        PreviewLogger this_$iv$iv3 = this_$iv2.log;
                                        boolean $i$f$invoke4 = false;
                                        if (this_$iv$iv3.isEnabled()) {
                                            PreviewLogger previewLogger3 = this_$iv$iv3;
                                            boolean bl13 = false;
                                            string2 = "CLOSED " + name$iv2 + " in " + ms$iv2 + " ms";
                                            previewLogger3.log(string2);
                                        }
                                    }
                                    catch (Exception e$iv) {
                                        PreviewLogger this_$iv$iv4 = this_$iv2.log;
                                        boolean $i$f$error = false;
                                        PreviewLogger this_$iv$iv$iv = this_$iv$iv4;
                                        boolean $i$f$invoke5 = false;
                                        if (!this_$iv$iv$iv.isEnabled()) break block36;
                                        PreviewLogger previewLogger4 = this_$iv$iv$iv;
                                        bl3 = false;
                                        String string3 = "error: ";
                                        boolean $i$a$-error-PreviewManagerImpl$closeService$3$iv2 = false;
                                        string2 = "ERROR CLOSING " + name$iv2 + ": " + UtilsKt.getStackTraceString(e$iv);
                                        String string4 = Intrinsics.stringPlus((String)string3, (Object)string2);
                                        previewLogger4.log(string4);
                                    }
                                }
                                this_$iv2 = this;
                                name$iv2 = "PREVIEW SOCKET";
                                $i$f$closeService2 = false;
                                try {
                                    this_$iv$iv = this_$iv2.log;
                                    boolean $i$f$invoke6 = false;
                                    if (this_$iv$iv.isEnabled()) {
                                        PreviewLogger previewLogger5 = this_$iv$iv;
                                        boolean bl14 = false;
                                        string2 = Intrinsics.stringPlus((String)"CLOSING ", (Object)name$iv2);
                                        previewLogger5.log(string2);
                                    }
                                    boolean $i$f$measureTimeMillis = false;
                                    boolean this_$iv$iv$iv = false;
                                    start$iv$iv2 = System.currentTimeMillis();
                                    bl2 = false;
                                    boolean bl15 = false;
                                    this.previewSocket.close();
                                    ms$iv = System.currentTimeMillis() - start$iv$iv2;
                                    PreviewLogger this_$iv$iv5 = this_$iv2.log;
                                    boolean $i$f$invoke7 = false;
                                    if (this_$iv$iv5.isEnabled()) {
                                        PreviewLogger previewLogger6 = this_$iv$iv5;
                                        bl4 = false;
                                        string2 = "CLOSED " + name$iv2 + " in " + ms$iv + " ms";
                                        previewLogger6.log(string2);
                                    }
                                }
                                catch (Exception e$iv) {
                                    PreviewLogger this_$iv$iv6 = this_$iv2.log;
                                    boolean $i$f$error = false;
                                    PreviewLogger this_$iv$iv$iv = this_$iv$iv6;
                                    $i$f$invoke = false;
                                    if (!this_$iv$iv$iv.isEnabled()) break block37;
                                    PreviewLogger $i$f$invoke5 = this_$iv$iv$iv;
                                    bl3 = false;
                                    String string5 = "error: ";
                                    boolean bl16 = false;
                                    string2 = "ERROR CLOSING " + name$iv2 + ": " + UtilsKt.getStackTraceString(e$iv);
                                    String $i$a$-error-PreviewManagerImpl$closeService$3$iv2 = Intrinsics.stringPlus((String)string5, (Object)string2);
                                    $i$f$invoke5.log($i$a$-error-PreviewManagerImpl$closeService$3$iv2);
                                }
                            }
                            this_$iv2 = this;
                            name$iv2 = "GRADLE SOCKET";
                            $i$f$closeService2 = false;
                            try {
                                this_$iv$iv = this_$iv2.log;
                                boolean $i$f$invoke8 = false;
                                if (this_$iv$iv.isEnabled()) {
                                    PreviewLogger previewLogger7 = this_$iv$iv;
                                    boolean bl17 = false;
                                    string2 = Intrinsics.stringPlus((String)"CLOSING ", (Object)name$iv2);
                                    previewLogger7.log(string2);
                                }
                                boolean $i$f$measureTimeMillis = false;
                                boolean this_$iv$iv$iv = false;
                                start$iv$iv2 = System.currentTimeMillis();
                                bl2 = false;
                                boolean bl18 = false;
                                this.gradleCallbackSocket.close();
                                ms$iv = System.currentTimeMillis() - start$iv$iv2;
                                PreviewLogger this_$iv$iv7 = this_$iv2.log;
                                boolean $i$f$invoke9 = false;
                                if (this_$iv$iv7.isEnabled()) {
                                    PreviewLogger previewLogger8 = this_$iv$iv7;
                                    bl4 = false;
                                    string2 = "CLOSED " + name$iv2 + " in " + ms$iv + " ms";
                                    previewLogger8.log(string2);
                                }
                            }
                            catch (Exception e$iv) {
                                PreviewLogger this_$iv$iv8 = this_$iv2.log;
                                boolean $i$f$error = false;
                                PreviewLogger this_$iv$iv$iv = this_$iv$iv8;
                                $i$f$invoke = false;
                                if (!this_$iv$iv$iv.isEnabled()) break block38;
                                PreviewLogger $i$f$invoke5 = this_$iv$iv$iv;
                                bl3 = false;
                                String string6 = "error: ";
                                $i$a$-error-PreviewManagerImpl$closeService$3$iv = false;
                                string2 = "ERROR CLOSING " + name$iv2 + ": " + UtilsKt.getStackTraceString(e$iv);
                                String $i$a$-error-PreviewManagerImpl$closeService$3$iv2 = Intrinsics.stringPlus((String)string6, (Object)string2);
                                $i$f$invoke5.log($i$a$-error-PreviewManagerImpl$closeService$3$iv2);
                            }
                        }
                        this_$iv2 = this;
                        name$iv2 = "THREADS";
                        $i$f$closeService2 = false;
                        try {
                            void $this$filterTo$iv$iv;
                            this_$iv$iv = this_$iv2.log;
                            boolean $i$f$invoke = false;
                            if (this_$iv$iv.isEnabled()) {
                                PreviewLogger previewLogger9 = this_$iv$iv;
                                boolean bl19 = false;
                                string2 = Intrinsics.stringPlus((String)"CLOSING ", (Object)name$iv2);
                                previewLogger9.log(string2);
                            }
                            boolean $i$f$measureTimeMillis = false;
                            boolean this_$iv$iv$iv = false;
                            start$iv$iv2 = System.currentTimeMillis();
                            bl2 = false;
                            boolean bl20 = false;
                            int n = 0;
                            do {
                                int i2 = n++;
                                int aliveThreads = 0;
                                for (Thread t : this.threads) {
                                    if (!t.isAlive()) continue;
                                    int $i$a$-error-PreviewManagerImpl$closeService$3$iv2 = aliveThreads;
                                    aliveThreads = $i$a$-error-PreviewManagerImpl$closeService$3$iv2 + 1;
                                    t.interrupt();
                                }
                                if (aliveThreads == 0) break;
                                Thread.sleep(300L);
                            } while (n <= 3);
                            Iterable $this$filter$iv = this.threads;
                            boolean $i$f$filter = false;
                            Iterable $i$f$invoke5 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                Thread it = (Thread)element$iv$iv;
                                boolean bl21 = false;
                                if (!it.isAlive()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            List aliveThreads = (List)destination$iv$iv;
                            object = aliveThreads;
                            bl = false;
                            if (!object.isEmpty()) {
                                object = Intrinsics.stringPlus((String)"Could not stop threads: ", (Object)CollectionsKt.joinToString$default((Iterable)aliveThreads, (CharSequence)", ", null, null, (int)0, null, (Function1)close.1.5.1.INSTANCE, (int)30, null));
                                bl = false;
                                throw (Throwable)new IllegalStateException(object.toString());
                            }
                            long ms$iv = System.currentTimeMillis() - start$iv$iv2;
                            PreviewLogger this_$iv$iv9 = this_$iv2.log;
                            boolean $i$f$invoke10 = false;
                            if (this_$iv$iv9.isEnabled()) {
                                PreviewLogger previewLogger10 = this_$iv$iv9;
                                boolean bl22 = false;
                                string2 = "CLOSED " + name$iv2 + " in " + ms$iv + " ms";
                                previewLogger10.log(string2);
                            }
                        }
                        catch (Exception e$iv) {
                            PreviewLogger this_$iv$iv10 = this_$iv2.log;
                            boolean $i$f$error = false;
                            PreviewLogger this_$iv$iv$iv = this_$iv$iv10;
                            boolean $i$f$invoke = false;
                            if (!this_$iv$iv$iv.isEnabled()) break block39;
                            PreviewLogger previewLogger11 = this_$iv$iv$iv;
                            bl3 = false;
                            String string7 = "error: ";
                            $i$a$-error-PreviewManagerImpl$closeService$3$iv = false;
                            string2 = "ERROR CLOSING " + name$iv2 + ": " + UtilsKt.getStackTraceString(e$iv);
                            String string8 = Intrinsics.stringPlus((String)string7, (Object)string2);
                            previewLogger11.log(string8);
                        }
                    }
                    this_$iv2 = this;
                    name$iv2 = "PREVIEW HOST PROCESS";
                    $i$f$closeService2 = false;
                    try {
                        Unit unit;
                        this_$iv$iv = this_$iv2.log;
                        boolean $i$f$invoke = false;
                        if (this_$iv$iv.isEnabled()) {
                            PreviewLogger previewLogger12 = this_$iv$iv;
                            boolean bl23 = false;
                            string2 = Intrinsics.stringPlus((String)"CLOSING ", (Object)name$iv2);
                            previewLogger12.log(string2);
                        }
                        boolean $i$f$measureTimeMillis = false;
                        boolean this_$iv$iv$iv = false;
                        start$iv$iv2 = System.currentTimeMillis();
                        bl2 = false;
                        boolean bl24 = false;
                        object2 = previewProcess;
                        if (object2 == null) {
                            unit = null;
                        } else {
                            object = object2;
                            bl = false;
                            boolean bl25 = false;
                            Object process = object;
                            boolean bl26 = false;
                            if (!((Process)process).waitFor(5L, TimeUnit.SECONDS)) {
                                PreviewLogger this_$iv3 = this.log;
                                boolean $i$f$invoke11 = false;
                                if (this_$iv3.isEnabled()) {
                                    PreviewLogger previewLogger13 = this_$iv3;
                                    boolean bl27 = false;
                                    String string9 = "FORCIBLY DESTROYING PREVIEW HOST PROCESS";
                                    previewLogger13.log(string9);
                                }
                                ((Process)process).destroyForcibly();
                            }
                            unit = Unit.INSTANCE;
                        }
                        long ms$iv = System.currentTimeMillis() - start$iv$iv2;
                        PreviewLogger this_$iv$iv11 = this_$iv2.log;
                        boolean $i$f$invoke12 = false;
                        if (this_$iv$iv11.isEnabled()) {
                            PreviewLogger previewLogger14 = this_$iv$iv11;
                            boolean bl28 = false;
                            string2 = "CLOSED " + name$iv2 + " in " + ms$iv + " ms";
                            previewLogger14.log(string2);
                        }
                    }
                    catch (Exception e$iv) {
                        PreviewLogger this_$iv$iv12 = this_$iv2.log;
                        boolean $i$f$error = false;
                        PreviewLogger this_$iv$iv$iv = this_$iv$iv12;
                        boolean $i$f$invoke = false;
                        if (!this_$iv$iv$iv.isEnabled()) break block40;
                        PreviewLogger previewLogger15 = this_$iv$iv$iv;
                        bl3 = false;
                        String string10 = "error: ";
                        $i$a$-error-PreviewManagerImpl$closeService$3$iv = false;
                        string2 = "ERROR CLOSING " + name$iv2 + ": " + UtilsKt.getStackTraceString(e$iv);
                        String string11 = Intrinsics.stringPlus((String)string10, (Object)string2);
                        previewLogger15.log(string11);
                    }
                }
                long ms$iv = System.currentTimeMillis() - start$iv$iv;
                PreviewLogger this_$iv$iv = ((PreviewManagerImpl)this_$iv).log;
                boolean $i$f$invoke = false;
                if (this_$iv$iv.isEnabled()) {
                    previewLogger = this_$iv$iv;
                    boolean bl = false;
                    string = "CLOSED " + name$iv + " in " + ms$iv + " ms";
                    previewLogger.log(string);
                }
            }
            catch (Exception e$iv) {
                PreviewLogger this_$iv$iv = ((PreviewManagerImpl)this_$iv).log;
                boolean $i$f$error = false;
                PreviewLogger this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$invoke = false;
                if (!this_$iv$iv$iv.isEnabled()) break block41;
                PreviewLogger previewLogger = this_$iv$iv$iv;
                boolean bl = false;
                String string = "error: ";
                $i$a$-error-PreviewManagerImpl$closeService$3$iv = false;
                String string12 = "ERROR CLOSING " + name$iv + ": " + UtilsKt.getStackTraceString(e$iv);
                String string13 = Intrinsics.stringPlus((String)string, (Object)string12);
                previewLogger.log(string13);
            }
        }
    }

    private final void closeService(String name, Function0<Unit> doClose) {
        block4: {
            boolean $i$f$closeService = false;
            try {
                String string;
                PreviewLogger previewLogger;
                PreviewLogger this_$iv = this.log;
                boolean $i$f$invoke = false;
                if (this_$iv.isEnabled()) {
                    previewLogger = this_$iv;
                    boolean bl = false;
                    string = Intrinsics.stringPlus((String)"CLOSING ", (Object)name);
                    previewLogger.log(string);
                }
                boolean $i$f$measureTimeMillis = false;
                boolean bl = false;
                long start$iv = System.currentTimeMillis();
                boolean bl2 = false;
                doClose.invoke();
                long ms = System.currentTimeMillis() - start$iv;
                PreviewLogger this_$iv2 = this.log;
                boolean $i$f$invoke2 = false;
                if (this_$iv2.isEnabled()) {
                    previewLogger = this_$iv2;
                    boolean bl3 = false;
                    string = "CLOSED " + name + " in " + ms + " ms";
                    previewLogger.log(string);
                }
            }
            catch (Exception e) {
                PreviewLogger this_$iv = this.log;
                boolean $i$f$error = false;
                PreviewLogger this_$iv$iv = this_$iv;
                boolean $i$f$invoke = false;
                if (!this_$iv$iv.isEnabled()) break block4;
                PreviewLogger previewLogger = this_$iv$iv;
                boolean bl = false;
                String string = "error: ";
                boolean bl4 = false;
                String string2 = "ERROR CLOSING " + name + ": " + UtilsKt.getStackTraceString(e);
                String string3 = Intrinsics.stringPlus((String)string, (Object)string2);
                previewLogger.log(string3);
            }
        }
    }

    @Override
    public void updateFrameConfig(@NotNull FrameConfig frameConfig) {
        Intrinsics.checkNotNullParameter((Object)frameConfig, (String)"frameConfig");
        this.previewFrameConfig.set(frameConfig);
        this.sendPreviewRequestThread.interrupt();
    }

    @Override
    public int getGradleCallbackPort() {
        return this.gradleCallbackSocket.getLocalPort();
    }

    private final RemoteConnection tryAcceptConnection(ServerSocket serverSocket, String socketType) {
        while (this.isAlive.get()) {
            try {
                Socket socket = serverSocket.accept();
                Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"socket");
                return new RemoteConnectionImpl(socket, new PrintStreamLogger("CONNECTION (" + socketType + ") #" + this.connectionNumber.incrementAndGet(), null, 2, null), (Function0<Unit>)((Function0)tryAcceptConnection.1.INSTANCE));
            }
            catch (IOException e) {
                if (e instanceof SocketTimeoutException || !this.isAlive.get()) continue;
                PreviewLogger this_$iv = this.log;
                boolean $i$f$error = false;
                PreviewLogger this_$iv$iv = this_$iv;
                boolean $i$f$invoke = false;
                if (!this_$iv$iv.isEnabled()) continue;
                PreviewLogger previewLogger = this_$iv$iv;
                boolean bl = false;
                String string = "error: ";
                boolean bl2 = false;
                String string2 = ExceptionsKt.stackTraceToString((Throwable)e);
                String string3 = Intrinsics.stringPlus((String)string, (Object)string2);
                previewLogger.log(string3);
            }
        }
        return null;
    }

    private final void withLivePreviewConnection(Function1<? super RemoteConnection, Unit> fn) {
        boolean $i$f$withLivePreviewConnection = false;
        RunningPreview runningPreview = (RunningPreview)this.runningPreview.get();
        if (runningPreview == null) {
            return;
        }
        RunningPreview runningPreview2 = runningPreview;
        if (runningPreview2.isAlive()) {
            fn.invoke((Object)runningPreview2.getConnection());
        }
    }

    private final Thread repeatWhileAliveThread(String name, long sleepDelayMs, Function0<Unit> fn) {
        boolean $i$f$repeatWhileAliveThread = false;
        Thread thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)name, (int)0, (Function0)((Function0)new Function0<Unit>(this, fn, sleepDelayMs){
            final /* synthetic */ PreviewManagerImpl this$0;
            final /* synthetic */ Function0<Unit> $fn;
            final /* synthetic */ long $sleepDelayMs;
            {
                this.this$0 = $receiver;
                this.$fn = $fn;
                this.$sleepDelayMs = $sleepDelayMs;
                super(0);
            }

            public final void invoke() {
                while (PreviewManagerImpl.access$isAlive$p(this.this$0).get()) {
                    try {
                        this.$fn.invoke();
                        Thread.sleep(this.$sleepDelayMs);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }), (int)22, null);
        boolean bl = false;
        boolean bl2 = false;
        Thread it = thread;
        boolean bl3 = false;
        it.setUncaughtExceptionHandler(new /* invalid duplicate definition of identical inner class */);
        this.threads.add(it);
        it.start();
        return thread;
    }

    static /* synthetic */ Thread repeatWhileAliveThread$default(PreviewManagerImpl this_, String name, long sleepDelayMs, Function0 fn, int n, Object object) {
        if ((n & 2) != 0) {
            sleepDelayMs = 1000L;
        }
        boolean $i$f$repeatWhileAliveThread = false;
        object = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)name, (int)0, (Function0)((Function0)new /* invalid duplicate definition of identical inner class */), (int)22, null);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        ((Thread)it).setUncaughtExceptionHandler(new /* invalid duplicate definition of identical inner class */);
        this_.threads.add(it);
        ((Thread)it).start();
        return object;
    }

    private final void onError(Throwable e) {
        this.onError(UtilsKt.getStackTraceString(e));
    }

    private final void onError(String error) {
        PreviewLogger this_$iv = this.log;
        boolean $i$f$error = false;
        PreviewLogger this_$iv$iv = this_$iv;
        boolean $i$f$invoke = false;
        if (this_$iv$iv.isEnabled()) {
            PreviewLogger previewLogger = this_$iv$iv;
            boolean bl = false;
            String string = "error: ";
            boolean bl2 = false;
            String string2 = error;
            String string3 = Intrinsics.stringPlus((String)string, (Object)string2);
            previewLogger.log(string3);
        }
        this.previewListener.onError(error);
    }

    private static final Process runPreviewThread$lambda-2$startPreviewProcess(PreviewManagerImpl this$0, PreviewHostConfig config) {
        Object object = new String[]{config.getJavaExecutable(), "-Djava.awt.headless=true", "-classpath", config.getHostClasspath(), RemotePreviewHostKt.getPREVIEW_HOST_CLASS_NAME(), String.valueOf(this$0.previewSocket.getLocalPort())};
        object = new ProcessBuilder((String[])object);
        boolean bl = false;
        boolean bl2 = false;
        Object $this$runPreviewThread_u24lambda_u2d2_u24startPreviewProcess_u24lambda_u2d0 = object;
        boolean bl3 = false;
        ((ProcessBuilder)$this$runPreviewThread_u24lambda_u2d2_u24startPreviewProcess_u24lambda_u2d0).redirectOutput(ProcessBuilder.Redirect.PIPE);
        ((ProcessBuilder)$this$runPreviewThread_u24lambda_u2d2_u24startPreviewProcess_u24lambda_u2d0).redirectError(ProcessBuilder.Redirect.PIPE);
        ((ProcessBuilder)$this$runPreviewThread_u24lambda_u2d2_u24startPreviewProcess_u24lambda_u2d0).redirectErrorStream(true);
        Process process = ((ProcessBuilder)object).start();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"ProcessBuilder(\n        \u2026ue)\n            }.start()");
        return process;
    }

    public static final /* synthetic */ AtomicBoolean access$isAlive$p(PreviewManagerImpl $this) {
        return $this.isAlive;
    }

    public static final /* synthetic */ AtomicReference access$getPreviewHostConfig$p(PreviewManagerImpl $this) {
        return $this.previewHostConfig;
    }

    public static final /* synthetic */ Process access$runPreviewThread$lambda-2$startPreviewProcess(PreviewManagerImpl this$0, PreviewHostConfig config) {
        return PreviewManagerImpl.runPreviewThread$lambda-2$startPreviewProcess(this$0, config);
    }

    public static final /* synthetic */ RemoteConnection access$tryAcceptConnection(PreviewManagerImpl $this, ServerSocket serverSocket, String socketType) {
        return $this.tryAcceptConnection(serverSocket, socketType);
    }

    public static final /* synthetic */ ServerSocket access$getPreviewSocket$p(PreviewManagerImpl $this) {
        return $this.previewSocket;
    }

    public static final /* synthetic */ PreviewListener access$getPreviewListener$p(PreviewManagerImpl $this) {
        return $this.previewListener;
    }

    public static final /* synthetic */ void access$onError(PreviewManagerImpl $this, String error) {
        $this.onError(error);
    }

    public static final /* synthetic */ AtomicReference access$getPreviewClasspath$p(PreviewManagerImpl $this) {
        return $this.previewClasspath;
    }

    public static final /* synthetic */ AtomicReference access$getPreviewFqName$p(PreviewManagerImpl $this) {
        return $this.previewFqName;
    }

    public static final /* synthetic */ AtomicReference access$getPreviewFrameConfig$p(PreviewManagerImpl $this) {
        return $this.previewFrameConfig;
    }

    public static final /* synthetic */ AtomicLong access$getUserRequestCount$p(PreviewManagerImpl $this) {
        return $this.userRequestCount;
    }

    public static final /* synthetic */ AtomicReference access$getProcessedRequest$p(PreviewManagerImpl $this) {
        return $this.processedRequest;
    }

    public static final /* synthetic */ AtomicReference access$getInProcessRequest$p(PreviewManagerImpl $this) {
        return $this.inProcessRequest;
    }

    public static final /* synthetic */ Thread access$getSendPreviewRequestThread$p(PreviewManagerImpl $this) {
        return $this.sendPreviewRequestThread;
    }

    public static final /* synthetic */ ServerSocket access$getGradleCallbackSocket$p(PreviewManagerImpl $this) {
        return $this.gradleCallbackSocket;
    }

    public static final /* synthetic */ void access$onError(PreviewManagerImpl $this, Throwable e) {
        $this.onError(e);
    }
}

