/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.internal.MacSigner;
import org.jetbrains.compose.desktop.application.internal.files.MacJarSignFileCopyingProcessorKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010\u0010\u001a\u00020\u000fJ\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/compose/desktop/application/internal/MacSigningHelper;", "", "macSigner", "Lorg/jetbrains/compose/desktop/application/internal/MacSigner;", "runtimeProvisioningProfile", "Ljava/io/File;", "entitlementsFile", "runtimeEntitlementsFile", "destinationDir", "packageName", "", "(Lorg/jetbrains/compose/desktop/application/internal/MacSigner;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/lang/String;)V", "appDir", "runtimeDir", "addRuntimeProvisioningProfile", "", "modifyRuntimeIfNeeded", "resignRuntimeAndAppDir", "compose"})
public final class MacSigningHelper {
    @NotNull
    private final MacSigner macSigner;
    @Nullable
    private final File runtimeProvisioningProfile;
    @Nullable
    private final File entitlementsFile;
    @Nullable
    private final File runtimeEntitlementsFile;
    @NotNull
    private final File appDir;
    @NotNull
    private final File runtimeDir;

    public MacSigningHelper(@NotNull MacSigner macSigner2, @Nullable File runtimeProvisioningProfile, @Nullable File entitlementsFile, @Nullable File runtimeEntitlementsFile, @NotNull File destinationDir, @NotNull String packageName2) {
        Intrinsics.checkNotNullParameter((Object)macSigner2, (String)"macSigner");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        this.macSigner = macSigner2;
        this.runtimeProvisioningProfile = runtimeProvisioningProfile;
        this.entitlementsFile = entitlementsFile;
        this.runtimeEntitlementsFile = runtimeEntitlementsFile;
        this.appDir = FilesKt.resolve((File)destinationDir, (String)(packageName2 + ".app"));
        this.runtimeDir = FilesKt.resolve((File)this.appDir, (String)"Contents/runtime");
    }

    public final void modifyRuntimeIfNeeded() {
        if (this.runtimeProvisioningProfile == null && (this.runtimeEntitlementsFile == null || this.entitlementsFile == null)) {
            return;
        }
        File file2 = this.runtimeProvisioningProfile;
        if (file2 != null) {
            File it = file2;
            boolean bl = false;
            this.addRuntimeProvisioningProfile(this.runtimeDir, it);
        }
        this.resignRuntimeAndAppDir(this.appDir, this.runtimeDir);
    }

    private final void addRuntimeProvisioningProfile(File runtimeDir, File runtimeProvisioningProfile) {
        FilesKt.copyTo$default((File)runtimeProvisioningProfile, (File)FilesKt.resolve((File)runtimeDir, (String)"Contents/embedded.provisionprofile"), (boolean)true, (int)0, (int)4, null);
    }

    private final void resignRuntimeAndAppDir(File appDir2, File runtimeDir) {
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)runtimeDir, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file2 = (File)element$iv;
            boolean bl = false;
            Path path = file2.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isRegularFile(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || !Files.isExecutable(path) && !MacJarSignFileCopyingProcessorKt.isDylibPath(((Object)path).toString()) || Files.isSymbolicLink(path)) continue;
            this.macSigner.unsign(file2);
            MacSigner.sign$default(this.macSigner, file2, this.runtimeEntitlementsFile, false, 4, null);
        }
        this.macSigner.unsign(runtimeDir);
        this.macSigner.sign(runtimeDir, this.runtimeEntitlementsFile, true);
        this.macSigner.unsign(appDir2);
        this.macSigner.sign(appDir2, this.entitlementsFile, true);
    }
}

