/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.de.undercouch.gradle.tasks.download.internal;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.internal.Job;
import org.jetbrains.compose.de.undercouch.gradle.tasks.download.internal.WorkerExecutorHelper;

public class DefaultWorkerExecutorHelper
extends WorkerExecutorHelper {
    private static final AtomicInteger UNIQUE_ID = new AtomicInteger();
    private static final Map<Integer, Job> jobs = new ConcurrentHashMap<Integer, Job>();
    private final WorkerExecutor workerExecutor;
    private final WorkQueue workQueue;

    @Inject
    public DefaultWorkerExecutorHelper(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
        this.workQueue = workerExecutor.noIsolation();
    }

    @Override
    public void submit(Job job) {
        int id = UNIQUE_ID.getAndIncrement();
        jobs.put(id, job);
        this.workQueue.submit(DefaultWorkAction.class, parameters -> parameters.getID().set((Object)id));
    }

    @Override
    public void await() {
        this.workerExecutor.await();
    }

    @Override
    public boolean needsAwait() {
        return false;
    }

    public static abstract class DefaultWorkAction
    implements WorkAction<DefaultWorkParameters> {
        public void execute() {
            Job job = (Job)jobs.remove(((DefaultWorkParameters)this.getParameters()).getID().get());
            try {
                job.run();
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
    }

    public static interface DefaultWorkParameters
    extends WorkParameters {
        public Property<Integer> getID();
    }
}

