/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.tasks;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.internal.ExternalToolRunner;
import org.jetbrains.compose.desktop.application.tasks.AbstractNativeMacApplicationPackageDmgTask;
import org.jetbrains.compose.desktop.application.tasks.AbstractNativeMacApplicationPackageTask;
import org.jetbrains.compose.internal.utils.FileUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016H\u0014J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J!\u0010\u0007\u001a\u00020\r2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u001f\"\u00020\rH\u0002\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\"H\u0002J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\"H\u0002R\u0013\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\n\u00a8\u0006("}, d2={"Lorg/jetbrains/compose/desktop/application/tasks/AbstractNativeMacApplicationPackageDmgTask;", "Lorg/jetbrains/compose/desktop/application/tasks/AbstractNativeMacApplicationPackageTask;", "()V", "appDir", "Lorg/gradle/api/file/DirectoryProperty;", "getAppDir", "()Lorg/gradle/api/file/DirectoryProperty;", "hdiutil", "Lorg/gradle/api/file/RegularFileProperty;", "getHdiutil", "()Lorg/gradle/api/file/RegularFileProperty;", "installDir", "Lorg/gradle/api/provider/Property;", "", "getInstallDir", "()Lorg/gradle/api/provider/Property;", "osascript", "getOsascript", "createImage", "", "volumeName", "imageFile", "Ljava/io/File;", "srcDir", "createPackage", "destinationDir", "workingDir", "finalizeImage", "tmpImage", "finalImage", "args", "", "([Ljava/lang/String;)Ljava/lang/String;", "mountImage", "Lorg/jetbrains/compose/desktop/application/tasks/AbstractNativeMacApplicationPackageDmgTask$MountedImage;", "runSetupScript", "appName", "mounted", "unmountImage", "MountedImage", "compose"})
public abstract class AbstractNativeMacApplicationPackageDmgTask
extends AbstractNativeMacApplicationPackageTask {
    @NotNull
    private final RegularFileProperty hdiutil;
    @NotNull
    private final RegularFileProperty osascript;
    @NotNull
    private final Property<String> installDir;
    @NotNull
    private final DirectoryProperty appDir;

    /*
     * WARNING - void declaration
     */
    public AbstractNativeMacApplicationPackageDmgTask() {
        void $this$notNullProperty$iv;
        RegularFileProperty regularFileProperty = this.getObjects().fileProperty().value(AbstractNativeMacApplicationPackageDmgTask::hdiutil$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objects.fileProperty().v\u2026ile(\"/usr/bin/hdiutil\") }");
        this.hdiutil = regularFileProperty;
        RegularFileProperty regularFileProperty2 = this.getObjects().fileProperty().value(AbstractNativeMacApplicationPackageDmgTask::osascript$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty2, (String)"objects.fileProperty().v\u2026e(\"/usr/bin/osascript\") }");
        this.osascript = regularFileProperty2;
        ObjectFactory objectFactory = this.getObjects();
        String defaultValue$iv = "/Applications";
        boolean $i$f$notNullProperty = false;
        Property property = $this$notNullProperty$iv.property(String.class).value((Object)defaultValue$iv);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java).value(defaultValue)");
        this.installDir = property;
        DirectoryProperty directoryProperty = this.getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objects.directoryProperty()");
        this.appDir = directoryProperty;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public final RegularFileProperty getHdiutil() {
        return this.hdiutil;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public final RegularFileProperty getOsascript() {
        return this.osascript;
    }

    @Input
    @NotNull
    public final Property<String> getInstallDir() {
        return this.installDir;
    }

    @InputDirectory
    @NotNull
    public final DirectoryProperty getAppDir() {
        return this.appDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createPackage(@NotNull File destinationDir, @NotNull File workingDir2) {
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter((Object)workingDir2, (String)"workingDir");
        String packageName2 = (String)this.getPackageName().get();
        String fullPackageName = (String)this.getFullPackageName$compose().get();
        File tmpImage = FilesKt.resolve((File)workingDir2, (String)(fullPackageName + ".tmp.dmg"));
        File finalImage = FilesKt.resolve((File)destinationDir, (String)(fullPackageName + ".dmg"));
        Intrinsics.checkNotNullExpressionValue((Object)packageName2, (String)"packageName");
        this.createImage(packageName2, tmpImage, FileUtilsKt.getIoFile((Provider)this.appDir));
        MountedImage mounted = this.mountImage(packageName2, tmpImage);
        try {
            this.runSetupScript(packageName2, mounted);
        }
        finally {
            this.unmountImage(mounted);
        }
        this.finalizeImage(tmpImage, finalImage);
        this.getLogger().lifecycle("The distribution is written to " + finalImage.getCanonicalPath());
    }

    /*
     * WARNING - void declaration
     */
    private final void createImage(String volumeName, File imageFile, File srcDir) {
        String[] stringArray = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)srcDir, null, (int)1, null)), (Function1)createImage.size.1.INSTANCE);
        long l = 0L;
        for (Object e : stringArray) {
            void it;
            File file2 = (File)e;
            long l2 = l;
            boolean bl = false;
            long l3 = it.length();
            l = l2 + l3;
        }
        long size2 = l;
        size2 += (long)(10 * 1024 * 1024);
        stringArray = new String[13];
        stringArray[0] = "create";
        stringArray[1] = "-srcfolder";
        Intrinsics.checkNotNullExpressionValue((Object)srcDir.getAbsolutePath(), (String)"srcDir.absolutePath");
        stringArray[3] = "-volname";
        stringArray[4] = volumeName;
        stringArray[5] = "-size";
        stringArray[6] = String.valueOf(size2);
        stringArray[7] = "-ov";
        Intrinsics.checkNotNullExpressionValue((Object)imageFile.getAbsolutePath(), (String)"imageFile.absolutePath");
        stringArray[9] = "-fs";
        stringArray[10] = "HFS+";
        stringArray[11] = "-format";
        stringArray[12] = "UDRW";
        this.hdiutil(stringArray);
    }

    private final MountedImage mountImage(String volumeName, File imageFile) {
        String[] stringArray = new String[5];
        stringArray[0] = "attach";
        stringArray[1] = "-readwrite";
        stringArray[2] = "-noverify";
        stringArray[3] = "-noautoopen";
        Intrinsics.checkNotNullExpressionValue((Object)imageFile.getAbsolutePath(), (String)"imageFile.absolutePath");
        String output = this.hdiutil(stringArray);
        Thread.sleep(3000L);
        String device = null;
        String volume = null;
        String[] stringArray2 = new String[]{"\n"};
        for (String line : StringsKt.split$default((CharSequence)output, (String[])stringArray2, (boolean)false, (int)0, (int)6, null)) {
            int n;
            int n2;
            String string;
            block4: {
                int volumeIndex;
                if (!StringsKt.startsWith$default((String)line, (String)"/dev/", (boolean)false, (int)2, null) || (volumeIndex = StringsKt.lastIndexOf$default((CharSequence)line, (String)("/Volumes/" + volumeName), (int)0, (boolean)false, (int)6, null)) <= 0) continue;
                String string2 = line.substring(volumeIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                volume = ((Object)StringsKt.trimEnd((CharSequence)string2)).toString();
                string = line;
                n2 = 0;
                CharSequence $this$indexOfFirst$iv = line;
                boolean $i$f$indexOfFirst = false;
                int n3 = $this$indexOfFirst$iv.length();
                for (int index$iv = 0; index$iv < n3; ++index$iv) {
                    char p0 = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!CharsKt.isWhitespace((char)p0)) continue;
                    n = index$iv;
                    break block4;
                }
                n = -1;
            }
            int n4 = n;
            Intrinsics.checkNotNullExpressionValue((Object)string.substring(n2, n4), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        }
        if (!(device != null && volume != null)) {
            boolean bl = false;
            String string = "Could not parse mounted image's device (" + device + ") & volume (" + volume + ") from hdiutil output:\n=======\n" + output + "\n=======\n";
            throw new IllegalStateException(string.toString());
        }
        Object object = this.getVerbose().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"verbose.get()");
        if (((Boolean)object).booleanValue()) {
            this.getLogger().info("Mounted DMG image '" + imageFile + "': volume '" + volume + "', device '" + device + '\'');
        }
        return new MountedImage(device, StringsKt.removePrefix(volume, (CharSequence)"/Volumes/"));
    }

    private final void unmountImage(MountedImage mounted) {
        String[] stringArray = new String[]{"detach", mounted.getDevice()};
        this.hdiutil(stringArray);
    }

    private final void finalizeImage(File tmpImage, File finalImage) {
        String[] stringArray = new String[8];
        stringArray[0] = "convert";
        Intrinsics.checkNotNullExpressionValue((Object)tmpImage.getAbsolutePath(), (String)"tmpImage.absolutePath");
        stringArray[2] = "-format";
        stringArray[3] = "UDZO";
        stringArray[4] = "-imagekey";
        stringArray[5] = "zlib-level=9";
        stringArray[6] = "-o";
        Intrinsics.checkNotNullExpressionValue((Object)finalImage.getAbsolutePath(), (String)"finalImage.absolutePath");
        this.hdiutil(stringArray);
    }

    private final String hdiutil(String ... args2) {
        Ref.ObjectRef resultStdout = new Ref.ObjectRef();
        resultStdout.element = "";
        List allArgs = ArraysKt.toMutableList((Object[])args2);
        Object object = this.getVerbose().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"verbose.get()");
        if (((Boolean)object).booleanValue()) {
            allArgs.add("-verbose");
        }
        ExternalToolRunner.invoke$default(this.getRunExternalTool$compose(), FileUtilsKt.getIoFile((Provider)this.hdiutil), allArgs, null, null, false, (Function1)new Function1<String, Unit>((Ref.ObjectRef<String>)resultStdout){
            final /* synthetic */ Ref.ObjectRef<String> $resultStdout;
            {
                this.$resultStdout = $resultStdout;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$resultStdout.element = it;
            }
        }, null, 92, null);
        return (String)resultStdout.element;
    }

    private final void runSetupScript(String appName, MountedImage mounted) {
        File file2;
        String disk = mounted.getDisk();
        String installDir = (String)this.installDir.get();
        File $this$runSetupScript_u24lambda_u244 = file2 = FilesKt.resolve((File)FileUtilsKt.getIoFile(this.getWorkingDir()), (String)"setup-dmg.scpt");
        boolean bl = false;
        FilesKt.writeText$default((File)$this$runSetupScript_u24lambda_u244, (String)StringsKt.trimIndent((String)("\n                   tell application \"Finder\"\n                     tell disk \"" + disk + "\"\n                           open\n                           set current view of container window to icon view\n                           set toolbar visible of container window to false\n                           set statusbar visible of container window to false\n                           set the bounds of container window to {400, 100, 885, 430}\n                           set theViewOptions to the icon view options of container window\n                           set arrangement of theViewOptions to not arranged\n                           set icon size of theViewOptions to 72\n                           make new alias file at container window to POSIX file \"" + installDir + "\" with properties {name:\"" + installDir + "\"}\n                           set position of item \"" + appName + "\" of container window to {100, 100}\n                           set position of item \"" + installDir + "\" of container window to {375, 100}\n                           update without registering applications\n                           delay 5\n                           close\n                     end tell\n                   end tell\n            ")), null, (int)2, null);
        File setupScript = file2;
        ExternalToolRunner.invoke$default(this.getRunExternalTool$compose(), FileUtilsKt.getIoFile((Provider)this.osascript), CollectionsKt.listOf((Object)setupScript.getAbsolutePath()), null, null, false, null, null, 124, null);
    }

    private static final File hdiutil$lambda$0() {
        return new File("/usr/bin/hdiutil");
    }

    private static final File osascript$lambda$1() {
        return new File("/usr/bin/osascript");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/compose/desktop/application/tasks/AbstractNativeMacApplicationPackageDmgTask$MountedImage;", "", "device", "", "disk", "(Ljava/lang/String;Ljava/lang/String;)V", "getDevice", "()Ljava/lang/String;", "getDisk", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "compose"})
    private static final class MountedImage {
        @NotNull
        private final String device;
        @NotNull
        private final String disk;

        public MountedImage(@NotNull String device, @NotNull String disk) {
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            Intrinsics.checkNotNullParameter((Object)disk, (String)"disk");
            this.device = device;
            this.disk = disk;
        }

        @NotNull
        public final String getDevice() {
            return this.device;
        }

        @NotNull
        public final String getDisk() {
            return this.disk;
        }

        @NotNull
        public final String component1() {
            return this.device;
        }

        @NotNull
        public final String component2() {
            return this.disk;
        }

        @NotNull
        public final MountedImage copy(@NotNull String device, @NotNull String disk) {
            Intrinsics.checkNotNullParameter((Object)device, (String)"device");
            Intrinsics.checkNotNullParameter((Object)disk, (String)"disk");
            return new MountedImage(device, disk);
        }

        public static /* synthetic */ MountedImage copy$default(MountedImage mountedImage, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = mountedImage.device;
            }
            if ((n & 2) != 0) {
                string2 = mountedImage.disk;
            }
            return mountedImage.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "MountedImage(device=" + this.device + ", disk=" + this.disk + ')';
        }

        public int hashCode() {
            int result2 = this.device.hashCode();
            result2 = result2 * 31 + this.disk.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MountedImage)) {
                return false;
            }
            MountedImage mountedImage = (MountedImage)other;
            if (!Intrinsics.areEqual((Object)this.device, (Object)mountedImage.device)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.disk, (Object)mountedImage.disk);
        }
    }
}

