/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.dsl.JvmApplicationDistributionsKt;
import org.jetbrains.compose.desktop.application.internal.ComposeProperties;
import org.jetbrains.compose.desktop.application.internal.ExternalToolRunner;
import org.jetbrains.compose.desktop.application.internal.files.FileUtilsKt;
import org.jetbrains.compose.desktop.application.tasks.AbstractSuggestModulesTask;
import org.jetbrains.compose.desktop.tasks.AbstractComposeDesktopTask;
import org.jetbrains.compose.internal.utils.OsUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0007R\u0013\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u000e\u001a\u00020\u000f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00138G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178EX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/compose/desktop/application/tasks/AbstractSuggestModulesTask;", "Lorg/jetbrains/compose/desktop/tasks/AbstractComposeDesktopTask;", "()V", "files", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "javaHome", "Lorg/gradle/api/provider/Property;", "", "getJavaHome", "()Lorg/gradle/api/provider/Property;", "jvmTarget", "getJvmTarget", "launcherMainJar", "Lorg/gradle/api/file/RegularFileProperty;", "getLauncherMainJar", "()Lorg/gradle/api/file/RegularFileProperty;", "modules", "Lorg/gradle/api/provider/ListProperty;", "getModules", "()Lorg/gradle/api/provider/ListProperty;", "workingDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getWorkingDir", "()Lorg/gradle/api/provider/Provider;", "run", "", "compose"})
public abstract class AbstractSuggestModulesTask
extends AbstractComposeDesktopTask {
    @NotNull
    private final Property<String> javaHome;
    @NotNull
    private final ConfigurableFileCollection files;
    @NotNull
    private final RegularFileProperty launcherMainJar;
    @NotNull
    private final ListProperty<String> modules;
    @NotNull
    private final Property<String> jvmTarget;
    @NotNull
    private final Provider<Directory> workingDir;

    /*
     * WARNING - void declaration
     */
    public AbstractSuggestModulesTask() {
        void $this$javaHome_u24lambda_u240;
        ObjectFactory $this$notNullProperty$iv = this.getObjects();
        boolean $i$f$notNullProperty22 = false;
        Property property = $this$notNullProperty$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        ObjectFactory $i$f$notNullProperty22 = $this$notNullProperty$iv = property;
        AbstractSuggestModulesTask abstractSuggestModulesTask = this;
        boolean bl = false;
        $this$javaHome_u24lambda_u240.set(this.getProviders().systemProperty("java.home"));
        abstractSuggestModulesTask.javaHome = $this$notNullProperty$iv;
        ConfigurableFileCollection configurableFileCollection = this.getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"objects.fileCollection()");
        this.files = configurableFileCollection;
        RegularFileProperty regularFileProperty = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objects.fileProperty()");
        this.launcherMainJar = regularFileProperty;
        ListProperty listProperty = this.getObjects().listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"objects.listProperty(String::class.java)");
        this.modules = listProperty;
        $this$notNullProperty$iv = this.getObjects();
        String defaultValue$iv = "15";
        boolean $i$f$notNullProperty = false;
        Property property2 = $this$notNullProperty$iv.property(String.class).value((Object)defaultValue$iv);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java).value(defaultValue)");
        this.jvmTarget = property2;
        Provider provider = this.getProject().getLayout().getBuildDirectory().dir("compose/tmp/" + this.getName());
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.layout.buildDire\u2026.dir(\"compose/tmp/$name\")");
        this.workingDir = provider;
    }

    @Input
    @NotNull
    public final Property<String> getJavaHome() {
        return this.javaHome;
    }

    @InputFiles
    @NotNull
    public final ConfigurableFileCollection getFiles() {
        return this.files;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @NotNull
    public final RegularFileProperty getLauncherMainJar() {
        return this.launcherMainJar;
    }

    @Input
    @NotNull
    public final ListProperty<String> getModules() {
        return this.modules;
    }

    @Input
    @NotNull
    public final Property<String> getJvmTarget() {
        return this.jvmTarget;
    }

    @LocalState
    @NotNull
    protected final Provider<Directory> getWorkingDir() {
        return this.workingDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TaskAction
    public final void run() {
        Object[] objectArray;
        File jtool = OsUtilsKt.jvmToolFile("jdeps", (Provider<String>)((Provider)this.javaHome));
        Provider[] providerArray = new Provider[]{this.workingDir};
        org.jetbrains.compose.internal.utils.FileUtilsKt.clearDirs(this.getFileOperations(), providerArray);
        Object[] objectArray2 = new ArrayList<Object>();
        ArrayList<Object> $this$run_u24lambda_u241 = objectArray2;
        boolean bl = false;
        $this$run_u24lambda_u241.add("--print-module-deps");
        $this$run_u24lambda_u241.add("--ignore-missing-deps");
        $this$run_u24lambda_u241.add("--multi-release");
        $this$run_u24lambda_u241.add(this.jvmTarget.get());
        $this$run_u24lambda_u241.add("--class-path");
        Iterable iterable = (Iterable)this.files;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        $this$run_u24lambda_u241.add(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)run.args.1.1.INSTANCE, (int)30, null));
        $this$run_u24lambda_u241.add(FileUtilsKt.normalizedPath(org.jetbrains.compose.internal.utils.FileUtilsKt.getIoFile((Provider)this.launcherMainJar)));
        ArrayList<Object> args2 = objectArray2;
        try {
            objectArray2 = this.getRunExternalTool$compose();
            objectArray = ExternalToolRunner.LogToConsole.Never;
            ExternalToolRunner.invoke$default((ExternalToolRunner)objectArray2, jtool, args2, null, null, false, (Function1)new Function1<String, Unit>(this){
                final /* synthetic */ AbstractSuggestModulesTask this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull String output) {
                    Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                    String[] stringArray = JvmApplicationDistributionsKt.getDEFAULT_RUNTIME_MODULES();
                    HashSet defaultModules = SetsKt.hashSetOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
                    String[] stringArray2 = new String[]{","};
                    SortedSet suggestedModules2 = SequencesKt.toSortedSet((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)output, (String[])stringArray2, (boolean)false, (int)0, (int)6, null), (Function1)run.suggestedModules.1.INSTANCE), (Function1)((Function1)new Function1<String, Boolean>((HashSet<String>)defaultModules){
                        final /* synthetic */ HashSet<String> $defaultModules;
                        {
                            this.$defaultModules = $defaultModules;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return !StringsKt.isBlank((CharSequence)it) && !this.$defaultModules.contains(it);
                        }
                    })));
                    String suggestion2 = "modules(" + CollectionsKt.joinToString$default((Iterable)suggestedModules2, (CharSequence)", ", null, null, (int)0, null, (Function1)run.suggestion.1.INSTANCE, (int)30, null) + ')';
                    this.this$0.getLogger().quiet("Suggested runtime modules to include:");
                    this.this$0.getLogger().quiet(suggestion2);
                }
            }, (ExternalToolRunner.LogToConsole)objectArray, 28, null);
            if (((Boolean)ComposeProperties.INSTANCE.preserveWorkingDir(this.getProviders()).get()).booleanValue()) return;
        }
        catch (Throwable throwable) {
            if (((Boolean)ComposeProperties.INSTANCE.preserveWorkingDir(this.getProviders()).get()).booleanValue()) throw throwable;
            objectArray = new Object[]{this.workingDir};
            org.jetbrains.compose.internal.utils.FileUtilsKt.delete(this.getFileOperations(), objectArray);
            throw throwable;
        }
        objectArray2 = new Object[]{this.workingDir};
        org.jetbrains.compose.internal.utils.FileUtilsKt.delete(this.getFileOperations(), objectArray2);
    }
}

