/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.tasks;

import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.dsl.TargetFormat;
import org.jetbrains.compose.desktop.application.internal.ExternalToolRunner;
import org.jetbrains.compose.desktop.application.internal.NotarizationRequestInfo;
import org.jetbrains.compose.desktop.application.internal.files.FileUtilsKt;
import org.jetbrains.compose.desktop.application.internal.validation.ValidatedMacOSNotarizationSettings;
import org.jetbrains.compose.desktop.application.tasks.AbstractNotarizationTask;
import org.jetbrains.compose.internal.utils.MacUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0007R\u0013\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/compose/desktop/application/tasks/AbstractUploadAppForNotarizationTask;", "Lorg/jetbrains/compose/desktop/application/tasks/AbstractNotarizationTask;", "targetFormat", "Lorg/jetbrains/compose/desktop/application/dsl/TargetFormat;", "(Lorg/jetbrains/compose/desktop/application/dsl/TargetFormat;)V", "inputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getInputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "requestsDir", "getRequestsDir", "getTargetFormat", "()Lorg/jetbrains/compose/desktop/application/dsl/TargetFormat;", "processUploadToolOutput", "", "packageFile", "Ljava/io/File;", "output", "", "run", "compose"})
public abstract class AbstractUploadAppForNotarizationTask
extends AbstractNotarizationTask {
    @NotNull
    private final TargetFormat targetFormat;
    @NotNull
    private final DirectoryProperty inputDir;
    @NotNull
    private final DirectoryProperty requestsDir;

    @Inject
    public AbstractUploadAppForNotarizationTask(@NotNull TargetFormat targetFormat) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetFormat), (String)"targetFormat");
        this.targetFormat = targetFormat;
        DirectoryProperty directoryProperty = this.getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objects.directoryProperty()");
        this.inputDir = directoryProperty;
        DirectoryProperty directoryProperty2 = this.getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty2, (String)"objects.directoryProperty()");
        this.requestsDir = directoryProperty2;
        if (!(this.targetFormat != TargetFormat.AppImage)) {
            boolean bl = false;
            String string = (Object)((Object)TargetFormat.AppImage) + " cannot be notarized!";
            throw new IllegalStateException(string.toString());
        }
    }

    @Input
    @NotNull
    public final TargetFormat getTargetFormat() {
        return this.targetFormat;
    }

    @InputDirectory
    @NotNull
    public final DirectoryProperty getInputDir() {
        return this.inputDir;
    }

    @Internal
    @NotNull
    public final DirectoryProperty getRequestsDir() {
        return this.requestsDir;
    }

    @TaskAction
    public final void run() {
        ValidatedMacOSNotarizationSettings notarization = this.validateNotarization$compose();
        File packageFile = FileUtilsKt.checkExistingFile(FileUtilsKt.findOutputFileOrDir(org.jetbrains.compose.internal.utils.FileUtilsKt.getIoFile((Provider)this.inputDir), this.targetFormat));
        this.getLogger().quiet("Uploading '" + packageFile.getName() + "' for notarization (package id: '" + notarization.getBundleID() + "')");
        Object[] objectArray = new String[]{"altool", "--notarize-app", "--primary-bundle-id", notarization.getBundleID(), "--username", notarization.getAppleID(), "--password", notarization.getPassword(), "--file", packageFile.getAbsolutePath()};
        ArrayList args2 = CollectionsKt.arrayListOf((Object[])objectArray);
        if (notarization.getAscProvider() != null) {
            args2.add("--asc-provider");
            args2.add(notarization.getAscProvider());
        }
        ExternalToolRunner.invoke$default(this.getRunExternalTool$compose(), MacUtils.INSTANCE.getXcrun(), args2, null, null, false, (Function1)new Function1<String, Unit>(this, packageFile){
            final /* synthetic */ AbstractUploadAppForNotarizationTask this$0;
            final /* synthetic */ File $packageFile;
            {
                this.this$0 = $receiver;
                this.$packageFile = $packageFile;
                super(1);
            }

            public final void invoke(@NotNull String output) {
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                AbstractUploadAppForNotarizationTask.access$processUploadToolOutput(this.this$0, this.$packageFile, output);
            }
        }, null, 92, null);
    }

    private final void processUploadToolOutput(File packageFile, String output) {
        MatchResult matchResult = Regex.find$default((Regex)new Regex("RequestUUID = ([A-Za-z0-9\\-]+)"), (CharSequence)output, (int)0, (int)2, null);
        if (matchResult == null) {
            throw new IllegalStateException(("Could not determine RequestUUID from output: " + output).toString());
        }
        MatchResult m = matchResult;
        String requestId = (String)m.getGroupValues().get(1);
        String uploadTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss"));
        File requestDir = FilesKt.resolve((File)org.jetbrains.compose.internal.utils.FileUtilsKt.getIoFile((Provider)this.requestsDir), (String)(uploadTime + '-' + this.targetFormat.getId$compose()));
        String string = packageFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"packageFile.name");
        File packageCopy = FilesKt.resolve((File)requestDir, (String)string);
        FilesKt.copyTo$default((File)packageFile, (File)packageCopy, (boolean)false, (int)0, (int)6, null);
        Intrinsics.checkNotNullExpressionValue((Object)uploadTime, (String)"uploadTime");
        NotarizationRequestInfo requestInfo = new NotarizationRequestInfo(requestId, uploadTime);
        File requestInfoFile = FilesKt.resolve((File)requestDir, (String)"notarization-request.properties");
        requestInfo.saveTo(requestInfoFile);
        this.getLogger().quiet("Request UUID: " + requestId);
        this.getLogger().quiet("Request UUID is saved to " + requestInfoFile.getAbsolutePath());
        this.getLogger().quiet("Uploaded file is saved to " + packageCopy.getAbsolutePath());
    }

    public static final /* synthetic */ void access$processUploadToolOutput(AbstractUploadAppForNotarizationTask $this, File packageFile, String output) {
        $this.processUploadToolOutput(packageFile, output);
    }
}

