/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.internal.ExternalToolRunner;
import org.jetbrains.compose.desktop.application.internal.MacSigner;
import org.jetbrains.compose.desktop.application.internal.MacSignerKt;
import org.jetbrains.compose.desktop.application.internal.validation.ValidatedMacOSSigningSettings;
import org.jetbrains.compose.internal.utils.MacUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/compose/desktop/application/internal/MacSignerImpl;", "Lorg/jetbrains/compose/desktop/application/internal/MacSigner;", "settings", "Lorg/jetbrains/compose/desktop/application/internal/validation/ValidatedMacOSSigningSettings;", "runTool", "Lorg/jetbrains/compose/desktop/application/internal/ExternalToolRunner;", "(Lorg/jetbrains/compose/desktop/application/internal/validation/ValidatedMacOSSigningSettings;Lorg/jetbrains/compose/desktop/application/internal/ExternalToolRunner;)V", "getSettings", "()Lorg/jetbrains/compose/desktop/application/internal/validation/ValidatedMacOSSigningSettings;", "signKey", "", "matchCertificates", "certificates", "sign", "", "file", "Ljava/io/File;", "entitlements", "forceEntitlements", "", "compose"})
public final class MacSignerImpl
extends MacSigner {
    @NotNull
    private final ValidatedMacOSSigningSettings settings;
    private String signKey;

    public MacSignerImpl(@NotNull ValidatedMacOSSigningSettings settings, @NotNull ExternalToolRunner runTool) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)runTool, (String)"runTool");
        super(runTool);
        this.settings = settings;
        Object[] objectArray = new String[5];
        objectArray[0] = "find-certificate";
        objectArray[1] = "-a";
        objectArray[2] = "-c";
        objectArray[3] = this.getSettings().getFullDeveloperID();
        File file2 = this.getSettings().getKeychain();
        objectArray[4] = file2 != null ? file2.getAbsolutePath() : null;
        ExternalToolRunner.invoke$default(runTool, MacUtils.INSTANCE.getSecurity(), CollectionsKt.listOfNotNull((Object[])objectArray), null, null, false, (Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                signKey = this.matchCertificates(it);
            }
        }, null, 92, null);
    }

    @Override
    @NotNull
    public ValidatedMacOSSigningSettings getSettings() {
        return this.settings;
    }

    @Override
    public void sign(@NotNull File file2, @Nullable File entitlements, boolean forceEntitlements) {
        File file3;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        MacSignerKt.access$unsign(this.getRunTool(), file2);
        ExternalToolRunner externalToolRunner = this.getRunTool();
        File file4 = file2;
        String string = this.signKey;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"signKey");
            string = null;
        }
        File file5 = entitlements;
        if (file5 != null) {
            File file6;
            File file7 = file6 = file5;
            String string2 = string;
            File file8 = file4;
            ExternalToolRunner externalToolRunner2 = externalToolRunner;
            boolean bl = false;
            boolean bl2 = forceEntitlements || MacSignerKt.access$isExecutable(file2);
            externalToolRunner = externalToolRunner2;
            file4 = file8;
            string = string2;
            file3 = bl2 ? file6 : null;
        } else {
            file3 = null;
        }
        MacSignerKt.access$sign(externalToolRunner, file4, string, file3, this.getSettings().getPrefix(), this.getSettings().getKeychain());
    }

    private final String matchCertificates(String certificates) {
        Pattern regex = Pattern.compile("\"alis\"<blob>=\"([^\"]+)\"");
        Matcher m = regex.matcher(certificates);
        if (!m.find()) {
            File file2 = this.getSettings().getKeychain();
            String keychainPath = file2 != null ? file2.getAbsolutePath() : null;
            StringBuilder stringBuilder = new StringBuilder().append("Could not find certificate for '").append(this.getSettings().getIdentity()).append("' in keychain [");
            String string = keychainPath;
            if (string == null) {
                string = "";
            }
            throw new IllegalStateException(stringBuilder.append(string).append(']').toString().toString());
        }
        String result2 = m.group(1);
        if (m.find()) {
            throw new IllegalStateException(("Multiple matching certificates are found for '" + this.getSettings().getFullDeveloperID() + "'. Please specify keychain containing unique matching certificate.").toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
        return result2;
    }
}

