/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal.validation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.internal.validation.VersionChecker;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/compose/desktop/application/internal/validation/DebVersionChecker;", "Lorg/jetbrains/compose/desktop/application/internal/validation/VersionChecker;", "()V", "correctFormat", "", "getCorrectFormat", "()Ljava/lang/String;", "debRegex", "Lkotlin/text/Regex;", "isValid", "", "version", "compose"})
final class DebVersionChecker
implements VersionChecker {
    @NotNull
    public static final DebVersionChecker INSTANCE = new DebVersionChecker();
    @NotNull
    private static final String correctFormat = StringsKt.trimMargin$default((String)"|'[EPOCH:]UPSTREAM_VERSION[-DEBIAN_REVISION]', where:\n                    |    * EPOCH is an optional non-negative integer;\n                    |    * UPSTREAM_VERSION may contain only alphanumerics and the characters '.', '+', '-', '~' and must start with a digit;\n                    |    * DEBIAN_REVISION is optional and may contain only alphanumerics and the characters '.', '+', '~';\n                    |    * see https://www.debian.org/doc/debian-policy/ch-controlfields.html#version for details;\n    ", null, (int)1, null);
    @NotNull
    private static final Regex debRegex = new Regex("([0-9]+:)?[0-9][0-9a-zA-Z.+\\-~]*(-[0-9a-zA-Z.+~]+)?");

    private DebVersionChecker() {
    }

    @Override
    @NotNull
    public String getCorrectFormat() {
        return correctFormat;
    }

    @Override
    public boolean isValid(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        CharSequence charSequence = version;
        return debRegex.matches(charSequence);
    }
}

