/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal.validation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.dsl.MacOSNotarizationSettings;
import org.jetbrains.compose.desktop.application.internal.validation.ValidateBundleIDKt;
import org.jetbrains.compose.desktop.application.internal.validation.ValidatedMacOSNotarizationSettings;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"ERR_APPLE_ID_IS_EMPTY", "", "ERR_NOTARIZATION_SETTINGS_ARE_NOT_PROVIDED", "ERR_PASSWORD_IS_EMPTY", "ERR_PREFIX", "validate", "Lorg/jetbrains/compose/desktop/application/internal/validation/ValidatedMacOSNotarizationSettings;", "Lorg/jetbrains/compose/desktop/application/dsl/MacOSNotarizationSettings;", "bundleIDProvider", "Lorg/gradle/api/provider/Provider;", "compose"})
public final class ValidatedMacOSNotarizationSettingsKt {
    @NotNull
    private static final String ERR_PREFIX = "Notarization settings error:";
    @NotNull
    private static final String ERR_NOTARIZATION_SETTINGS_ARE_NOT_PROVIDED = "Notarization settings error: notarization settings are not provided";
    @NotNull
    private static final String ERR_APPLE_ID_IS_EMPTY = StringsKt.trimMargin$default((String)"|Notarization settings error: appleID is null or empty. To specify:\n               |  * Use 'compose.desktop.mac.notarization.appleID' Gradle property;\n               |  * Or use 'nativeDistributions.macOS.notarization.appleID' DSL property;\n            ", null, (int)1, null);
    @NotNull
    private static final String ERR_PASSWORD_IS_EMPTY = StringsKt.trimMargin$default((String)"|Notarization settings error: password is null or empty. To specify:\n               |  * Use 'compose.desktop.mac.notarization.password' Gradle property;\n               |  * Or use 'nativeDistributions.macOS.notarization.password' DSL property;\n            ", null, (int)1, null);

    @NotNull
    public static final ValidatedMacOSNotarizationSettings validate(@Nullable MacOSNotarizationSettings $this$validate, @NotNull Provider<String> bundleIDProvider) {
        Intrinsics.checkNotNullParameter(bundleIDProvider, (String)"bundleIDProvider");
        if ($this$validate == null) {
            boolean $i$a$-checkNotNull-ValidatedMacOSNotarizationSettingsKt$validate$22 = false;
            String $i$a$-checkNotNull-ValidatedMacOSNotarizationSettingsKt$validate$22 = ERR_NOTARIZATION_SETTINGS_ARE_NOT_PROVIDED;
            throw new IllegalStateException($i$a$-checkNotNull-ValidatedMacOSNotarizationSettingsKt$validate$22.toString());
        }
        String bundleID = ValidateBundleIDKt.validateBundleID(bundleIDProvider);
        CharSequence charSequence = (CharSequence)$this$validate.getAppleID().getOrNull();
        if (!(!(charSequence == null || charSequence.length() == 0))) {
            boolean $i$a$-check-ValidatedMacOSNotarizationSettingsKt$validate$42 = false;
            String $i$a$-check-ValidatedMacOSNotarizationSettingsKt$validate$42 = ERR_APPLE_ID_IS_EMPTY;
            throw new IllegalStateException($i$a$-check-ValidatedMacOSNotarizationSettingsKt$validate$42.toString());
        }
        charSequence = (CharSequence)$this$validate.getPassword().getOrNull();
        if (!(!(charSequence == null || charSequence.length() == 0))) {
            boolean bl = false;
            String string = ERR_PASSWORD_IS_EMPTY;
            throw new IllegalStateException(string.toString());
        }
        Object object = $this$validate.getAppleID().getOrNull();
        Intrinsics.checkNotNull((Object)object);
        String string = (String)object;
        Object object2 = $this$validate.getPassword().getOrNull();
        Intrinsics.checkNotNull((Object)object2);
        return new ValidatedMacOSNotarizationSettings(bundleID, string, (String)object2, (String)$this$validate.getAscProvider().getOrNull());
    }
}

