/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.experimental.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.execution.TaskExecutionGraph;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.experimental.internal.CheckExperimentalTargetsKt;
import org.jetbrains.compose.experimental.internal.CheckResult;
import org.jetbrains.compose.experimental.internal.TargetType;
import org.jetbrains.compose.internal.ProjectExtensionsKt;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.plugin.KotlinTargetPreset;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u001a\u0014\u0010\u000b\u001a\u00020\f*\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\f\u0010\u000f\u001a\u00020\t*\u00020\nH\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0005\u001a\u00020\u0004*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"EXPERIMENTAL_TARGETS", "", "Lorg/jetbrains/compose/experimental/internal/TargetType;", "SKIKO_ARTIFACT_PREFIX", "", "gradlePropertyName", "getGradlePropertyName", "(Lorg/jetbrains/compose/experimental/internal/TargetType;)Ljava/lang/String;", "checkExperimentalTargetsWithSkikoIsEnabled", "", "Lorg/gradle/api/Project;", "checkTarget", "Lorg/jetbrains/compose/experimental/internal/CheckResult;", "target", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "configureExperimentalTargetsFlagsCheck", "compose"})
public final class CheckExperimentalTargetsKt {
    @NotNull
    private static final String SKIKO_ARTIFACT_PREFIX = "org.jetbrains.skiko:skiko";
    @NotNull
    private static final Set<TargetType> EXPERIMENTAL_TARGETS;

    public static final void configureExperimentalTargetsFlagsCheck(@NotNull Project $this$configureExperimentalTargetsFlagsCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$configureExperimentalTargetsFlagsCheck, (String)"<this>");
        $this$configureExperimentalTargetsFlagsCheck.getPlugins().withId("org.jetbrains.kotlin.multiplatform", arg_0 -> CheckExperimentalTargetsKt.configureExperimentalTargetsFlagsCheck$lambda$0((Function1)new Function1<Plugin<?>, Unit>($this$configureExperimentalTargetsFlagsCheck){
            final /* synthetic */ Project $this_configureExperimentalTargetsFlagsCheck;
            {
                this.$this_configureExperimentalTargetsFlagsCheck = $receiver;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                this.$this_configureExperimentalTargetsFlagsCheck.getGradle().getTaskGraph().whenReady(arg_0 -> configureExperimentalTargetsFlagsCheck.1.invoke$lambda$0(this.$this_configureExperimentalTargetsFlagsCheck, arg_0));
            }

            private static final void invoke$lambda$0(Project $this_configureExperimentalTargetsFlagsCheck, TaskExecutionGraph it) {
                Intrinsics.checkNotNullParameter((Object)$this_configureExperimentalTargetsFlagsCheck, (String)"$this_configureExperimentalTargetsFlagsCheck");
                CheckExperimentalTargetsKt.access$checkExperimentalTargetsWithSkikoIsEnabled($this_configureExperimentalTargetsFlagsCheck);
            }
        }, arg_0));
    }

    private static final String getGradlePropertyName(TargetType $this$gradlePropertyName) {
        return "org.jetbrains.compose.experimental." + $this$gradlePropertyName.getId() + ".enabled";
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkExperimentalTargetsWithSkikoIsEnabled(Project $this$checkExperimentalTargetsWithSkikoIsEnabled) {
        void $this$filterIsInstanceTo$iv$iv;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Project project = $this$checkExperimentalTargetsWithSkikoIsEnabled.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        KotlinMultiplatformExtension mppExt = ProjectExtensionsKt.getMppExt(project);
        Iterable $this$map$iv = (Iterable)mppExt.getTargets();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinTarget kotlinTarget = (KotlinTarget)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(CheckExperimentalTargetsKt.checkTarget($this$checkExperimentalTargetsWithSkikoIsEnabled, (KotlinTarget)it));
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CheckResult.Fail)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<TargetType> set$iv = new HashSet<TargetType>();
        Iterable<Object> list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            CheckResult.Fail it = (CheckResult.Fail)e$iv;
            boolean bl = false;
            TargetType key$iv = it.getTarget();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List failedResults = list$iv;
        if (!((Collection)failedResults).isEmpty()) {
            StringBuilder stringBuilder;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = failedResults;
            boolean $i$f$map2 = false;
            list$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                CheckResult.Fail bl = (CheckResult.Fail)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getTarget().getId());
            }
            List ids = (List)destination$iv$iv2;
            StringBuilder $this$checkExperimentalTargetsWithSkikoIsEnabled_u24lambda_u245 = stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = $this$checkExperimentalTargetsWithSkikoIsEnabled_u24lambda_u245.append("ERROR: Compose targets '" + ids + "' are experimental and may have bugs!");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            StringBuilder stringBuilder3 = $this$checkExperimentalTargetsWithSkikoIsEnabled_u24lambda_u245.append("But, if you still want to use them, add to gradle.properties:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            Iterable $this$forEach$iv = failedResults;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CheckResult.Fail it = (CheckResult.Fail)element$iv;
                boolean bl3 = false;
                StringBuilder stringBuilder4 = $this$checkExperimentalTargetsWithSkikoIsEnabled_u24lambda_u245.append(CheckExperimentalTargetsKt.getGradlePropertyName(it.getTarget()) + "=true");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String msg = string;
            $this$checkExperimentalTargetsWithSkikoIsEnabled.getProject().getLogger().error(msg);
            throw new IllegalStateException(msg.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final CheckResult checkTarget(Project $this$checkTarget, KotlinTarget target) {
        void $this$mapTo$iv$iv;
        Object v2;
        block8: {
            KotlinTargetPreset kotlinTargetPreset = target.getPreset();
            String string = kotlinTargetPreset != null ? kotlinTargetPreset.getName() : null;
            if (string == null) {
                return CheckResult.Success.INSTANCE;
            }
            String presetName = string;
            Iterable $this$firstOrNull$iv = EXPERIMENTAL_TARGETS;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TargetType it = (TargetType)element$iv;
                boolean bl = false;
                if (!it.getPresets().contains(presetName)) continue;
                v2 = element$iv;
                break block8;
            }
            v2 = null;
        }
        TargetType targetType = v2;
        if (targetType == null) {
            return CheckResult.Success.INSTANCE;
        }
        TargetType targetType2 = targetType;
        Iterable $this$map$iv = (Iterable)target.getCompilations();
        boolean $i$f$map = false;
        Iterator iterator2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void compilation;
            KotlinCompilation kotlinCompilation = (KotlinCompilation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(compilation.getCompileDependencyConfigurationName());
        }
        List targetConfigurationNames = (List)destination$iv$iv;
        ConfigurationContainer configurationContainer = $this$checkTarget.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"configurations");
        Iterable $this$forEach$iv = (Iterable)configurationContainer;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean containsSkikoArtifact;
            boolean bl;
            block9: {
                Configuration configuration = (Configuration)element$iv;
                boolean bl2 = false;
                if (!configuration.isCanBeResolved() || !targetConfigurationNames.contains(configuration.getName())) continue;
                Set set = configuration.getResolvedConfiguration().getResolvedArtifacts();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"configuration.resolvedCo\u2026uration.resolvedArtifacts");
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        ResolvedArtifact it = (ResolvedArtifact)element$iv2;
                        boolean bl3 = false;
                        String string = it.getId().getDisplayName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.id.displayName");
                        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)SKIKO_ARTIFACT_PREFIX, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!(containsSkikoArtifact = bl) || Intrinsics.areEqual((Object)$this$checkTarget.getProject().findProperty(CheckExperimentalTargetsKt.getGradlePropertyName(targetType2)), (Object)"true")) continue;
            return new CheckResult.Fail(targetType2);
        }
        return CheckResult.Success.INSTANCE;
    }

    private static final void configureExperimentalTargetsFlagsCheck$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$checkExperimentalTargetsWithSkikoIsEnabled(Project $receiver) {
        CheckExperimentalTargetsKt.checkExperimentalTargetsWithSkikoIsEnabled($receiver);
    }

    static {
        Object[] objectArray = new TargetType[3];
        Object[] objectArray2 = new String[]{"iosSimulatorArm64", "iosArm64", "iosX64"};
        objectArray[0] = new TargetType("uikit", CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"macosX64", "macosArm64"};
        objectArray[1] = new TargetType("macos", CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"jsIr", "js"};
        objectArray[2] = new TargetType("jscanvas", CollectionsKt.listOf((Object[])objectArray2));
        EXPERIMENTAL_TARGETS = SetsKt.setOf((Object[])objectArray);
    }
}

