/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.tasks;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.internal.ExternalToolRunner;
import org.jetbrains.compose.desktop.application.internal.JvmRuntimeProperties;
import org.jetbrains.compose.desktop.application.tasks.AbstractCheckNativeDistributionRuntime;
import org.jetbrains.compose.desktop.tasks.AbstractComposeDesktopTask;
import org.jetbrains.compose.internal.utils.FileUtilsKt;
import org.jetbrains.compose.internal.utils.OS;
import org.jetbrains.compose.internal.utils.OsUtilsKt;

@CacheableTask
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u001e\"\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000eH\u0002J\b\u0010&\u001a\u00020\u001cH\u0007J\u0014\u0010'\u001a\u00020\u0011*\u00020\u00112\u0006\u0010(\u001a\u00020\u000eH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u00020\u00158G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R2\u0010\u0018\u001a&\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019 \u001a*\u0012\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/compose/desktop/application/tasks/AbstractCheckNativeDistributionRuntime;", "Lorg/jetbrains/compose/desktop/tasks/AbstractComposeDesktopTask;", "()V", "checkJdkVendor", "Lorg/gradle/api/provider/Property;", "", "getCheckJdkVendor", "()Lorg/gradle/api/provider/Property;", "javaRuntimePropertiesFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "getJavaRuntimePropertiesFile", "()Lorg/gradle/api/provider/Provider;", "jdkHome", "", "getJdkHome", "jdkHomeFile", "Ljava/io/File;", "getJdkHomeFile", "()Ljava/io/File;", "jdkVersionProbeJar", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getJdkVersionProbeJar", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "taskDir", "Lorg/gradle/api/file/Directory;", "kotlin.jvm.PlatformType", "ensureToolsExist", "", "tools", "", "([Ljava/io/File;)V", "getJDKRuntimeProperties", "Ljava/util/Properties;", "javaExecutable", "jdkDistributionProbingError", "", "errorMessage", "run", "getJdkTool", "toolName", "compose"})
@SourceDebugExtension(value={"SMAP\nAbstractCheckNativeDistributionRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractCheckNativeDistributionRuntime.kt\norg/jetbrains/compose/desktop/application/tasks/AbstractCheckNativeDistributionRuntime\n+ 2 providerUtils.kt\norg/jetbrains/compose/internal/utils/ProviderUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n22#2:146\n3792#3:147\n4307#3,2:148\n1549#4:150\n1620#4,3:151\n*S KotlinDebug\n*F\n+ 1 AbstractCheckNativeDistributionRuntime.kt\norg/jetbrains/compose/desktop/application/tasks/AbstractCheckNativeDistributionRuntime\n*L\n37#1:146\n54#1:147\n54#1:148,2\n54#1:150\n54#1:151,3\n*E\n"})
public abstract class AbstractCheckNativeDistributionRuntime
extends AbstractComposeDesktopTask {
    @NotNull
    private final ConfigurableFileCollection jdkVersionProbeJar;
    @NotNull
    private final Property<String> jdkHome;
    private final Provider<Directory> taskDir;
    @NotNull
    private final Provider<RegularFile> javaRuntimePropertiesFile;

    public AbstractCheckNativeDistributionRuntime() {
        ConfigurableFileCollection configurableFileCollection = this.getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"objects.fileCollection()");
        this.jdkVersionProbeJar = configurableFileCollection;
        ObjectFactory $this$notNullProperty$iv = this.getObjects();
        boolean $i$f$notNullProperty = false;
        Property property = $this$notNullProperty$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.jdkHome = property;
        this.taskDir = this.getProject().getLayout().getBuildDirectory().dir("compose/tmp/" + this.getName());
        Provider provider = this.taskDir.map(arg_0 -> AbstractCheckNativeDistributionRuntime.javaRuntimePropertiesFile$lambda$0(javaRuntimePropertiesFile.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"taskDir.map { it.file(\"properties.bin\") }");
        this.javaRuntimePropertiesFile = provider;
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getJdkVersionProbeJar() {
        return this.jdkVersionProbeJar;
    }

    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @InputDirectory
    @NotNull
    public final Property<String> getJdkHome() {
        return this.jdkHome;
    }

    @Input
    @NotNull
    public abstract Property<Boolean> getCheckJdkVendor();

    @OutputFile
    @NotNull
    public final Provider<RegularFile> getJavaRuntimePropertiesFile() {
        return this.javaRuntimePropertiesFile;
    }

    private final File getJdkHomeFile() {
        String string = (String)this.jdkHome.getOrNull();
        if (string == null) {
            throw new IllegalStateException("Missing jdkHome value".toString());
        }
        return new File(string);
    }

    private final File getJdkTool(File $this$getJdkTool, String toolName) {
        return FilesKt.resolve((File)$this$getJdkTool, (String)("bin/" + OsUtilsKt.executableName(toolName)));
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureToolsExist(File ... tools) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        File[] $this$filter$iv = tools;
        boolean $i$f$filter = false;
        File[] fileArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (File element$iv$iv : $this$filterTo$iv$iv) {
            void it = element$iv$iv;
            boolean bl = false;
            if (!(!it.exists())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File element$iv$iv;
            element$iv$iv = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add('\'' + it.getName() + '\'');
        }
        List missingTools = (List)destination$iv$iv;
        if (missingTools.isEmpty()) {
            return;
        }
        if (missingTools.size() == 1) {
            this.jdkDistributionProbingError((String)CollectionsKt.single((List)missingTools) + " is missing");
            throw new KotlinNothingValueException();
        }
        this.jdkDistributionProbingError(CollectionsKt.joinToString$default((Iterable)missingTools, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " are missing");
        throw new KotlinNothingValueException();
    }

    private final Void jdkDistributionProbingError(String errorMessage) {
        StringBuilder stringBuilder;
        StringBuilder $this$jdkDistributionProbingError_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$jdkDistributionProbingError_u24lambda_u243.append("Failed to check JDK distribution: " + errorMessage);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        StringBuilder stringBuilder3 = $this$jdkDistributionProbingError_u24lambda_u243.append("JDK distribution path: " + this.getJdkHomeFile().getAbsolutePath());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String fullErrorMessage = string;
        throw new IllegalStateException(fullErrorMessage.toString());
    }

    @TaskAction
    public final void run() {
        Provider<Directory> provider = this.taskDir;
        Intrinsics.checkNotNullExpressionValue(provider, (String)"taskDir");
        FileUtilsKt.getIoFile(provider).mkdirs();
        File jdkHome = this.getJdkHomeFile();
        File javaExecutable = this.getJdkTool(jdkHome, "java");
        File jlinkExecutable = this.getJdkTool(jdkHome, "jlink");
        File jpackageExecutabke = this.getJdkTool(jdkHome, "jpackage");
        File[] fileArray = new File[]{javaExecutable, jlinkExecutable, jpackageExecutabke};
        this.ensureToolsExist(fileArray);
        Properties jdkRuntimeProperties = this.getJDKRuntimeProperties(javaExecutable);
        String jdkMajorVersionString = jdkRuntimeProperties.getProperty("jdk.major.version");
        Object object = jdkMajorVersionString;
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            this.jdkDistributionProbingError("JDK version '" + jdkMajorVersionString + "' has unexpected format");
            throw new KotlinNothingValueException();
        }
        int jdkMajorVersion = (Integer)object;
        if (!(jdkMajorVersion >= 17)) {
            boolean bl = false;
            this.jdkDistributionProbingError("minimum required JDK version is '17', but actual version is '" + jdkMajorVersion + '\'');
            throw new KotlinNothingValueException();
        }
        Object object2 = this.getCheckJdkVendor().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"checkJdkVendor.get()");
        if (((Boolean)object2).booleanValue()) {
            String vendor = jdkRuntimeProperties.getProperty("jdk.vendor");
            if (vendor == null) {
                this.getLogger().warn("JDK vendor probe failed: " + jdkHome);
            } else if (OsUtilsKt.getCurrentOS() == OS.MacOS && StringsKt.equals((String)vendor, (String)"homebrew", (boolean)true)) {
                throw new IllegalStateException("Homebrew's JDK distribution may cause issues with packaging.\nSee: https://github.com/JetBrains/compose-multiplatform/issues/3107\nPossible solutions:\n* Use other vendor's JDK distribution, such as Amazon Corretto;\n* To continue using Homebrew distribution for packaging on your own risk, add \"compose.desktop.packaging.checkJdkVendor=false\" to your gradle.properties".toString());
            }
        }
        ArrayList<String> modules = new ArrayList<String>();
        ExternalToolRunner bl = this.getRunExternalTool$compose();
        List list = CollectionsKt.listOf((Object)"--list-modules");
        ExternalToolRunner.LogToConsole logToConsole = ExternalToolRunner.LogToConsole.Never;
        ExternalToolRunner.invoke$default(bl, javaExecutable, list, null, null, false, (Function1)new Function1<String, Unit>(modules){
            final /* synthetic */ ArrayList<String> $modules;
            {
                this.$modules = $modules;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull String stdout) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
                Sequence sequence = StringsKt.lineSequence((CharSequence)stdout);
                ArrayList<String> arrayList = this.$modules;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    String line = (String)element$iv;
                    boolean bl = false;
                    String moduleName = StringsKt.substringBefore$default((String)((Object)StringsKt.trim((CharSequence)line)).toString(), (String)"@", null, (int)2, null);
                    if (!(!StringsKt.isBlank((CharSequence)moduleName))) continue;
                    arrayList.add(moduleName);
                }
            }
        }, logToConsole, null, 156, null);
        JvmRuntimeProperties properties = new JvmRuntimeProperties(jdkMajorVersion, (List<String>)modules);
        JvmRuntimeProperties.Companion.writeToFile(properties, FileUtilsKt.getIoFile(this.javaRuntimePropertiesFile));
    }

    private final Properties getJDKRuntimeProperties(File javaExecutable) {
        Properties jdkProperties = new Properties();
        ExternalToolRunner externalToolRunner = this.getRunExternalTool$compose();
        Object[] objectArray = new String[2];
        objectArray[0] = "-jar";
        Set set = this.jdkVersionProbeJar.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"jdkVersionProbeJar.files");
        objectArray[1] = ((File)CollectionsKt.single((Iterable)set)).getAbsolutePath();
        ExternalToolRunner.invoke$default(externalToolRunner, javaExecutable, CollectionsKt.listOf((Object[])objectArray), null, null, false, (Function1)new Function1<String, Unit>(jdkProperties){
            final /* synthetic */ Properties $jdkProperties;
            {
                this.$jdkProperties = $jdkProperties;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull String stdout) {
                Intrinsics.checkNotNullParameter((Object)stdout, (String)"stdout");
                Object object = ((Object)StringsKt.trim((CharSequence)stdout)).toString();
                byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                object = new ByteArrayInputStream(byArray);
                Properties properties = this.$jdkProperties;
                Throwable throwable = null;
                try {
                    ByteArrayInputStream it = (ByteArrayInputStream)object;
                    boolean bl = false;
                    properties.loadFromXML(it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
        }, null, null, 220, null);
        return jdkProperties;
    }

    private static final RegularFile javaRuntimePropertiesFile$lambda$0(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RegularFile)$tmp0.invoke(in);
    }
}

