/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.internal.kotlinx.serialization.json;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.internal.kotlinx.serialization.DeserializationStrategy;
import org.jetbrains.compose.internal.kotlinx.serialization.ExperimentalSerializationApi;
import org.jetbrains.compose.internal.kotlinx.serialization.SerializationStrategy;
import org.jetbrains.compose.internal.kotlinx.serialization.StringFormat;
import org.jetbrains.compose.internal.kotlinx.serialization.json.JsonConfiguration;
import org.jetbrains.compose.internal.kotlinx.serialization.json.JsonElement;
import org.jetbrains.compose.internal.kotlinx.serialization.json.JsonElementSerializer;
import org.jetbrains.compose.internal.kotlinx.serialization.json.JsonEncoder;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.DescriptorSchemaCache;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.JsonLexer;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.JsonStringBuilder;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.StreamingJsonDecoder;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.StreamingJsonEncoder;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.TreeJsonDecoderKt;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.TreeJsonEncoderKt;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.WriteMode;
import org.jetbrains.compose.internal.kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.compose.internal.kotlinx.serialization.modules.SerializersModuleKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 $2\u00020\u0001:\u0001$B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J'\u0010\u0018\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ'\u0010\u001c\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00120\u001e2\u0006\u0010\u001f\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010 J'\u0010!\u001a\u00020\u001a\"\u0004\b\u0000\u0010\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00120\u001e2\u0006\u0010\u001f\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010\"J\u000e\u0010#\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aR\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0002%&\u00a8\u0006'"}, d2={"Lorg/jetbrains/compose/internal/kotlinx/serialization/json/Json;", "Lorg/jetbrains/compose/internal/kotlinx/serialization/StringFormat;", "configuration", "Lorg/jetbrains/compose/internal/kotlinx/serialization/json/JsonConfiguration;", "serializersModule", "Lorg/jetbrains/compose/internal/kotlinx/serialization/modules/SerializersModule;", "(Lkotlinx/serialization/json/JsonConfiguration;Lkotlinx/serialization/modules/SerializersModule;)V", "getConfiguration$annotations", "()V", "getConfiguration", "()Lkotlinx/serialization/json/JsonConfiguration;", "schemaCache", "Lorg/jetbrains/compose/internal/kotlinx/serialization/json/internal/DescriptorSchemaCache;", "getSchemaCache$kotlinx_serialization_json", "()Lkotlinx/serialization/json/internal/DescriptorSchemaCache;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "decodeFromJsonElement", "T", "deserializer", "Lorg/jetbrains/compose/internal/kotlinx/serialization/DeserializationStrategy;", "element", "Lorg/jetbrains/compose/internal/kotlinx/serialization/json/JsonElement;", "(Lkotlinx/serialization/DeserializationStrategy;Lkotlinx/serialization/json/JsonElement;)Ljava/lang/Object;", "decodeFromString", "string", "", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/lang/String;)Ljava/lang/Object;", "encodeToJsonElement", "serializer", "Lorg/jetbrains/compose/internal/kotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Lkotlinx/serialization/json/JsonElement;", "encodeToString", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Ljava/lang/String;", "parseToJsonElement", "Default", "Lorg/jetbrains/compose/internal/kotlinx/serialization/json/Json$Default;", "Lorg/jetbrains/compose/internal/kotlinx/serialization/json/JsonImpl;", "kotlinx-serialization-json"})
public abstract class Json
implements StringFormat {
    @NotNull
    public static final Default Default = new Default(null);
    @NotNull
    private final JsonConfiguration configuration;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final DescriptorSchemaCache schemaCache;

    private Json(JsonConfiguration configuration, SerializersModule serializersModule) {
        this.configuration = configuration;
        this.serializersModule = serializersModule;
        this.schemaCache = new DescriptorSchemaCache();
    }

    @NotNull
    public final JsonConfiguration getConfiguration() {
        return this.configuration;
    }

    @ExperimentalSerializationApi
    public static /* synthetic */ void getConfiguration$annotations() {
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @NotNull
    public final DescriptorSchemaCache getSchemaCache$kotlinx_serialization_json() {
        return this.schemaCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public final <T> String encodeToString(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        JsonStringBuilder result2 = new JsonStringBuilder();
        try {
            StreamingJsonEncoder encoder2 = new StreamingJsonEncoder(result2, this, WriteMode.OBJ, new JsonEncoder[WriteMode.values().length]);
            encoder2.encodeSerializableValue(serializer2, value);
            String string = result2.toString();
            return string;
        }
        finally {
            result2.release();
        }
    }

    @Override
    public final <T> T decodeFromString(@NotNull DeserializationStrategy<T> deserializer, @NotNull String string) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        JsonLexer lexer = new JsonLexer(string);
        StreamingJsonDecoder input = new StreamingJsonDecoder(this, WriteMode.OBJ, lexer);
        T result2 = input.decodeSerializableValue(deserializer);
        lexer.expectEof();
        return result2;
    }

    @NotNull
    public final <T> JsonElement encodeToJsonElement(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        return TreeJsonEncoderKt.writeJson(this, value, serializer2);
    }

    public final <T> T decodeFromJsonElement(@NotNull DeserializationStrategy<T> deserializer, @NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return TreeJsonDecoderKt.readJson(this, element, deserializer);
    }

    @NotNull
    public final JsonElement parseToJsonElement(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return (JsonElement)this.decodeFromString(JsonElementSerializer.INSTANCE, string);
    }

    public /* synthetic */ Json(JsonConfiguration configuration, SerializersModule serializersModule, DefaultConstructorMarker $constructor_marker) {
        this(configuration, serializersModule);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/compose/internal/kotlinx/serialization/json/Json$Default;", "Lorg/jetbrains/compose/internal/kotlinx/serialization/json/Json;", "()V", "kotlinx-serialization-json"})
    public static final class Default
    extends Json {
        private Default() {
            super(new JsonConfiguration(false, false, false, false, false, null, false, false, null, false, false, 2047, null), SerializersModuleKt.getEmptySerializersModule(), null);
        }

        public /* synthetic */ Default(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

