/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.internal.kotlinx.serialization.json.internal;

import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.internal.kotlinx.serialization.ExperimentalSerializationApi;
import org.jetbrains.compose.internal.kotlinx.serialization.SerializationStrategy;
import org.jetbrains.compose.internal.kotlinx.serialization.descriptors.PolymorphicKind;
import org.jetbrains.compose.internal.kotlinx.serialization.descriptors.PrimitiveKind;
import org.jetbrains.compose.internal.kotlinx.serialization.descriptors.SerialDescriptor;
import org.jetbrains.compose.internal.kotlinx.serialization.descriptors.SerialKind;
import org.jetbrains.compose.internal.kotlinx.serialization.descriptors.StructureKind;
import org.jetbrains.compose.internal.kotlinx.serialization.encoding.AbstractEncoder;
import org.jetbrains.compose.internal.kotlinx.serialization.encoding.CompositeEncoder;
import org.jetbrains.compose.internal.kotlinx.serialization.encoding.Encoder;
import org.jetbrains.compose.internal.kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import org.jetbrains.compose.internal.kotlinx.serialization.internal.NamedValueEncoder;
import org.jetbrains.compose.internal.kotlinx.serialization.json.Json;
import org.jetbrains.compose.internal.kotlinx.serialization.json.JsonConfiguration;
import org.jetbrains.compose.internal.kotlinx.serialization.json.JsonElement;
import org.jetbrains.compose.internal.kotlinx.serialization.json.JsonElementKt;
import org.jetbrains.compose.internal.kotlinx.serialization.json.JsonElementSerializer;
import org.jetbrains.compose.internal.kotlinx.serialization.json.JsonEncoder;
import org.jetbrains.compose.internal.kotlinx.serialization.json.JsonLiteral;
import org.jetbrains.compose.internal.kotlinx.serialization.json.JsonNull;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.JsonExceptionsKt;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.JsonPrimitiveEncoder;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.JsonTreeEncoder;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.JsonTreeListEncoder;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.JsonTreeMapEncoder;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.PolymorphicKt;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import org.jetbrains.compose.internal.kotlinx.serialization.json.internal.WriteModeKt;
import org.jetbrains.compose.internal.kotlinx.serialization.modules.SerializersModule;

@ExperimentalSerializationApi
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b3\u0018\u00002\u00020\u00012\u00020\u0002B#\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0019H\u0014J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\bH\u0016J)\u0010\u001f\u001a\u00020\b\"\u0004\b\u0000\u0010 2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\"2\u0006\u0010#\u001a\u0002H H\u0016\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0013H\u0014J\u0018\u0010'\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u00020(H\u0014J\u0018\u0010)\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u00020*H\u0014J\u0018\u0010+\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u00020,H\u0014J \u0010-\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0014J\u0018\u00101\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u000202H\u0014J\u0018\u00103\u001a\u0002042\u0006\u0010&\u001a\u00020\u00192\u0006\u00105\u001a\u00020\u0017H\u0014J\u0018\u00106\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u000200H\u0014J\u0018\u00107\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u000208H\u0014J\u0010\u00109\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0019H\u0014J\u0018\u0010:\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u00020;H\u0014J\u0018\u0010<\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0019H\u0014J\u0018\u0010=\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010#\u001a\u00020>H\u0014J\u0010\u0010?\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010@\u001a\u00020\u0007H&J\u0018\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0007H&J\u0018\u0010C\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010D\u001a\u000200H\u0016R\u0010\u0010\n\u001a\u00020\u000b8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003EFG\u00a8\u0006H"}, d2={"Lorg/jetbrains/compose/internal/kotlinx/serialization/json/internal/AbstractJsonTreeEncoder;", "Lorg/jetbrains/compose/internal/kotlinx/serialization/internal/NamedValueEncoder;", "Lorg/jetbrains/compose/internal/kotlinx/serialization/json/JsonEncoder;", "json", "Lorg/jetbrains/compose/internal/kotlinx/serialization/json/Json;", "nodeConsumer", "Lkotlin/Function1;", "Lorg/jetbrains/compose/internal/kotlinx/serialization/json/JsonElement;", "", "(Lkotlinx/serialization/json/Json;Lkotlin/jvm/functions/Function1;)V", "configuration", "Lorg/jetbrains/compose/internal/kotlinx/serialization/json/JsonConfiguration;", "getJson", "()Lkotlinx/serialization/json/Json;", "serializersModule", "Lorg/jetbrains/compose/internal/kotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "writePolymorphic", "", "beginStructure", "Lorg/jetbrains/compose/internal/kotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lorg/jetbrains/compose/internal/kotlinx/serialization/descriptors/SerialDescriptor;", "composeName", "", "parentName", "childName", "encodeJsonElement", "element", "encodeNull", "encodeSerializableValue", "T", "serializer", "Lorg/jetbrains/compose/internal/kotlinx/serialization/SerializationStrategy;", "value", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeTaggedBoolean", "tag", "encodeTaggedByte", "", "encodeTaggedChar", "", "encodeTaggedDouble", "", "encodeTaggedEnum", "enumDescriptor", "ordinal", "", "encodeTaggedFloat", "", "encodeTaggedInline", "Lorg/jetbrains/compose/internal/kotlinx/serialization/encoding/Encoder;", "inlineDescriptor", "encodeTaggedInt", "encodeTaggedLong", "", "encodeTaggedNull", "encodeTaggedShort", "", "encodeTaggedString", "encodeTaggedValue", "", "endEncode", "getCurrent", "putElement", "key", "shouldEncodeElementDefault", "index", "Lorg/jetbrains/compose/internal/kotlinx/serialization/json/internal/JsonPrimitiveEncoder;", "Lorg/jetbrains/compose/internal/kotlinx/serialization/json/internal/JsonTreeEncoder;", "Lorg/jetbrains/compose/internal/kotlinx/serialization/json/internal/JsonTreeListEncoder;", "kotlinx-serialization-json"})
abstract class AbstractJsonTreeEncoder
extends NamedValueEncoder
implements JsonEncoder {
    @NotNull
    private final Json json;
    @NotNull
    private final Function1<JsonElement, Unit> nodeConsumer;
    @JvmField
    @NotNull
    protected final JsonConfiguration configuration;
    private boolean writePolymorphic;

    private AbstractJsonTreeEncoder(Json json2, Function1<? super JsonElement, Unit> nodeConsumer) {
        this.json = json2;
        this.nodeConsumer = nodeConsumer;
        this.configuration = this.json.getConfiguration();
    }

    @Override
    @NotNull
    public final Json getJson() {
        return this.json;
    }

    @Override
    @NotNull
    public final SerializersModule getSerializersModule() {
        return this.json.getSerializersModule();
    }

    @Override
    public void encodeJsonElement(@NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.encodeSerializableValue(JsonElementSerializer.INSTANCE, element);
    }

    @Override
    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return this.configuration.getEncodeDefaults();
    }

    @Override
    @NotNull
    protected String composeName(@NotNull String parentName, @NotNull String childName) {
        Intrinsics.checkNotNullParameter((Object)parentName, (String)"parentName");
        Intrinsics.checkNotNullParameter((Object)childName, (String)"childName");
        return childName;
    }

    public abstract void putElement(@NotNull String var1, @NotNull JsonElement var2);

    @NotNull
    public abstract JsonElement getCurrent();

    @Override
    public void encodeNull() {
        String string = (String)this.getCurrentTagOrNull();
        if (string == null) {
            this.nodeConsumer.invoke((Object)JsonNull.INSTANCE);
            return;
        }
        String tag = string;
        this.encodeTaggedNull(tag);
    }

    @Override
    protected void encodeTaggedNull(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.putElement(tag, JsonNull.INSTANCE);
    }

    @Override
    protected void encodeTaggedInt(@NotNull String tag, int value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.putElement(tag, JsonElementKt.JsonPrimitive(value));
    }

    @Override
    protected void encodeTaggedByte(@NotNull String tag, byte value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.putElement(tag, JsonElementKt.JsonPrimitive(value));
    }

    @Override
    protected void encodeTaggedShort(@NotNull String tag, short value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.putElement(tag, JsonElementKt.JsonPrimitive(value));
    }

    @Override
    protected void encodeTaggedLong(@NotNull String tag, long value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.putElement(tag, JsonElementKt.JsonPrimitive(value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void encodeTaggedFloat(@NotNull String tag, float value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.putElement(tag, JsonElementKt.JsonPrimitive(Float.valueOf(value)));
        if (this.configuration.getAllowSpecialFloatingPointValues()) return;
        float f = value;
        boolean bl = false;
        float f2 = f;
        boolean bl2 = false;
        if (!Float.isInfinite(f2)) {
            f2 = f;
            bl2 = false;
            if (!Float.isNaN(f2)) {
                return;
            }
        }
        boolean bl3 = false;
        if (bl3) return;
        throw JsonExceptionsKt.InvalidFloatingPointEncoded(Float.valueOf(value), tag, this.getCurrent().toString());
    }

    @Override
    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        if (this.getCurrentTagOrNull() != null || !(serializer2.getDescriptor().getKind() instanceof PrimitiveKind) && serializer2.getDescriptor().getKind() != SerialKind.ENUM.INSTANCE) {
            JsonEncoder $this$encodePolymorphically$iv = this;
            boolean $i$f$encodePolymorphically = false;
            if (!(serializer2 instanceof AbstractPolymorphicSerializer) || $this$encodePolymorphically$iv.getJson().getConfiguration().getUseArrayPolymorphism()) {
                serializer2.serialize($this$encodePolymorphically$iv, value);
            } else {
                if (value == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
                }
                SerializationStrategy actualSerializer$iv = PolymorphicKt.access$findActualSerializer($this$encodePolymorphically$iv, serializer2, value);
                boolean bl = false;
                this.writePolymorphic = true;
                actualSerializer$iv.serialize($this$encodePolymorphically$iv, value);
            }
        } else {
            JsonPrimitiveEncoder jsonPrimitiveEncoder = new JsonPrimitiveEncoder(this.json, this.nodeConsumer);
            boolean bl = false;
            boolean bl2 = false;
            JsonPrimitiveEncoder $this$encodeSerializableValue_u24lambda_u2d1 = jsonPrimitiveEncoder;
            boolean bl3 = false;
            $this$encodeSerializableValue_u24lambda_u2d1.encodeSerializableValue(serializer2, value);
            $this$encodeSerializableValue_u24lambda_u2d1.endEncode(serializer2.getDescriptor());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void encodeTaggedDouble(@NotNull String tag, double value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.putElement(tag, JsonElementKt.JsonPrimitive(value));
        if (this.configuration.getAllowSpecialFloatingPointValues()) return;
        double d = value;
        boolean bl = false;
        double d2 = d;
        boolean bl2 = false;
        if (!Double.isInfinite(d2)) {
            d2 = d;
            bl2 = false;
            if (!Double.isNaN(d2)) {
                return;
            }
        }
        boolean bl3 = false;
        if (bl3) return;
        throw JsonExceptionsKt.InvalidFloatingPointEncoded(value, tag, this.getCurrent().toString());
    }

    @Override
    protected void encodeTaggedBoolean(@NotNull String tag, boolean value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.putElement(tag, JsonElementKt.JsonPrimitive(value));
    }

    @Override
    protected void encodeTaggedChar(@NotNull String tag, char value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.putElement(tag, JsonElementKt.JsonPrimitive(String.valueOf(value)));
    }

    @Override
    protected void encodeTaggedString(@NotNull String tag, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.putElement(tag, JsonElementKt.JsonPrimitive(value));
    }

    @Override
    protected void encodeTaggedEnum(@NotNull String tag, @NotNull SerialDescriptor enumDescriptor, int ordinal) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        this.putElement(tag, JsonElementKt.JsonPrimitive(enumDescriptor.getElementName(ordinal)));
    }

    @Override
    protected void encodeTaggedValue(@NotNull String tag, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.putElement(tag, JsonElementKt.JsonPrimitive(value.toString()));
    }

    @Override
    @NotNull
    protected Encoder encodeTaggedInline(@NotNull String tag, @NotNull SerialDescriptor inlineDescriptor) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)inlineDescriptor, (String)"inlineDescriptor");
        return StreamingJsonEncoderKt.isUnsignedNumber(inlineDescriptor) ? (Encoder)new AbstractEncoder(this, tag){
            @NotNull
            private final SerializersModule serializersModule;
            final /* synthetic */ AbstractJsonTreeEncoder this$0;
            final /* synthetic */ String $tag;
            {
                this.this$0 = $receiver;
                this.$tag = $tag;
                this.serializersModule = this.this$0.getJson().getSerializersModule();
            }

            @NotNull
            public SerializersModule getSerializersModule() {
                return this.serializersModule;
            }

            public final void putUnquotedString(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                this.this$0.putElement(this.$tag, new JsonLiteral(s, false));
            }

            public void encodeInt(int value) {
                int n = value;
                boolean bl = false;
                this.putUnquotedString(UInt.toString-impl((int)UInt.constructor-impl((int)n)));
            }

            public void encodeLong(long value) {
                long l = value;
                boolean bl = false;
                this.putUnquotedString(ULong.toString-impl((long)ULong.constructor-impl((long)l)));
            }

            public void encodeByte(byte value) {
                byte by = value;
                boolean bl = false;
                this.putUnquotedString(UByte.toString-impl((byte)UByte.constructor-impl((byte)by)));
            }

            public void encodeShort(short value) {
                short s = value;
                boolean bl = false;
                this.putUnquotedString(UShort.toString-impl((short)UShort.constructor-impl((short)s)));
            }
        } : super.encodeTaggedInline(tag, inlineDescriptor);
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        AbstractJsonTreeEncoder encoder2;
        AbstractJsonTreeEncoder abstractJsonTreeEncoder;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Function1 consumer2 = this.getCurrentTagOrNull() == null ? this.nodeConsumer : (Function1)new Function1<JsonElement, Unit>(this){
            final /* synthetic */ AbstractJsonTreeEncoder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JsonElement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.this$0.putElement(AbstractJsonTreeEncoder.access$getCurrentTag(this.this$0), node);
            }
        };
        SerialKind serialKind = descriptor2.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.LIST.INSTANCE) ? true : serialKind instanceof PolymorphicKind) {
            abstractJsonTreeEncoder = new JsonTreeListEncoder(this.json, (Function1<? super JsonElement, Unit>)consumer2);
        } else if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE)) {
            AbstractJsonTreeEncoder abstractJsonTreeEncoder2;
            Json $this$selectMapMode$iv = this.json;
            boolean $i$f$selectMapMode = false;
            SerialDescriptor keyDescriptor$iv = WriteModeKt.getCarrierDescriptor(descriptor2.getElementDescriptor(0));
            SerialKind keyKind$iv = keyDescriptor$iv.getKind();
            if (keyKind$iv instanceof PrimitiveKind || Intrinsics.areEqual((Object)keyKind$iv, (Object)SerialKind.ENUM.INSTANCE)) {
                boolean bl = false;
                abstractJsonTreeEncoder2 = new JsonTreeMapEncoder(this.getJson(), (Function1<? super JsonElement, Unit>)consumer2);
            } else if ($this$selectMapMode$iv.getConfiguration().getAllowStructuredMapKeys()) {
                boolean bl = false;
                abstractJsonTreeEncoder2 = new JsonTreeListEncoder(this.getJson(), (Function1<? super JsonElement, Unit>)consumer2);
            } else {
                throw JsonExceptionsKt.InvalidKeyKindException(keyDescriptor$iv);
            }
            abstractJsonTreeEncoder = abstractJsonTreeEncoder2;
        } else {
            abstractJsonTreeEncoder = encoder2 = (AbstractJsonTreeEncoder)new JsonTreeEncoder(this.json, (Function1<? super JsonElement, Unit>)consumer2);
        }
        if (this.writePolymorphic) {
            this.writePolymorphic = false;
            encoder2.putElement(this.configuration.getClassDiscriminator(), JsonElementKt.JsonPrimitive(descriptor2.getSerialName()));
        }
        return encoder2;
    }

    @Override
    protected void endEncode(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        this.nodeConsumer.invoke((Object)this.getCurrent());
    }

    public /* synthetic */ AbstractJsonTreeEncoder(Json json2, Function1 nodeConsumer, DefaultConstructorMarker $constructor_marker) {
        this(json2, (Function1<? super JsonElement, Unit>)nodeConsumer);
    }

    public static final /* synthetic */ String access$getCurrentTag(AbstractJsonTreeEncoder $this) {
        return (String)$this.getCurrentTag();
    }
}

