/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.internal.ExternalToolRunner;
import org.jetbrains.compose.desktop.application.internal.MultiOutputStreamKt;
import org.jetbrains.compose.internal.utils.FileUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eB)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fH\u0002Jy\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0014\b\u0002\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0017\u001a\u00020\u00042\u0016\b\u0002\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\fH\u0086\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/compose/desktop/application/internal/ExternalToolRunner;", "", "verbose", "Lorg/gradle/api/provider/Property;", "", "logsDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/api/provider/Property;Lorg/gradle/api/provider/Provider;Lorg/gradle/process/ExecOperations;)V", "currentTimeStamp", "", "kotlin.jvm.PlatformType", "invoke", "Lorg/gradle/process/ExecResult;", "tool", "Ljava/io/File;", "args", "", "environment", "", "workingDir", "checkExitCodeIsNormal", "processStdout", "Lkotlin/Function1;", "", "logToConsole", "Lorg/jetbrains/compose/desktop/application/internal/ExternalToolRunner$LogToConsole;", "stdinStr", "LogToConsole", "compose"})
public final class ExternalToolRunner {
    @NotNull
    private final Property<Boolean> verbose;
    @NotNull
    private final Provider<Directory> logsDir;
    @NotNull
    private final ExecOperations execOperations;

    public ExternalToolRunner(@NotNull Property<Boolean> verbose, @NotNull Provider<Directory> logsDir, @NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter(verbose, (String)"verbose");
        Intrinsics.checkNotNullParameter(logsDir, (String)"logsDir");
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.verbose = verbose;
        this.logsDir = logsDir;
        this.execOperations = execOperations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ExecResult invoke(@NotNull File tool, @NotNull Collection<String> args2, @NotNull Map<String, ? extends Object> environment, @Nullable File workingDir, boolean checkExitCodeIsNormal, @Nullable Function1<? super String, Unit> processStdout, @NotNull LogToConsole logToConsole, @Nullable String stdinStr) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter(args2, (String)"args");
        Intrinsics.checkNotNullParameter(environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)((Object)logToConsole), (String)"logToConsole");
        File logsDir = FileUtilsKt.getIoFile(this.logsDir);
        logsDir.mkdirs();
        String toolName = FilesKt.getNameWithoutExtension((File)tool);
        File outFile = FilesKt.resolve((File)logsDir, (String)(toolName + '-' + this.currentTimeStamp() + "-out.txt"));
        File errFile = FilesKt.resolve((File)logsDir, (String)(toolName + '-' + this.currentTimeStamp() + "-err.txt"));
        Closeable closeable = new FileOutputStream(outFile);
        int n = 8192;
        closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
        Serializable serializable = null;
        try {
            ExecResult execResult;
            BufferedOutputStream outFileStream = (BufferedOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream(errFile);
            int n2 = 8192;
            closeable2 = closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n2);
            Throwable throwable = null;
            try {
                BufferedOutputStream errFileStream = (BufferedOutputStream)closeable2;
                boolean bl2 = false;
                execResult = this.execOperations.exec(arg_0 -> ExternalToolRunner.invoke$lambda$2$lambda$1$lambda$0((Function1)new Function1<ExecSpec, Unit>(tool, args2, workingDir, environment, stdinStr, logToConsole, this, outFileStream, errFileStream){
                    final /* synthetic */ File $tool;
                    final /* synthetic */ Collection<String> $args;
                    final /* synthetic */ File $workingDir;
                    final /* synthetic */ Map<String, Object> $environment;
                    final /* synthetic */ String $stdinStr;
                    final /* synthetic */ LogToConsole $logToConsole;
                    final /* synthetic */ ExternalToolRunner this$0;
                    final /* synthetic */ BufferedOutputStream $outFileStream;
                    final /* synthetic */ BufferedOutputStream $errFileStream;
                    {
                        this.$tool = $tool;
                        this.$args = $args;
                        this.$workingDir = $workingDir;
                        this.$environment = $environment;
                        this.$stdinStr = $stdinStr;
                        this.$logToConsole = $logToConsole;
                        this.this$0 = $receiver;
                        this.$outFileStream = $outFileStream;
                        this.$errFileStream = $errFileStream;
                        super(1);
                    }

                    public final void invoke(ExecSpec spec) {
                        Boolean bl;
                        spec.setExecutable(this.$tool.getAbsolutePath());
                        Collection<String> $this$toTypedArray$iv = this.$args;
                        boolean $i$f$toTypedArray = false;
                        Collection<String> thisCollection$iv = $this$toTypedArray$iv;
                        Object object = thisCollection$iv.toArray(new String[0]);
                        spec.args((Object[])Arrays.copyOf(object, ((String[])object).length));
                        File file2 = this.$workingDir;
                        if (file2 != null) {
                            File wd = file2;
                            boolean bl2 = false;
                            spec.workingDir((Object)wd);
                        }
                        spec.environment(this.$environment);
                        spec.setIgnoreExitValue(true);
                        if (this.$stdinStr != null) {
                            object = this.$stdinStr;
                            byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                            spec.setStandardInput((InputStream)new ByteArrayInputStream(byArray));
                        }
                        switch (invoke.result.1.1.WhenMappings.$EnumSwitchMapping$0[this.$logToConsole.ordinal()]) {
                            case 1: {
                                bl = true;
                                break;
                            }
                            case 2: {
                                bl = false;
                                break;
                            }
                            case 3: {
                                bl = (Boolean)ExternalToolRunner.access$getVerbose$p(this.this$0).get();
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        Boolean logToConsole = bl;
                        Intrinsics.checkNotNullExpressionValue((Object)logToConsole, (String)"logToConsole");
                        if (logToConsole.booleanValue()) {
                            OutputStream outputStream = spec.getStandardOutput();
                            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"spec.standardOutput");
                            spec.setStandardOutput(MultiOutputStreamKt.alsoOutputTo(outputStream, this.$outFileStream));
                            OutputStream outputStream2 = spec.getErrorOutput();
                            Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"spec.errorOutput");
                            spec.setErrorOutput(MultiOutputStreamKt.alsoOutputTo(outputStream2, this.$errFileStream));
                        } else {
                            spec.setStandardOutput((OutputStream)this.$outFileStream);
                            spec.setErrorOutput((OutputStream)this.$errFileStream);
                        }
                    }
                }, arg_0));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
            }
            outFileStream = execResult;
        }
        catch (Throwable outFileStream) {
            serializable = outFileStream;
            throw outFileStream;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)serializable);
        }
        BufferedOutputStream result2 = outFileStream;
        if (checkExitCodeIsNormal && result2.getExitValue() != 0) {
            Serializable $this$invoke_u24lambda_u243 = serializable = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder = ((StringBuilder)$this$invoke_u24lambda_u243).append("External tool execution failed:");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            String cmd = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)tool.getAbsolutePath()), (Iterable)args2), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            StringBuilder stringBuilder2 = ((StringBuilder)$this$invoke_u24lambda_u243).append("* Command: [" + cmd + ']');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            StringBuilder stringBuilder3 = new StringBuilder().append("* Working dir: [");
            File file2 = workingDir;
            String string = file2 != null ? file2.getAbsolutePath() : null;
            if (string == null) {
                string = "";
            }
            StringBuilder stringBuilder4 = ((StringBuilder)$this$invoke_u24lambda_u243).append(stringBuilder3.append(string).append(']').toString());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            StringBuilder stringBuilder5 = ((StringBuilder)$this$invoke_u24lambda_u243).append("* Exit code: " + result2.getExitValue());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
            StringBuilder stringBuilder6 = ((StringBuilder)$this$invoke_u24lambda_u243).append("* Standard output log: " + outFile.getAbsolutePath());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
            StringBuilder stringBuilder7 = ((StringBuilder)$this$invoke_u24lambda_u243).append("* Error log: " + errFile.getAbsolutePath());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
            String string2 = ((StringBuilder)serializable).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            String errMsg = string2;
            throw new IllegalStateException(errMsg.toString());
        }
        if (processStdout != null) {
            processStdout.invoke((Object)FilesKt.readText$default((File)outFile, null, (int)1, null));
        }
        if (result2.getExitValue() == 0) {
            outFile.delete();
            errFile.delete();
        }
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"result");
        return result2;
    }

    public static /* synthetic */ ExecResult invoke$default(ExternalToolRunner externalToolRunner, File file2, Collection collection, Map map, File file3, boolean bl, Function1 function1, LogToConsole logToConsole, String string, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            file3 = null;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            function1 = null;
        }
        if ((n & 0x40) != 0) {
            logToConsole = LogToConsole.OnlyWhenVerbose;
        }
        if ((n & 0x80) != 0) {
            string = null;
        }
        return externalToolRunner.invoke(file2, collection, map, file3, bl, (Function1<? super String, Unit>)function1, logToConsole, string);
    }

    private final String currentTimeStamp() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss"));
    }

    private static final void invoke$lambda$2$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Property access$getVerbose$p(ExternalToolRunner $this) {
        return $this.verbose;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/compose/desktop/application/internal/ExternalToolRunner$LogToConsole;", "", "(Ljava/lang/String;I)V", "Always", "Never", "OnlyWhenVerbose", "compose"})
    public static final class LogToConsole
    extends Enum<LogToConsole> {
        public static final /* enum */ LogToConsole Always = new LogToConsole();
        public static final /* enum */ LogToConsole Never = new LogToConsole();
        public static final /* enum */ LogToConsole OnlyWhenVerbose = new LogToConsole();
        private static final /* synthetic */ LogToConsole[] $VALUES;

        public static LogToConsole[] values() {
            return (LogToConsole[])$VALUES.clone();
        }

        public static LogToConsole valueOf(String value) {
            return Enum.valueOf(LogToConsole.class, value);
        }

        static {
            $VALUES = logToConsoleArray = new LogToConsole[]{LogToConsole.Always, LogToConsole.Never, LogToConsole.OnlyWhenVerbose};
        }
    }
}

