/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.experimental.uikit.tasks;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.experimental.uikit.internal.resources.DetermineIosKonanTargetsFromEnvKt;
import org.jetbrains.compose.experimental.uikit.internal.resources.IosTargetResources;
import org.jetbrains.compose.experimental.uikit.tasks.AbstractComposeIosTask;
import org.jetbrains.compose.experimental.uikit.tasks.SyncComposeResourcesForIosTask;
import org.jetbrains.compose.internal.utils.FileUtilsKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\r2\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0007R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001f\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/compose/experimental/uikit/tasks/SyncComposeResourcesForIosTask;", "Lorg/jetbrains/compose/experimental/uikit/tasks/AbstractComposeIosTask;", "()V", "iosTargets", "Lorg/gradle/api/provider/SetProperty;", "Lorg/jetbrains/compose/experimental/uikit/internal/resources/IosTargetResources;", "getIosTargets$compose", "()Lorg/gradle/api/provider/SetProperty;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "resourceFiles", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileCollection;", "getResourceFiles", "()Lorg/gradle/api/provider/Provider;", "xcodeTargetArchs", "", "", "getXcodeTargetArchs", "xcodeTargetPlatform", "getXcodeTargetPlatform", "missingTargetEnvAttributeError", "", "attribute", "run", "", "compose"})
public abstract class SyncComposeResourcesForIosTask
extends AbstractComposeIosTask {
    @NotNull
    private final Provider<String> xcodeTargetPlatform;
    @NotNull
    private final Provider<List<String>> xcodeTargetArchs;
    @NotNull
    private final SetProperty<IosTargetResources> iosTargets;
    @NotNull
    private final Provider<FileCollection> resourceFiles;
    @NotNull
    private final DirectoryProperty outputDir;

    public SyncComposeResourcesForIosTask() {
        Provider provider = this.getProviders().gradleProperty("compose.ios.resources.platform").orElse(this.getProviders().environmentVariable("PLATFORM_NAME")).orElse(this.missingTargetEnvAttributeError("platform"));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"providers.gradleProperty\u2026tributeError(\"platform\"))");
        this.xcodeTargetPlatform = provider;
        Provider provider2 = this.getProviders().gradleProperty("compose.ios.resources.archs").orElse(this.getProviders().environmentVariable("ARCHS")).orElse(this.missingTargetEnvAttributeError("architectures")).map(arg_0 -> SyncComposeResourcesForIosTask.xcodeTargetArchs$lambda$0(xcodeTargetArchs.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providers.gradleProperty\u2026ter { it.isNotBlank() } }");
        this.xcodeTargetArchs = provider2;
        SetProperty setProperty = this.getObjects().setProperty(IosTargetResources.class);
        Intrinsics.checkNotNullExpressionValue((Object)setProperty, (String)"objects.setProperty(IosT\u2026getResources::class.java)");
        this.iosTargets = setProperty;
        Provider provider3 = this.xcodeTargetPlatform.zip(this.xcodeTargetArchs, (arg_0, arg_1) -> SyncComposeResourcesForIosTask.resourceFiles$lambda$1(resourceFiles.1.INSTANCE, arg_0, arg_1)).map(arg_0 -> SyncComposeResourcesForIosTask.resourceFiles$lambda$2((Function1)new Function1<Pair<? extends String, ? extends List<? extends String>>, FileCollection>(this){
            final /* synthetic */ SyncComposeResourcesForIosTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final FileCollection invoke(Pair<String, ? extends List<String>> pair) {
                void $this$flatMapTo$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                void $this$mapTo$iv;
                String xcodeTargetPlatform = (String)pair.component1();
                List xcodeTargetArchs2 = (List)pair.component2();
                ConfigurableFileCollection allResources = this.this$0.getObjects().fileCollection();
                Intrinsics.checkNotNullExpressionValue((Object)xcodeTargetPlatform, (String)"xcodeTargetPlatform");
                Intrinsics.checkNotNullExpressionValue((Object)xcodeTargetArchs2, (String)"xcodeTargetArchs");
                Iterable iterable = DetermineIosKonanTargetsFromEnvKt.determineIosKonanTargetsFromEnv(xcodeTargetPlatform, xcodeTargetArchs2);
                Iterable<E> destination$iv = new HashSet<E>();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it;
                    KonanTarget konanTarget = (KonanTarget)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                HashSet activeKonanTargets = (HashSet)destination$iv;
                Object object = this.this$0.getIosTargets$compose().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"iosTargets.get()");
                destination$iv = (Iterable)object;
                boolean $i$f$filter = false;
                Iterator<T> iterator2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    IosTargetResources it = (IosTargetResources)element$iv$iv;
                    boolean bl = false;
                    if (!activeKonanTargets.contains(it.getKonanTarget().get())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                Collection destination$iv2 = new HashSet<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv : $this$flatMapTo$iv) {
                    IosTargetResources it = (IosTargetResources)element$iv;
                    boolean bl = false;
                    Object object2 = it.getDirs().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.dirs.get()");
                    Iterable list$iv = (Set)object2;
                    CollectionsKt.addAll((Collection)destination$iv2, (Iterable)list$iv);
                }
                HashSet dirsToInclude = (HashSet)destination$iv2;
                for (String dirPath : dirsToInclude) {
                    Object[] objectArray = this.this$0.getObjects().fileTree();
                    SyncComposeResourcesForIosTask syncComposeResourcesForIosTask = this.this$0;
                    Object[] $this$invoke_u24lambda_u243 = objectArray;
                    boolean bl = false;
                    $this$invoke_u24lambda_u243.setDir((Object)syncComposeResourcesForIosTask.getLayout().getProjectDirectory().dir(dirPath));
                    String[] stringArray = new String[]{"**/*"};
                    $this$invoke_u24lambda_u243.include(stringArray);
                    Object[] fileTree = objectArray;
                    objectArray = new Object[]{fileTree};
                    allResources.from(objectArray);
                }
                return (FileCollection)allResources;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"xcodeTargetPlatform.zip(\u2026   allResources\n        }");
        this.resourceFiles = provider3;
        DirectoryProperty directoryProperty = this.getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objects.directoryProperty()");
        this.outputDir = directoryProperty;
    }

    private final Provider missingTargetEnvAttributeError(String attribute) {
        Provider provider = this.getProviders().provider(new Callable(attribute){
            final /* synthetic */ String $attribute;
            {
                this.$attribute = $attribute;
            }

            public final Void call() {
                throw new IllegalStateException(("Could not infer iOS target " + this.$attribute + ". Make sure to build via XCode (directly or via Kotlin Multiplatform Mobile plugin for Android Studio)").toString());
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"attribute: String): Prov\u2026droid Studio)\")\n        }");
        return provider;
    }

    @Input
    @NotNull
    public final Provider<String> getXcodeTargetPlatform() {
        return this.xcodeTargetPlatform;
    }

    @Input
    @NotNull
    public final Provider<List<String>> getXcodeTargetArchs() {
        return this.xcodeTargetArchs;
    }

    @Input
    @NotNull
    public final SetProperty<IosTargetResources> getIosTargets$compose() {
        return this.iosTargets;
    }

    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @InputFiles
    @NotNull
    public final Provider<FileCollection> getResourceFiles() {
        return this.resourceFiles;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void run() {
        void $this$flatMapTo$iv;
        File outputDir = ((Directory)this.outputDir.get()).getAsFile();
        FileSystemOperations fileSystemOperations = this.getFileOperations();
        File[] fileArray = new File[1];
        Intrinsics.checkNotNullExpressionValue((Object)outputDir, (String)"outputDir");
        fileArray[0] = outputDir;
        FileUtilsKt.clearDirs(fileSystemOperations, fileArray);
        Object object = this.iosTargets.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"iosTargets.get()");
        Iterable iterable = (Iterable)object;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void $this$mapTo$iv$iv;
            IosTargetResources it = (IosTargetResources)element$iv;
            boolean bl = false;
            Object object2 = it.getDirs().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.dirs.get()");
            Iterable $this$map$iv = (Iterable)object2;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                Path path = Paths.get((String)it2, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(path)");
                collection.add(path.toAbsolutePath());
            }
            Iterable list$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        HashSet allResourceDirs = (HashSet)destination$iv;
        Set resourceFiles2 = ((FileCollection)this.resourceFiles.get()).getFiles();
        for (File file2 : resourceFiles2) {
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            SyncComposeResourcesForIosTask.run$copyFileToOutputDir(allResourceDirs, outputDir, file2);
        }
        this.getLogger().info("Synced Compose resource files. Copied " + resourceFiles2.size() + " files to " + outputDir);
    }

    private static final List xcodeTargetArchs$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final Pair resourceFiles$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0, p1);
    }

    private static final FileCollection resourceFiles$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FileCollection)$tmp0.invoke(p0);
    }

    private static final void run$copyFileToOutputDir(HashSet<Path> allResourceDirs, File outputDir, File file2) {
        Object object = allResourceDirs.iterator();
        while (object.hasNext()) {
            Path dir2 = object.next();
            Path path = file2.toPath().toAbsolutePath();
            if (!path.startsWith(dir2)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)outputDir, (String)"outputDir");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
            Intrinsics.checkNotNullExpressionValue((Object)dir2, (String)"dir");
            File targetFile = FilesKt.resolve((File)outputDir, (String)((Object)PathsKt.relativeTo((Path)path, (Path)dir2)).toString());
            FilesKt.copyTo$default((File)file2, (File)targetFile, (boolean)true, (int)0, (int)4, null);
            return;
        }
        Object $this$run_u24copyFileToOutputDir_u24lambda_u246 = object = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder = ((StringBuilder)$this$run_u24copyFileToOutputDir_u24lambda_u246).append("Resource file '" + file2 + "' does not belong to a known resource directory:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        Iterable $this$forEach$iv = allResourceDirs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder2 = ((StringBuilder)$this$run_u24copyFileToOutputDir_u24lambda_u246).append("* " + it);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        }
        String string = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        object = string;
        throw new IllegalStateException(object.toString());
    }
}

