/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.ComposeCompilerKotlinSupportPlugin;
import org.jetbrains.compose.internal.IdeaImportTaskKt;
import org.jetbrains.compose.internal.Version;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePlugin;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0000\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"COMPOSE_COMPILER_COMPATIBILITY_LINK", "", "newCompilerIsAvailableVersion", "newComposeCompilerError", "newComposeCompilerKotlinSupportPluginId", "createWarningAboutNonCompatibleCompiler", "currentCompilerPluginGroupId", "configureComposeCompilerPlugin", "", "Lorg/gradle/api/Project;", "kgp", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinBasePlugin;", "compose"})
@SourceDebugExtension(value={"SMAP\nComposeCompilerKotlinSupportPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeCompilerKotlinSupportPlugin.kt\norg/jetbrains/compose/ComposeCompilerKotlinSupportPluginKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1855#2,2:168\n*S KotlinDebug\n*F\n+ 1 ComposeCompilerKotlinSupportPlugin.kt\norg/jetbrains/compose/ComposeCompilerKotlinSupportPluginKt\n*L\n38#1:168,2\n*E\n"})
public final class ComposeCompilerKotlinSupportPluginKt {
    @NotNull
    public static final String newCompilerIsAvailableVersion = "2.0.0-RC2-238";
    @NotNull
    public static final String newComposeCompilerKotlinSupportPluginId = "org.jetbrains.kotlin.plugin.compose";
    @NotNull
    public static final String newComposeCompilerError = "Since Kotlin 2.0.0-RC2 to use Compose Multiplatform you must apply \"org.jetbrains.kotlin.plugin.compose\" plugin.\nSee the migration guide https://www.jetbrains.com/help/kotlin-multiplatform-dev/compose-compiler.html#migrating-a-compose-multiplatform-project";
    @NotNull
    private static final String COMPOSE_COMPILER_COMPATIBILITY_LINK = "https://github.com/JetBrains/compose-jb/blob/master/VERSIONING.md#using-compose-multiplatform-compiler";

    public static final void configureComposeCompilerPlugin(@NotNull Project $this$configureComposeCompilerPlugin) {
        Intrinsics.checkNotNullParameter((Object)$this$configureComposeCompilerPlugin, (String)"<this>");
        Object[] objectArray = new String[]{"org.jetbrains.kotlin.multiplatform", "org.jetbrains.kotlin.jvm", "org.jetbrains.kotlin.android", "org.jetbrains.kotlin.js"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String pluginId = (String)element$iv;
            boolean bl = false;
            $this$configureComposeCompilerPlugin.getPlugins().withId(pluginId, arg_0 -> ComposeCompilerKotlinSupportPluginKt.configureComposeCompilerPlugin$lambda$1$lambda$0((Function1)new Function1<Plugin<?>, Unit>($this$configureComposeCompilerPlugin){
                final /* synthetic */ Project $this_configureComposeCompilerPlugin;
                {
                    this.$this_configureComposeCompilerPlugin = $receiver;
                    super(1);
                }

                public final void invoke(Plugin<?> plugin) {
                    Intrinsics.checkNotNull(plugin, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.plugin.KotlinBasePlugin");
                    ComposeCompilerKotlinSupportPluginKt.access$configureComposeCompilerPlugin(this.$this_configureComposeCompilerPlugin, (KotlinBasePlugin)plugin);
                }
            }, arg_0));
        }
    }

    private static final void configureComposeCompilerPlugin(Project $this$configureComposeCompilerPlugin, KotlinBasePlugin kgp) {
        String kgpVersion = kgp.getPluginVersion();
        if (Version.Companion.fromString(kgpVersion).compareTo(Version.Companion.fromString(newCompilerIsAvailableVersion)) < 0) {
            $this$configureComposeCompilerPlugin.getLogger().info("Apply ComposeCompilerKotlinSupportPlugin (KGP version = " + kgpVersion + ')');
            $this$configureComposeCompilerPlugin.getProject().getPlugins().apply(ComposeCompilerKotlinSupportPlugin.class);
        } else {
            $this$configureComposeCompilerPlugin.afterEvaluate(arg_0 -> ComposeCompilerKotlinSupportPluginKt.configureComposeCompilerPlugin$lambda$2((Function1)new Function1<Project, Unit>($this$configureComposeCompilerPlugin){
                final /* synthetic */ Project $this_configureComposeCompilerPlugin;
                {
                    this.$this_configureComposeCompilerPlugin = $receiver;
                    super(1);
                }

                public final void invoke(Project it) {
                    this.$this_configureComposeCompilerPlugin.getLogger().info("Check that new 'org.jetbrains.kotlin.plugin.compose' was applied");
                    if (!this.$this_configureComposeCompilerPlugin.getProject().getPlugins().hasPlugin("org.jetbrains.kotlin.plugin.compose")) {
                        Project project = this.$this_configureComposeCompilerPlugin.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                        Boolean ideaIsInSync = (Boolean)IdeaImportTaskKt.ideaIsInSyncProvider(project).get();
                        Intrinsics.checkNotNullExpressionValue((Object)ideaIsInSync, (String)"ideaIsInSync");
                        if (ideaIsInSync.booleanValue()) {
                            this.$this_configureComposeCompilerPlugin.getLogger().error("e: Configuration problem: Since Kotlin 2.0.0-RC2 to use Compose Multiplatform you must apply \"org.jetbrains.kotlin.plugin.compose\" plugin.\nSee the migration guide https://www.jetbrains.com/help/kotlin-multiplatform-dev/compose-compiler.html#migrating-a-compose-multiplatform-project");
                        } else {
                            throw new IllegalStateException("e: Configuration problem: Since Kotlin 2.0.0-RC2 to use Compose Multiplatform you must apply \"org.jetbrains.kotlin.plugin.compose\" plugin.\nSee the migration guide https://www.jetbrains.com/help/kotlin-multiplatform-dev/compose-compiler.html#migrating-a-compose-multiplatform-project".toString());
                        }
                    }
                }
            }, arg_0));
        }
    }

    @NotNull
    public static final String createWarningAboutNonCompatibleCompiler(@NotNull String currentCompilerPluginGroupId) {
        Intrinsics.checkNotNullParameter((Object)currentCompilerPluginGroupId, (String)"currentCompilerPluginGroupId");
        return StringsKt.trimMargin$default((String)("\nWARNING: Usage of the Custom Compose Compiler plugin ('" + currentCompilerPluginGroupId + "') \nwith non-JVM targets (Kotlin/Native, Kotlin/JS, Kotlin/WASM) is not supported.\nFor more information, please visit: https://github.com/JetBrains/compose-jb/blob/master/VERSIONING.md#using-compose-multiplatform-compiler\n"), null, (int)1, null);
    }

    private static final void configureComposeCompilerPlugin$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureComposeCompilerPlugin$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$configureComposeCompilerPlugin(Project $receiver, KotlinBasePlugin kgp) {
        ComposeCompilerKotlinSupportPluginKt.configureComposeCompilerPlugin($receiver, kgp);
    }
}

