/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.tasks.AbstractJPackageTask;
import org.jetbrains.compose.desktop.application.tasks.AbstractRunDistributableTask;
import org.jetbrains.compose.desktop.tasks.AbstractComposeDesktopTask;
import org.jetbrains.compose.internal.utils.FileUtilsKt;
import org.jetbrains.compose.internal.utils.OS;
import org.jetbrains.compose.internal.utils.OsUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00078AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/compose/desktop/application/tasks/AbstractRunDistributableTask;", "Lorg/jetbrains/compose/desktop/tasks/AbstractComposeDesktopTask;", "createApplicationImage", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/jetbrains/compose/desktop/application/tasks/AbstractJPackageTask;", "(Lorg/gradle/api/tasks/TaskProvider;)V", "appImageRootDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getAppImageRootDir$compose", "()Lorg/gradle/api/provider/Provider;", "packageName", "", "getPackageName$compose", "run", "", "compose"})
@SourceDebugExtension(value={"SMAP\nAbstractRunDistributableTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractRunDistributableTask.kt\norg/jetbrains/compose/desktop/application/tasks/AbstractRunDistributableTask\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,57:1\n4117#2:58\n4217#2,2:59\n*S KotlinDebug\n*F\n+ 1 AbstractRunDistributableTask.kt\norg/jetbrains/compose/desktop/application/tasks/AbstractRunDistributableTask\n*L\n38#1:58\n38#1:59,2\n*E\n"})
public abstract class AbstractRunDistributableTask
extends AbstractComposeDesktopTask {
    @NotNull
    private final Provider<Directory> appImageRootDir;
    @NotNull
    private final Provider<String> packageName;

    @Inject
    public AbstractRunDistributableTask(@NotNull TaskProvider<AbstractJPackageTask> createApplicationImage) {
        Intrinsics.checkNotNullParameter(createApplicationImage, (String)"createApplicationImage");
        Provider provider = createApplicationImage.flatMap(arg_0 -> AbstractRunDistributableTask.appImageRootDir$lambda$0(appImageRootDir.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"createApplicationImage.f\u2026Map { it.destinationDir }");
        this.appImageRootDir = provider;
        Provider provider2 = createApplicationImage.flatMap(arg_0 -> AbstractRunDistributableTask.packageName$lambda$1(packageName.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"createApplicationImage.flatMap { it.packageName }");
        this.packageName = provider2;
    }

    @InputDirectory
    @NotNull
    public final Provider<Directory> getAppImageRootDir$compose() {
        return this.appImageRootDir;
    }

    @Input
    @NotNull
    public final Provider<String> getPackageName$compose() {
        return this.packageName;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void run() {
        Pair pair;
        List files;
        List list;
        File appImageRoot = FileUtilsKt.getIoFile(this.appImageRootDir);
        boolean bl = false;
        File[] fileArray = appImageRoot.listFiles();
        if (fileArray != null) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv;
            File[] fileArray2 = fileArray;
            boolean $i$f$filterNot = false;
            void var8_7 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            int n = ((void)$this$filterNotTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterNotTo$iv$iv[j];
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it.getName(), (Object)".DS_Store")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = files = null;
        }
        if (files == null || files.isEmpty()) {
            throw new IllegalStateException(("Could not find application image: " + appImageRoot + " is empty!").toString());
        }
        if (files.size() > 1) {
            throw new IllegalStateException(("Could not find application image: " + appImageRoot + " contains multiple children [" + CollectionsKt.joinToString$default((Iterable)files, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ']').toString());
        }
        File appDir2 = (File)CollectionsKt.single((List)files);
        Object object = this.packageName.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"packageName.get()");
        String appExecutableName = OsUtilsKt.executableName((String)object);
        switch (WhenMappings.$EnumSwitchMapping$0[OsUtilsKt.getCurrentOS().ordinal()]) {
            case 1: {
                pair = TuplesKt.to((Object)appDir2, (Object)("bin/" + appExecutableName));
                break;
            }
            case 2: {
                pair = TuplesKt.to((Object)appDir2, (Object)appExecutableName);
                break;
            }
            case 3: {
                Intrinsics.checkNotNullExpressionValue((Object)appDir2, (String)"appDir");
                pair = TuplesKt.to((Object)FilesKt.resolve((File)appDir2, (String)"Contents"), (Object)("MacOS/" + appExecutableName));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Pair pair2 = pair;
        File workingDir = (File)pair2.component1();
        String executable = (String)pair2.component2();
        this.getExecOperations().exec(arg_0 -> AbstractRunDistributableTask.run$lambda$4((Function1)new Function1<ExecSpec, Unit>(workingDir, executable){
            final /* synthetic */ File $workingDir;
            final /* synthetic */ String $executable;
            {
                this.$workingDir = $workingDir;
                this.$executable = $executable;
                super(1);
            }

            public final void invoke(ExecSpec spec) {
                spec.workingDir((Object)this.$workingDir);
                File file2 = this.$workingDir;
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"workingDir");
                spec.executable((Object)FilesKt.resolve((File)file2, (String)this.$executable).getAbsolutePath());
            }
        }, arg_0)).assertNormalExitValue();
    }

    private static final Provider appImageRootDir$lambda$0(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Provider)$tmp0.invoke(in);
    }

    private static final Provider packageName$lambda$1(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Provider)$tmp0.invoke(in);
    }

    private static final void run$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Linux.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Windows.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.MacOS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

