/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.resources;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.internal.com.squareup.kotlinpoet.FileSpec;
import org.jetbrains.compose.resources.GenerateResClassTaskKt;
import org.jetbrains.compose.resources.ResourceItem;
import org.jetbrains.compose.resources.ResourceType;
import org.jetbrains.compose.resources.ResourcesSpecKt;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0007J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u001c\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0013*\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u0013*\u00020\rH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/compose/resources/GenerateResClassTask;", "Lorg/gradle/api/DefaultTask;", "()V", "codeDir", "Lorg/gradle/api/file/DirectoryProperty;", "getCodeDir", "()Lorg/gradle/api/file/DirectoryProperty;", "packageName", "Lorg/gradle/api/provider/Property;", "", "getPackageName", "()Lorg/gradle/api/provider/Property;", "resDir", "Ljava/io/File;", "getResDir", "shouldGenerateResClass", "", "getShouldGenerateResClass", "stringTypeNames", "", "generate", "", "getStringIds", "", "stringsXml", "fileToResourceItems", "Lorg/jetbrains/compose/resources/ResourceItem;", "relativeTo", "Ljava/nio/file/Path;", "listNotHiddenFiles", "compose"})
@SourceDebugExtension(value={"SMAP\nGenerateResClassTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateResClassTask.kt\norg/jetbrains/compose/resources/GenerateResClassTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,118:1\n1855#2,2:119\n1360#2:121\n1446#2,2:122\n1603#2,9:124\n1855#2:133\n1856#2:135\n1612#2:136\n1448#2,3:137\n1477#2:140\n1502#2,3:141\n1505#2,3:151\n1238#2,2:156\n1477#2:158\n1502#2,3:159\n1505#2,3:169\n1241#2:172\n1855#2,2:173\n1549#2:175\n1620#2,3:176\n766#2:180\n857#2,2:181\n1549#2:183\n1620#2,3:184\n1#3:134\n1#3:179\n372#4,7:144\n453#4:154\n403#4:155\n372#4,7:162\n3792#5:187\n4307#5,2:188\n*S KotlinDebug\n*F\n+ 1 GenerateResClassTask.kt\norg/jetbrains/compose/resources/GenerateResClassTask\n*L\n44#1:119,2\n52#1:121\n52#1:122,2\n54#1:124,9\n54#1:133\n54#1:135\n54#1:136\n52#1:137,3\n57#1:140\n57#1:141,3\n57#1:151,3\n58#1:156,2\n58#1:158\n58#1:159,3\n58#1:169,3\n58#1:172\n59#1:173,2\n93#1:175\n93#1:176,3\n107#1:180\n107#1:181,2\n108#1:183\n108#1:184,3\n54#1:134\n57#1:144,7\n58#1:154\n58#1:155\n58#1:162,7\n113#1:187\n113#1:188,2\n*E\n"})
public abstract class GenerateResClassTask
extends DefaultTask {
    @NotNull
    private final List<String> stringTypeNames;

    public GenerateResClassTask() {
        Object[] objectArray = new String[]{"string", "string-array"};
        this.stringTypeNames = CollectionsKt.listOf((Object[])objectArray);
    }

    @Input
    @NotNull
    public abstract Property<String> getPackageName();

    @Input
    @NotNull
    public abstract Property<Boolean> getShouldGenerateResClass();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract Property<File> getResDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getCodeDir();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void generate() {
        block14: {
            try {
                File kotlinDir = ((Directory)this.getCodeDir().get()).getAsFile();
                this.getLogger().info("Clean directory " + kotlinDir);
                Intrinsics.checkNotNullExpressionValue((Object)kotlinDir, (String)"kotlinDir");
                FilesKt.deleteRecursively((File)kotlinDir);
                kotlinDir.mkdirs();
                Object object = this.getShouldGenerateResClass().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"shouldGenerateResClass.get()");
                if (((Boolean)object).booleanValue()) {
                    void $this$mapValuesTo$iv$iv;
                    void $this$mapValues$iv;
                    Object key$iv$iv;
                    void $this$groupByTo$iv$iv;
                    Object $this$groupBy$iv;
                    Iterable list$iv$iv;
                    Object element$iv$iv$iv;
                    void $this$flatMapTo$iv$iv;
                    Iterable $this$flatMap$iv;
                    Object element$iv2;
                    File rootResDir = (File)this.getResDir().get();
                    this.getLogger().info("Generate resources for " + rootResDir);
                    Intrinsics.checkNotNullExpressionValue((Object)rootResDir, (String)"rootResDir");
                    List<File> dirs = this.listNotHiddenFiles(rootResDir);
                    Iterable $this$forEach$iv = dirs;
                    boolean $i$f$forEach22 = false;
                    for (Object element$iv2 : $this$forEach$iv) {
                        File f = (File)element$iv2;
                        boolean bl = false;
                        if (f.isDirectory()) continue;
                        throw new IllegalStateException((f.getName() + " is not directory! Raw files should be placed in '" + rootResDir.getName() + "/files' directory.").toString());
                    }
                    Iterable $i$f$forEach22 = dirs;
                    boolean $i$f$flatMap = false;
                    element$iv2 = $this$flatMap$iv;
                    Object destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        void $this$mapNotNullTo$iv$iv;
                        void $this$mapNotNull$iv;
                        File dir2 = (File)element$iv$iv;
                        boolean bl = false;
                        Iterable iterable = this.listNotHiddenFiles(dir2);
                        boolean $i$f$mapNotNull = false;
                        void var16_25 = $this$mapNotNull$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            List<ResourceItem> it$iv$iv;
                            Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                            boolean bl2 = false;
                            File it = (File)element$iv$iv2;
                            boolean bl3 = false;
                            Path path = rootResDir.toPath();
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"rootResDir.toPath()");
                            if (this.fileToResourceItems(it, path) == null) continue;
                            boolean bl4 = false;
                            destination$iv$iv2.add(it$iv$iv);
                        }
                        list$iv$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    $this$flatMap$iv = (List)destination$iv$iv;
                    boolean $i$f$groupBy = false;
                    $this$flatMapTo$iv$iv = $this$groupBy$iv;
                    destination$iv$iv = new LinkedHashMap();
                    boolean $i$f$groupByTo = false;
                    for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object2;
                        ResourceItem it = (ResourceItem)element$iv$iv;
                        boolean bl = false;
                        key$iv$iv = it.getType();
                        Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl5 = false;
                            List answer$iv$iv$iv = new ArrayList();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object2 = answer$iv$iv$iv;
                        } else {
                            object2 = value$iv$iv$iv;
                        }
                        list$iv$iv = (List)object2;
                        list$iv$iv.add(element$iv$iv);
                    }
                    $this$groupBy$iv = destination$iv$iv;
                    boolean $i$f$mapValues = false;
                    $this$groupByTo$iv$iv = $this$mapValues$iv;
                    destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (Object element$iv$iv$iv2 : $this$associateByTo$iv$iv$iv) {
                        void $this$groupByTo$iv$iv2;
                        void it$iv$iv;
                        key$iv$iv = (Map.Entry)element$iv$iv$iv2;
                        Object object3 = destination$iv$iv;
                        boolean bl = false;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv2;
                        Object k = it$iv$iv.getKey();
                        Object object4 = object3;
                        boolean bl6 = false;
                        List items = (List)entry.getValue();
                        Iterable $this$groupBy$iv2 = items;
                        boolean $i$f$groupBy2 = false;
                        element$iv$iv$iv = $this$groupBy$iv2;
                        Map destination$iv$iv3 = new LinkedHashMap();
                        boolean $i$f$groupByTo2 = false;
                        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
                            Object object5;
                            ResourceItem it = (ResourceItem)element$iv$iv;
                            boolean bl7 = false;
                            String key$iv$iv2 = it.getName();
                            Map $this$getOrPut$iv$iv$iv = destination$iv$iv3;
                            boolean $i$f$getOrPut = false;
                            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv2);
                            if (value$iv$iv$iv == null) {
                                boolean bl8 = false;
                                List answer$iv$iv$iv = new ArrayList();
                                $this$getOrPut$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv);
                                object5 = answer$iv$iv$iv;
                            } else {
                                object5 = value$iv$iv$iv;
                            }
                            List list$iv$iv2 = (List)object5;
                            list$iv$iv2.add(element$iv$iv);
                        }
                        Map map = destination$iv$iv3;
                        object4.put(k, map);
                    }
                    Object resources = destination$iv$iv;
                    Object object6 = this.getPackageName().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"packageName.get()");
                    Iterable $this$forEach$iv2 = ResourcesSpecKt.getResFileSpecs((Map<ResourceType, ? extends Map<String, ? extends List<ResourceItem>>>)resources, (String)object6);
                    boolean $i$f$forEach = false;
                    for (Object element$iv3 : $this$forEach$iv2) {
                        FileSpec it = (FileSpec)element$iv3;
                        boolean bl = false;
                        it.writeTo(kotlinDir);
                    }
                    break block14;
                }
                this.getLogger().info("Generation Res class is disabled");
            }
            catch (Exception e) {
                this.getLogger().error("e: GenerateResClassTask was failed:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ResourceItem> fileToResourceItems(File $this$fileToResourceItems, Path relativeTo) {
        File file2 = $this$fileToResourceItems;
        String string = file2.getParentFile().getName();
        if (string == null) {
            return null;
        }
        String dirName = string;
        String[] stringArray = new String[]{"-"};
        List typeAndQualifiers = StringsKt.split$default((CharSequence)dirName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (typeAndQualifiers.isEmpty()) {
            return null;
        }
        String string2 = ((String)CollectionsKt.first((List)typeAndQualifiers)).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String typeString = string2;
        List qualifiers = CollectionsKt.takeLast((List)typeAndQualifiers, (int)(typeAndQualifiers.size() - 1));
        Path path = file2.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.toPath()");
        Path path2 = PathsKt.relativeTo((Path)path, (Path)relativeTo);
        if (Intrinsics.areEqual((Object)typeString, (Object)"string")) {
            throw new IllegalStateException(("Forbidden directory name '" + dirName + "'! String resources should be declared in 'values/strings.xml'.").toString());
        }
        if (Intrinsics.areEqual((Object)typeString, (Object)"files")) {
            if (!((Collection)qualifiers).isEmpty()) {
                throw new IllegalStateException(("The 'files' directory doesn't support qualifiers: '" + dirName + "'.").toString());
            }
            return null;
        }
        if (Intrinsics.areEqual((Object)typeString, (Object)"values") && StringsKt.equals((String)file2.getName(), (String)"strings.xml", (boolean)true)) {
            void $this$mapTo$iv$iv;
            Set<String> stringIds = this.getStringIds(file2);
            Iterable $this$map$iv = stringIds;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void strId;
                String string3 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ResourceItem(ResourceType.STRING, qualifiers, GenerateResClassTaskKt.asUnderscoredIdentifier((String)strId), path2));
            }
            return (List)destination$iv$iv;
        }
        ResourceType type = ResourceType.Companion.fromString(typeString);
        return CollectionsKt.listOf((Object)new ResourceItem(type, qualifiers, GenerateResClassTaskKt.asUnderscoredIdentifier(FilesKt.getNameWithoutExtension((File)file2)), path2));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getStringIds(File stringsXml) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Node it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection<String> collection;
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stringsXml);
        NodeList items = doc.getElementsByTagName("resources").item(0).getChildNodes();
        int n = items.getLength();
        ArrayList<Node> arrayList = new ArrayList<Node>(n);
        int n2 = 0;
        while (n2 < n) {
            void it2;
            int n3;
            int n4 = n3 = n2++;
            collection = arrayList;
            boolean bl = false;
            ((ArrayList)collection).add((String)((Object)items.item((int)it2)));
        }
        Iterable iterable = arrayList;
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Node)element$iv$iv;
            boolean bl = false;
            if (!this.stringTypeNames.contains(it.getNodeName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Node)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAttributes().getNamedItem("name").getNodeValue());
        }
        List ids = (List)destination$iv$iv;
        return CollectionsKt.toSet((Iterable)ids);
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> listNotHiddenFiles(File $this$listNotHiddenFiles) {
        List list;
        List list2;
        File[] fileArray = $this$listNotHiddenFiles.listFiles();
        if (fileArray != null) {
            void $this$filterTo$iv$iv;
            File[] $this$filter$iv = fileArray;
            boolean $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[j];
                boolean bl = false;
                if (!(!it.isHidden())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

