/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.tasks;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.tasks.AbstractComposeDesktopTask;
import org.jetbrains.compose.desktop.tasks.AbstractUnpackDefaultComposeApplicationResourcesTask;
import org.jetbrains.compose.internal.utils.FileUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007J \u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\r2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0004H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u00020\t8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/compose/desktop/tasks/AbstractUnpackDefaultComposeApplicationResourcesTask;", "Lorg/jetbrains/compose/desktop/tasks/AbstractComposeDesktopTask;", "()V", "destinationDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getDestinationDir", "()Lorg/gradle/api/provider/Provider;", "resources", "Lorg/jetbrains/compose/desktop/tasks/AbstractUnpackDefaultComposeApplicationResourcesTask$DefaultResourcesProvider;", "getResources$compose", "()Lorg/jetbrains/compose/desktop/tasks/AbstractUnpackDefaultComposeApplicationResourcesTask$DefaultResourcesProvider;", "iconSourcePath", "", "platformName", "iconExt", "run", "", "unpack", "from", "to", "Lorg/gradle/api/file/FileSystemLocation;", "DefaultResourcesProvider", "compose"})
public abstract class AbstractUnpackDefaultComposeApplicationResourcesTask
extends AbstractComposeDesktopTask {
    @OutputDirectory
    @NotNull
    private final Provider<Directory> destinationDir;
    @NotNull
    private final DefaultResourcesProvider resources;

    public AbstractUnpackDefaultComposeApplicationResourcesTask() {
        Provider provider = this.getProject().getLayout().getBuildDirectory().dir("compose/default-resources/1.7.0-rc01");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.layout.buildDire\u2026adlePluginVersion}\"\n    )");
        this.destinationDir = provider;
        this.resources = new DefaultResourcesProvider(this.destinationDir);
    }

    @NotNull
    public final Provider<Directory> getDestinationDir() {
        return this.destinationDir;
    }

    @Internal
    @NotNull
    public final DefaultResourcesProvider getResources$compose() {
        return this.resources;
    }

    @TaskAction
    public final void run() {
        Provider[] providerArray = new Provider[]{this.destinationDir};
        FileUtilsKt.clearDirs(this.getFileOperations(), providerArray);
        this.unpack(this.iconSourcePath("mac", "icns"), this.resources.getMacIcon());
        this.unpack(this.iconSourcePath("windows", "ico"), this.resources.getWindowsIcon());
        this.unpack(this.iconSourcePath("linux", "png"), this.resources.getLinuxIcon());
        this.unpack("default-compose-desktop-rules.pro", this.resources.getDefaultComposeProguardRules());
        this.unpack("default-entitlements.plist", this.resources.getDefaultEntitlements());
    }

    private final String iconSourcePath(String platformName, String iconExt) {
        return "default-compose-desktop-icon-" + platformName + '.' + iconExt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unpack(String from, Provider<? extends FileSystemLocation> to) {
        File file2;
        File $this$unpack_u24lambda_u240 = file2 = FileUtilsKt.getIoFile(to);
        boolean bl = false;
        if ($this$unpack_u24lambda_u240.exists()) {
            $this$unpack_u24lambda_u240.delete();
        } else {
            $this$unpack_u24lambda_u240.getParentFile().mkdirs();
        }
        $this$unpack_u24lambda_u240.createNewFile();
        File targetIoFile = file2;
        Closeable closeable = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(from);
        if (closeable == null) {
            throw new IllegalStateException(("Could not find default resource: " + from).toString());
        }
        InputStream iconResourceStream = closeable;
        closeable = iconResourceStream;
        Throwable throwable = null;
        try {
            long l;
            Closeable input = closeable;
            boolean bl2 = false;
            Closeable closeable2 = new FileOutputStream(targetIoFile);
            int n = 8192;
            closeable2 = closeable2 instanceof BufferedOutputStream ? (BufferedOutputStream)closeable2 : new BufferedOutputStream((OutputStream)closeable2, n);
            Throwable throwable2 = null;
            try {
                BufferedOutputStream output = (BufferedOutputStream)closeable2;
                boolean bl3 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/compose/desktop/tasks/AbstractUnpackDefaultComposeApplicationResourcesTask$DefaultResourcesProvider;", "", "resourcesRootDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "(Lorg/gradle/api/provider/Provider;)V", "defaultComposeProguardRules", "Lorg/gradle/api/file/RegularFile;", "getDefaultComposeProguardRules", "()Lorg/gradle/api/provider/Provider;", "defaultEntitlements", "getDefaultEntitlements", "linuxIcon", "getLinuxIcon", "macIcon", "getMacIcon", "windowsIcon", "getWindowsIcon", "compose"})
    public static final class DefaultResourcesProvider {
        @NotNull
        private final Provider<RegularFile> macIcon;
        @NotNull
        private final Provider<RegularFile> windowsIcon;
        @NotNull
        private final Provider<RegularFile> linuxIcon;
        @NotNull
        private final Provider<RegularFile> defaultComposeProguardRules;
        @NotNull
        private final Provider<RegularFile> defaultEntitlements;

        public DefaultResourcesProvider(@NotNull Provider<Directory> resourcesRootDir) {
            Intrinsics.checkNotNullParameter(resourcesRootDir, (String)"resourcesRootDir");
            Provider provider = resourcesRootDir.map(arg_0 -> DefaultResourcesProvider.macIcon$lambda$0(macIcon.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"resourcesRootDir.map { i\u2026default-icon-mac.icns\") }");
            this.macIcon = provider;
            Provider provider2 = resourcesRootDir.map(arg_0 -> DefaultResourcesProvider.windowsIcon$lambda$1(windowsIcon.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"resourcesRootDir.map { i\u2026ault-icon-windows.ico\") }");
            this.windowsIcon = provider2;
            Provider provider3 = resourcesRootDir.map(arg_0 -> DefaultResourcesProvider.linuxIcon$lambda$2(linuxIcon.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"resourcesRootDir.map { i\u2026efault-icon-linux.png\") }");
            this.linuxIcon = provider3;
            Provider provider4 = resourcesRootDir.map(arg_0 -> DefaultResourcesProvider.defaultComposeProguardRules$lambda$3(defaultComposeProguardRules.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"resourcesRootDir.map { i\u2026OGUARD_RULES_FILE_NAME) }");
            this.defaultComposeProguardRules = provider4;
            Provider provider5 = resourcesRootDir.map(arg_0 -> DefaultResourcesProvider.defaultEntitlements$lambda$4(defaultEntitlements.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)provider5, (String)"resourcesRootDir.map { i\u2026ENTITLEMENTS_FILE_NAME) }");
            this.defaultEntitlements = provider5;
        }

        @NotNull
        public final Provider<RegularFile> getMacIcon() {
            return this.macIcon;
        }

        @NotNull
        public final Provider<RegularFile> getWindowsIcon() {
            return this.windowsIcon;
        }

        @NotNull
        public final Provider<RegularFile> getLinuxIcon() {
            return this.linuxIcon;
        }

        @NotNull
        public final Provider<RegularFile> getDefaultComposeProguardRules() {
            return this.defaultComposeProguardRules;
        }

        @NotNull
        public final Provider<RegularFile> getDefaultEntitlements() {
            return this.defaultEntitlements;
        }

        private static final RegularFile macIcon$lambda$0(Function1 $tmp0, Object in) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (RegularFile)$tmp0.invoke(in);
        }

        private static final RegularFile windowsIcon$lambda$1(Function1 $tmp0, Object in) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (RegularFile)$tmp0.invoke(in);
        }

        private static final RegularFile linuxIcon$lambda$2(Function1 $tmp0, Object in) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (RegularFile)$tmp0.invoke(in);
        }

        private static final RegularFile defaultComposeProguardRules$lambda$3(Function1 $tmp0, Object in) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (RegularFile)$tmp0.invoke(in);
        }

        private static final RegularFile defaultEntitlements$lambda$4(Function1 $tmp0, Object in) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (RegularFile)$tmp0.invoke(in);
        }
    }
}

