/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.ui.tooling.preview.rpc;

import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.CommandsKt;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.FrameConfig;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.FrameRequest;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewClassloaderProvider;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewHost;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewLogger;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PrintStreamLogger;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RemoteConnection;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RemoteConnectionKt;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RenderedFrame;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\rH\u0002J\u0014\u0010\u001b\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewHost;", "", "log", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewLogger;", "connection", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/RemoteConnection;", "(Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewLogger;Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/RemoteConnection;)V", "classloaderProvider", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewClassloaderProvider;", "previewClasspath", "Ljava/util/concurrent/atomic/AtomicReference;", "", "previewRequest", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/FrameRequest;", "receiverThread", "Ljava/lang/Thread;", "getReceiverThread", "()Ljava/lang/Thread;", "senderThread", "join", "", "renderFrame", "", "classloader", "Ljava/lang/ClassLoader;", "request", "classpath", "setUpUnhandledExceptionHandler", "exitCode", "", "Companion", "preview-rpc"})
@SourceDebugExtension(value={"SMAP\nRemotePreviewHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemotePreviewHost.kt\norg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewHost\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 PreviewLogger.kt\norg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewLogger\n+ 4 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,185:1\n3829#2:186\n4344#2,2:187\n12#3,4:189\n12#3,4:199\n17#4,6:193\n*S KotlinDebug\n*F\n+ 1 RemotePreviewHost.kt\norg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewHost\n*L\n151#1:186\n151#1:187,2\n158#1:189,4\n163#1:199,4\n160#1:193,6\n*E\n"})
public final class PreviewHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PreviewLogger log;
    @NotNull
    private final AtomicReference<String> previewClasspath;
    @NotNull
    private final AtomicReference<FrameRequest> previewRequest;
    @NotNull
    private final PreviewClassloaderProvider classloaderProvider;
    @NotNull
    private final Thread senderThread;
    @NotNull
    private final Thread receiverThread;
    @NotNull
    private static final String PREVIEW_FACADE_CLASS_NAME = "androidx.compose.desktop.ui.tooling.preview.runtime.NonInteractivePreviewFacade";

    public PreviewHost(@NotNull PreviewLogger log, @NotNull RemoteConnection connection2) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        Intrinsics.checkNotNullParameter((Object)connection2, (String)"connection");
        this.log = log;
        this.previewClasspath = new AtomicReference<Object>(null);
        this.previewRequest = new AtomicReference<Object>(null);
        this.classloaderProvider = new PreviewClassloaderProvider();
        CommandsKt.sendAttach(connection2);
        this.senderThread = this.setUpUnhandledExceptionHandler(ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(connection2, this){
            final /* synthetic */ RemoteConnection $connection;
            final /* synthetic */ PreviewHost this$0;
            {
                this.$connection = $connection;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                while (this.$connection.isAlive()) {
                    try {
                        String classpath = (String)PreviewHost.access$getPreviewClasspath$p(this.this$0).get();
                        FrameRequest request = (FrameRequest)PreviewHost.access$getPreviewRequest$p(this.this$0).get();
                        if (classpath != null && request != null && PreviewHost.access$getPreviewRequest$p(this.this$0).compareAndSet(request, null)) {
                            byte[] bytes = PreviewHost.access$renderFrame(this.this$0, classpath, request);
                            FrameConfig config = request.getFrameConfig();
                            RenderedFrame frame = new RenderedFrame(bytes, config.getWidth(), config.getHeight());
                            CommandsKt.sendFrame(this.$connection, frame);
                        }
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Exception e) {
                        if (this.$connection.isAlive()) {
                            CommandsKt.sendError(this.$connection, e);
                            continue;
                        }
                        throw new IllegalStateException("Could not report an exception: IDE connection is not alive", e);
                    }
                }
            }
        }), (int)31, null), 3);
        this.receiverThread = this.setUpUnhandledExceptionHandler(ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(connection2, this){
            final /* synthetic */ RemoteConnection $connection;
            final /* synthetic */ PreviewHost this$0;
            {
                this.$connection = $connection;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                while (this.$connection.isAlive()) {
                    try {
                        CommandsKt.receivePreviewRequest(this.$connection, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.this$0){
                            final /* synthetic */ PreviewHost this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(String it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                PreviewHost.access$getPreviewClasspath$p(this.this$0).set(it);
                                PreviewHost.access$getSenderThread$p(this.this$0).interrupt();
                            }
                        }), (Function1<? super FrameRequest, Unit>)((Function1)new Function1<FrameRequest, Unit>(this.this$0){
                            final /* synthetic */ PreviewHost this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(FrameRequest it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                PreviewHost.access$getPreviewRequest$p(this.this$0).set(it);
                                PreviewHost.access$getSenderThread$p(this.this$0).interrupt();
                            }
                        }));
                    }
                    catch (SocketTimeoutException e) {
                    }
                    catch (InterruptedException e) {}
                }
            }
        }), (int)31, null), 2);
    }

    @NotNull
    public final Thread getReceiverThread() {
        return this.receiverThread;
    }

    private final Thread setUpUnhandledExceptionHandler(Thread $this$setUpUnhandledExceptionHandler, int exitCode) {
        Thread thread;
        Thread $this$setUpUnhandledExceptionHandler_u24lambda_u241 = thread = $this$setUpUnhandledExceptionHandler;
        boolean bl = false;
        $this$setUpUnhandledExceptionHandler_u24lambda_u241.setUncaughtExceptionHandler((arg_0, arg_1) -> PreviewHost.setUpUnhandledExceptionHandler$lambda$1$lambda$0(exitCode, arg_0, arg_1));
        return thread;
    }

    public final void join() {
        this.senderThread.join();
        this.receiverThread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] renderFrame(String classpath, FrameRequest request) {
        byte[] byArray;
        ClassLoader classloader = this.classloaderProvider.getClassloader(classpath);
        Thread thread = Thread.currentThread();
        ClassLoader prevContextClassloader = thread.getContextClassLoader();
        thread.setContextClassLoader(classloader);
        try {
            byArray = this.renderFrame(classloader, request);
        }
        finally {
            thread.setContextClassLoader(prevContextClassloader);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] renderFrame(ClassLoader classloader, FrameRequest request) {
        PreviewLogger previewLogger;
        Method method;
        Class<?> previewFacade = classloader.loadClass(PREVIEW_FACADE_CLASS_NAME);
        Object[] objectArray = new Class[]{String.class, Integer.TYPE, Integer.TYPE, Double.class};
        Object[] renderArgsClasses = objectArray;
        try {
            method = previewFacade.getMethod("render", Arrays.copyOf(renderArgsClasses, renderArgsClasses.length));
        }
        catch (NoSuchMethodException e) {
            void $this$filterTo$iv$iv;
            String signature2 = previewFacade.getCanonicalName() + "#render(" + ArraysKt.joinToString$default((Object[])renderArgsClasses, (CharSequence)", ", null, null, (int)0, null, (Function1)renderFrame.render.signature.1.INSTANCE, (int)30, null) + ')';
            Method[] methodArray = previewFacade.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"previewFacade.methods");
            Object[] $this$filter$iv = methodArray;
            boolean $i$f$filter = false;
            Object[] objectArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Method it = (Method)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"render")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List possibleCandidates = (List)destination$iv$iv;
            throw new RuntimeException("Could not find method '" + signature2 + "'. Possible candidates: \n" + CollectionsKt.joinToString$default((Iterable)possibleCandidates, (CharSequence)"\n", null, null, (int)0, null, (Function1)renderFrame.render.1.INSTANCE, (int)30, null), e);
        }
        Method render2 = method;
        long id = request.component1();
        String fqName = request.component2();
        FrameConfig frameConfig = request.component3();
        int scaledWidth = frameConfig.getScaledWidth();
        int scaledHeight = frameConfig.getScaledHeight();
        Double scale = frameConfig.getScale();
        PreviewLogger this_$iv = this.log;
        boolean $i$f$invoke = false;
        if (this_$iv.isEnabled()) {
            previewLogger = this_$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("RENDERING '").append(fqName).append("' ").append(scaledWidth).append('x').append(scaledHeight).append('@');
            Number number = scale;
            if (number == null) {
                number = Float.valueOf(1.0f);
            }
            previewLogger.log(stringBuilder.append(number).toString());
        }
        byte[] bytes = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Object[] objectArray3 = new Object[]{fqName, scaledWidth, scaledHeight, scale};
        Object object = render2.invoke(previewFacade, objectArray3);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.ByteArray");
        bytes = (byte[])object;
        long ms = System.currentTimeMillis() - start$iv;
        PreviewLogger this_$iv2 = this.log;
        boolean $i$f$invoke2 = false;
        if (this_$iv2.isEnabled()) {
            previewLogger = this_$iv2;
            boolean bl2 = false;
            previewLogger.log("RENDERED [" + bytes.length + "] in " + ms + " ms");
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void setUpUnhandledExceptionHandler$lambda$1$lambda$0(int $exitCode, Thread t, Throwable e) {
        try {
            System.err.println();
            System.err.println("<!--START OF COMPOSE PREVIEW PROCESS FATAL EXCEPTION--!>");
            e.printStackTrace(System.err);
        }
        finally {
            System.exit($exitCode);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    @JvmStatic
    public static final void main(@NotNull String[] args2) {
        Companion.main(args2);
    }

    public static final /* synthetic */ AtomicReference access$getPreviewClasspath$p(PreviewHost $this) {
        return $this.previewClasspath;
    }

    public static final /* synthetic */ AtomicReference access$getPreviewRequest$p(PreviewHost $this) {
        return $this.previewRequest;
    }

    public static final /* synthetic */ byte[] access$renderFrame(PreviewHost $this, String classpath, FrameRequest request) {
        return $this.renderFrame(classpath, request);
    }

    public static final /* synthetic */ Thread access$getSenderThread$p(PreviewHost $this) {
        return $this.senderThread;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0007\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewHost$Companion;", "", "()V", "PREVIEW_FACADE_CLASS_NAME", "", "main", "", "args", "", "([Ljava/lang/String;)V", "preview-rpc"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args2) {
            Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
            int port = Integer.parseInt(args2[0]);
            PrintStreamLogger logger = new PrintStreamLogger("PREVIEW_HOST", null, 2, null);
            Function0 onClose2 = main.onClose.1.INSTANCE;
            RemoteConnection connection2 = RemoteConnectionKt.getLocalConnectionOrNull(port, logger, (Function0<Unit>)onClose2);
            if (connection2 == null) {
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            new PreviewHost(logger, connection2).join();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

