/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.internal.utils;

import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.internal.utils.Arch;
import org.jetbrains.compose.internal.utils.OS;
import org.jetbrains.compose.internal.utils.OsUtilsKt;
import org.jetbrains.compose.internal.utils.Target;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0000\u001a\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0016H\u0000\u001a\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018H\u0000\"\u001b\u0010\u0000\u001a\u00020\u00018@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0006\u001a\u00020\u00078@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u0005\u001a\u0004\b\b\u0010\t\"\u001b\u0010\u000b\u001a\u00020\f8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0005\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"currentArch", "Lorg/jetbrains/compose/internal/utils/Arch;", "getCurrentArch", "()Lorg/jetbrains/compose/internal/utils/Arch;", "currentArch$delegate", "Lkotlin/Lazy;", "currentOS", "Lorg/jetbrains/compose/internal/utils/OS;", "getCurrentOS", "()Lorg/jetbrains/compose/internal/utils/OS;", "currentOS$delegate", "currentTarget", "Lorg/jetbrains/compose/internal/utils/Target;", "getCurrentTarget", "()Lorg/jetbrains/compose/internal/utils/Target;", "currentTarget$delegate", "executableName", "", "nameWithoutExtension", "javaExecutable", "javaHome", "jvmToolFile", "Ljava/io/File;", "toolName", "Lorg/gradle/api/provider/Provider;", "compose"})
public final class OsUtilsKt {
    @NotNull
    private static final Lazy currentTarget$delegate = LazyKt.lazy((Function0)currentTarget.2.INSTANCE);
    @NotNull
    private static final Lazy currentArch$delegate = LazyKt.lazy((Function0)currentArch.2.INSTANCE);
    @NotNull
    private static final Lazy currentOS$delegate = LazyKt.lazy((Function0)currentOS.2.INSTANCE);

    @NotNull
    public static final Target getCurrentTarget() {
        Lazy lazy = currentTarget$delegate;
        return (Target)lazy.getValue();
    }

    @NotNull
    public static final Arch getCurrentArch() {
        Lazy lazy = currentArch$delegate;
        return (Arch)((Object)lazy.getValue());
    }

    @NotNull
    public static final OS getCurrentOS() {
        Lazy lazy = currentOS$delegate;
        return (OS)((Object)lazy.getValue());
    }

    @NotNull
    public static final String executableName(@NotNull String nameWithoutExtension) {
        Intrinsics.checkNotNullParameter((Object)nameWithoutExtension, (String)"nameWithoutExtension");
        return OsUtilsKt.getCurrentOS() == OS.Windows ? nameWithoutExtension + ".exe" : nameWithoutExtension;
    }

    @NotNull
    public static final String javaExecutable(@NotNull String javaHome) {
        Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
        String string = FilesKt.resolve((File)new File(javaHome), (String)("bin/" + OsUtilsKt.executableName("java"))).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(javaHome).resolve(\"\u2026e(\"java\")}\").absolutePath");
        return string;
    }

    @NotNull
    public static final File jvmToolFile(@NotNull String toolName, @NotNull Provider<String> javaHome) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Intrinsics.checkNotNullParameter(javaHome, (String)"javaHome");
        return OsUtilsKt.jvmToolFile(toolName, new File((String)javaHome.get()));
    }

    @NotNull
    public static final File jvmToolFile(@NotNull String toolName, @NotNull File javaHome) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Intrinsics.checkNotNullParameter((Object)javaHome, (String)"javaHome");
        File jtool = FilesKt.resolve((File)javaHome, (String)("bin/" + OsUtilsKt.executableName(toolName)));
        if (!jtool.isFile()) {
            boolean bl = false;
            String string = "Invalid JDK: " + jtool + " is not a file! \nEnsure JAVA_HOME or buildSettings.javaHome is set to JDK 17 or newer";
            throw new IllegalStateException(string.toString());
        }
        return jtool;
    }
}

