/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Copy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.internal.JvmApplicationContext;
import org.jetbrains.compose.desktop.application.internal.WixToolsetKt;
import org.jetbrains.compose.desktop.application.tasks.AbstractJPackageTask;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.Download;
import org.jetbrains.compose.internal.utils.FileUtilsKt;
import org.jetbrains.compose.internal.utils.OS;
import org.jetbrains.compose.internal.utils.OsUtilsKt;
import org.jetbrains.compose.internal.utils.ProviderUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0007H\u0000\u001a%\u0010\b\u001a\u00020\u0006*\u00020\t2\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\b\rH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"DOWNLOAD_WIX_PROPERTY", "", "DOWNLOAD_WIX_TOOLSET_TASK_NAME", "UNZIP_WIX_TOOLSET_TASK_NAME", "WIX_PATH_ENV_VAR", "configureWix", "", "Lorg/jetbrains/compose/desktop/application/internal/JvmApplicationContext;", "eachWindowsPackageTask", "Lorg/gradle/api/Project;", "fn", "Lkotlin/Function1;", "Lorg/jetbrains/compose/desktop/application/tasks/AbstractJPackageTask;", "Lkotlin/ExtensionFunctionType;", "compose"})
@SourceDebugExtension(value={"SMAP\nwixToolset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 wixToolset.kt\norg/jetbrains/compose/desktop/application/internal/WixToolsetKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class WixToolsetKt {
    @NotNull
    public static final String DOWNLOAD_WIX_TOOLSET_TASK_NAME = "downloadWix";
    @NotNull
    public static final String UNZIP_WIX_TOOLSET_TASK_NAME = "unzipWix";
    @NotNull
    public static final String WIX_PATH_ENV_VAR = "WIX_PATH";
    @NotNull
    public static final String DOWNLOAD_WIX_PROPERTY = "compose.desktop.application.downloadWix";

    public static final void configureWix(@NotNull JvmApplicationContext $this$configureWix) {
        Task task;
        Task download2;
        Intrinsics.checkNotNullParameter((Object)$this$configureWix, (String)"<this>");
        if (!(OsUtilsKt.getCurrentOS() == OS.Windows)) {
            boolean $i$a$-check-WixToolsetKt$configureWix$32 = false;
            String $i$a$-check-WixToolsetKt$configureWix$32 = "Should not be called for non-Windows OS: " + OsUtilsKt.getCurrentOS();
            throw new IllegalStateException($i$a$-check-WixToolsetKt$configureWix$32.toString());
        }
        String wixPath = System.getenv().get(WIX_PATH_ENV_VAR);
        if (wixPath != null) {
            File wixDir = new File(wixPath);
            if (!wixDir.isDirectory()) {
                boolean $i$a$-check-WixToolsetKt$configureWix$42 = false;
                String $i$a$-check-WixToolsetKt$configureWix$42 = "WIX_PATH value is not a valid directory: " + wixDir;
                throw new IllegalStateException($i$a$-check-WixToolsetKt$configureWix$42.toString());
            }
            WixToolsetKt.eachWindowsPackageTask($this$configureWix.getProject(), (Function1<? super AbstractJPackageTask, Unit>)((Function1)new Function1<AbstractJPackageTask, Unit>(wixDir){
                final /* synthetic */ File $wixDir;
                {
                    this.$wixDir = $wixDir;
                    super(1);
                }

                public final void invoke(AbstractJPackageTask $this$eachWindowsPackageTask) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$this$eachWindowsPackageTask), (String)"$this$eachWindowsPackageTask");
                    $this$eachWindowsPackageTask.getWixToolsetDir().set(this.$wixDir);
                }
            }));
            return;
        }
        Provider disableWixDownload2 = ProviderUtilsKt.findLocalOrGlobalProperty$default($this$configureWix.getProject(), DOWNLOAD_WIX_PROPERTY, null, 2, null).map(arg_0 -> WixToolsetKt.configureWix$lambda$2(configureWix.disableWixDownload.1.INSTANCE, arg_0));
        Object object = disableWixDownload2.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"disableWixDownload.get()");
        if (((Boolean)object).booleanValue()) {
            return;
        }
        Project root = $this$configureWix.getProject().getRootProject();
        File file2 = $this$configureWix.getProject().getGradle().getGradleUserHomeDir();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.gradle.gradleUserHomeDir");
        File wixDir = FilesKt.resolve((File)file2, (String)"compose-jb");
        String fileName = "wix311";
        File zipFile = FilesKt.resolve((File)wixDir, (String)(fileName + ".zip"));
        Provider unzipDir = root.getLayout().getBuildDirectory().dir(fileName);
        Task task2 = (Task)root.getTasks().findByName(DOWNLOAD_WIX_TOOLSET_TASK_NAME);
        if (task2 == null) {
            Object object2 = root.getTasks().maybeCreate(DOWNLOAD_WIX_TOOLSET_TASK_NAME, Download.class);
            Download $this$configureWix_u24lambda_u244 = (Download)object2;
            boolean bl = false;
            $this$configureWix_u24lambda_u244.onlyIf(arg_0 -> WixToolsetKt.configureWix$lambda$4$lambda$3((Function1)new Function1<Task, Boolean>(zipFile){
                final /* synthetic */ File $zipFile;
                {
                    this.$zipFile = $zipFile;
                    super(1);
                }

                public final Boolean invoke(Task it) {
                    return !this.$zipFile.isFile();
                }
            }, arg_0));
            $this$configureWix_u24lambda_u244.src("https://github.com/wixtoolset/wix3/releases/download/wix3112rtm/wix311-binaries.zip");
            $this$configureWix_u24lambda_u244.dest(zipFile);
            task2 = download2 = (Task)object2;
        }
        if ((task = (Task)root.getTasks().findByName(UNZIP_WIX_TOOLSET_TASK_NAME)) == null) {
            Object object3 = root.getTasks().maybeCreate(UNZIP_WIX_TOOLSET_TASK_NAME, Copy.class);
            Copy $this$configureWix_u24lambda_u245 = (Copy)object3;
            boolean bl = false;
            Object[] objectArray = new Object[]{download2};
            $this$configureWix_u24lambda_u245.dependsOn(objectArray);
            objectArray = new Object[]{$this$configureWix_u24lambda_u245.getProject().zipTree((Object)zipFile)};
            $this$configureWix_u24lambda_u245.from(objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)unzipDir, (String)"unzipDir");
            $this$configureWix_u24lambda_u245.setDestinationDir(FileUtilsKt.getIoFile(unzipDir));
            task = (Task)object3;
        }
        Task unzip = task;
        WixToolsetKt.eachWindowsPackageTask($this$configureWix.getProject(), (Function1<? super AbstractJPackageTask, Unit>)((Function1)new Function1<AbstractJPackageTask, Unit>(unzip, (Provider<Directory>)unzipDir){
            final /* synthetic */ Task $unzip;
            final /* synthetic */ Provider<Directory> $unzipDir;
            {
                this.$unzip = $unzip;
                this.$unzipDir = $unzipDir;
                super(1);
            }

            public final void invoke(AbstractJPackageTask $this$eachWindowsPackageTask) {
                Intrinsics.checkNotNullParameter((Object)((Object)$this$eachWindowsPackageTask), (String)"$this$eachWindowsPackageTask");
                Object[] objectArray = new Object[]{this.$unzip};
                $this$eachWindowsPackageTask.dependsOn(objectArray);
                $this$eachWindowsPackageTask.getWixToolsetDir().set(this.$unzipDir);
            }
        }));
    }

    private static final void eachWindowsPackageTask(Project $this$eachWindowsPackageTask, Function1<? super AbstractJPackageTask, Unit> fn) {
        $this$eachWindowsPackageTask.getTasks().withType(AbstractJPackageTask.class).configureEach(arg_0 -> WixToolsetKt.eachWindowsPackageTask$lambda$6((Function1)new Function1<AbstractJPackageTask, Unit>(fn){
            final /* synthetic */ Function1<AbstractJPackageTask, Unit> $fn;
            {
                this.$fn = $fn;
                super(1);
            }

            public final void invoke(AbstractJPackageTask packageTask) {
                if (packageTask.getTargetFormat().isCompatibleWith$compose(OS.Windows)) {
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)packageTask), (String)"packageTask");
                    this.$fn.invoke((Object)((Object)packageTask));
                }
            }
        }, arg_0));
    }

    private static final Boolean configureWix$lambda$2(Function1 $tmp0, Object in) {
        return (Boolean)$tmp0.invoke(in);
    }

    private static final boolean configureWix$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void eachWindowsPackageTask$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

